/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.packets;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LibsPackets {
    private final ArrayList<PacketContainer> packets = new ArrayList();
    private final HashMap<Integer, ArrayList<PacketContainer>> delayedPacketsMap = new HashMap();
    private final Disguise disguise;
    private boolean unhandled;

    public Disguise getDisguise() {
        return this.disguise;
    }

    public void addPacket(PacketContainer packetContainer) {
        this.packets.add(packetContainer);
    }

    public void addDelayedPacket(PacketContainer packetContainer) {
        this.addDelayedPacket(packetContainer, 2);
    }

    public void clear() {
        this.getPackets().clear();
    }

    public void addDelayedPacket(PacketContainer packetContainer, int n) {
        if (!this.delayedPacketsMap.containsKey(n)) {
            this.delayedPacketsMap.put(n, new ArrayList());
        }
        this.delayedPacketsMap.get(n).add(packetContainer);
    }

    public ArrayList<PacketContainer> getPackets() {
        return this.packets;
    }

    public void sendDelayed(Player player) {
        for (Map.Entry<Integer, ArrayList<PacketContainer>> entry : this.getDelayedPacketsMap().entrySet()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                if (!this.getDisguise().isDisguiseInUse()) {
                    ArrayList arrayList = (ArrayList)entry.getValue();
                    if (arrayList.stream().noneMatch(packetContainer -> packetContainer.getType() == PacketType.Play.Server.PLAYER_INFO)) {
                        return;
                    }
                    arrayList.removeIf(packetContainer -> packetContainer.getType() != PacketType.Play.Server.PLAYER_INFO);
                }
                try {
                    for (PacketContainer packetContainer2 : (ArrayList)entry.getValue()) {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer2, packetContainer2.getType() == PacketType.Play.Server.ENTITY_EQUIPMENT);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }, (long)entry.getKey().intValue());
        }
    }

    private PacketContainer createPacket(EquipmentSlot equipmentSlot) {
        ItemStack itemStack = this.getDisguise().getWatcher().getItemStack(equipmentSlot);
        if (itemStack == null ? (itemStack = ReflectionManager.getEquipment(equipmentSlot, this.getDisguise().getEntity())) == null || itemStack.getType() == Material.AIR : itemStack.getType() == Material.AIR) {
            return null;
        }
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
        StructureModifier structureModifier = packetContainer.getModifier();
        structureModifier.write(0, (Object)this.getDisguise().getEntity().getEntityId());
        if (NmsVersion.v1_16.isSupported()) {
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            arrayList.add(Pair.of((Object)ReflectionManager.createEnumItemSlot(equipmentSlot), (Object)ReflectionManager.getNmsItem(itemStack)));
            structureModifier.write(1, arrayList);
        } else {
            structureModifier.write(1, (Object)ReflectionManager.createEnumItemSlot(equipmentSlot));
            structureModifier.write(2, ReflectionManager.getNmsItem(itemStack));
        }
        return packetContainer;
    }

    public HashMap<Integer, ArrayList<PacketContainer>> getDelayedPacketsMap() {
        return this.delayedPacketsMap;
    }

    public boolean isUnhandled() {
        return this.unhandled;
    }

    public LibsPackets(Disguise disguise) {
        this.disguise = disguise;
    }

    public void setUnhandled(boolean bl) {
        this.unhandled = bl;
    }
}

