/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.modded;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.utility.StreamSerializer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.listeners.ModdedListener;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.packets.packetlisteners.PacketListenerModdedClient;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class ModdedManager {
    private static final HashMap<NamespacedKey, ModdedEntity> entities = new HashMap();
    private static byte[] fmlHandshake;
    private static byte[] fmlRegistries;
    private static final Cache<String, ArrayList<String>> forgeMods;

    public ModdedManager(ArrayList<String> arrayList) {
        if (ModdedManager.getEntities().isEmpty()) {
            return;
        }
        if (fmlRegistries == null && DisguiseConfig.isLoginPayloadPackets()) {
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new PacketListenerModdedClient());
            Bukkit.getPluginManager().registerEvents((Listener)new ModdedListener(), (Plugin)LibsDisguises.getInstance());
        }
        this.createPayloads(arrayList);
    }

    private void createPayloads(ArrayList<String> arrayList) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        StreamSerializer streamSerializer = StreamSerializer.getDefault();
        try {
            streamSerializer.serializeVarInt(dataOutputStream, 1);
            streamSerializer.serializeVarInt(dataOutputStream, 0);
            streamSerializer.serializeVarInt(dataOutputStream, arrayList.size());
            for (String object : arrayList) {
                streamSerializer.serializeString(dataOutputStream, object.substring(0, object.indexOf("|")));
                streamSerializer.serializeString(dataOutputStream, object.substring(object.indexOf("|") + 1));
            }
            streamSerializer.serializeVarInt(dataOutputStream, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        fmlHandshake = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream = new ByteArrayOutputStream();
        dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        streamSerializer = StreamSerializer.getDefault();
        try {
            streamSerializer.serializeVarInt(dataOutputStream, 3);
            streamSerializer.serializeString(dataOutputStream, "minecraft:entity_type");
            streamSerializer.serializeVarInt(dataOutputStream, 1);
            streamSerializer.serializeVarInt(dataOutputStream, entities.size());
            for (Map.Entry entry : entities.entrySet()) {
                streamSerializer.serializeString(dataOutputStream, ((NamespacedKey)entry.getKey()).toString());
                streamSerializer.serializeVarInt(dataOutputStream, ((ModdedEntity)entry.getValue()).getTypeId());
            }
            streamSerializer.serializeVarInt(dataOutputStream, 0);
            streamSerializer.serializeVarInt(dataOutputStream, 0);
            streamSerializer.serializeVarInt(dataOutputStream, 0);
            streamSerializer.serializeVarInt(dataOutputStream, 0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        fmlRegistries = byteArrayOutputStream.toByteArray();
    }

    public static void registerModdedEntity(NamespacedKey namespacedKey, ModdedEntity moddedEntity, boolean bl) {
        Object object;
        if (entities.keySet().stream().anyMatch(namespacedKey2 -> namespacedKey2.toString().equalsIgnoreCase(namespacedKey.toString()))) {
            throw new IllegalArgumentException(namespacedKey + " has already been registered");
        }
        if (entities.values().stream().anyMatch(moddedEntity2 -> moddedEntity2.getName().equalsIgnoreCase(moddedEntity.getName()))) {
            throw new IllegalArgumentException("Modded entity " + moddedEntity.getName() + " has already been registered");
        }
        if (bl) {
            object = ReflectionManager.registerEntityType(namespacedKey);
            int n = ReflectionManager.getEntityTypeId(object);
            moddedEntity.setTypeId(n);
        } else {
            object = ReflectionManager.getEntityType(namespacedKey);
            int n = ReflectionManager.getEntityTypeId(object);
            moddedEntity.setTypeId(n);
        }
        moddedEntity.setEntityType(object);
        entities.put(namespacedKey, moddedEntity);
    }

    public static ModdedEntity getModdedEntity(NamespacedKey namespacedKey) {
        return entities.get(namespacedKey);
    }

    public static ModdedEntity getModdedEntity(String string) {
        for (ModdedEntity moddedEntity : entities.values()) {
            if (!moddedEntity.getName().equalsIgnoreCase(string)) continue;
            return moddedEntity;
        }
        return null;
    }

    public static void doMods(Player player) {
        ArrayList arrayList = (ArrayList)ModdedManager.getForgeMods().getIfPresent((Object)player.getName());
        player.setMetadata("forge_mods", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)arrayList));
        for (ModdedEntity moddedEntity : ModdedManager.getEntities().values()) {
            if (moddedEntity.getMod() == null || arrayList.contains(moddedEntity.getMod().toLowerCase(Locale.ENGLISH)) || moddedEntity.getRequired() == null) continue;
            player.kickPlayer(moddedEntity.getRequired());
            break;
        }
    }

    public static ArrayList<DisguisePerm> getDisguiseTypes() {
        ArrayList<DisguisePerm> arrayList = new ArrayList<DisguisePerm>();
        for (Map.Entry<NamespacedKey, ModdedEntity> entry : entities.entrySet()) {
            arrayList.add(new DisguisePerm(entry.getValue().isLiving() ? DisguiseType.MODDED_LIVING : DisguiseType.MODDED_MISC, entry.getValue().getName()));
        }
        return arrayList;
    }

    public static HashMap<NamespacedKey, ModdedEntity> getEntities() {
        return entities;
    }

    public static byte[] getFmlHandshake() {
        return fmlHandshake;
    }

    public static byte[] getFmlRegistries() {
        return fmlRegistries;
    }

    public static Cache<String, ArrayList<String>> getForgeMods() {
        return forgeMods;
    }

    static {
        forgeMods = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }
}

