/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.mineskin;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.SkinUtils;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinResponse;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;

public class MineSkinAPI {
    private long nextRequest;
    private final ReentrantLock lock = new ReentrantLock();
    private boolean debugging;
    private String apiKey;

    public boolean isInUse() {
        return this.lock.isLocked();
    }

    public int nextRequestIn() {
        long l = this.nextRequest - System.currentTimeMillis();
        if (l < 0L) {
            return 0;
        }
        return (int)Math.ceil((double)l / 1000.0);
    }

    public MineSkinResponse generateFromUrl(SkinUtils.SkinCallback skinCallback, String string, SkinUtils.ModelType modelType) {
        return this.doPost(skinCallback, "/generate/url", string, null, modelType);
    }

    private void printDebug(String string) {
        if (!this.isDebugging() || LibsDisguises.getInstance() == null) {
            return;
        }
        LibsDisguises.getInstance().getLogger().info("[MineSkinAPI] " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MineSkinResponse doPost(SkinUtils.SkinCallback skinCallback, String string, String string2, File file, SkinUtils.ModelType modelType) {
        MineSkinResponse mineSkinResponse;
        Object object;
        String string3;
        long l;
        HttpURLConnection httpURLConnection;
        block57: {
            Object object2;
            block56: {
                block54: {
                    block55: {
                        block50: {
                            block53: {
                                block52: {
                                    block51: {
                                        this.lock.lock();
                                        long l2 = this.nextRequest - System.currentTimeMillis();
                                        if (file != null) {
                                            this.printDebug("Grabbing a skin from file at " + file.getPath());
                                        } else if (string2 != null) {
                                            this.printDebug("Grabbing a skin from url '" + string2 + "'");
                                        }
                                        if (this.getApiKey() != null) {
                                            this.printDebug("Using a MineSkin api key!");
                                        }
                                        if (l2 > 0L) {
                                            this.printDebug("Sleeping for " + l2 + "ms before calling the API due to a recent request");
                                            try {
                                                Thread.sleep(l2);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                interruptedException.printStackTrace();
                                            }
                                        }
                                        httpURLConnection = null;
                                        l = TimeUnit.SECONDS.toMillis(10L);
                                        if (this.getApiKey() != null) {
                                            string = string + (string.contains("?") ? (char)'&' : '?') + "key=" + this.getApiKey();
                                        }
                                        URL uRL = new URL("https://api.mineskin.org" + string);
                                        httpURLConnection = (HttpURLConnection)uRL.openConnection();
                                        httpURLConnection.setConnectTimeout(19000);
                                        httpURLConnection.setReadTimeout(19000);
                                        httpURLConnection.setDoOutput(true);
                                        httpURLConnection.setRequestProperty("User-Agent", "LibsDisguises");
                                        string3 = "LD@" + Long.toHexString(System.currentTimeMillis());
                                        httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
                                        String string4 = "UTF-8";
                                        String string5 = "\r\n";
                                        object = httpURLConnection.getOutputStream();
                                        try {
                                            object2 = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)object, string4), true);
                                            try {
                                                ((PrintWriter)object2).append("--").append(string3).append(string5);
                                                ((PrintWriter)object2).append("Content-Disposition: form-data; name=\"visibility\"").append(string5);
                                                ((PrintWriter)object2).append("Content-Type: text/plain; charset=").append(string4).append(string5);
                                                ((PrintWriter)object2).append(string5).append("1").append(string5).flush();
                                                if (file != null) {
                                                    ((PrintWriter)object2).append("--").append(string3).append(string5);
                                                    ((PrintWriter)object2).append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(file.getName()).append("\"").append(string5);
                                                    ((PrintWriter)object2).append("Content-Type: image/png").append(string5);
                                                    ((PrintWriter)object2).append("Content-Transfer-Encoding: binary").append(string5);
                                                    ((PrintWriter)object2).append(string5).flush();
                                                    Files.copy(file.toPath(), (OutputStream)object);
                                                    ((OutputStream)object).flush();
                                                    ((PrintWriter)object2).append(string5).flush();
                                                } else if (string2 != null) {
                                                    ((PrintWriter)object2).append("--").append(string3).append(string5);
                                                    ((PrintWriter)object2).append("Content-Disposition: form-data; name=\"url\"").append(string5);
                                                    ((PrintWriter)object2).append(string5).append(string2).append(string5).flush();
                                                }
                                                if (modelType == SkinUtils.ModelType.SLIM) {
                                                    ((PrintWriter)object2).append("--").append(string3).append(string5);
                                                    ((PrintWriter)object2).append("Content-Disposition: form-data; name=\"model\"").append(string5);
                                                    ((PrintWriter)object2).append(string5).append("slim").append(string5).flush();
                                                }
                                                ((PrintWriter)object2).append("--").append(string3).append("--").append(string5).flush();
                                            }
                                            finally {
                                                ((PrintWriter)object2).close();
                                            }
                                        }
                                        finally {
                                            if (object != null) {
                                                ((OutputStream)object).close();
                                            }
                                        }
                                        this.printDebug("Received status code: " + httpURLConnection.getResponseCode());
                                        if (httpURLConnection.getResponseCode() != 500) break block50;
                                        object = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                                        object2 = (APIError)new Gson().fromJson((String)object, APIError.class);
                                        this.printDebug("Received error: " + (String)object);
                                        if (((APIError)object2).code != 403) break block51;
                                        skinCallback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + ((APIError)object2).code, LibsMsg.SKIN_API_403.get(new Object[0]));
                                        MineSkinResponse mineSkinResponse2 = null;
                                        this.nextRequest = System.currentTimeMillis() + l + 1000L;
                                        this.lock.unlock();
                                        return mineSkinResponse2;
                                    }
                                    if (((APIError)object2).code != 404) break block52;
                                    skinCallback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + ((APIError)object2).code, LibsMsg.SKIN_API_404.get(new Object[0]));
                                    MineSkinResponse mineSkinResponse3 = null;
                                    this.nextRequest = System.currentTimeMillis() + l + 1000L;
                                    this.lock.unlock();
                                    return mineSkinResponse3;
                                }
                                if (((APIError)object2).code != 408 && ((APIError)object2).code != 504 && ((APIError)object2).code != 599) break block53;
                                skinCallback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + ((APIError)object2).code, LibsMsg.SKIN_API_TIMEOUT.get(new Object[0]));
                                MineSkinResponse mineSkinResponse4 = null;
                                this.nextRequest = System.currentTimeMillis() + l + 1000L;
                                this.lock.unlock();
                                return mineSkinResponse4;
                            }
                            skinCallback.onError(LibsMsg.SKIN_API_FAIL_CODE, "" + ((APIError)object2).code, LibsMsg.SKIN_API_IMAGE_HAS_ERROR.get(((APIError)object2).error));
                            MineSkinResponse mineSkinResponse5 = null;
                            this.nextRequest = System.currentTimeMillis() + l + 1000L;
                            this.lock.unlock();
                            return mineSkinResponse5;
                        }
                        if (httpURLConnection.getResponseCode() != 400) break block54;
                        if (string2 == null) break block55;
                        skinCallback.onError(LibsMsg.SKIN_API_BAD_URL, new Object[0]);
                        object = null;
                        this.nextRequest = System.currentTimeMillis() + l + 1000L;
                        this.lock.unlock();
                        return object;
                    }
                    if (file == null) break block56;
                    skinCallback.onError(LibsMsg.SKIN_API_BAD_FILE, new Object[0]);
                    object = null;
                    this.nextRequest = System.currentTimeMillis() + l + 1000L;
                    this.lock.unlock();
                    return object;
                }
                if (httpURLConnection.getResponseCode() != 429) break block56;
                skinCallback.onError(LibsMsg.SKIN_API_FAIL_TOO_FAST, new Object[0]);
                object = null;
                this.nextRequest = System.currentTimeMillis() + l + 1000L;
                this.lock.unlock();
                return object;
            }
            object = httpURLConnection.getInputStream();
            object2 = new BufferedReader(new InputStreamReader((InputStream)object, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            this.printDebug("Received: " + (String)object2);
            MineSkinResponse mineSkinResponse6 = (MineSkinResponse)new Gson().fromJson((String)object2, MineSkinResponse.class);
            l = (long)(mineSkinResponse6.getNextRequest() * 1000.0);
            mineSkinResponse = mineSkinResponse6;
            if (object == null) break block57;
            ((InputStream)object).close();
        }
        this.nextRequest = System.currentTimeMillis() + l + 1000L;
        this.lock.unlock();
        return mineSkinResponse;
        {
            catch (Throwable throwable) {
                try {
                    if (object == null) throw throwable;
                    try {
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (this.isDebugging()) {
                        socketTimeoutException.printStackTrace();
                    }
                    skinCallback.onError(string2 == null ? LibsMsg.SKIN_API_TIMEOUT_ERROR : LibsMsg.SKIN_API_IMAGE_TIMEOUT, new Object[0]);
                    string3 = null;
                    this.nextRequest = System.currentTimeMillis() + l + 1000L;
                    this.lock.unlock();
                    return string3;
                }
                catch (Exception exception) {
                    block58: {
                        if (httpURLConnection == null || httpURLConnection.getResponseCode() != 524 && httpURLConnection.getResponseCode() != 408 && httpURLConnection.getResponseCode() != 504 && httpURLConnection.getResponseCode() != 599) break block58;
                        if (this.getApiKey() != null && httpURLConnection.getResponseCode() == 504) {
                            skinCallback.onError(LibsMsg.SKIN_API_TIMEOUT_API_KEY_ERROR, new Object[0]);
                        } else {
                            skinCallback.onError(LibsMsg.SKIN_API_TIMEOUT_ERROR, new Object[0]);
                        }
                        string3 = null;
                        this.nextRequest = System.currentTimeMillis() + l + 1000L;
                        this.lock.unlock();
                        return string3;
                    }
                    try {
                        block59: {
                            break block59;
                            {
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (DisguiseUtilities.getLogger() != null) {
                            DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                        }
                        exception.printStackTrace();
                        skinCallback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                        return null;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                    finally {
                        this.nextRequest = System.currentTimeMillis() + l + 1000L;
                        this.lock.unlock();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MineSkinResponse generateFromUUID(UUID uUID, SkinUtils.ModelType modelType) {
        block18: {
            this.lock.lock();
            long l = this.nextRequest - System.currentTimeMillis();
            if (l > 0L) {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            long l2 = TimeUnit.SECONDS.toMillis(10L);
            try {
                MineSkinResponse mineSkinResponse;
                block17: {
                    String string = "https://api.mineskin.org/generate/user/:" + uUID.toString();
                    if (modelType == SkinUtils.ModelType.SLIM) {
                        string = string + "?model=slim";
                    }
                    URL uRL = new URL(string);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestProperty("User-Agent", "LibsDisguises");
                    httpURLConnection.setDoOutput(true);
                    InputStream inputStream = httpURLConnection.getInputStream();
                    try {
                        String string2 = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                        MineSkinResponse mineSkinResponse2 = (MineSkinResponse)new Gson().fromJson(string2, MineSkinResponse.class);
                        l2 = (long)(mineSkinResponse2.getNextRequest() * 1000.0);
                        mineSkinResponse = mineSkinResponse2;
                        if (inputStream == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            if (exception.getMessage() != null && exception.getMessage().contains("Server returned HTTP response code: 400 for URL")) {
                                throw new IllegalArgumentException();
                            }
                            if (DisguiseUtilities.getLogger() != null) {
                                DisguiseUtilities.getLogger().warning("Failed to access MineSkin.org");
                            }
                            exception.printStackTrace();
                            break block18;
                        }
                    }
                    inputStream.close();
                }
                return mineSkinResponse;
            }
            finally {
                this.nextRequest = System.currentTimeMillis() + l2 + 1000L;
                this.lock.unlock();
            }
        }
        return null;
    }

    public MineSkinResponse generateFromFile(SkinUtils.SkinCallback skinCallback, File file, SkinUtils.ModelType modelType) {
        return this.doPost(skinCallback, "/generate/upload", null, file, modelType);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean bl) {
        this.debugging = bl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String string) {
        this.apiKey = string;
    }

    private class APIError {
        int code;
        String error;

        private APIError() {
        }
    }
}

