/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.metrics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.metrics.Metrics;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.plugin.PluginInformation;

public class MetricsInitalizer {
    public MetricsInitalizer() {
        this.infectWithMetrics();
    }

    private void infectWithMetrics() {
        String string;
        LibsDisguises libsDisguises = LibsDisguises.getInstance();
        String string2 = libsDisguises.getDescription().getVersion();
        Metrics metrics = new Metrics(libsDisguises, string2);
        if (LibsPremium.isPremium().booleanValue()) {
            boolean bl;
            PluginInformation pluginInformation = LibsPremium.getPaidInformation();
            if (pluginInformation == null) {
                pluginInformation = LibsPremium.getPluginInformation();
            }
            boolean bl2 = bl = !pluginInformation.getUserID().matches("[0-9]+") || pluginInformation.getUserID().equals("1") || !pluginInformation.getResourceID().equals("32453") || !pluginInformation.getDownloadID().matches("-?[0-9]+");
            string = bl ? (libsDisguises.isReleaseBuild() && LibsPremium.getPaidInformation() == null ? "Custom Plugin" : "Custom Builds") : (libsDisguises.isReleaseBuild() ? "Paid Plugin" : "Paid Builds");
        } else {
            string = "Free Builds";
        }
        metrics.addCustomChart(new Metrics.SimplePie("bisecthosting"){

            @Override
            public String getValue() {
                return "" + LibsPremium.isBisectHosted();
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("grabskin_command"){

            @Override
            public String getValue() {
                return "" + DisguiseUtilities.isGrabSkinCommandUsed();
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("grabhead_command"){

            @Override
            public String getValue() {
                return "" + DisguiseUtilities.isGrabHeadCommandUsed();
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("default_libraryaddict"){

            @Override
            public String getValue() {
                return (DisguiseAPI.getRawCustomDisguise("libraryaddict") != null) + "";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("save_disguise_command"){

            @Override
            public String getValue() {
                return "" + DisguiseUtilities.isSaveDisguiseCommandUsed();
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("copydisguise_command"){

            @Override
            public String getValue() {
                return "" + DisguiseUtilities.isCopyDisguiseCommandUsed();
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("premium"){

            @Override
            public String getValue() {
                return string;
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("translations"){

            @Override
            public String getValue() {
                return LibsPremium.isPremium() != false && DisguiseConfig.isUseTranslations() ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("custom_disguises"){

            @Override
            public String getValue() {
                HashMap<DisguisePerm, String> hashMap = DisguiseConfig.getCustomDisguises();
                return hashMap.size() + (hashMap.containsKey("libraryaddict") ? -1 : 0) > 0 ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.MultiLineChart("disguised_entities"){

            @Override
            public HashMap<String, Integer> getValues(HashMap<String, Integer> hashMap) {
                for (Set<TargetedDisguise> set : DisguiseUtilities.getDisguises().values()) {
                    for (Disguise disguise : set) {
                        String string;
                        if (disguise.getEntity() == null || !disguise.isDisguiseInUse()) continue;
                        hashMap.put(string, hashMap.containsKey(string = disguise.getEntity().getType().name()) ? hashMap.get(string) + 1 : 1);
                    }
                }
                return hashMap;
            }
        });
        metrics.addCustomChart(new Metrics.MultiLineChart("disguises_used"){

            @Override
            public HashMap<String, Integer> getValues(HashMap<String, Integer> hashMap) {
                for (Set<TargetedDisguise> set : DisguiseUtilities.getDisguises().values()) {
                    for (Disguise disguise : set) {
                        String string;
                        if (disguise.getEntity() == null || !disguise.isDisguiseInUse()) continue;
                        hashMap.put(string, hashMap.containsKey(string = disguise.getType().name()) ? hashMap.get(string) + 1 : 1);
                    }
                }
                return hashMap;
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("disguised_using"){

            @Override
            public String getValue() {
                if (DisguiseUtilities.isPluginsUsed()) {
                    if (DisguiseUtilities.isCommandsUsed()) {
                        return "Plugins and Commands";
                    }
                    return "Plugins";
                }
                if (DisguiseUtilities.isCommandsUsed()) {
                    return "Commands";
                }
                return "Unknown";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("active_disguises"){

            @Override
            public String getValue() {
                int n = 0;
                for (Set<TargetedDisguise> set : DisguiseUtilities.getDisguises().values()) {
                    n += set.size();
                }
                if (n == 0) {
                    return "0";
                }
                if (n <= 5) {
                    return "1 to 5";
                }
                if (n <= 15) {
                    return "6 to 15";
                }
                if (n <= 30) {
                    return "16 to 30";
                }
                if (n <= 60) {
                    return "30 to 60";
                }
                if (n <= 100) {
                    return "60 to 100";
                }
                if (n <= 200) {
                    return "100 to 200";
                }
                return "More than 200";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("self_disguises"){

            @Override
            public String getValue() {
                return DisguiseConfig.isViewDisguises() ? "Yes" : "No";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("spigot"){

            @Override
            public String getValue() {
                try {
                    Class.forName("org.spigotmc.SpigotConfig");
                    return "Yes";
                }
                catch (Exception exception) {
                    return "No";
                }
            }
        });
        final boolean bl = DisguiseConfig.isNotifyUpdate();
        metrics.addCustomChart(new Metrics.SimplePie("updates"){

            @Override
            public String getValue() {
                return bl ? "Enabled" : "Disabled";
            }
        });
        if (libsDisguises.getBuildNo() != null) {
            final String string3 = libsDisguises.getBuildNo();
            metrics.addCustomChart(new Metrics.SimplePie("build_number"){

                @Override
                public String getValue() {
                    return string3;
                }
            });
        }
        metrics.addCustomChart(new Metrics.SimplePie("targeted_disguises"){
            private boolean targetedDisguises;

            @Override
            public String getValue() {
                if (this.targetedDisguises) {
                    return "Yes";
                }
                Collection<Set<TargetedDisguise>> collection = DisguiseUtilities.getDisguises().values();
                if (collection.isEmpty()) {
                    return "Unknown";
                }
                for (Set<TargetedDisguise> set : collection) {
                    for (TargetedDisguise targetedDisguise : set) {
                        if (targetedDisguise.getObservers().isEmpty()) continue;
                        this.targetedDisguises = true;
                        return "Yes";
                    }
                }
                return "No";
            }
        });
    }
}

