/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerSkinHandler
implements Listener {
    private final Cache<Player, List<PlayerSkin>> cache = CacheBuilder.newBuilder().weakKeys().expireAfterWrite((long)(DisguiseConfig.getPlayerDisguisesSkinExpiresMove() * 50), TimeUnit.MILLISECONDS).removalListener(removalNotification -> {
        if (removalNotification.getCause() != RemovalCause.EXPIRED) {
            return;
        }
        List list = (List)removalNotification.getValue();
        for (PlayerSkin playerSkin : list) {
            this.doPacketRemoval((Player)removalNotification.getKey(), playerSkin);
        }
        list.clear();
    }).build();

    public PlayerSkinHandler() {
        new BukkitRunnable(){

            public void run() {
                PlayerSkinHandler.this.getCache().asMap().forEach((player, list) -> PlayerSkinHandler.this.doTeleport(player, list));
            }
        }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 1L, 1L);
    }

    public boolean isSleeping(Player player, PlayerDisguise playerDisguise) {
        List list = (List)this.getCache().getIfPresent((Object)player);
        if (list == null) {
            return false;
        }
        return list.stream().anyMatch(playerSkin -> playerSkin.getDisguise().get() == playerDisguise);
    }

    public PlayerSkin addPlayerSkin(Player player, PlayerDisguise playerDisguise) {
        this.tryProcess(player, false);
        ArrayList<PlayerSkin> arrayList = (ArrayList<PlayerSkin>)this.getCache().getIfPresent((Object)player);
        if (arrayList == null) {
            arrayList = new ArrayList<PlayerSkin>();
        }
        PlayerSkin playerSkin = new PlayerSkin(new WeakReference<PlayerDisguise>(playerDisguise));
        arrayList.add(playerSkin);
        this.getCache().put((Object)player, arrayList);
        return playerSkin;
    }

    private void doTeleport(Player player, List<PlayerSkin> list) {
        if (player == null || !player.isOnline()) {
            return;
        }
        Location location = player.getLocation();
        location.add(location.getDirection().normalize().multiply(10));
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        packetContainer.getModifier().write(1, (Object)location.getX());
        packetContainer.getModifier().write(2, (Object)location.getY());
        packetContainer.getModifier().write(3, (Object)location.getZ());
        for (PlayerSkin playerSkin : new ArrayList<PlayerSkin>(list)) {
            PlayerDisguise playerDisguise;
            if (!list.contains(playerSkin) || !playerSkin.isSleepPackets() || (playerDisguise = (PlayerDisguise)playerSkin.getDisguise().get()) == null || !playerDisguise.isDisguiseInUse()) continue;
            packetContainer = packetContainer.shallowClone();
            int n = playerDisguise.getEntity().getEntityId();
            if (n == player.getEntityId()) {
                n = DisguiseAPI.getSelfDisguiseId();
            }
            packetContainer.getModifier().write(0, (Object)n);
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void handlePackets(Player player, PlayerDisguise playerDisguise, LibsPackets libsPackets) {
        boolean bl = libsPackets.getPackets().stream().anyMatch(packetContainer -> packetContainer.getType() == PacketType.Play.Server.NAMED_ENTITY_SPAWN);
        List list = (List)this.getCache().getIfPresent((Object)player);
        if (list == null) {
            return;
        }
        PlayerSkin playerSkin2 = list.stream().filter(playerSkin -> playerSkin.getDisguise().get() == playerDisguise).findAny().orElse(null);
        if (playerSkin2 == null || !playerSkin2.isSleepPackets()) {
            return;
        }
        if (bl) {
            libsPackets.getDelayedPacketsMap().entrySet().removeIf(entry -> {
                ((ArrayList)entry.getValue()).removeIf(packetContainer -> packetContainer.getType() == PacketType.Play.Server.ENTITY_EQUIPMENT && this.isRemove(playerSkin2, (PacketContainer)packetContainer));
                return ((ArrayList)entry.getValue()).isEmpty();
            });
            return;
        }
        libsPackets.getPackets().removeIf(packetContainer -> this.isRemove(playerSkin2, (PacketContainer)packetContainer));
        libsPackets.getDelayedPacketsMap().entrySet().removeIf(entry -> {
            ((ArrayList)entry.getValue()).removeIf(packetContainer -> this.isRemove(playerSkin2, (PacketContainer)packetContainer));
            return ((ArrayList)entry.getValue()).isEmpty();
        });
    }

    private boolean isRemove(PlayerSkin playerSkin, PacketContainer packetContainer) {
        PacketType packetType = packetContainer.getType();
        if (packetType != PacketType.Play.Server.ENTITY_EQUIPMENT && packetType != PacketType.Play.Server.ENTITY_METADATA) {
            return false;
        }
        if (packetType == PacketType.Play.Server.ENTITY_EQUIPMENT) {
            playerSkin.getSleptPackets().computeIfAbsent(3, n -> new ArrayList()).add(packetContainer);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onUndisguise(UndisguiseEvent undisguiseEvent) {
        if (!undisguiseEvent.getDisguise().isPlayerDisguise()) {
            return;
        }
        PlayerDisguise playerDisguise = (PlayerDisguise)undisguiseEvent.getDisguise();
        ArrayList arrayList = new ArrayList(this.getCache().asMap().keySet());
        for (Player player : arrayList) {
            PlayerSkin playerSkin2;
            List list = (List)this.getCache().getIfPresent((Object)player);
            if (list == null || (playerSkin2 = (PlayerSkin)list.stream().filter(playerSkin -> playerSkin.getDisguise().get() == playerDisguise).findAny().orElse(null)) == null) continue;
            this.doPacketRemoval(player, playerSkin2);
            if (list.size() == 1) {
                this.getCache().invalidate((Object)player);
                continue;
            }
            list.remove(playerSkin2);
        }
    }

    private void addMetadata(Player player, PlayerSkin playerSkin) {
        PlayerDisguise playerDisguise = (PlayerDisguise)playerSkin.getDisguise().get();
        if (!playerDisguise.isDisguiseInUse()) {
            return;
        }
        Entity entity = playerDisguise.getEntity();
        WrappedDataWatcher wrappedDataWatcher = DisguiseUtilities.createSanitizedDataWatcher(player, WrappedDataWatcher.getEntityWatcher((Entity)entity), playerDisguise.getWatcher());
        PacketContainer packetContainer = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{entity.getEntityId(), wrappedDataWatcher, true}).createPacket(new Object[]{entity.getEntityId(), wrappedDataWatcher, true});
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
    }

    private void addTeleport(Player player, PlayerSkin playerSkin) {
        int n;
        PlayerDisguise playerDisguise = (PlayerDisguise)playerSkin.getDisguise().get();
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.ENTITY_TELEPORT);
        StructureModifier structureModifier = packetContainer.getModifier();
        Location location = playerDisguise.getEntity().getLocation().add(0.0, (double)playerDisguise.getWatcher().getYModifier() + DisguiseUtilities.getYModifier(playerDisguise), 0.0);
        Float f = DisguiseConfig.isMovementPacketsEnabled() ? playerDisguise.getWatcher().getPitchLock() : null;
        Float f2 = DisguiseConfig.isMovementPacketsEnabled() ? playerDisguise.getWatcher().getYawLock() : null;
        byte by = (byte)((f2 == null ? location.getYaw() : f2.floatValue()) * 256.0f / 360.0f);
        byte by2 = (byte)((f == null ? location.getPitch() : f.floatValue()) * 256.0f / 360.0f);
        if (DisguiseConfig.isMovementPacketsEnabled()) {
            if (f2 == null) {
                by = DisguiseUtilities.getYaw(DisguiseType.getType(playerDisguise.getEntity().getType()), by);
            }
            if (f == null) {
                by2 = DisguiseUtilities.getPitch(DisguiseType.getType(playerDisguise.getEntity().getType()), by2);
            }
            by = DisguiseUtilities.getYaw(playerDisguise.getType(), by);
            by2 = DisguiseUtilities.getPitch(playerDisguise.getType(), by2);
        }
        if ((n = playerDisguise.getEntity().getEntityId()) == player.getEntityId()) {
            n = DisguiseAPI.getSelfDisguiseId();
        }
        structureModifier.write(0, (Object)n);
        structureModifier.write(1, (Object)location.getX());
        structureModifier.write(2, (Object)location.getY());
        structureModifier.write(3, (Object)location.getZ());
        structureModifier.write(4, (Object)by);
        structureModifier.write(5, (Object)by2);
        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
    }

    private void doPacketRemoval(final Player player, final PlayerSkin playerSkin) {
        final PlayerDisguise playerDisguise = (PlayerDisguise)playerSkin.getDisguise().get();
        if (playerDisguise == null) {
            return;
        }
        try {
            Object object;
            for (final Map.Entry<Integer, ArrayList<PacketContainer>> entry : playerSkin.getSleptPackets().entrySet()) {
                if (entry.getKey() == 0) {
                    for (PacketContainer packetContainer : entry.getValue()) {
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
                    }
                    continue;
                }
                new BukkitRunnable(){

                    public void run() {
                        try {
                            if (!playerDisguise.isDisguiseInUse()) {
                                return;
                            }
                            for (PacketContainer packetContainer : (ArrayList)entry.getValue()) {
                                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
                            }
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), (long)entry.getKey().intValue());
            }
            if (playerSkin.isSleepPackets()) {
                this.addTeleport(player, playerSkin);
                new BukkitRunnable(){

                    public void run() {
                        try {
                            PlayerSkinHandler.this.addMetadata(player, playerSkin);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
            if (DisguiseConfig.isArmorstandsName() && playerDisguise.isNameVisible() && playerDisguise.getMultiNameLength() > 0) {
                Map.Entry<Integer, ArrayList<PacketContainer>> entry;
                object = DisguiseUtilities.getNamePackets(playerDisguise, new String[0]);
                entry = ((ArrayList)object).iterator();
                while (entry.hasNext()) {
                    PacketContainer packetContainer = (PacketContainer)entry.next();
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                }
            }
            if (playerSkin.isDoTabList()) {
                object = DisguiseUtilities.getTabPacket(playerDisguise, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, (PacketContainer)object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private void tryProcess(Player player, boolean bl) {
        List list = (List)this.getCache().getIfPresent((Object)player);
        if (list == null) {
            return;
        }
        ArrayList<PlayerSkin> arrayList = new ArrayList<PlayerSkin>();
        list.removeIf(playerSkin -> {
            if (!playerSkin.canRemove(bl)) {
                return false;
            }
            arrayList.add((PlayerSkin)playerSkin);
            return true;
        });
        arrayList.forEach(playerSkin -> this.doPacketRemoval(player, (PlayerSkin)playerSkin));
        if (!list.isEmpty()) {
            return;
        }
        this.getCache().invalidate((Object)player);
    }

    @EventHandler
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        this.tryProcess(playerMoveEvent.getPlayer(), true);
    }

    public Cache<Player, List<PlayerSkin>> getCache() {
        return this.cache;
    }

    public static class PlayerSkin {
        private final long firstPacketSent = System.currentTimeMillis();
        private final WeakReference<PlayerDisguise> disguise;
        private final HashMap<Integer, ArrayList<PacketContainer>> sleptPackets = new HashMap();
        private boolean doTabList = true;
        private boolean sleepPackets;

        public boolean canRemove(boolean bl) {
            return this.firstPacketSent + (long)(DisguiseConfig.getTablistRemoveDelay() * 50) + (long)(bl ? 0 : DisguiseConfig.getPlayerDisguisesSkinExpiresMove() * 50) < System.currentTimeMillis();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PlayerSkin playerSkin = (PlayerSkin)object;
            return this.getDisguise().get() == playerSkin.getDisguise().get();
        }

        public PlayerSkin(WeakReference<PlayerDisguise> weakReference) {
            this.disguise = weakReference;
        }

        public WeakReference<PlayerDisguise> getDisguise() {
            return this.disguise;
        }

        public HashMap<Integer, ArrayList<PacketContainer>> getSleptPackets() {
            return this.sleptPackets;
        }

        public boolean isDoTabList() {
            return this.doTabList;
        }

        public void setDoTabList(boolean bl) {
            this.doTabList = bl;
        }

        public boolean isSleepPackets() {
            return this.sleepPackets;
        }

        public void setSleepPackets(boolean bl) {
            this.sleepPackets = bl;
        }
    }
}

