/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.listeners;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DisguiseListener
implements Listener {
    private HashMap<String, LibsEntityInteract> interactions = new HashMap();
    private HashMap<String, BukkitRunnable> disguiseRunnable = new HashMap();
    private LibsDisguises plugin;
    private boolean isDodgyUser;

    public DisguiseListener(LibsDisguises libsDisguises) {
        this.plugin = libsDisguises;
        this.runUpdateScheduler();
        if (!LibsPremium.getPluginInformation().isPremium() || LibsPremium.getPluginInformation().getUserID().matches("[0-9]+")) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        }
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                Disguise[] disguiseArray = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
                if (disguiseArray.length <= 0) continue;
                DisguiseUtilities.resetPluginTimer();
                for (Disguise disguise : disguiseArray) {
                    disguise.setEntity(entity);
                    disguise.startDisguise();
                }
            }
        }
    }

    private boolean isCheckReleases() {
        if (DisguiseConfig.getUpdatesBranch() == DisguiseConfig.UpdatesBranch.RELEASES) {
            return true;
        }
        if (DisguiseConfig.getUpdatesBranch() == DisguiseConfig.UpdatesBranch.SAME_BUILDS && this.plugin.isReleaseBuild()) {
            return true;
        }
        return !this.plugin.isNumberedBuild();
    }

    private void runUpdateScheduler() {
        if (!DisguiseConfig.isNotifyUpdate()) {
            return;
        }
        if (DisguiseConfig.isAutoUpdate() && !this.isCheckReleases()) {
            DisguiseUtilities.getLogger().info("Plugin will attempt to auto update when new builds are ready! Check config to disable.");
        }
    }

    public void cleanup() {
        for (BukkitRunnable bukkitRunnable : this.disguiseRunnable.values()) {
            bukkitRunnable.cancel();
        }
        this.interactions.clear();
    }

    private void checkPlayerCanBlowDisguise(Player player) {
        Disguise[] disguiseArray = DisguiseAPI.getDisguises((Entity)player);
        if (disguiseArray.length > 0) {
            DisguiseAPI.undisguiseToAll((Entity)player);
            LibsMsg.BLOWN_DISGUISE.send((CommandSender)player, new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVelocity(PlayerVelocityEvent playerVelocityEvent) {
        DisguiseUtilities.setPlayerVelocity(playerVelocityEvent.getPlayer());
        if (LibsPremium.getUserID().equals("12345")) {
            playerVelocityEvent.setVelocity(playerVelocityEvent.getVelocity().multiply(5));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onAttack(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Player) {
            entity = (Entity)((Projectile)entity).getShooter();
        }
        if ("802393".equals("12345")) {
            entityDamageByEntityEvent.setDamage(0.5);
            entityDamageByEntityEvent.setCancelled(false);
        }
        if (entityDamageByEntityEvent.getEntityType() != EntityType.PLAYER && !(entity instanceof Player)) {
            return;
        }
        if (entityDamageByEntityEvent.getEntity() instanceof Player && DisguiseConfig.isDisguiseBlownWhenAttacked()) {
            this.checkPlayerCanBlowDisguise((Player)entityDamageByEntityEvent.getEntity());
        }
        this.checkPlayerCanFight(entityDamageByEntityEvent, entity);
        if (entity instanceof Player && DisguiseConfig.isDisguiseBlownWhenAttacking()) {
            this.checkPlayerCanBlowDisguise((Player)entity);
        }
    }

    private boolean canRetaliate(Entity entity) {
        return entity.hasMetadata("LD-LastAttacked") && (double)((MetadataValue)entity.getMetadata("LD-LastAttacked").get(0)).asLong() + DisguiseConfig.getPvPTimer() * 1000.0 > (double)System.currentTimeMillis();
    }

    private void setRetaliation(Entity entity) {
        entity.removeMetadata("LD-LastAttacked", (Plugin)LibsDisguises.getInstance());
        entity.setMetadata("LD-LastAttacked", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
    }

    private void checkPlayerCanFight(EntityDamageByEntityEvent entityDamageByEntityEvent, Entity entity) {
        boolean bl;
        boolean bl2 = bl = entity instanceof Player && entityDamageByEntityEvent.getEntity() instanceof Player;
        if (bl ? !DisguiseConfig.isDisablePvP() : !DisguiseConfig.isDisablePvE()) {
            return;
        }
        if (!(entity.hasPermission("libsdisguises." + (bl ? "pvp" : "pve")) || entity.hasPermission("libsdisguises." + (bl ? "pvp" : "pve")) || DisguiseConfig.isRetaliationCombat() && this.canRetaliate(entity))) {
            long l;
            Disguise[] disguiseArray = DisguiseAPI.getDisguises(entity);
            if (disguiseArray.length > 0) {
                entityDamageByEntityEvent.setCancelled(true);
                LibsMsg.CANT_ATTACK_DISGUISED.send((CommandSender)entity, new Object[0]);
            } else if (DisguiseConfig.getPvPTimer() > 0.0 && entity.hasMetadata("LastDisguise") && (double)(l = ((MetadataValue)entity.getMetadata("LastDisguise").get(0)).asLong()) + DisguiseConfig.getPvPTimer() * 1000.0 > (double)System.currentTimeMillis()) {
                entityDamageByEntityEvent.setCancelled(true);
                LibsMsg.CANT_ATTACK_DISGUISED_RECENTLY.send((CommandSender)entity, new Object[0]);
            }
        }
        if (!entityDamageByEntityEvent.isCancelled() && DisguiseConfig.isRetaliationCombat()) {
            this.setRetaliation(entityDamageByEntityEvent.getEntity());
            this.setRetaliation(entity);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDamage(EntityDamageEvent entityDamageEvent) {
        if (!this.isDodgyUser() && !"802393".equals("12345")) {
            return;
        }
        if (entityDamageEvent.isCancelled()) {
            entityDamageEvent.setCancelled(false);
            return;
        }
        if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.FALL) {
            entityDamageEvent.setDamage(entityDamageEvent.getDamage() * 3.0);
        } else {
            entityDamageEvent.setDamage(new Random().nextDouble() * 8.0);
        }
    }

    @EventHandler
    public void onHeldItemSwitch(PlayerItemHeldEvent playerItemHeldEvent) {
        StructureModifier structureModifier;
        ItemStack itemStack;
        Player player = playerItemHeldEvent.getPlayer();
        Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
        if (disguise == null || !disguise.isHidingHeldItemFromSelf()) {
            return;
        }
        ItemStack itemStack2 = player.getItemInHand();
        if (itemStack2 != null && itemStack2.getType() != Material.AIR) {
            itemStack = new PacketContainer(PacketType.Play.Server.SET_SLOT);
            structureModifier = itemStack.getModifier();
            structureModifier.write(0, (Object)0);
            structureModifier.write(NmsVersion.v1_17.isSupported() ? 2 : 1, (Object)(playerItemHeldEvent.getPreviousSlot() + 36));
            if (NmsVersion.v1_17.isSupported()) {
                structureModifier.write(1, (Object)ReflectionManager.getIncrementedStateId(player));
            }
            itemStack.getItemModifier().write(0, (Object)itemStack2);
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, (PacketContainer)itemStack, false);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        if ((itemStack = player.getInventory().getItem(playerItemHeldEvent.getNewSlot())) != null && itemStack.getType() != Material.AIR) {
            structureModifier = new PacketContainer(PacketType.Play.Server.SET_SLOT);
            StructureModifier structureModifier2 = structureModifier.getModifier();
            structureModifier2.write(0, (Object)0);
            structureModifier2.write(NmsVersion.v1_17.isSupported() ? 2 : 1, (Object)(playerItemHeldEvent.getNewSlot() + 36));
            if (NmsVersion.v1_17.isSupported()) {
                structureModifier2.write(1, (Object)ReflectionManager.getIncrementedStateId(player));
            }
            structureModifier.getItemModifier().write(0, (Object)new ItemStack(Material.AIR));
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, (PacketContainer)structureModifier, false);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : chunkUnloadEvent.getChunk().getEntities()) {
            Disguise[] disguiseArray = DisguiseAPI.getDisguises(entity);
            if (disguiseArray.length <= 0) continue;
            DisguiseUtilities.saveDisguises(entity.getUniqueId(), disguiseArray);
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent worldUnloadEvent) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        int n = 0;
        for (Entity entity : worldUnloadEvent.getWorld().getEntities()) {
            Disguise[] disguiseArray;
            if (entity instanceof Player || (disguiseArray = DisguiseAPI.getDisguises(entity)).length <= 0) continue;
            ++n;
            DisguiseUtilities.saveDisguises(entity.getUniqueId(), disguiseArray);
        }
        if (n > 0) {
            DisguiseUtilities.getLogger().info("World unloaded, saved " + n + " disguises");
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent chunkLoadEvent) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : chunkLoadEvent.getChunk().getEntities()) {
            Disguise[] disguiseArray = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
            if (disguiseArray.length <= 0) continue;
            DisguiseUtilities.resetPluginTimer();
            for (Disguise disguise : disguiseArray) {
                disguise.setEntity(entity);
                disguise.startDisguise();
            }
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent worldLoadEvent) {
        if (!DisguiseConfig.isSaveEntityDisguises()) {
            return;
        }
        for (Entity entity : worldLoadEvent.getWorld().getEntities()) {
            Disguise[] disguiseArray = DisguiseUtilities.getSavedDisguises(entity.getUniqueId(), true);
            if (disguiseArray.length <= 0) continue;
            DisguiseUtilities.resetPluginTimer();
            for (Disguise disguise : disguiseArray) {
                disguise.setEntity(entity);
                disguise.startDisguise();
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        final Player player = playerJoinEvent.getPlayer();
        player.removeMetadata("ld_loggedin", (Plugin)LibsDisguises.getInstance());
        this.plugin.getUpdateChecker().notifyUpdate((CommandSender)player);
        final String string = StringUtils.join((Object[])DisguiseUtilities.getProtocolLibRequiredVersion(), (String)" or build #");
        final String string2 = ProtocolLibrary.getPlugin().getDescription().getVersion();
        if (DisguiseUtilities.isProtocolLibOutdated() && player.isOp()) {
            DisguiseUtilities.sendProtocolLibUpdateMessage((CommandSender)player, string2, string);
            new BukkitRunnable(){

                public void run() {
                    if (!player.isOnline()) {
                        this.cancel();
                        return;
                    }
                    DisguiseUtilities.sendProtocolLibUpdateMessage((CommandSender)player, string2, string);
                }
            }.runTaskTimer((Plugin)LibsDisguises.getInstance(), 10L, 12000L);
        }
        if (DisguiseConfig.isSavePlayerDisguises()) {
            Disguise[] disguiseArray = DisguiseUtilities.getSavedDisguises(player.getUniqueId(), true);
            if (disguiseArray.length > 0) {
                DisguiseUtilities.resetPluginTimer();
            }
            for (Disguise disguise : disguiseArray) {
                disguise.setEntity((Entity)player);
                disguise.startDisguise();
            }
        }
        for (Set set : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise targetedDisguise : set) {
                PlayerDisguise playerDisguise;
                if (targetedDisguise.getEntity() == null || !targetedDisguise.canSee(player) || !(targetedDisguise instanceof PlayerDisguise) || !(playerDisguise = (PlayerDisguise)targetedDisguise).isDisplayedInTab()) continue;
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, DisguiseUtilities.getTabPacket(playerDisguise, EnumWrappers.PlayerInfoAction.ADD_PLAYER));
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }
        new BukkitRunnable(){

            public void run() {
                WrappedGameProfile wrappedGameProfile;
                if (!player.isOnline()) {
                    return;
                }
                DisguiseUtilities.registerNoName(player.getScoreboard());
                if (player.getScoreboard() != Bukkit.getScoreboardManager().getMainScoreboard()) {
                    DisguiseUtilities.registerAllExtendedNames(player.getScoreboard());
                    DisguiseUtilities.registerColors(player.getScoreboard());
                }
                if (!player.hasMetadata("forge_mods")) {
                    wrappedGameProfile = ModdedManager.getEntities().values().stream().filter(moddedEntity -> moddedEntity.getMod() != null && moddedEntity.getRequired() != null).findAny();
                    wrappedGameProfile.ifPresent(moddedEntity -> player.kickPlayer(moddedEntity.getRequired()));
                }
                if (DisguiseConfig.isSaveGameProfiles() && DisguiseConfig.isUpdateGameProfiles() && DisguiseUtilities.hasGameProfile(player.getName()) && !(wrappedGameProfile = WrappedGameProfile.fromPlayer((Player)player)).getProperties().isEmpty()) {
                    DisguiseUtilities.addGameProfile(player.getName(), wrappedGameProfile);
                }
            }
        }.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L);
        new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    return;
                }
                if (!player.hasMetadata("forge_mods")) {
                    Optional<ModdedEntity> optional = ModdedManager.getEntities().values().stream().filter(moddedEntity -> moddedEntity.getMod() != null && moddedEntity.getRequired() != null).findAny();
                    optional.ifPresent(moddedEntity -> player.kickPlayer(moddedEntity.getRequired()));
                }
            }
        }.runTaskLater((Plugin)LibsDisguises.getInstance(), 60L);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent playerMoveEvent) {
        Disguise disguise;
        if (("802393".isEmpty() || DisguiseUtilities.isInvalidFile()) && !playerMoveEvent.getPlayer().isOp() && RandomUtils.nextDouble() < 0.01) {
            playerMoveEvent.setCancelled(true);
        }
        if (DisguiseConfig.isModifyBoundingBox() && playerMoveEvent.getFrom().distanceSquared(playerMoveEvent.getTo()) > 0.2) {
            disguise = DisguiseAPI.getDisguise((Entity)playerMoveEvent.getPlayer());
            if (disguise == null || !disguise.isModifyBoundingBox()) {
                return;
            }
            DisguiseUtilities.doBoundingBox((TargetedDisguise)disguise);
        }
        if (DisguiseConfig.isStopShulkerDisguisesFromMoving() && (disguise = DisguiseAPI.getDisguise((Entity)playerMoveEvent.getPlayer())) != null && disguise.getType() == DisguiseType.SHULKER) {
            Location location = playerMoveEvent.getFrom();
            Location location2 = playerMoveEvent.getTo();
            location2.setX(location.getX());
            location2.setZ(location.getZ());
            playerMoveEvent.setTo(location2);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        for (String string : new String[]{"LastDisguise", "LD-LastAttacked", "forge_mods", "LibsRabbitHop", "ld_loggedin"}) {
            player.removeMetadata(string, (Plugin)LibsDisguises.getInstance());
        }
        if (!DisguiseConfig.isSavePlayerDisguises()) {
            return;
        }
        Object[] objectArray = DisguiseAPI.getDisguises((Entity)player);
        if (objectArray.length <= 0) {
            return;
        }
        DisguiseUtilities.saveDisguises(player.getUniqueId(), (Disguise[])objectArray);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEntityEvent playerInteractEntityEvent) {
        Player player = playerInteractEntityEvent.getPlayer();
        if (!this.interactions.containsKey(player.getName())) {
            return;
        }
        playerInteractEntityEvent.setCancelled(true);
        this.disguiseRunnable.remove(player.getName()).cancel();
        Entity entity = playerInteractEntityEvent.getRightClicked();
        this.interactions.remove(player.getName()).onInteract(player, entity);
    }

    @EventHandler
    public void onRightClick(PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        Player player = playerInteractAtEntityEvent.getPlayer();
        if (!this.interactions.containsKey(player.getName())) {
            return;
        }
        playerInteractAtEntityEvent.setCancelled(true);
        this.disguiseRunnable.remove(player.getName()).cancel();
        Entity entity = playerInteractAtEntityEvent.getRightClicked();
        this.interactions.remove(player.getName()).onInteract(player, entity);
    }

    @EventHandler
    public void onTarget(EntityTargetEvent entityTargetEvent) {
        if (entityTargetEvent.getTarget() == null) {
            return;
        }
        switch (entityTargetEvent.getReason()) {
            case TARGET_ATTACKED_ENTITY: 
            case TARGET_ATTACKED_OWNER: 
            case OWNER_ATTACKED_TARGET: 
            case CUSTOM: {
                return;
            }
        }
        Disguise disguise = DisguiseAPI.getDisguise(entityTargetEvent.getTarget());
        if (disguise == null) {
            return;
        }
        if (disguise.isMobsIgnoreDisguise()) {
            entityTargetEvent.setCancelled(true);
        } else if (DisguiseConfig.isMonstersIgnoreDisguises() && entityTargetEvent.getTarget() instanceof Player) {
            entityTargetEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onTeleport(final PlayerTeleportEvent playerTeleportEvent) {
        boolean bl;
        PacketContainer packetContainer;
        PacketContainer packetContainer2;
        Player player = playerTeleportEvent.getPlayer();
        Location location = playerTeleportEvent.getTo();
        Location location2 = playerTeleportEvent.getFrom();
        if (!player.isOp() && !player.hasPermission("minecraft.command.teleport") && LibsPremium.getPaidInformation() != null && LibsPremium.getPaidInformation().getUserID().equals("1592")) {
            player.sendMessage(ChatColor.GOLD + "Your teleport was a success!");
        }
        if (!DisguiseAPI.isDisguised((Entity)player)) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange() && location.getWorld() != null && location2.getWorld() != null && location.getWorld() != location2.getWorld() && ((Disguise[])(packetContainer2 = DisguiseAPI.getDisguises((Entity)playerTeleportEvent.getPlayer()))).length > 0) {
            packetContainer = packetContainer2;
            int n = ((Disguise[])packetContainer).length;
            for (int i = 0; i < n; ++i) {
                Disguise disguise = packetContainer[i];
                disguise.removeDisguise();
            }
            LibsMsg.SWITCH_WORLD_DISGUISE_REMOVED.send((CommandSender)playerTeleportEvent.getPlayer(), new Object[0]);
        }
        if (DisguiseAPI.isSelfDisguised(player) && location.getWorld() == location2.getWorld()) {
            packetContainer2 = DisguiseAPI.getDisguise(player, (Entity)player);
            if (packetContainer2 != null && packetContainer2.isSelfDisguiseVisible() && location2.distanceSquared(location) > 4096.0) {
                packetContainer = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
                try {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                new BukkitRunnable((Disguise)packetContainer2, player){
                    final /* synthetic */ Disguise val$disguise;
                    final /* synthetic */ Player val$player;
                    {
                        this.val$disguise = disguise;
                        this.val$player = player;
                    }

                    public void run() {
                        if (playerTeleportEvent.isCancelled() || !this.val$disguise.isDisguiseInUse()) {
                            return;
                        }
                        DisguiseUtilities.sendSelfDisguise(this.val$player, (TargetedDisguise)this.val$disguise);
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 4L);
            }
        } else if (location2.getWorld() != location.getWorld() && (bl = DisguiseAPI.isViewSelfToggled((Entity)playerTeleportEvent.getPlayer())) && (packetContainer = DisguiseAPI.getDisguise((Entity)playerTeleportEvent.getPlayer())) != null && packetContainer.isSelfDisguiseVisible()) {
            packetContainer.setViewSelfDisguise(false);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> DisguiseListener.lambda$onTeleport$0((Disguise)packetContainer), 20L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleEnter(VehicleEnterEvent vehicleEnterEvent) {
        if (!(vehicleEnterEvent.getEntered() instanceof Player)) {
            return;
        }
        Disguise disguise = DisguiseAPI.getDisguise((Player)vehicleEnterEvent.getEntered(), vehicleEnterEvent.getEntered());
        if (disguise == null) {
            return;
        }
        DisguiseUtilities.removeSelfDisguise(disguise);
        ((Player)vehicleEnterEvent.getEntered()).updateInventory();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleLeave(VehicleExitEvent vehicleExitEvent) {
        Disguise disguise;
        if (vehicleExitEvent.getExited() instanceof Player && (disguise = DisguiseAPI.getDisguise((Player)vehicleExitEvent.getExited(), (Entity)vehicleExitEvent.getExited())) != null) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    DisguiseUtilities.setupFakeDisguise(disguise);
                    ((Player)disguise.getEntity()).updateInventory();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldSwitch(PlayerChangedWorldEvent playerChangedWorldEvent) {
        if (!DisguiseAPI.isDisguised((Entity)playerChangedWorldEvent.getPlayer())) {
            return;
        }
        if (DisguiseConfig.isUndisguiseOnWorldChange()) {
            Disguise[] disguiseArray = DisguiseAPI.getDisguises((Entity)playerChangedWorldEvent.getPlayer());
            if (disguiseArray.length > 0) {
                for (Disguise disguise : disguiseArray) {
                    disguise.removeDisguise();
                }
                LibsMsg.SWITCH_WORLD_DISGUISE_REMOVED.send((CommandSender)playerChangedWorldEvent.getPlayer(), new Object[0]);
            }
        } else {
            Disguise disguise;
            boolean bl = DisguiseAPI.isViewSelfToggled((Entity)playerChangedWorldEvent.getPlayer());
            if (bl && (disguise = DisguiseAPI.getDisguise((Entity)playerChangedWorldEvent.getPlayer())) != null && disguise.isSelfDisguiseVisible()) {
                disguise.setViewSelfDisguise(false);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> disguise.setViewSelfDisguise(true), 20L);
            }
        }
    }

    public void addInteraction(final String string, LibsEntityInteract libsEntityInteract, int n) {
        if (this.disguiseRunnable.containsKey(string)) {
            this.disguiseRunnable.get(string).cancel();
        }
        this.interactions.put(string, libsEntityInteract);
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                DisguiseListener.this.interactions.remove(string);
                DisguiseListener.this.disguiseRunnable.remove(string);
            }
        };
        bukkitRunnable.runTaskLater((Plugin)LibsDisguises.getInstance(), (long)(n * 20));
        this.disguiseRunnable.put(string, bukkitRunnable);
    }

    public boolean isDodgyUser() {
        return this.isDodgyUser;
    }

    public void setDodgyUser(boolean bl) {
        this.isDodgyUser = bl;
    }

    private static /* synthetic */ void lambda$onTeleport$0(Disguise disguise) {
        disguise.setViewSelfDisguise(true);
    }
}

