/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.json;

import com.comphenix.protocol.wrappers.WrappedParticle;
import com.google.gson.Gson;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.EntityPose;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.VillagerData;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.params.types.ParamInfoEnum;
import me.libraryaddict.disguise.utilities.params.types.custom.ParamInfoParticle;
import org.bukkit.inventory.ItemStack;

public class SerializerFlagWatcher
implements JsonDeserializer<FlagWatcher>,
InstanceCreator<FlagWatcher> {
    private Gson gson;

    public SerializerFlagWatcher(Gson gson) {
        this.gson = gson;
    }

    public FlagWatcher deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
        try {
            FlagWatcher flagWatcher = (FlagWatcher)this.gson.fromJson(jsonElement, Class.forName(((JsonObject)jsonElement).get("flagType").getAsString()));
            DisguiseType disguiseType = DisguiseType.valueOf(((JsonObject)jsonElement).get("entityType").getAsString());
            this.correct(flagWatcher, flagWatcher.getClass(), "entityValues");
            this.correct(flagWatcher, disguiseType.getWatcherClass(), "backupEntityValues");
            return flagWatcher;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void correct(FlagWatcher flagWatcher, Class<? extends FlagWatcher> clazz, String string) {
        Field field = FlagWatcher.class.getDeclaredField(string);
        field.setAccessible(true);
        HashMap hashMap = (HashMap)field.get(flagWatcher);
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            MetaIndex metaIndex = MetaIndex.getMetaIndex(clazz, (int)((Integer)entry.getKey()));
            if (entry.getValue() instanceof Double) {
                Object y = metaIndex.getDefault();
                if (y instanceof Long) {
                    entry.setValue(((Double)entry.getValue()).longValue());
                } else if (y instanceof Float) {
                    entry.setValue(Float.valueOf(((Double)entry.getValue()).floatValue()));
                } else if (y instanceof Integer) {
                    entry.setValue(((Double)entry.getValue()).intValue());
                } else if (y instanceof Short) {
                    entry.setValue(((Double)entry.getValue()).shortValue());
                } else if (y instanceof Byte) {
                    entry.setValue(((Double)entry.getValue()).byteValue());
                }
            } else if (entry.getValue() instanceof String) {
                if (metaIndex.getDefault() instanceof WrappedParticle) {
                    entry.setValue(((ParamInfoParticle)ParamInfoManager.getParamInfo(WrappedParticle.class)).fromString((String)entry.getValue()));
                } else if (metaIndex.getDefault() instanceof EntityPose) {
                    entry.setValue(((ParamInfoEnum)ParamInfoManager.getParamInfo(EntityPose.class)).fromString((String)entry.getValue()));
                }
            } else if (entry.getValue() instanceof LinkedTreeMap) {
                if (metaIndex.getDefault() instanceof VillagerData) {
                    entry.setValue(new Gson().fromJson(new Gson().toJson(entry.getValue()), VillagerData.class));
                } else if (metaIndex.getDefault() instanceof Optional) {
                    for (Field field2 : MetaIndex.class.getFields()) {
                        try {
                            if (field2.get(null) != metaIndex) {
                                continue;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                        }
                        Type type = field2.getGenericType();
                        Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                        if (!(type2 instanceof ParameterizedType)) continue;
                        Type type3 = ((ParameterizedType)type2).getActualTypeArguments()[0];
                        Optional<Object> optional = ((LinkedTreeMap)entry.getValue()).isEmpty() ? Optional.empty() : Optional.of(this.gson.fromJson(this.gson.toJson(((LinkedTreeMap)entry.getValue()).get((Object)"value")), type3));
                        entry.setValue(optional);
                    }
                } else if (metaIndex.getDefault() instanceof ItemStack) {
                    entry.setValue(this.gson.fromJson(this.gson.toJson(entry.getValue()), ItemStack.class));
                }
            }
            if (metaIndex.getDefault().getClass().isInstance(entry.getValue())) continue;
            entry.setValue(metaIndex.getDefault());
            ++n;
        }
        if (n > 0) {
            DisguiseUtilities.getLogger().info("Fixed " + n + " incorrect disguise flags on saved disguise");
        }
    }

    public FlagWatcher createInstance(Type type) {
        try {
            return (FlagWatcher)((Class)type).getConstructor(Disguise.class).newInstance(new Object[]{null});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

