/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.config;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.PluginDescriptionFile;

public class DisguiseCommandConfig {
    private File commandConfig = new File(LibsDisguises.getInstance().getDataFolder(), "configs/plugin-commands.yml");
    private HashMap<String, DisguiseCommand> commands = new HashMap();
    private boolean modifyCommands = false;

    private void loadConfig() {
        if (!this.commandConfig.exists()) {
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.commandConfig);
        for (String string : yamlConfiguration.getKeys(false)) {
            DisguiseCommand disguiseCommand = this.commands.get(string);
            if (!yamlConfiguration.isConfigurationSection(string)) continue;
            if (disguiseCommand == null) {
                DisguiseUtilities.getLogger().warning("Config defines '" + string + "' as a command but that command doesn't exist?");
                continue;
            }
            if (!yamlConfiguration.isConfigurationSection(string)) {
                DisguiseUtilities.getLogger().warning("Improper config for " + string);
                continue;
            }
            ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection(string);
            if (!string.equals("libsdisguises")) {
                disguiseCommand.setEnabled(configurationSection.getBoolean("enabled", true));
                disguiseCommand.setName(configurationSection.getString("name", string));
                disguiseCommand.setPermission(configurationSection.getString("permission", disguiseCommand.getPermission()));
            }
            disguiseCommand.setDescription(configurationSection.getString("description", disguiseCommand.getDescription()));
            if (!configurationSection.contains("aliases")) continue;
            disguiseCommand.setAliases(new ArrayList<String>(configurationSection.getStringList("aliases")));
        }
        this.modifyCommands = yamlConfiguration.getBoolean("ModifyCommands", false);
    }

    private void saveConfig() {
        Object iOException;
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        for (Map.Entry<String, DisguiseCommand> object22 : this.commands.entrySet()) {
            iOException = yamlConfiguration.createSection(object22.getKey());
            DisguiseCommand disguiseCommand = object22.getValue();
            if (!disguiseCommand.getName().equals("libsdisguises")) {
                iOException.set("name", (Object)disguiseCommand.getName());
                iOException.set("permission", (Object)disguiseCommand.getPermission());
                iOException.set("enabled", (Object)disguiseCommand.isEnabled());
            }
            iOException.set("description", (Object)disguiseCommand.getDescription());
            iOException.set("aliases", disguiseCommand.getAliases());
        }
        Object object3 = yamlConfiguration.saveToString();
        object3 = ((String)object3).replaceAll("\n([a-zA-Z])", "\n\n$1");
        String string = "# The following can be changed to modify how the disguise commands are registered\n# This will only work on server startup\nModifyCommands: " + this.modifyCommands + "\n\n" + (String)object3;
        this.commandConfig.delete();
        try {
            this.commandConfig.getParentFile().mkdirs();
            this.commandConfig.createNewFile();
        }
        catch (IOException iOException2) {
            iOException2.printStackTrace();
        }
        try {
            iOException = new PrintWriter(this.commandConfig, "UTF-8");
            try {
                ((PrintWriter)iOException).write(string);
            }
            finally {
                ((PrintWriter)iOException).close();
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException iOException3) {
            iOException3.printStackTrace();
        }
    }

    public void load() {
        this.loadPlugin();
        this.loadConfig();
        this.saveConfig();
        if (!this.modifyCommands) {
            return;
        }
        this.registerCommands();
    }

    private void registerCommands() {
        PluginDescriptionFile pluginDescriptionFile = LibsDisguises.getInstance().getDescription();
        HashMap hashMap = new HashMap();
        for (DisguiseCommand disguiseCommand : this.commands.values()) {
            if (!disguiseCommand.isEnabled()) continue;
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap.put(disguiseCommand.getName(), hashMap2);
            if (!disguiseCommand.getAliases().isEmpty()) {
                hashMap2.put("aliases", disguiseCommand.getAliases());
            }
            if (!Strings.isNullOrEmpty((String)disguiseCommand.getPermission())) {
                hashMap2.put("permission", disguiseCommand.getPermission());
            }
            if (Strings.isNullOrEmpty((String)disguiseCommand.getDescription())) continue;
            hashMap2.put("description", disguiseCommand.getDescription());
        }
        try {
            Field field = PluginDescriptionFile.class.getDeclaredField("commands");
            field.setAccessible(true);
            field.set(pluginDescriptionFile, hashMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getCommand(String string) {
        if (!this.modifyCommands) {
            return string;
        }
        DisguiseCommand disguiseCommand = this.commands.get(string);
        if (disguiseCommand == null || !disguiseCommand.isEnabled()) {
            return null;
        }
        return disguiseCommand.getName();
    }

    private void loadPlugin() {
        PluginDescriptionFile pluginDescriptionFile = LibsDisguises.getInstance().getDescription();
        for (Map.Entry entry : pluginDescriptionFile.getCommands().entrySet()) {
            DisguiseCommand disguiseCommand = new DisguiseCommand();
            disguiseCommand.setName((String)entry.getKey());
            Map map = (Map)entry.getValue();
            disguiseCommand.setPermission((String)map.get("permission"));
            if (map.containsKey("aliases")) {
                disguiseCommand.setAliases(new ArrayList<String>((Collection)map.get("aliases")));
            }
            disguiseCommand.setDescription(map.getOrDefault("description", "No description set"));
            disguiseCommand.setEnabled(true);
            this.commands.put((String)entry.getKey(), disguiseCommand);
        }
    }

    public class DisguiseCommand {
        private String name;
        private String description;
        private String permission;
        private List<String> aliases = new ArrayList<String>();
        private boolean enabled;

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPermission() {
            return this.permission;
        }

        public List<String> getAliases() {
            return this.aliases;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public void setPermission(String string) {
            this.permission = string;
        }

        public void setAliases(List<String> list) {
            this.aliases = list;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }
}

