/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ClassGetter;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigLoader {
    private final List<String> configs = new ArrayList<String>();

    public ConfigLoader() {
        for (String string : ClassGetter.getEntriesForPackage(ConfigLoader.class, "configs")) {
            if (!string.endsWith(".yml") || string.endsWith("/disguises.yml") || string.endsWith("/sounds.yml")) continue;
            this.configs.add(string);
        }
    }

    public void saveMissingConfigs() {
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "config.yml");
        boolean bl = file.exists();
        for (String string : this.configs) {
            File file2 = new File(LibsDisguises.getInstance().getDataFolder(), string);
            if (file2.exists()) {
                bl = false;
                continue;
            }
            this.saveDefaultConfig(string);
        }
        if (bl) {
            DisguiseUtilities.getLogger().info("Migrated old config system to new config system");
            file.delete();
        }
    }

    public YamlConfiguration loadDefaults() {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        for (String string : this.configs) {
            try {
                YamlConfiguration yamlConfiguration2 = new YamlConfiguration();
                yamlConfiguration2.loadFromString(ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), string));
                for (String string2 : yamlConfiguration2.getKeys(true)) {
                    if (yamlConfiguration2.isConfigurationSection(string2)) continue;
                    yamlConfiguration.set(string2, yamlConfiguration2.get(string2));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return yamlConfiguration;
    }

    public YamlConfiguration load() {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        for (String string : this.configs) {
            YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)new File(LibsDisguises.getInstance().getDataFolder(), string));
            for (String string2 : yamlConfiguration2.getKeys(true)) {
                if (yamlConfiguration2.isConfigurationSection(string2)) continue;
                yamlConfiguration.set(string2, yamlConfiguration2.get(string2));
            }
        }
        return yamlConfiguration;
    }

    public void saveDefaultConfigs() {
        for (String string : this.configs) {
            this.saveDefaultConfig(string);
        }
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "config.yml");
        file.delete();
    }

    public void saveDefaultConfig(String string) {
        File file;
        DisguiseUtilities.getLogger().info("Config " + string + " is out of date (Or missing)! Now refreshing it!");
        String string2 = ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), string);
        YamlConfiguration yamlConfiguration = null;
        File file2 = file = new File(LibsDisguises.getInstance().getDataFolder(), string);
        if (!file.exists()) {
            file = new File(LibsDisguises.getInstance().getDataFolder(), "config.yml");
        }
        if (file.exists()) {
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        } else {
            try {
                yamlConfiguration = new YamlConfiguration();
                yamlConfiguration.loadFromString(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Object[] objectArray = string2.split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            String string3;
            String string4 = objectArray[i];
            if (string4.trim().startsWith("#") || !string4.contains(":")) continue;
            String string5 = string4.split(":")[0];
            if (stringBuilder.length() > 0) {
                int n = StringUtils.countMatches((String)string5, (String)"  ");
                int n2 = 0;
                for (int j = 0; j < n; ++j) {
                    n2 = stringBuilder.indexOf(".", n2) + 1;
                }
                stringBuilder = new StringBuilder(stringBuilder.substring(0, n2));
            }
            if (yamlConfiguration.isConfigurationSection(string3 = (string5.startsWith(" ") ? stringBuilder.toString() : "") + string5.trim())) {
                stringBuilder.append(string3).append(".");
                continue;
            }
            if (!yamlConfiguration.isSet(string3)) continue;
            String string6 = string4.split(":")[1].trim();
            Object object = yamlConfiguration.get(string3);
            if (yamlConfiguration.isString(string3) && !string6.equals("true") && !string6.equals("false")) {
                object = "'" + StringEscapeUtils.escapeJava((String)object.toString().replace("\u00a7", "&")) + "'";
            }
            objectArray[i] = string5 + ": " + object;
        }
        try {
            if (!file2.getParentFile().exists()) {
                file2.mkdirs();
            }
            file2.delete();
            file2.createNewFile();
            try (PrintWriter printWriter = new PrintWriter(file2);){
                printWriter.write(StringUtils.join((Object[])objectArray, (String)"\n"));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public List<String> getConfigs() {
        return this.configs;
    }
}

