/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinResponse;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SkinUtils {
    public static void handleFile(final File file, final ModelType modelType, final SkinCallback skinCallback) {
        new BukkitRunnable(){

            public void run() {
                try {
                    final MineSkinResponse mineSkinResponse = DisguiseUtilities.getMineSkinAPI().generateFromFile(skinCallback, file, modelType);
                    new BukkitRunnable(){

                        public void run() {
                            if (mineSkinResponse == null) {
                                return;
                            }
                            if (mineSkinResponse.getGameProfile() == null) {
                                skinCallback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                                return;
                            }
                            SkinUtils.handleProfile(mineSkinResponse.getGameProfile(), modelType, skinCallback);
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    new BukkitRunnable(){

                        public void run() {
                            skinCallback.onError(LibsMsg.SKIN_API_BAD_FILE, new Object[0]);
                        }
                    }.runTask((Plugin)LibsDisguises.getInstance());
                }
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static void handleUrl(final String string, final ModelType modelType, final SkinCallback skinCallback) {
        new BukkitRunnable(){

            public void run() {
                final MineSkinResponse mineSkinResponse = DisguiseUtilities.getMineSkinAPI().generateFromUrl(skinCallback, string, modelType);
                new BukkitRunnable(){

                    public void run() {
                        if (mineSkinResponse == null) {
                            return;
                        }
                        if (mineSkinResponse.getGameProfile() == null) {
                            skinCallback.onError(LibsMsg.SKIN_API_FAIL, new Object[0]);
                        }
                        SkinUtils.handleProfile(mineSkinResponse.getGameProfile(), modelType, skinCallback);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static void handleName(final String string, final ModelType modelType, final SkinCallback skinCallback) {
        WrappedGameProfile wrappedGameProfile = DisguiseUtilities.getProfileFromMojang(string, new LibsProfileLookup(){

            @Override
            public void onLookup(WrappedGameProfile wrappedGameProfile) {
                if (!Pattern.matches("([A-Za-z0-9_]){1,16}", string)) {
                    return;
                }
                if (wrappedGameProfile == null || wrappedGameProfile.getProperties().isEmpty()) {
                    skinCallback.onError(LibsMsg.CANNOT_FIND_PLAYER_NAME, string);
                    return;
                }
                SkinUtils.handleProfile(wrappedGameProfile, modelType, skinCallback);
            }
        });
        if (wrappedGameProfile == null) {
            return;
        }
        if (wrappedGameProfile.getProperties().isEmpty()) {
            skinCallback.onError(LibsMsg.CANNOT_FIND_PLAYER_NAME, string);
            return;
        }
        SkinUtils.handleProfile(wrappedGameProfile, modelType, skinCallback);
    }

    public static void handleProfile(GameProfile gameProfile, ModelType modelType, SkinCallback skinCallback) {
        SkinUtils.handleProfile(WrappedGameProfile.fromHandle((Object)gameProfile), modelType, skinCallback);
    }

    public static void handleProfile(WrappedGameProfile wrappedGameProfile, ModelType modelType, SkinCallback skinCallback) {
        skinCallback.onSuccess(wrappedGameProfile);
    }

    public static void handleUUID(final UUID uUID, final ModelType modelType, final SkinCallback skinCallback) {
        new BukkitRunnable(){

            public void run() {
                final WrappedGameProfile wrappedGameProfile = ReflectionManager.getSkullBlob(new WrappedGameProfile(uUID, "AutoGenerated"));
                new BukkitRunnable(){

                    public void run() {
                        if (wrappedGameProfile == null || wrappedGameProfile.getProperties().isEmpty()) {
                            skinCallback.onError(LibsMsg.CANNOT_FIND_PLAYER_UUID, uUID.toString());
                            return;
                        }
                        SkinUtils.handleProfile(wrappedGameProfile, modelType, skinCallback);
                    }
                }.runTask((Plugin)LibsDisguises.getInstance());
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    public static boolean isUsable() {
        return SkinUtils.getUsableStatus() == null;
    }

    public static String getUsableStatus() {
        if (DisguiseUtilities.getMineSkinAPI().isInUse()) {
            return LibsMsg.SKIN_API_IN_USE.get(new Object[0]);
        }
        if (DisguiseUtilities.getMineSkinAPI().nextRequestIn() > 0) {
            return LibsMsg.SKIN_API_TIMER.get(DisguiseUtilities.getMineSkinAPI().nextRequestIn());
        }
        return null;
    }

    public static void grabSkin(String string, SkinCallback skinCallback) {
        ModelType modelType;
        ModelType modelType2 = modelType = string.toLowerCase(Locale.ENGLISH).endsWith(":slim") ? ModelType.SLIM : ModelType.NORMAL;
        if (modelType == ModelType.SLIM) {
            string = string.substring(0, string.length() - ":slim".length());
        }
        if (string.matches("https?:\\/\\/.+")) {
            skinCallback.onInfo(LibsMsg.SKIN_API_USING_URL, new Object[0]);
            SkinUtils.handleUrl(string, modelType, skinCallback);
        } else {
            if (!string.matches("[a-zA-Z0-9 -_]+(\\.png)?")) {
                skinCallback.onError(LibsMsg.SKIN_API_INVALID_NAME, new Object[0]);
                return;
            }
            File file = new File(LibsDisguises.getInstance().getDataFolder(), "/Skins/" + string + (string.toLowerCase(Locale.ENGLISH).endsWith(".png") ? "" : ".png"));
            if (!file.exists()) {
                file = null;
                if (string.toLowerCase(Locale.ENGLISH).endsWith(".png")) {
                    skinCallback.onError(LibsMsg.SKIN_API_BAD_FILE_NAME, new Object[0]);
                    return;
                }
            }
            if (file != null) {
                skinCallback.onInfo(LibsMsg.SKIN_API_USING_FILE, new Object[0]);
                SkinUtils.handleFile(file, modelType, skinCallback);
            } else {
                WrappedGameProfile wrappedGameProfile;
                if (string.contains("-")) {
                    try {
                        UUID uUID = UUID.fromString(string);
                        skinCallback.onInfo(LibsMsg.SKIN_API_USING_UUID, new Object[0]);
                        SkinUtils.handleUUID(uUID, modelType, skinCallback);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((wrappedGameProfile = DisguiseUtilities.getGameProfile(string)) != null) {
                    skinCallback.onInfo(LibsMsg.SKIN_API_USING_EXISTING_NAME, new Object[0]);
                    skinCallback.onSuccess(wrappedGameProfile);
                    return;
                }
                skinCallback.onInfo(LibsMsg.SKIN_API_USING_NAME, new Object[0]);
                SkinUtils.handleName(string, modelType, skinCallback);
            }
        }
    }

    public static interface SkinCallback {
        public void onError(LibsMsg var1, Object ... var2);

        public void onInfo(LibsMsg var1, Object ... var2);

        public void onSuccess(WrappedGameProfile var1);
    }

    public static enum ModelType {
        SLIM,
        NORMAL;

    }
}

