/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.plugin.BisectHosting;
import me.libraryaddict.disguise.utilities.plugin.PluginInformation;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.util.FileUtil;

public class LibsPremium {
    private static Boolean thisPluginIsPaidFor;
    private static PluginInformation pluginInformation;
    private static PluginInformation paidInformation;
    private static boolean bisectHosted;

    public static PluginInformation getPluginInformation() {
        return pluginInformation;
    }

    public static PluginInformation getPaidInformation() {
        return paidInformation;
    }

    public static String getUserID() {
        return "802393";
    }

    public static String getResourceID() {
        return "32453";
    }

    public static String getDownloadID() {
        return "-830507508";
    }

    private static Boolean isPremium(String string, String string2) {
        return !string2.contains("__USER__") && string.equals("32453");
    }

    public static Boolean isPremium() {
        return thisPluginIsPaidFor == null ? LibsPremium.isPremium(LibsPremium.getResourceID(), LibsPremium.getUserID()) : thisPluginIsPaidFor;
    }

    private static boolean isValidVersion(String string, String string2) {
        string = string.replaceAll("(v)|(-SNAPSHOT)", "");
        if (!string2.matches("[0-9]+(\\.[0-9]+)+")) {
            return false;
        }
        if (string2.startsWith("9.")) {
            return false;
        }
        if (!string.matches("[0-9]+(\\.[0-9]+)+")) {
            return true;
        }
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        return Integer.parseInt(stringArray[0]) <= Integer.parseInt(stringArray2[0]);
    }

    public static PluginInformation getInformation(File file) {
        try (URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});){
            Class<?> clazz = uRLClassLoader.loadClass(LibsPremium.class.getName());
            YamlConfiguration yamlConfiguration = ReflectionManager.getPluginYAMLEx(file);
            String string = (String)clazz.getMethod("getUserID", new Class[0]).invoke(null, new Object[0]);
            String string2 = (String)clazz.getMethod("getDownloadID", new Class[0]).invoke(null, new Object[0]);
            String string3 = (String)clazz.getMethod("getResourceID", new Class[0]).invoke(null, new Object[0]);
            Boolean bl = LibsPremium.isPremium(string3, string);
            String string4 = "??/??/????";
            if (yamlConfiguration.contains("build-date")) {
                string4 = yamlConfiguration.getString("build-date");
            }
            String string5 = "???";
            if (yamlConfiguration.contains("build-number") && (string5 = yamlConfiguration.getString("build-number")).matches("[0-9]+")) {
                string5 = "#" + string5;
            }
            String string6 = yamlConfiguration.getString("version");
            PluginInformation pluginInformation = new PluginInformation(file.length(), string, string3, string2, bl, string6, string5, string4);
            return pluginInformation;
        }
    }

    private static void doSecondaryCheck(String string) {
        File[] fileArray = new File("plugins/LibsDisguises/").listFiles();
        boolean bl = false;
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            PluginInformation pluginInformation;
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            bl = true;
            try {
                pluginInformation = LibsPremium.getInformation(file);
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                DisguiseUtilities.getLogger().warning("Found an unrecognized jar in the LibsDisguises folder (" + file.getName() + ") - It may need replacing with a newer jar from SpigotMC");
                continue;
            }
            catch (Exception exception) {
                DisguiseUtilities.getLogger().warning("Error while trying to handle the file " + file.getName());
                exception.printStackTrace();
                continue;
            }
            String string2 = String.format("v%s, build %s, created %s", pluginInformation.getVersion(), pluginInformation.getBuildNumber(), pluginInformation.getBuildDate());
            if (pluginInformation.isPremium()) {
                if (!LibsPremium.isValidVersion(string, pluginInformation.getVersion()) || pluginInformation.getUserID() == null || pluginInformation.getDownloadID() == null || pluginInformation.getUserID().equals("666666")) {
                    DisguiseUtilities.getLogger().warning("You have an old Lib's Disguises jar (" + file.getName() + " " + string2 + ") in the LibsDisguises folder! For security purposes, please replace this with a new version from SpigotMC - https://www.spigotmc.org/resources/libs-disguises.32453/");
                    continue;
                }
                paidInformation = pluginInformation;
                thisPluginIsPaidFor = true;
                DisguiseUtilities.getLogger().info("Found a premium Lib's Disguises jar (" + string2 + ")");
                DisguiseUtilities.getLogger().info("Registered to: " + LibsPremium.getSanitizedUser(pluginInformation.getUserID()));
                if (pluginInformation.getBuildNumber() != null && pluginInformation.getBuildNumber().matches("#[0-9]+") && Integer.parseInt(pluginInformation.getBuildNumber().substring(1)) >= 300) break;
                file.delete();
                continue;
            }
            DisguiseUtilities.getLogger().warning("You have a non-premium Lib's Disguises jar (" + file.getName() + " " + string2 + ") in the LibsDisguises folder!");
            DisguiseUtilities.getLogger().warning("Please place the premium jar downloaded from https://www.spigotmc.org/resources/libs-disguises.32453/ in here!");
        }
        if (!LibsPremium.isPremium().booleanValue()) {
            bisectHosted = new BisectHosting().isBisectHosted("LibsDisguises");
            if (bisectHosted) {
                DisguiseUtilities.getLogger().info("Hosted by BisectHosting! Premium enabled!");
                paidInformation = new PluginInformation(0L, "0", "32453", "0", true, "0", "#0", "0");
                thisPluginIsPaidFor = true;
            } else {
                DisguiseUtilities.getLogger().warning("If you own the plugin, place the premium jar downloaded from https://www.spigotmc.org/resources/libs-disguises.32453/ in plugins/LibsDisguises/");
            }
        }
    }

    private static String getSanitizedUser(String string) {
        if (string == null) {
            return "N/A";
        }
        if (!string.matches("[0-9]+")) {
            return String.format("... %s? Am I reading this right?", string);
        }
        int n = 0;
        for (char c : string.toCharArray()) {
            n += Character.getNumericValue(c);
        }
        return String.format("%s (%s)", string, n);
    }

    public static void check(String string, File file) {
        Object object;
        thisPluginIsPaidFor = LibsPremium.isPremium();
        try {
            pluginInformation = LibsPremium.getInformation(file);
        }
        catch (Exception exception) {
            Object object2;
            object = "??/??/????";
            YamlConfiguration yamlConfiguration = new YamlConfiguration();
            try {
                object2 = LibsDisguises.getInstance().getResource("plugin.yml");
                try {
                    yamlConfiguration.loadFromString(new BufferedReader(new InputStreamReader((InputStream)object2, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n")));
                }
                finally {
                    if (object2 != null) {
                        ((InputStream)object2).close();
                    }
                }
                if (yamlConfiguration.contains("build-date")) {
                    object = yamlConfiguration.getString("build-date");
                }
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            object2 = LibsDisguises.getInstance().getBuildNo();
            if (object2 != null && ((String)object2).matches("[0-9]+")) {
                object2 = "#" + (String)object2;
            }
            pluginInformation = new PluginInformation(LibsDisguises.getInstance().getFile().length(), LibsPremium.getUserID(), LibsPremium.getResourceID(), LibsPremium.getDownloadID(), LibsPremium.isPremium(LibsPremium.getResourceID(), LibsPremium.getUserID()), string, (String)object2, (String)object);
        }
        if (!LibsPremium.isPremium().booleanValue() || !LibsDisguises.getInstance().isReleaseBuild()) {
            LibsPremium.doSecondaryCheck(string);
        } else {
            DisguiseUtilities.getLogger().info("Registered to: " + LibsPremium.getSanitizedUser(LibsPremium.getUserID()));
            boolean bl = false;
            for (File file2 : LibsDisguises.getInstance().getDataFolder().listFiles()) {
                if (file2.isDirectory() || !file2.getName().endsWith(".jar")) continue;
                try {
                    PluginInformation pluginInformation = LibsPremium.getInformation(file2);
                    if (pluginInformation.getBuildNumber() == null || !pluginInformation.getBuildNumber().matches("#[0-9]+")) {
                        file2.delete();
                        DisguiseUtilities.getLogger().info("Ew, I don't recognize " + file2.getName());
                        continue;
                    }
                    if (Integer.parseInt(pluginInformation.getBuildNumber().replace("#", "")) < Integer.parseInt(LibsDisguises.getInstance().getBuildNo().replace("#", ""))) {
                        file2.delete();
                        DisguiseUtilities.getLogger().info("Ew, " + file2.getName() + " is so old");
                        continue;
                    }
                    if (!pluginInformation.isLegit()) {
                        file2.delete();
                        DisguiseUtilities.getLogger().info("Ew, I saw something nasty in " + file2.getName());
                        continue;
                    }
                    bl = true;
                    break;
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                    DisguiseUtilities.getLogger().info("Ew, error about invalid Libs Disguises jar. Deleting " + file2.getName());
                    file2.delete();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            if (!bl) {
                object = LibsDisguises.getInstance().getFile();
                FileUtil.copy((File)object, (File)new File(LibsDisguises.getInstance().getDataFolder(), ((File)object).getName()));
                DisguiseUtilities.getLogger().info("Copied " + ((File)object).getName() + " to the plugin folder! You can use dev builds with premium enabled!");
            }
        }
        if (LibsPremium.isPremium().booleanValue()) {
            boolean bl = LibsPremium.getPaidInformation() == null ? LibsPremium.getPluginInformation().isLegit() : LibsPremium.getPaidInformation().isLegit();
            DisguiseUtilities.getLogger().info("Premium enabled, thank you for supporting Lib's Disguises!" + (!bl ? "!" : ""));
        }
    }

    public static boolean isBisectHosted() {
        return bisectHosted;
    }
}

