/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.utilities;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ld-shaded.net.kyori.adventure.text.Component;
import ld-shaded.net.kyori.adventure.text.minimessage.MiniMessage;
import ld-shaded.net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArmorStandWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.json.SerializerBlockData;
import me.libraryaddict.disguise.utilities.json.SerializerChatComponent;
import me.libraryaddict.disguise.utilities.json.SerializerDisguise;
import me.libraryaddict.disguise.utilities.json.SerializerFlagWatcher;
import me.libraryaddict.disguise.utilities.json.SerializerGameProfile;
import me.libraryaddict.disguise.utilities.json.SerializerItemStack;
import me.libraryaddict.disguise.utilities.json.SerializerMetaIndex;
import me.libraryaddict.disguise.utilities.json.SerializerParticle;
import me.libraryaddict.disguise.utilities.json.SerializerWrappedBlockData;
import me.libraryaddict.disguise.utilities.mineskin.MineSkinAPI;
import me.libraryaddict.disguise.utilities.packets.LibsPackets;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.watchers.CompileMethods;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.logging.log4j.util.Strings;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class DisguiseUtilities {
    public static final Random random = new Random();
    private static final LinkedHashMap<String, Disguise> clonedDisguises = new LinkedHashMap();
    private static final List<Integer> isNoInteract = new ArrayList<Integer>();
    private static final List<Integer> isSpecialInteract = new ArrayList<Integer>();
    private static final Map<Integer, Set<TargetedDisguise>> disguises = new HashMap<Integer, Set<TargetedDisguise>>();
    private static final HashMap<Integer, HashSet<TargetedDisguise>> futureDisguises = new HashMap();
    private static final HashSet<UUID> savedDisguiseList = new HashSet();
    private static final HashSet<String> cachedNames = new HashSet();
    private static final HashMap<String, ArrayList<Object>> runnables = new HashMap();
    private static final HashSet<UUID> selfDisguised = new HashSet();
    private static final File profileCache = new File("plugins/LibsDisguises/SavedSkins");
    private static final File savedDisguises = new File("plugins/LibsDisguises/SavedDisguises");
    private static Gson gson;
    private static boolean pluginsUsed;
    private static boolean commandsUsed;
    private static boolean copyDisguiseCommandUsed;
    private static boolean grabSkinCommandUsed;
    private static boolean saveDisguiseCommandUsed;
    private static boolean grabHeadCommandUsed;
    private static long libsDisguisesCalled;
    private static long velocityTime;
    private static int velocityID;
    private static final HashMap<UUID, ArrayList<Integer>> disguiseLoading;
    private static boolean runningPaper;
    private static final MineSkinAPI mineSkinAPI;
    private static boolean invalidFile;
    private static final char[] alphabet;
    private static final Pattern urlMatcher;
    private static final List<UUID> viewSelf;
    private static final List<UUID> viewBar;
    private static long lastSavedPreferences;
    private static final ConcurrentHashMap<String, DScoreTeam> teams;
    private static final boolean java16;
    private static boolean criedOverJava16;
    private static HashSet<UUID> warnedSkin;
    private static Boolean adventureTextSupport;

    public static String serialize(Component component) {
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    public static void doSkinUUIDWarning(CommandSender commandSender) {
        if (!(commandSender instanceof Player)) {
            return;
        }
        UUID uUID = ((Player)commandSender).getUniqueId();
        if (uUID.version() == 4 || warnedSkin.contains(uUID)) {
            return;
        }
        warnedSkin.add(uUID);
        LibsMsg.SKIN_API_UUID_3.send(commandSender, new Object[0]);
    }

    public static void addSaveAttempt() {
        if (lastSavedPreferences + TimeUnit.SECONDS.toMillis(120L) > System.currentTimeMillis()) {
            return;
        }
        lastSavedPreferences = System.currentTimeMillis();
        new BukkitRunnable(){

            public void run() {
                DisguiseUtilities.saveViewPreferances();
            }
        }.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L * TimeUnit.SECONDS.toMillis(120L));
    }

    public static List<UUID> getViewSelf() {
        return viewSelf;
    }

    public static String getDisplayName(CommandSender commandSender) {
        String string;
        if (commandSender == null) {
            return "???";
        }
        if (!(commandSender instanceof Player)) {
            return commandSender.getName();
        }
        Team team = ((Player)commandSender).getScoreboard().getEntryTeam(commandSender.getName());
        if (team == null) {
            team = ((Player)commandSender).getScoreboard().getEntryTeam(((Player)commandSender).getUniqueId().toString());
        }
        if (team == null || StringUtils.isEmpty((String)team.getPrefix()) && StringUtils.isEmpty((String)team.getSuffix())) {
            string = ((Player)commandSender).getDisplayName();
            if (string.equals(commandSender.getName())) {
                string = ((Player)commandSender).getPlayerListName();
            }
        } else {
            string = team.getPrefix() + team.getColor() + commandSender.getName() + team.getSuffix();
        }
        return string.replaceAll("\u00a7x\u00a7([0-9a-fA-F])\u00a7([0-9a-fA-F])\u00a7([0-9a-fA-F])\u00a7([0-9a-fA-F])\u00a7([0-9a-fA-F])\u00a7([0-9a-fA-F])", "<#$1$2$3$4$5$6>");
    }

    public static String getDisplayName(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return string;
        }
        Team team = Bukkit.getScoreboardManager().getMainScoreboard().getEntryTeam(string);
        if (!(team == null || team.getColor() == org.bukkit.ChatColor.RESET && StringUtils.isEmpty((String)team.getPrefix()) && StringUtils.isEmpty((String)team.getSuffix()))) {
            return team.getPrefix() + team.getColor() + string + team.getSuffix();
        }
        Player player = Bukkit.getPlayerExact((String)string);
        if (player == null) {
            return string;
        }
        team = Bukkit.getScoreboardManager().getMainScoreboard().getEntryTeam(player.getUniqueId().toString());
        if (team == null || team.getColor() != org.bukkit.ChatColor.RESET || StringUtils.isEmpty((String)team.getPrefix()) && StringUtils.isEmpty((String)team.getSuffix())) {
            String string2 = player.getDisplayName();
            if (string2.equals(string)) {
                return player.getPlayerListName();
            }
            return string2;
        }
        return team.getPrefix() + team.getColor() + player.getName() + team.getSuffix();
    }

    public static void saveViewPreferances() {
        if (!DisguiseConfig.isSaveUserPreferences()) {
            return;
        }
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "preferences.json");
        File file2 = new File(LibsDisguises.getInstance().getDataFolder(), "preferences-temp.json");
        HashMap<String, List<UUID>> hashMap = new HashMap<String, List<UUID>>();
        hashMap.put("selfdisguise", DisguiseUtilities.getViewSelf());
        hashMap.put("notifybar", DisguiseUtilities.getViewBar());
        String string = DisguiseUtilities.getGson().toJson(hashMap);
        try {
            Files.write(file2.toPath(), string.getBytes(), new OpenOption[0]);
            Files.move(file2.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void removeInvisibleSlime(Player player) {
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, DisguiseUtilities.getDestroyPacket(DisguiseAPI.getEntityAttachmentId()), false);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static void sendInvisibleSlime(Player player, int n) {
        PacketContainer packetContainer;
        PacketContainer packetContainer2 = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.SPAWN_ENTITY_LIVING, new Object[]{player}).createPacket(new Object[]{player});
        packetContainer2.getModifier().write(0, (Object)DisguiseAPI.getEntityAttachmentId());
        packetContainer2.getModifier().write(1, (Object)UUID.randomUUID());
        packetContainer2.getModifier().write(2, (Object)DisguiseType.SLIME.getTypeId());
        WrappedDataWatcher wrappedDataWatcher = new WrappedDataWatcher();
        WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject = ReflectionManager.createDataWatcherObject(MetaIndex.SLIME_SIZE, 0);
        wrappedDataWatcher.setObject(wrappedDataWatcherObject, (Object)0);
        if (NmsVersion.v1_15.isSupported()) {
            packetContainer = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{DisguiseAPI.getEntityAttachmentId(), wrappedDataWatcher, true}).createPacket(new Object[]{DisguiseAPI.getEntityAttachmentId(), wrappedDataWatcher, true});
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer2, false);
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        } else {
            packetContainer2.getDataWatcherModifier().write(0, (Object)wrappedDataWatcher);
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer2, false);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        packetContainer = new PacketContainer(PacketType.Play.Server.MOUNT);
        packetContainer.getModifier().write(0, (Object)n);
        packetContainer.getModifier().write(1, (Object)new int[]{DisguiseAPI.getEntityAttachmentId()});
        PacketContainer packetContainer3 = new PacketContainer(PacketType.Play.Server.MOUNT);
        packetContainer3.getModifier().write(0, (Object)DisguiseAPI.getEntityAttachmentId());
        packetContainer3.getModifier().write(1, (Object)new int[]{player.getEntityId()});
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer3, false);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static void loadViewPreferences() {
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "preferences.json");
        if (!file.exists()) {
            return;
        }
        try {
            String string2 = new String(Files.readAllBytes(file.toPath()));
            HashMap hashMap = (HashMap)DisguiseUtilities.getGson().fromJson(string2, HashMap.class);
            if (hashMap == null) {
                file.delete();
                return;
            }
            if (hashMap.containsKey("selfdisguise")) {
                DisguiseUtilities.getViewSelf().clear();
                ((Collection)hashMap.get("selfdisguise")).forEach(string -> DisguiseUtilities.getViewSelf().add(UUID.fromString(string)));
            }
            if (hashMap.containsKey("notifybar")) {
                DisguiseUtilities.getViewBar().clear();
                ((Collection)hashMap.get("notifybar")).forEach(string -> DisguiseUtilities.getViewBar().add(UUID.fromString(string)));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            DisguiseUtilities.getLogger().warning("preferences.json has been deleted as its corrupt");
            file.delete();
        }
    }

    public static List<UUID> getViewBar() {
        return viewBar;
    }

    public static void setPlayerVelocity(Player player) {
        if (player == null) {
            velocityID = 0;
            velocityTime = 0L;
        } else {
            velocityID = player.getEntityId();
            velocityTime = player.getWorld().getTime();
        }
    }

    public static String[] getProtocolLibRequiredVersion() {
        if (!NmsVersion.v1_13.isSupported()) {
            return new String[]{"4.4.0"};
        }
        if (!NmsVersion.v1_16.isSupported()) {
            return new String[]{"4.5.1"};
        }
        if (!NmsVersion.v1_17.isSupported()) {
            return new String[]{"4.6.0"};
        }
        if (!NmsVersion.v1_18.isSupported()) {
            return new String[]{"4.7.0", "528"};
        }
        return new String[]{"4.8.0", "538"};
    }

    public static boolean isProtocolLibOutdated() {
        String string = Bukkit.getPluginManager().getPlugin("ProtocolLib").getDescription().getVersion();
        String[] stringArray = DisguiseUtilities.getProtocolLibRequiredVersion();
        if (stringArray.length > 1 && string.contains("-SNAPSHOT-b")) {
            try {
                String string2 = string.substring(string.lastIndexOf("b") + 1);
                if (string2.length() < 3) {
                    return false;
                }
                int n = Integer.parseInt(string2);
                return n < Integer.parseInt(stringArray[1]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return DisguiseUtilities.isOlderThan(stringArray[0], string);
    }

    public static File updateProtocolLib() {
        Object object;
        Object object2;
        File file = new File("plugins/ProtocolLib.jar");
        if (Bukkit.getPluginManager().getPlugin("ProtocolLib") != null) {
            object2 = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            ((Method)object2).setAccessible(true);
            object = (File)((Method)object2).invoke((Object)ProtocolLibrary.getPlugin(), new Object[0]);
            file = new File(Bukkit.getUpdateFolderFile(), ((File)object).getName());
        }
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        object2 = new URL("https://ci.dmulloy2.net/job/ProtocolLib/lastSuccessfulBuild/artifact/target/ProtocolLib.jar");
        object = (HttpURLConnection)((URL)object2).openConnection();
        ((URLConnection)object).setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
        try (InputStream inputStream = ((URLConnection)object).getInputStream();){
            Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return file;
    }

    public static boolean isPlayerVelocity(Player player) {
        return player.getEntityId() == velocityID && player.getWorld().getTime() - velocityTime < 3L;
    }

    public static void setGrabSkinCommandUsed() {
        grabSkinCommandUsed = true;
    }

    public static void setGrabHeadCommandUsed() {
        grabHeadCommandUsed = true;
    }

    public static void setCopyDisguiseCommandUsed() {
        copyDisguiseCommandUsed = true;
    }

    public static void setSaveDisguiseCommandUsed() {
        saveDisguiseCommandUsed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNotInteractable(int n) {
        List<Integer> list = isNoInteract;
        synchronized (list) {
            return isNoInteract.contains(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSpecialInteract(int n) {
        List<Integer> list = isSpecialInteract;
        synchronized (list) {
            return isSpecialInteract.contains(n);
        }
    }

    public static boolean isGrabSkinCommandUsed() {
        return grabSkinCommandUsed;
    }

    public static boolean isCopyDisguiseCommandUsed() {
        return copyDisguiseCommandUsed;
    }

    public static boolean isSaveDisguiseCommandUsed() {
        return saveDisguiseCommandUsed;
    }

    public static void setPluginsUsed() {
        if (libsDisguisesCalled > System.currentTimeMillis()) {
            return;
        }
        pluginsUsed = true;
    }

    public static void resetPluginTimer() {
        libsDisguisesCalled = System.currentTimeMillis() + 100L;
    }

    public static void setCommandsUsed() {
        DisguiseUtilities.resetPluginTimer();
        commandsUsed = true;
    }

    public static void saveDisguises() {
        DisguiseUtilities.saveViewPreferances();
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!DisguiseConfig.isSaveEntityDisguises() && !DisguiseConfig.isSavePlayerDisguises()) {
            return;
        }
        DisguiseUtilities.getLogger().info("Now saving disguises..");
        int n = 0;
        block0: for (Set<TargetedDisguise> set : DisguiseUtilities.getDisguises().values()) {
            for (TargetedDisguise targetedDisguise : set) {
                if (targetedDisguise.getEntity() == null) continue;
                if (targetedDisguise.getEntity() instanceof Player ? !DisguiseConfig.isSavePlayerDisguises() : !DisguiseConfig.isSaveEntityDisguises()) continue block0;
                ++n;
                DisguiseUtilities.saveDisguises(targetedDisguise.getEntity().getUniqueId(), set.toArray(new Disguise[0]));
                continue block0;
            }
        }
        DisguiseUtilities.getLogger().info("Saved " + n + " disguises.");
    }

    public static boolean hasGameProfile(String string) {
        return cachedNames.contains(string.toLowerCase(Locale.ENGLISH));
    }

    public static void createClonedDisguise(Player player, Entity entity, Boolean[] booleanArray) {
        Disguise disguise = DisguiseAPI.getDisguise(player, entity);
        disguise = disguise == null ? DisguiseAPI.constructDisguise(entity, booleanArray[0], booleanArray[1]) : disguise.clone();
        String string = null;
        int n = Math.max(2, (int)Math.ceil((0.1 + (double)DisguiseConfig.getMaxClonedDisguises()) / 26.0));
        int n2 = 0;
        while (string == null && n2++ < 1000) {
            string = "@";
            for (int i = 0; i < n; ++i) {
                string = string + alphabet[random.nextInt(alphabet.length)];
            }
            if (DisguiseUtilities.getClonedDisguise(string) == null) continue;
            string = null;
        }
        if (string != null && DisguiseUtilities.addClonedDisguise(string, disguise)) {
            String string2 = DisguiseType.getType(entity).toReadable();
            LibsMsg.MADE_REF.send((CommandSender)player, string2, string);
            LibsMsg.MADE_REF_EXAMPLE.send((CommandSender)player, string);
        } else {
            LibsMsg.REF_TOO_MANY.send((CommandSender)player, new Object[0]);
        }
    }

    public static void saveDisguises(UUID uUID, Disguise[] disguiseArray) {
        if (!LibsPremium.isPremium().booleanValue()) {
            return;
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        try {
            File file = new File(savedDisguises, uUID.toString());
            if (disguiseArray == null || disguiseArray.length == 0) {
                if (savedDisguiseList.contains(uUID)) {
                    file.delete();
                }
            } else {
                PrintWriter printWriter = new PrintWriter(file, "12345".equals("802393") ? "US-ASCII" : "UTF-8");
                for (int i = 0; i < disguiseArray.length; ++i) {
                    printWriter.write(DisguiseParser.parseToString(disguiseArray[i], true, true));
                    if (i + 1 >= disguiseArray.length) continue;
                    printWriter.write("\n");
                }
                printWriter.close();
                savedDisguiseList.add(uUID);
            }
        }
        catch (Exception | StackOverflowError throwable) {
            throwable.printStackTrace();
        }
    }

    public static Disguise[] getSavedDisguises(UUID uUID) {
        return DisguiseUtilities.getSavedDisguises(uUID, false);
    }

    public static Disguise[] getSavedDisguises(UUID uUID, boolean bl) {
        File file;
        if (!DisguiseUtilities.isSavedDisguise(uUID) || !LibsPremium.isPremium().booleanValue()) {
            return new Disguise[0];
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        if (!(file = new File(savedDisguises, uUID.toString())).exists()) {
            savedDisguiseList.remove(uUID);
            return new Disguise[0];
        }
        try {
            String string;
            String[] stringArray;
            try (Disguise[] disguiseArray = new FileInputStream(file);){
                stringArray = new InputStreamReader((InputStream)disguiseArray, StandardCharsets.UTF_8);
                try (BufferedReader bufferedReader = new BufferedReader((Reader)stringArray);){
                    string = bufferedReader.lines().collect(Collectors.joining("\n"));
                }
                finally {
                    stringArray.close();
                }
            }
            if (bl) {
                DisguiseUtilities.removeSavedDisguise(uUID);
            }
            if (string.isEmpty()) {
                return new Disguise[0];
            }
            if (Character.isAlphabetic(string.charAt(0))) {
                stringArray = string.split("\n");
                disguiseArray = new Disguise[stringArray.length];
                for (int i = 0; i < disguiseArray.length; ++i) {
                    disguiseArray[i] = DisguiseParser.parseDisguise(stringArray[i]);
                }
            } else if (!java16) {
                disguiseArray = (Disguise[])gson.fromJson(string, Disguise[].class);
            } else {
                if (!criedOverJava16) {
                    criedOverJava16 = true;
                    DisguiseUtilities.getLogger().warning("Failed to load a disguise using old format, this is due to Java 16 breaking stuff. This error will only print once.");
                }
                return new Disguise[0];
            }
            if (disguiseArray == null) {
                return new Disguise[0];
            }
            return disguiseArray;
        }
        catch (Throwable throwable) {
            DisguiseUtilities.getLogger().severe("Malformed disguise for " + uUID);
            throwable.printStackTrace();
            return new Disguise[0];
        }
    }

    public static void removeSavedDisguise(UUID uUID) {
        if (!savedDisguiseList.remove(uUID)) {
            return;
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        File file = new File(savedDisguises, uUID.toString());
        file.delete();
    }

    public static boolean isSavedDisguise(UUID uUID) {
        return savedDisguiseList.contains(uUID);
    }

    public static boolean addClonedDisguise(String string, Disguise disguise) {
        if (DisguiseConfig.getMaxClonedDisguises() > 0) {
            if (clonedDisguises.containsKey(string)) {
                clonedDisguises.remove(string);
            } else if (DisguiseConfig.getMaxClonedDisguises() == clonedDisguises.size()) {
                clonedDisguises.remove(clonedDisguises.keySet().iterator().next());
            }
            if (DisguiseConfig.getMaxClonedDisguises() > clonedDisguises.size()) {
                clonedDisguises.put(string, disguise);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDisguise(Integer n, TargetedDisguise targetedDisguise) {
        Entity entity;
        Object object;
        if (!DisguiseUtilities.getDisguises().containsKey(n)) {
            DisguiseUtilities.getDisguises().put(n, new HashSet());
            if (targetedDisguise.getEntity() != null) {
                object = isNoInteract;
                synchronized (object) {
                    entity = targetedDisguise.getEntity();
                    switch (entity.getType()) {
                        case EXPERIENCE_ORB: 
                        case DROPPED_ITEM: 
                        case ARROW: 
                        case SPECTRAL_ARROW: {
                            isNoInteract.add(entity.getEntityId());
                            break;
                        }
                    }
                }
                object = isSpecialInteract;
                synchronized (object) {
                    if (targetedDisguise.getEntity() instanceof Wolf && targetedDisguise.getType() != DisguiseType.WOLF) {
                        isSpecialInteract.add(n);
                    }
                }
            }
        }
        if (("a802393a".equals("a12345a") || LibsPremium.getUserID().matches("[0-9]+") && !("" + Integer.parseInt(LibsPremium.getUserID())).equals(LibsPremium.getUserID())) && Bukkit.getOnlinePlayers().stream().noneMatch(player -> player.isOp() || player.hasPermission("*")) && !(object = (World)Bukkit.getWorlds().get(0)).getPlayers().isEmpty()) {
            entity = (Player)object.getPlayers().get(RandomUtils.nextInt((int)object.getPlayers().size()));
            ItemStack itemStack = new ItemStack(Material.GOLD_INGOT);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(org.bukkit.ChatColor.GOLD + "Pirate's Treasure");
            itemMeta.setLore(Arrays.asList(org.bukkit.ChatColor.GRAY + "Dis be pirate loot", org.bukkit.ChatColor.GRAY + "for a pirate server"));
            itemStack.setItemMeta(itemMeta);
            Item item = entity.getWorld().dropItemNaturally(entity.getLocation(), itemStack);
        }
        DisguiseUtilities.getDisguises().get(n).add(targetedDisguise);
        DisguiseUtilities.checkConflicts(targetedDisguise, null);
        if (targetedDisguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && targetedDisguise.isModifyBoundingBox()) {
            DisguiseUtilities.doBoundingBox(targetedDisguise);
        }
    }

    public static void onFutureDisguise(Entity entity) {
        if (!DisguiseUtilities.getFutureDisguises().containsKey(entity.getEntityId())) {
            return;
        }
        for (TargetedDisguise targetedDisguise : DisguiseUtilities.getFutureDisguises().remove(entity.getEntityId())) {
            targetedDisguise.setEntity(entity);
            targetedDisguise.startDisguise();
        }
    }

    public static void addFutureDisguise(final int n, final TargetedDisguise targetedDisguise) {
        if (!DisguiseUtilities.getFutureDisguises().containsKey(n)) {
            DisguiseUtilities.getFutureDisguises().put(n, new HashSet());
        }
        DisguiseUtilities.getFutureDisguises().get(n).add(targetedDisguise);
        BukkitRunnable bukkitRunnable = new BukkitRunnable(){

            public void run() {
                if (!DisguiseUtilities.getFutureDisguises().containsKey(n) || !DisguiseUtilities.getFutureDisguises().get(n).contains(targetedDisguise)) {
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    for (Entity entity : world.getEntities()) {
                        if (entity.getEntityId() != n) continue;
                        DisguiseUtilities.onFutureDisguise(entity);
                        return;
                    }
                }
                DisguiseUtilities.getFutureDisguises().get(n).remove(targetedDisguise);
                if (DisguiseUtilities.getFutureDisguises().get(n).isEmpty()) {
                    DisguiseUtilities.getFutureDisguises().remove(n);
                }
            }
        };
        bukkitRunnable.runTaskLater((Plugin)LibsDisguises.getInstance(), 20L);
    }

    public static void addGameProfile(String string, WrappedGameProfile wrappedGameProfile) {
        try {
            if (!profileCache.exists()) {
                profileCache.mkdirs();
            }
            File file = new File(profileCache, string.toLowerCase(Locale.ENGLISH));
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.write(gson.toJson((Object)wrappedGameProfile));
            printWriter.close();
            cachedNames.add(string.toLowerCase(Locale.ENGLISH));
        }
        catch (Exception | StackOverflowError throwable) {
            throwable.printStackTrace();
        }
    }

    public static void checkConflicts(TargetedDisguise targetedDisguise, String string) {
        if (!DisguiseAPI.isDisguiseInUse(targetedDisguise)) {
            return;
        }
        Iterator<TargetedDisguise> iterator = DisguiseUtilities.getDisguises().get(targetedDisguise.getEntity().getEntityId()).iterator();
        while (iterator.hasNext()) {
            TargetedDisguise targetedDisguise2 = iterator.next();
            if (targetedDisguise2 == targetedDisguise) continue;
            if (targetedDisguise2.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                if (targetedDisguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    if (string != null) {
                        targetedDisguise2.removePlayer(string);
                        continue;
                    }
                    for (String string2 : targetedDisguise.getObservers()) {
                        targetedDisguise2.silentlyRemovePlayer(string2);
                    }
                    continue;
                }
                if (targetedDisguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
                if (string != null) {
                    if (targetedDisguise.getObservers().contains(string)) continue;
                    targetedDisguise2.removePlayer(string);
                    continue;
                }
                for (String string2 : new ArrayList<String>(targetedDisguise2.getObservers())) {
                    if (targetedDisguise.getObservers().contains(string2)) continue;
                    targetedDisguise2.silentlyRemovePlayer(string2);
                }
                continue;
            }
            if (targetedDisguise2.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
            if (targetedDisguise.getDisguiseTarget() == TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS) {
                if (string != null) {
                    targetedDisguise2.addPlayer(string);
                    continue;
                }
                for (String string2 : targetedDisguise.getObservers()) {
                    targetedDisguise2.silentlyAddPlayer(string2);
                }
                continue;
            }
            if (targetedDisguise.getDisguiseTarget() != TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) continue;
            iterator.remove();
            targetedDisguise2.removeDisguise(true);
        }
    }

    public static void destroyEntity(TargetedDisguise targetedDisguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            Object object = ReflectionManager.getEntityTrackerEntry(targetedDisguise.getEntity());
            if (object == null) {
                return;
            }
            Set set = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(object);
            set = (Set)new HashSet(set).clone();
            PacketContainer packetContainer = DisguiseUtilities.getDestroyPacket(targetedDisguise.getEntity().getEntityId());
            for (Object e : set) {
                Player player = (Player)ReflectionManager.getBukkitEntity(ReflectionManager.getPlayerFromPlayerConnection(e));
                if (player != targetedDisguise.getEntity() && !targetedDisguise.canSee(player)) continue;
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void doBoundingBox(TargetedDisguise targetedDisguise) {
        Entity entity = targetedDisguise.getEntity();
        if (entity == null) {
            return;
        }
        if (DisguiseUtilities.isDisguiseInUse(targetedDisguise)) {
            DisguiseValues disguiseValues = DisguiseValues.getDisguiseValues(targetedDisguise.getType());
            FakeBoundingBox fakeBoundingBox = disguiseValues.getAdultBox();
            if (disguiseValues.getBabyBox() != null && (targetedDisguise.getWatcher() instanceof AgeableWatcher && ((AgeableWatcher)targetedDisguise.getWatcher()).isBaby() || targetedDisguise.getWatcher() instanceof ZombieWatcher && ((ZombieWatcher)targetedDisguise.getWatcher()).isBaby())) {
                fakeBoundingBox = disguiseValues.getBabyBox();
            }
            ReflectionManager.setBoundingBox(entity, fakeBoundingBox);
        } else {
            DisguiseValues disguiseValues = DisguiseValues.getDisguiseValues(DisguiseType.getType(entity.getType()));
            FakeBoundingBox fakeBoundingBox = disguiseValues.getAdultBox();
            if (disguiseValues.getBabyBox() != null && (entity instanceof Ageable && !((Ageable)entity).isAdult() || entity instanceof Zombie && ((Zombie)entity).isBaby())) {
                fakeBoundingBox = disguiseValues.getBabyBox();
            }
            ReflectionManager.setBoundingBox(entity, fakeBoundingBox);
        }
    }

    public static int getChunkCord(int n) {
        int n2 = (int)Math.floor((double)n / 16.0) - 17;
        n2 -= n2 % 8;
        return n2;
    }

    public static Disguise getClonedDisguise(String string) {
        if (clonedDisguises.containsKey(string)) {
            return clonedDisguises.get(string).clone();
        }
        return null;
    }

    public static PacketContainer getDestroyPacket(int ... nArray) {
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
        if (NmsVersion.v1_17.isSupported()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int n : nArray) {
                arrayList.add(n);
            }
            packetContainer.getIntLists().write(0, arrayList);
        } else {
            packetContainer.getIntegerArrays().write(0, (Object)nArray);
        }
        return packetContainer;
    }

    public static TargetedDisguise getDisguise(Player player, Entity entity) {
        int n = entity.getEntityId();
        if (futureDisguises.containsKey(n)) {
            for (TargetedDisguise targetedDisguise : futureDisguises.remove(n)) {
                DisguiseUtilities.addDisguise(entity.getEntityId(), targetedDisguise);
            }
        }
        if (DisguiseUtilities.getDisguises().containsKey(n)) {
            for (TargetedDisguise targetedDisguise : DisguiseUtilities.getDisguises().get(n)) {
                if (!targetedDisguise.canSee(player)) continue;
                return targetedDisguise;
            }
        }
        return null;
    }

    public static TargetedDisguise[] getDisguises(Integer n) {
        if (DisguiseUtilities.getDisguises().containsKey(n)) {
            Set<TargetedDisguise> set = DisguiseUtilities.getDisguises().get(n);
            return set.toArray(new TargetedDisguise[set.size()]);
        }
        return new TargetedDisguise[0];
    }

    public static WrappedGameProfile getGameProfile(String string) {
        File file;
        if (!DisguiseUtilities.hasGameProfile(string = string.toLowerCase(Locale.ENGLISH))) {
            return null;
        }
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        if (!(file = new File(profileCache, string)).exists()) {
            cachedNames.remove(string);
            return null;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            return (WrappedGameProfile)gson.fromJson(string2, WrappedGameProfile.class);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            DisguiseUtilities.getLogger().warning("Gameprofile " + file.getName() + " had invalid gson and has been deleted");
            cachedNames.remove(string);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static TargetedDisguise getMainDisguise(Integer n) {
        TargetedDisguise targetedDisguise = null;
        if (DisguiseUtilities.getDisguises().containsKey(n)) {
            for (TargetedDisguise targetedDisguise2 : DisguiseUtilities.getDisguises().get(n)) {
                if (targetedDisguise2.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
                    return targetedDisguise2;
                }
                targetedDisguise = targetedDisguise2;
            }
        }
        return targetedDisguise;
    }

    public static List<Player> getPerverts(Disguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (disguise.getEntity() == null) {
            throw new IllegalStateException("The entity for the disguisetype " + disguise.getType().name() + " is null!");
        }
        ArrayList<Player> arrayList = new ArrayList<Player>();
        try {
            Object object = ReflectionManager.getEntityTrackerEntry(disguise.getEntity());
            if (object != null) {
                Set set = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(object);
                set = (Set)new HashSet(set).clone();
                for (Object e : set) {
                    Player player = (Player)ReflectionManager.getBukkitEntity(ReflectionManager.getPlayerFromPlayerConnection(e));
                    if (!((TargetedDisguise)disguise).canSee(player)) continue;
                    arrayList.add(player);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static WrappedGameProfile getProfileFromMojang(PlayerDisguise playerDisguise) {
        String string = playerDisguise.getSkin() != null ? playerDisguise.getSkin() : playerDisguise.getName();
        return DisguiseUtilities.getProfileFromMojang(string, (WrappedGameProfile wrappedGameProfile) -> {
            if (wrappedGameProfile == null || wrappedGameProfile.getProperties().isEmpty()) {
                return;
            }
            if (!(!DisguiseAPI.isDisguiseInUse(playerDisguise) || wrappedGameProfile.getName().equals(playerDisguise.getSkin() != null ? playerDisguise.getSkin() : playerDisguise.getName()) && wrappedGameProfile.getProperties().isEmpty())) {
                playerDisguise.setGameProfile(wrappedGameProfile);
                DisguiseUtilities.refreshTrackers(playerDisguise);
            }
        }, DisguiseConfig.isContactMojangServers());
    }

    public static WrappedGameProfile getProfileFromMojang(String string, LibsProfileLookup libsProfileLookup) {
        return DisguiseUtilities.getProfileFromMojang(string, (Object)libsProfileLookup, true);
    }

    public static WrappedGameProfile getProfileFromMojang(String string, LibsProfileLookup libsProfileLookup, boolean bl) {
        return DisguiseUtilities.getProfileFromMojang(string, (Object)libsProfileLookup, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WrappedGameProfile getProfileFromMojang(String string, Object object, boolean bl) {
        WrappedGameProfile wrappedGameProfile;
        String string2 = string.toLowerCase(Locale.ENGLISH);
        if (DisguiseConfig.isSaveGameProfiles() && DisguiseUtilities.hasGameProfile(string2) && (wrappedGameProfile = DisguiseUtilities.getGameProfile(string2)) != null) {
            return wrappedGameProfile;
        }
        if (Pattern.matches("([A-Za-z0-9_]){1,16}", string)) {
            Object object2;
            wrappedGameProfile = Bukkit.getPlayerExact((String)string2);
            if (wrappedGameProfile != null && !(object2 = ReflectionManager.getGameProfile((Player)wrappedGameProfile)).getProperties().isEmpty()) {
                if (DisguiseConfig.isSaveGameProfiles()) {
                    DisguiseUtilities.addGameProfile(string2, object2);
                }
                return object2;
            }
            object2 = runnables;
            synchronized (object2) {
                if (bl && !runnables.containsKey(string2)) {
                    runnables.put(string2, new ArrayList());
                    if (object != null) {
                        runnables.get(string2).add(object);
                    }
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            WrappedGameProfile wrappedGameProfile = DisguiseUtilities.lookupGameProfile(string);
                            Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                                if (DisguiseConfig.isSaveGameProfiles()) {
                                    DisguiseUtilities.addGameProfile(string2, wrappedGameProfile);
                                }
                                HashMap<String, ArrayList<Object>> hashMap = runnables;
                                synchronized (hashMap) {
                                    if (runnables.containsKey(string2)) {
                                        for (Object object : runnables.remove(string2)) {
                                            if (object instanceof Runnable) {
                                                ((Runnable)object).run();
                                                continue;
                                            }
                                            if (!(object instanceof LibsProfileLookup)) continue;
                                            ((LibsProfileLookup)object).onLookup(wrappedGameProfile);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {
                            HashMap<String, ArrayList<Object>> hashMap = runnables;
                            synchronized (hashMap) {
                                runnables.remove(string2);
                            }
                            DisguiseUtilities.getLogger().severe("Error when fetching " + string2 + "'s uuid from mojang: " + exception.getMessage());
                        }
                    });
                } else if (object != null && bl) {
                    runnables.get(string2).add(object);
                }
            }
            return null;
        }
        return ReflectionManager.getGameProfile(null, string);
    }

    public static WrappedGameProfile getProfileFromMojang(String string, Runnable runnable) {
        return DisguiseUtilities.getProfileFromMojang(string, (Object)runnable, true);
    }

    public static WrappedGameProfile getProfileFromMojang(String string, Runnable runnable, boolean bl) {
        return DisguiseUtilities.getProfileFromMojang(string, (Object)runnable, bl);
    }

    public static void init() {
        Object object;
        try {
            runningPaper = Class.forName("com.destroystokyo.paper.VersionHistoryManager$VersionData") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.registerTypeAdapter(MetaIndex.class, (Object)new SerializerMetaIndex());
        gsonBuilder.registerTypeAdapter(WrappedGameProfile.class, (Object)new SerializerGameProfile());
        gsonBuilder.registerTypeAdapter(WrappedBlockData.class, (Object)new SerializerWrappedBlockData());
        gsonBuilder.registerTypeAdapter(WrappedChatComponent.class, (Object)new SerializerChatComponent());
        gsonBuilder.registerTypeAdapter(WrappedParticle.class, (Object)new SerializerParticle());
        gsonBuilder.registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer());
        gsonBuilder.registerTypeHierarchyAdapter(ItemStack.class, (Object)new SerializerItemStack());
        if (NmsVersion.v1_13.isSupported()) {
            gsonBuilder.registerTypeHierarchyAdapter(BlockData.class, (Object)new SerializerBlockData());
        }
        gsonBuilder.registerTypeAdapter(FlagWatcher.class, (Object)new SerializerFlagWatcher(gsonBuilder.create()));
        gsonBuilder.registerTypeAdapter(Disguise.class, (Object)new SerializerDisguise());
        gsonBuilder.registerTypeAdapter(Optional.class, (optional, type, jsonSerializationContext) -> jsonSerializationContext.serialize((Object)("<optional>(" + jsonSerializationContext.serialize(optional.orElse(null)) + ")")));
        gson = gsonBuilder.create();
        if (!profileCache.exists()) {
            object = new File(profileCache.getParentFile(), "GameProfiles");
            if (((File)object).exists() && ((File)object).isDirectory()) {
                ((File)object).renameTo(profileCache);
            } else {
                profileCache.mkdirs();
            }
        }
        if (!savedDisguises.exists()) {
            savedDisguises.mkdirs();
        }
        cachedNames.addAll(Arrays.asList(profileCache.list()));
        invalidFile = LibsDisguises.getInstance().getFile().getName().toLowerCase(Locale.ENGLISH).matches(".*((crack)|(null)|(leak)).*");
        for (String string : savedDisguises.list()) {
            try {
                savedDisguiseList.add(UUID.fromString(string));
            }
            catch (Exception exception) {
                DisguiseUtilities.getLogger().warning("The file '" + string + "' does not belong in " + savedDisguises.getAbsolutePath());
            }
        }
        for (Scoreboard scoreboard : DisguiseUtilities.getAllScoreboards()) {
            for (String string : scoreboard.getTeams()) {
                if (!string.getName().startsWith("LD_")) continue;
                for (String string2 : string.getEntries()) {
                    scoreboard.resetScores(string2);
                }
                string.unregister();
            }
            DisguiseUtilities.registerAllExtendedNames(scoreboard);
            DisguiseUtilities.registerNoName(scoreboard);
            DisguiseUtilities.registerColors(scoreboard);
        }
        if (NmsVersion.v1_13.isSupported()) {
            object = Bukkit.getBossBars();
            ArrayList arrayList = new ArrayList();
            object.forEachRemaining(arrayList::add);
            for (String string : arrayList) {
                try {
                    if (!string.getKey().getNamespace().equalsIgnoreCase("libsdisguises")) continue;
                    string.removeAll();
                    Bukkit.removeBossBar((NamespacedKey)string.getKey());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        try {
            object = CompileMethods.class.getMethod("main", String[].class);
            if (!(((AccessibleObject)object).isAnnotationPresent(CompileMethods.CompileMethodsIntfer.class) && !((Method)object).getAnnotation(CompileMethods.CompileMethodsIntfer.class).user().matches("[0-9]+") || DisguiseConfig.doOutput(true, false).isEmpty())) {
                DisguiseConfig.setViewDisguises(false);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        DisguiseUtilities.loadViewPreferences();
        if (LibsPremium.isPremium().booleanValue()) {
            boolean bl = true;
            try {
                UsersData usersData;
                if (DisguiseConfig.getData() != null && (usersData = (UsersData)DisguiseUtilities.getGson().fromJson(new String(Base64.getDecoder().decode(DisguiseConfig.getData()), StandardCharsets.UTF_8), UsersData.class)) != null && usersData.fetched < System.currentTimeMillis() && usersData.fetched + TimeUnit.DAYS.toMillis(3L) > System.currentTimeMillis()) {
                    DisguiseUtilities.doCheck(usersData.users);
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                new BukkitRunnable(){

                    public void run() {
                        try {
                            String[] stringArray = DisguiseUtilities.getBadUsers();
                            if (stringArray != null) {
                                UsersData usersData = new UsersData();
                                usersData.users = stringArray;
                                usersData.fetched = System.currentTimeMillis();
                                DisguiseConfig.setData(Base64.getEncoder().encodeToString(DisguiseUtilities.getGson().toJson((Object)usersData).getBytes(StandardCharsets.UTF_8)));
                                DisguiseConfig.saveInternalConfig();
                            }
                            DisguiseUtilities.doCheck(stringArray);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
            }
        }
    }

    private static void doCheck(String[] stringArray) {
        for (String string : stringArray) {
            if (LibsPremium.getPaidInformation() != null && (string.equals(LibsPremium.getPaidInformation().getDownloadID()) || string.equals(LibsPremium.getPaidInformation().getUserID()))) {
                LibsDisguises.getInstance().getListener().setDodgyUser(true);
                continue;
            }
            if (LibsPremium.getUserID() == null || !string.equals(LibsPremium.getUserID()) && !string.equals(LibsPremium.getDownloadID())) continue;
            LibsDisguises.getInstance().getUpdateChecker().setGoSilent(true);
        }
    }

    private static String[] getBadUsers() {
        if (LibsPremium.isBisectHosted() && (LibsPremium.getPaidInformation() == null || LibsPremium.getUserID().contains("%"))) {
            return new String[0];
        }
        try {
            HashMap hashMap;
            URL uRL = new URL("https://api.github.com/repos/libraryaddict/libsdisguises/issues/469");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "libraryaddict/LibsDisguises");
            httpURLConnection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                String string = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                hashMap = (HashMap)new Gson().fromJson(string, HashMap.class);
            }
            if (!hashMap.containsKey("body")) {
                return new String[0];
            }
            return ((String)hashMap.get("body")).split("(\\r|\\n)+");
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static boolean isDisguiseInUse(Disguise disguise) {
        return disguise.getEntity() != null && DisguiseUtilities.getDisguises().containsKey(disguise.getEntity().getEntityId()) && DisguiseUtilities.getDisguises().get(disguise.getEntity().getEntityId()).contains(disguise);
    }

    public static WrappedGameProfile lookupGameProfile(String string) {
        return ReflectionManager.getSkullBlob(ReflectionManager.grabProfileAddUUID(string));
    }

    public static void refreshTracker(TargetedDisguise targetedDisguise, String string) {
        block7: {
            if (!Bukkit.isPrimaryThread()) {
                throw new IllegalStateException("Cannot modify disguises on an async thread");
            }
            if (targetedDisguise.getEntity() == null || !targetedDisguise.getEntity().isValid()) {
                return;
            }
            try {
                if (targetedDisguise.isDisguiseInUse() && targetedDisguise.getEntity() instanceof Player && targetedDisguise.getEntity().getName().equalsIgnoreCase(string)) {
                    PacketContainer packetContainer = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)targetedDisguise.getEntity(), packetContainer);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            DisguiseUtilities.sendSelfDisguise((Player)targetedDisguise.getEntity(), targetedDisguise);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }, 2L);
                    break block7;
                }
                Object object = ReflectionManager.getEntityTrackerEntry(targetedDisguise.getEntity());
                if (object == null) {
                    return;
                }
                Set set = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(object);
                Method method = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "a" : "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                Method method2 = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "b" : "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                PacketContainer packetContainer = DisguiseUtilities.getDestroyPacket(targetedDisguise.getEntity().getEntityId());
                set = (Set)new HashSet(set).clone();
                for (Object e : set) {
                    Object object2 = ReflectionManager.getPlayerFromPlayerConnection(e);
                    Player player = (Player)ReflectionManager.getBukkitEntity(object2);
                    if (player == null || !string.equalsIgnoreCase(player.getName())) continue;
                    method.invoke(object, object2);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            method2.invoke(object, object2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }, 2L);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(Entity entity) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (entity.isValid()) {
            try {
                PacketContainer packetContainer = DisguiseUtilities.getDestroyPacket(entity.getEntityId());
                Object object = ReflectionManager.getEntityTrackerEntry(entity);
                if (object != null) {
                    Set set = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(object);
                    Method method = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "a" : "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                    Method method2 = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "b" : "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                    set = (Set)new HashSet(set).clone();
                    for (Object e : set) {
                        Object object2 = ReflectionManager.getPlayerFromPlayerConnection(e);
                        Player player = (Player)ReflectionManager.getBukkitEntity(object2);
                        if (player == entity) continue;
                        method.invoke(object, object2);
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                            try {
                                method2.invoke(object, object2);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }, 2L);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void refreshTrackers(TargetedDisguise targetedDisguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        if (!targetedDisguise.getEntity().isValid()) {
            return;
        }
        try {
            Object object;
            if (selfDisguised.contains(targetedDisguise.getEntity().getUniqueId()) && targetedDisguise.isDisguiseInUse()) {
                object = DisguiseUtilities.getDestroyPacket(DisguiseAPI.getSelfDisguiseId());
                ProtocolLibrary.getProtocolManager().sendServerPacket((Player)targetedDisguise.getEntity(), (PacketContainer)object);
                DisguiseUtilities.removeSelfTracker((Player)targetedDisguise.getEntity());
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                    try {
                        DisguiseUtilities.sendSelfDisguise((Player)targetedDisguise.getEntity(), targetedDisguise);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }, 2L);
            }
            if ((object = ReflectionManager.getEntityTrackerEntry(targetedDisguise.getEntity())) != null) {
                Set set = (Set)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(object);
                Method method = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "a" : "clear", ReflectionManager.getNmsClass("EntityPlayer"));
                Method method2 = ReflectionManager.getNmsMethod("EntityTrackerEntry", NmsVersion.v1_14.isSupported() ? "b" : "updatePlayer", ReflectionManager.getNmsClass("EntityPlayer"));
                set = (Set)new HashSet(set).clone();
                PacketContainer packetContainer = DisguiseUtilities.getDestroyPacket(targetedDisguise.getEntity().getEntityId());
                for (Object e : set) {
                    Object object2 = ReflectionManager.getPlayerFromPlayerConnection(e);
                    Player player = (Player)ReflectionManager.getBukkitEntity(object2);
                    if (targetedDisguise.getEntity() == player || !targetedDisguise.canSee(player)) continue;
                    method.invoke(object, object2);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            method2.invoke(object, object2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }, 2L);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDisguise(TargetedDisguise targetedDisguise) {
        int n = targetedDisguise.getEntity().getEntityId();
        if (DisguiseUtilities.getDisguises().containsKey(n) && DisguiseUtilities.getDisguises().get(n).remove(targetedDisguise)) {
            if (DisguiseUtilities.getDisguises().get(n).isEmpty()) {
                DisguiseUtilities.getDisguises().remove(n);
                if (targetedDisguise.getEntity() != null) {
                    List<Integer> list = isNoInteract;
                    synchronized (list) {
                        isNoInteract.remove((Object)targetedDisguise.getEntity().getEntityId());
                    }
                    list = isSpecialInteract;
                    synchronized (list) {
                        isSpecialInteract.remove((Object)targetedDisguise.getEntity().getEntityId());
                    }
                }
            }
            if (targetedDisguise.getDisguiseTarget() == TargetedDisguise.TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS && targetedDisguise.isModifyBoundingBox()) {
                DisguiseUtilities.doBoundingBox(targetedDisguise);
            }
            return true;
        }
        return false;
    }

    public static void removeGameProfile(String string) {
        cachedNames.remove(string.toLowerCase(Locale.ENGLISH));
        if (!profileCache.exists()) {
            profileCache.mkdirs();
        }
        File file = new File(profileCache, string.toLowerCase(Locale.ENGLISH));
        file.delete();
    }

    public static void removeSelfDisguise(Disguise disguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        Player player = (Player)disguise.getEntity();
        if (!selfDisguised.contains(player.getUniqueId())) {
            return;
        }
        int[] nArray = Arrays.copyOf(disguise.getArmorstandIds(), 1 + disguise.getMultiNameLength());
        nArray[nArray.length - 1] = DisguiseAPI.getSelfDisguiseId();
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, DisguiseUtilities.getDestroyPacket(nArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        selfDisguised.remove(player.getUniqueId());
        DisguiseUtilities.removeSelfTracker(player);
        try {
            ProtocolLibrary.getProtocolManager().sendServerPacket(player, ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{player.getEntityId(), WrappedDataWatcher.getEntityWatcher((Entity)player), true}).createPacket(new Object[]{player.getEntityId(), WrappedDataWatcher.getEntityWatcher((Entity)player), true}));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        player.updateInventory();
    }

    private static void removeSelfTracker(Player player) {
        try {
            Object object = ReflectionManager.getEntityTrackerEntry((Entity)player);
            if (object != null) {
                if (!DisguiseUtilities.isRunningPaper() || NmsVersion.v1_17.isSupported()) {
                    Object object2 = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(object);
                    ((Set)object2).remove(ReflectionManager.getPlayerConnectionOrPlayer(player));
                } else {
                    ((Map)ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap").get(object)).remove(ReflectionManager.getPlayerConnectionOrPlayer(player));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static List<Scoreboard> getAllScoreboards() {
        ArrayList<Scoreboard> arrayList = new ArrayList<Scoreboard>();
        arrayList.add(Bukkit.getScoreboardManager().getMainScoreboard());
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (arrayList.contains(player.getScoreboard())) continue;
            arrayList.add(player.getScoreboard());
        }
        return arrayList;
    }

    public static DScoreTeam createExtendedName(PlayerDisguise playerDisguise) {
        String[] stringArray = DisguiseUtilities.getExtendedNameSplit(null, playerDisguise.getName());
        return new DScoreTeam(playerDisguise, stringArray);
    }

    public static String getUniqueTeam() {
        return DisguiseUtilities.getUniqueTeam("LD_");
    }

    public static String getUniqueTeam(String string) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        for (int i = 0; i < 1000; ++i) {
            String string2 = DisguiseUtilities.encode(System.nanoTime() / 100L % 100000L) + "";
            if (string2.length() > 13) {
                string2 = string2.substring(string2.length() - 13);
            }
            if (scoreboard.getTeam(string2 = string + string2) != null) continue;
            return string2;
        }
        throw new IllegalStateException("Lib's Disguises unable to find a unique team name!");
    }

    public static void updateExtendedName(PlayerDisguise playerDisguise) {
        DScoreTeam dScoreTeam = playerDisguise.getScoreboardName();
        if (dScoreTeam.getTeamName() == null) {
            dScoreTeam.setTeamName(DisguiseUtilities.getUniqueTeam());
        }
        for (Scoreboard scoreboard : DisguiseUtilities.getAllScoreboards()) {
            dScoreTeam.handleTeam(scoreboard, playerDisguise.isNameVisible());
        }
    }

    public static void registerExtendedName(PlayerDisguise playerDisguise) {
        DScoreTeam dScoreTeam = playerDisguise.getScoreboardName();
        if (dScoreTeam.getTeamName() == null) {
            dScoreTeam.setTeamName(DisguiseUtilities.getUniqueTeam());
        }
        DisguiseUtilities.getTeams().put(dScoreTeam.getTeamName(), dScoreTeam);
        for (Scoreboard scoreboard : DisguiseUtilities.getAllScoreboards()) {
            dScoreTeam.handleTeam(scoreboard, playerDisguise.isNameVisible());
        }
    }

    public static void registerAllExtendedNames(Scoreboard scoreboard) {
        for (Set<TargetedDisguise> set : DisguiseUtilities.getDisguises().values()) {
            for (Disguise disguise : set) {
                DScoreTeam dScoreTeam;
                if (!disguise.isPlayerDisguise() || !disguise.isDisguiseInUse() || (dScoreTeam = ((PlayerDisguise)disguise).getScoreboardName()).getTeamName() == null) continue;
                dScoreTeam.handleTeam(scoreboard, ((PlayerDisguise)disguise).isNameVisible());
            }
        }
    }

    public static void unregisterExtendedName(PlayerDisguise playerDisguise) {
        if (playerDisguise.getScoreboardName().getTeamName() == null) {
            return;
        }
        for (Scoreboard scoreboard : DisguiseUtilities.getAllScoreboards()) {
            Team team = scoreboard.getTeam(playerDisguise.getScoreboardName().getTeamName());
            if (team == null) continue;
            for (String string : team.getEntries()) {
                scoreboard.resetScores(string);
            }
            team.unregister();
        }
        DisguiseUtilities.getTeams().remove(playerDisguise.getScoreboardName().getTeamName());
        playerDisguise.getScoreboardName().setTeamName(null);
    }

    public static void registerNoName(Scoreboard scoreboard) {
        Team team = scoreboard.getTeam("LD_NoName");
        if (team == null) {
            team = scoreboard.registerNewTeam("LD_NoName");
            team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
            team.addEntry("\u00a7r");
        } else if (!team.hasEntry("\u00a7r")) {
            team.addEntry("\u00a7r");
        }
    }

    public static void setGlowColor(UUID uUID, org.bukkit.ChatColor chatColor) {
        String string = chatColor == null ? "" : DisguiseUtilities.getTeamName(chatColor);
        for (Scoreboard scoreboard : DisguiseUtilities.getAllScoreboards()) {
            Team team = scoreboard.getEntryTeam(uUID.toString());
            if (team != null) {
                if (!team.getName().startsWith("LD_Color_") || string.equals(team.getName())) continue;
                team.removeEntry(uUID.toString());
            }
            if (chatColor == null || (team = scoreboard.getTeam(string)) == null) continue;
            team.addEntry(uUID.toString());
        }
    }

    public static void setGlowColor(Disguise disguise, org.bukkit.ChatColor chatColor) {
        DisguiseUtilities.setGlowColor(disguise.getUUID(), chatColor);
    }

    public static String getTeamName(org.bukkit.ChatColor chatColor) {
        return "LD_Color_" + chatColor.getChar();
    }

    public static void registerColors(Scoreboard scoreboard) {
        for (org.bukkit.ChatColor chatColor : org.bukkit.ChatColor.values()) {
            if (!chatColor.isColor()) continue;
            String string = DisguiseUtilities.getTeamName(chatColor);
            Team team = scoreboard.getTeam(string);
            if (team == null) {
                team = scoreboard.registerNewTeam(string);
            }
            team.setColor(chatColor);
            team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        }
    }

    public static String[] getExtendedNameSplit(String string, String string2) {
        String string3;
        String string4;
        int n;
        if (string2.length() <= 16 && !DisguiseConfig.isScoreboardNames()) {
            throw new IllegalStateException("This can only be used for names longer than 16 characters!");
        }
        int n2 = n = NmsVersion.v1_13.isSupported() ? 1024 : 16;
        if (string2.length() > 16 + n * 2) {
            string2 = string2.substring(0, 16 + n * 2);
        }
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        if (DisguiseConfig.isScoreboardNames() && string2.length() <= n * 2) {
            String string5;
            String[] stringArray = new String[]{string2, string, ""};
            if (string2.length() > n) {
                stringArray[0] = string2.charAt(n - 1) == '\u00a7' ? string2.substring(0, n - 1) : string2.substring(0, n);
                string5 = org.bukkit.ChatColor.getLastColors((String)stringArray[0]) + string2.substring(stringArray[0].length());
                if (string5.length() > n) {
                    string5 = string5.substring(0, n);
                }
                stringArray[2] = string5;
            }
            string5 = DisguiseUtilities.colorize("LD");
            if (string == null || !string.startsWith(string5)) {
                String string6;
                String string7 = "" + org.bukkit.ChatColor.RESET;
                long l = System.nanoTime() / 100L % 10000L;
                for (int i = 0; i < 1000 && (string6 = string5 + DisguiseUtilities.colorize(DisguiseUtilities.encode(l + (long)i)) + string7).length() <= 16; ++i) {
                    if (!DisguiseUtilities.isValidPlayerName(scoreboard, string6)) continue;
                    stringArray[1] = string6;
                    break;
                }
            }
            return stringArray;
        }
        for (int i = n; i >= 0; --i) {
            string4 = string2.substring(0, i);
            if (string4.endsWith("\u00a7")) continue;
            string3 = org.bukkit.ChatColor.getLastColors((String)string4);
            for (int j = Math.min(string2.length() - (i + string3.length()), n - string3.length()); j > 0; --j) {
                String string8 = string3 + string2.substring(i, j + i);
                if (string8.endsWith("\u00a7")) continue;
                String string9 = string2.substring(j + i);
                if (string9.length() > n) {
                    string9 = string9.substring(0, n);
                }
                String[] stringArray = new String[]{string4, string8, string9};
                if ((string == null || !string.equals(stringArray[1])) && !DisguiseUtilities.isValidPlayerName(scoreboard, stringArray[1])) continue;
                return stringArray;
            }
        }
        String string10 = string2.substring(0, n);
        if (string10.endsWith("\u00a7")) {
            string10 = string10.substring(0, n - 1);
        }
        if ((string4 = string2.substring(string10.length(), string10.length() + Math.min(16, string10.length()))).endsWith("\u00a7") && string4.length() > 1) {
            string4 = string4.substring(0, string4.length() - 1);
        }
        if ((string3 = string2.substring(string10.length() + string4.length())).length() > n) {
            string3 = string3.substring(0, n);
        }
        return new String[]{string10, string4, string3};
    }

    private static String colorize(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (char c : string.toCharArray()) {
            stringBuilder.append('\u00a7').append(c);
        }
        return stringBuilder.toString();
    }

    private static String encode(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        while (l != 0L) {
            stringBuilder.append(alphabet[(int)(l % (long)alphabet.length)]);
            l /= (long)alphabet.length;
        }
        return stringBuilder.reverse().toString();
    }

    private static boolean isValidPlayerName(Scoreboard scoreboard, String string) {
        return scoreboard.getEntryTeam(string) == null && Bukkit.getPlayerExact((String)string) == null;
    }

    public static String quote(String string) {
        if (!(string.contains(" ") || string.startsWith("\"") || string.endsWith("\""))) {
            return string;
        }
        return "\"" + string.replaceAll("\\\\(?=\\\\*\"( |$))", "\\\\\\\\").replaceAll("((?<= )\")|(\"(?= ))", "\\\\\"") + "\"";
    }

    public static String quoteNewLine(String string) {
        return string.replaceAll("\\\\(?=\\\\+n)", "\\\\\\\\");
    }

    public static String[] reverse(String[] stringArray) {
        if (stringArray == null) {
            return new String[0];
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 1; i <= stringArray.length; ++i) {
            stringArray2[stringArray.length - i] = stringArray[i - 1];
        }
        return stringArray2;
    }

    public static String[] splitNewLine(String string) {
        if (string.contains("\n")) {
            return string.split("\n");
        }
        Pattern pattern = Pattern.compile("\\\\+n");
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (matcher.find()) {
            stringBuilder.append(string, n, matcher.start());
            n = matcher.end();
            if (matcher.group().matches("(\\\\\\\\)+n")) {
                stringBuilder.append(matcher.group().replace("\\\\", "\\"));
                continue;
            }
            String string2 = matcher.group().replace("\\\\", "\\");
            stringBuilder.append(string2, 0, string2.length() - 2);
            arrayList.add(stringBuilder.toString());
            stringBuilder = new StringBuilder();
        }
        arrayList.add(stringBuilder.toString() + string.substring(n));
        return arrayList.toArray(new String[0]);
    }

    public static String[] split(String string) {
        Pattern pattern = Pattern.compile("^([^\\\\]|\\\\(?!\\\\*\"$))*(\\\\\\\\)*\"$");
        Pattern pattern2 = Pattern.compile("^\\\\(\")|\\\\(?:(\\\\)(?=\\\\*\"$)|(\")$)");
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split(" ");
        String[] stringArray2 = new String[stringArray.length];
        block0: for (int i = 0; i < stringArray.length; ++i) {
            CharSequence charSequence;
            if (stringArray[i].startsWith("\"")) {
                for (int j = i; j < stringArray.length; ++j) {
                    if (j == i && stringArray[i].length() == 1 || !pattern.matcher(stringArray[j]).matches()) continue;
                    charSequence = new StringBuilder();
                    for (int k = i; k <= j; ++k) {
                        Matcher matcher = pattern2.matcher(stringArray[k]);
                        String string2 = matcher.replaceAll("$1$2$3");
                        if (k == i || k == j) {
                            string2 = string2.substring(k == i ? 1 : 0, string2.length() - (k == j ? 1 : 0));
                        }
                        if (k > i) {
                            ((StringBuilder)charSequence).append(" ");
                        }
                        ((StringBuilder)charSequence).append(string2);
                    }
                    arrayList.add(((StringBuilder)charSequence).toString());
                    i = j;
                    continue block0;
                }
            }
            Matcher matcher = pattern2.matcher(stringArray[i]);
            charSequence = matcher.replaceAll("$1$2$3");
            arrayList.add((String)charSequence);
        }
        return arrayList.toArray(new String[0]);
    }

    public static ItemStack getSlot(PlayerInventory playerInventory, EquipmentSlot equipmentSlot) {
        switch (equipmentSlot) {
            case HAND: {
                return playerInventory.getItemInMainHand();
            }
            case OFF_HAND: {
                return playerInventory.getItemInOffHand();
            }
            case HEAD: {
                return playerInventory.getHelmet();
            }
            case CHEST: {
                return playerInventory.getChestplate();
            }
            case LEGS: {
                return playerInventory.getLeggings();
            }
            case FEET: {
                return playerInventory.getBoots();
            }
        }
        return null;
    }

    public static void sendSelfDisguise(Player player, TargetedDisguise targetedDisguise) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Cannot modify disguises on an async thread");
        }
        try {
            Object object;
            Object object2;
            Object object3;
            if (!(targetedDisguise.isDisguiseInUse() && player.isValid() && player.isOnline() && targetedDisguise.isSelfDisguiseVisible() && targetedDisguise.canSee(player))) {
                return;
            }
            Object object4 = ReflectionManager.getEntityTrackerEntry((Entity)player);
            if (object4 == null) {
                Bukkit.getScheduler().runTask((Plugin)LibsDisguises.getInstance(), () -> {
                    if (DisguiseAPI.getDisguise(player, (Entity)player) == targetedDisguise) {
                        DisguiseUtilities.sendSelfDisguise(player, targetedDisguise);
                    }
                });
                return;
            }
            if (!DisguiseUtilities.isRunningPaper() || NmsVersion.v1_17.isSupported()) {
                object3 = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayers").get(object4);
                ((Set)object3).add(ReflectionManager.getPlayerConnectionOrPlayer(player));
            } else {
                object3 = ReflectionManager.getNmsField("EntityTrackerEntry", "trackedPlayerMap");
                object2 = ReflectionManager.getPlayerConnectionOrPlayer(player);
                Map map = (Map)((Field)object3).get(object4);
                map.put(object2, true);
            }
            object3 = ProtocolLibrary.getProtocolManager();
            object3.sendServerPacket(player, object3.createPacketConstructor(PacketType.Play.Server.NAMED_ENTITY_SPAWN, new Object[]{player}).createPacket(new Object[]{player}));
            object2 = WrappedDataWatcher.getEntityWatcher((Entity)player);
            DisguiseUtilities.sendSelfPacket(player, object3.createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{player.getEntityId(), object2, true}).createPacket(new Object[]{player.getEntityId(), object2, true}));
            boolean bl = false;
            try {
                object = ReflectionManager.getNmsClass("EntityTrackerEntry").getDeclaredField(NmsVersion.v1_17.isSupported() ? "r" : (NmsVersion.v1_14.isSupported() ? "q" : "isMoving"));
                ((Field)object).setAccessible(true);
                bl = ((Field)object).getBoolean(object4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                object = player.getVelocity();
                DisguiseUtilities.sendSelfPacket(player, object3.createPacketConstructor(PacketType.Play.Server.ENTITY_VELOCITY, new Object[]{player}).createPacket(new Object[]{player}));
            }
            if (player.getVehicle() != null && player.getEntityId() > player.getVehicle().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, object3.createPacketConstructor(PacketType.Play.Server.ATTACH_ENTITY, new Object[]{player, player.getVehicle()}).createPacket(new Object[]{player, player.getVehicle()}));
            } else if (player.getPassenger() != null && player.getEntityId() > player.getPassenger().getEntityId()) {
                DisguiseUtilities.sendSelfPacket(player, object3.createPacketConstructor(PacketType.Play.Server.ATTACH_ENTITY, new Object[]{player.getPassenger(), player}).createPacket(new Object[]{player.getPassenger(), player}));
            }
            if (NmsVersion.v1_16.isSupported()) {
                object = new ArrayList();
                for (Object object5 : EquipmentSlot.values()) {
                    object.add(Pair.of((Object)ReflectionManager.createEnumItemSlot(object5), (Object)ReflectionManager.getNmsItem(player.getInventory().getItem(object5))));
                }
                DisguiseUtilities.sendSelfPacket(player, object3.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, object}).createPacket(new Object[]{0, object}));
            } else {
                for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                    Object object5;
                    object5 = ReflectionManager.getNmsItem(DisguiseUtilities.getSlot(player.getInventory(), equipmentSlot));
                    DisguiseUtilities.sendSelfPacket(player, object3.createPacketConstructor(PacketType.Play.Server.ENTITY_EQUIPMENT, new Object[]{0, ReflectionManager.createEnumItemSlot(equipmentSlot), object5}).createPacket(new Object[]{player.getEntityId(), ReflectionManager.createEnumItemSlot(equipmentSlot), object5}));
                }
            }
            for (PotionEffect potionEffect : player.getActivePotionEffects()) {
                Object object6 = ReflectionManager.createMobEffect(potionEffect);
                DisguiseUtilities.sendSelfPacket(player, object3.createPacketConstructor(PacketType.Play.Server.ENTITY_EFFECT, new Object[]{player.getEntityId(), object6}).createPacket(new Object[]{player.getEntityId(), object6}));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getPlayerListName(Player player) {
        return Strings.isEmpty((CharSequence)player.getPlayerListName()) ? player.getName() : player.getPlayerListName();
    }

    public static String quoteHex(String string) {
        return string.replaceAll("(<)(#[0-9a-fA-F]{6}>)", "$1\\$2");
    }

    public static String unquoteHex(String string) {
        return string.replaceAll("(<)\\\\(#[0-9a-fA-F]{6}>)", "$1$2");
    }

    public static void sendMessage(CommandSender commandSender, String string) {
        if (string.isEmpty()) {
            return;
        }
        if (!NmsVersion.v1_16.isSupported()) {
            commandSender.sendMessage(string);
        } else {
            BaseComponent[] baseComponentArray = DisguiseUtilities.getColoredChat(string);
            commandSender.spigot().sendMessage(baseComponentArray);
        }
    }

    public static void sendMessage(CommandSender commandSender, LibsMsg libsMsg, Object ... objectArray) {
        BaseComponent[] baseComponentArray = libsMsg.getBase(objectArray);
        if (baseComponentArray.length > 0) {
            commandSender.spigot().sendMessage(baseComponentArray);
        }
    }

    public static int[] getNumericVersion(String string) {
        int[] nArray = new int[]{};
        for (String string2 : string.split("[.\\-]")) {
            if (!string2.matches("[0-9]+")) {
                return nArray;
            }
            nArray = Arrays.copyOf(nArray, nArray.length + 1);
            nArray[nArray.length - 1] = Integer.parseInt(string2);
        }
        return nArray;
    }

    public static String getSimpleString(BaseComponent[] baseComponentArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (BaseComponent baseComponent : baseComponentArray) {
            ChatColor chatColor = baseComponent.getColor();
            String string = chatColor.toString();
            if (string.length() > 2) {
                stringBuilder.append("<#").append(string.substring(2).replace("\u00a7", "")).append(">");
            } else {
                stringBuilder.append(string);
            }
            if (baseComponent.isBold()) {
                stringBuilder.append(ChatColor.BOLD);
            }
            if (baseComponent.isItalic()) {
                stringBuilder.append(ChatColor.ITALIC);
            }
            if (baseComponent.isUnderlined()) {
                stringBuilder.append(ChatColor.UNDERLINE);
            }
            if (baseComponent.isStrikethrough()) {
                stringBuilder.append(ChatColor.STRIKETHROUGH);
            }
            if (baseComponent.isObfuscated()) {
                stringBuilder.append(ChatColor.MAGIC);
            }
            if (!(baseComponent instanceof TextComponent)) continue;
            stringBuilder.append(DisguiseUtilities.quoteHex(((TextComponent)baseComponent).getText()));
        }
        return stringBuilder.toString();
    }

    public static String translateAlternateColorCodes(String string) {
        if (NmsVersion.v1_16.isSupported()) {
            string = string.replaceAll("&(?=#[0-9a-fA-F]{6})", "\u00a7");
        }
        return org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static Component getAdventureChat(String string) {
        return MiniMessage.get().parse(string);
    }

    public static BaseComponent[] getColoredChat(String string) {
        if (string.isEmpty()) {
            return new BaseComponent[0];
        }
        return ComponentSerializer.parse((String)DisguiseUtilities.serialize(DisguiseUtilities.getAdventureChat(string)));
    }

    public static void sendProtocolLibUpdateMessage(CommandSender commandSender, String string, String string2) {
        commandSender.sendMessage(org.bukkit.ChatColor.RED + "Please ask the server owner to update ProtocolLib! You are running " + string + " but the minimum version you should be on is " + string2 + "!");
        commandSender.sendMessage(org.bukkit.ChatColor.RED + "https://ci.dmulloy2.net/job/ProtocolLib/lastSuccessfulBuild/artifact/target/ProtocolLib.jar");
        commandSender.sendMessage(org.bukkit.ChatColor.RED + "Or! Use " + org.bukkit.ChatColor.DARK_RED + "/ld updatepl" + org.bukkit.ChatColor.RED + " - To update to the latest development build");
        commandSender.sendMessage(org.bukkit.ChatColor.DARK_GREEN + "This message is `kindly` provided by Lib's Disguises on repeat to all players due to the sheer number of people who don't see it");
    }

    public static boolean isOlderThan(String string, String string2) {
        int[] nArray = DisguiseUtilities.getNumericVersion(string);
        int[] nArray2 = DisguiseUtilities.getNumericVersion(string2);
        for (int i = 0; i < Math.min(nArray.length, nArray2.length); ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return nArray[i] >= nArray2[i];
        }
        return false;
    }

    public static Logger getLogger() {
        return LibsDisguises.getInstance().getLogger();
    }

    private static void sendSelfPacket(Player player, PacketContainer packetContainer) {
        Disguise disguise = DisguiseAPI.getDisguise(player, (Entity)player);
        if (disguise == null) {
            return;
        }
        LibsPackets libsPackets = PacketsManager.getPacketsHandler().transformPacket(packetContainer, disguise, player, (Entity)player);
        try {
            if (libsPackets.isUnhandled()) {
                libsPackets.addPacket(packetContainer);
            }
            LibsPackets libsPackets2 = new LibsPackets(disguise);
            for (PacketContainer object : libsPackets.getPackets()) {
                object.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                libsPackets2.addPacket(object);
            }
            for (Map.Entry entry : libsPackets.getDelayedPacketsMap().entrySet()) {
                for (PacketContainer packetContainer2 : (ArrayList)entry.getValue()) {
                    if (packetContainer2.getType() != PacketType.Play.Server.PLAYER_INFO && packetContainer2.getType() != PacketType.Play.Server.ENTITY_DESTROY && ((Integer)packetContainer2.getIntegers().read(0)).intValue() == player.getEntityId()) {
                        packetContainer2.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                    }
                    libsPackets2.addDelayedPacket(packetContainer2, (Integer)entry.getKey());
                }
            }
            if (disguise.isPlayerDisguise()) {
                LibsDisguises.getInstance().getSkinHandler().handlePackets(player, (PlayerDisguise)disguise, libsPackets2);
            }
            for (PacketContainer packetContainer3 : libsPackets2.getPackets()) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer3, false);
            }
            libsPackets2.sendDelayed(player);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public static PacketContainer getTabPacket(PlayerDisguise playerDisguise, EnumWrappers.PlayerInfoAction playerInfoAction) {
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
        packetContainer.getPlayerInfoAction().write(0, (Object)playerInfoAction);
        packetContainer.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(playerDisguise.getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)playerDisguise.getName()))));
        return packetContainer;
    }

    public static void setupFakeDisguise(Disguise disguise) {
        Entity entity = disguise.getEntity();
        if (!(entity instanceof Player && DisguiseUtilities.getDisguises().containsKey(entity.getEntityId()) && DisguiseUtilities.getDisguises().get(entity.getEntityId()).contains(disguise))) {
            return;
        }
        Player player = (Player)entity;
        if (!((TargetedDisguise)disguise).canSee(player)) {
            return;
        }
        DisguiseUtilities.removeSelfDisguise(disguise);
        if (!disguise.isSelfDisguiseVisible() || !PacketsManager.isViewDisguisesListenerEnabled() || player.getVehicle() != null) {
            return;
        }
        selfDisguised.add(player.getUniqueId());
        DisguiseUtilities.sendSelfDisguise(player, (TargetedDisguise)disguise);
        if ((disguise.isHidingArmorFromSelf() || disguise.isHidingHeldItemFromSelf()) && PacketsManager.isInventoryListenerEnabled()) {
            player.updateInventory();
        }
    }

    public static WrappedDataWatcher.Serializer getSerializer(MetaIndex metaIndex) {
        if (metaIndex.getSerializer() != null) {
            return metaIndex.getSerializer();
        }
        if (metaIndex.getDefault() instanceof Optional) {
            for (Field field : MetaIndex.class.getFields()) {
                try {
                    if (field.get(null) != metaIndex) {
                        continue;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                Type type = field.getGenericType();
                Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                if (!(type2 instanceof ParameterizedType)) continue;
                Type type3 = ((ParameterizedType)type2).getActualTypeArguments()[0];
                return WrappedDataWatcher.Registry.get((Class)ReflectionManager.getNmsClass((Class)type3), (boolean)true);
            }
        } else {
            return WrappedDataWatcher.Registry.get((Class)ReflectionManager.getNmsClass(metaIndex.getDefault().getClass()));
        }
        Object y = metaIndex.getDefault();
        throw new IllegalArgumentException("Unable to find Serializer for " + y + (y instanceof Optional && ((Optional)y).isPresent() ? " (" + ((Optional)y).get().getClass().getName() + ")" : (y instanceof Optional || y == null ? "" : " " + y.getClass().getName())) + "! Are you running the latest version of ProtocolLib?");
    }

    public static String serialize(NbtBase nbtBase) {
        return DisguiseUtilities.serialize(0, nbtBase);
    }

    private static String serialize(int n, NbtBase nbtBase) {
        switch (nbtBase.getType()) {
            case TAG_COMPOUND: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("{");
                for (String string : ((NbtCompound)nbtBase).getKeys()) {
                    NbtBase nbtBase2 = ((NbtCompound)nbtBase).getValue(string);
                    String string2 = DisguiseUtilities.serialize(n + 1, nbtBase2);
                    if (n == 0 && string2.matches("0(\\.0)?")) continue;
                    if (stringBuilder.length() != 1) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(string).append(":").append(string2);
                }
                stringBuilder.append("}");
                return stringBuilder.toString();
            }
            case TAG_LIST: {
                Collection collection = ((NbtList)nbtBase).asCollection();
                return "[" + StringUtils.join((Object[])collection.stream().map(object -> DisguiseUtilities.serialize(n + 1, (NbtBase)object)).toArray(), (String)",") + "]";
            }
            case TAG_BYTE_ARRAY: 
            case TAG_INT_ARRAY: 
            case TAG_LONG_ARRAY: {
                Object[] objectArray = new String[Array.getLength(nbtBase.getValue())];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = Array.get(nbtBase.getValue(), i).toString();
                }
                String string = "";
                switch (nbtBase.getType()) {
                    case TAG_BYTE_ARRAY: {
                        string = "B;";
                        break;
                    }
                    case TAG_INT_ARRAY: {
                        string = "I;";
                        break;
                    }
                    case TAG_LONG_ARRAY: {
                        string = "L;";
                    }
                }
                return "[" + string + StringUtils.join((Object[])objectArray, (String)",") + "]";
            }
            case TAG_BYTE: 
            case TAG_INT: 
            case TAG_LONG: 
            case TAG_FLOAT: 
            case TAG_SHORT: 
            case TAG_DOUBLE: {
                return nbtBase.getValue().toString();
            }
            case TAG_STRING: {
                String string = (String)nbtBase.getValue();
                return "\"" + string.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
            }
            case TAG_END: {
                return "";
            }
        }
        throw new IllegalArgumentException();
    }

    public static WrappedDataWatcher createSanitizedDataWatcher(Player player, WrappedDataWatcher wrappedDataWatcher, FlagWatcher flagWatcher) {
        WrappedDataWatcher wrappedDataWatcher2 = new WrappedDataWatcher();
        try {
            List<WrappedWatchableObject> list = DisguiseConfig.isMetaPacketsEnabled() ? flagWatcher.convert(player, wrappedDataWatcher.getWatchableObjects()) : flagWatcher.getWatchableObjects();
            for (WrappedWatchableObject wrappedWatchableObject : list) {
                Object object;
                if (wrappedWatchableObject == null || (object = wrappedWatchableObject.getRawValue()) == null) continue;
                MetaIndex metaIndex = MetaIndex.getMetaIndex(flagWatcher, wrappedWatchableObject.getIndex());
                WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject = ReflectionManager.createDataWatcherObject(metaIndex, object);
                wrappedDataWatcher2.setObject(wrappedDataWatcherObject, object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return wrappedDataWatcher2;
    }

    public static byte getPitch(DisguiseType disguiseType, EntityType entityType, byte by) {
        return DisguiseUtilities.getPitch(disguiseType, DisguiseUtilities.getPitch(DisguiseType.getType(entityType), by));
    }

    public static byte getPitch(DisguiseType disguiseType, DisguiseType disguiseType2, byte by) {
        return DisguiseUtilities.getPitch(disguiseType, DisguiseUtilities.getPitch(disguiseType2, by));
    }

    public static byte getPitch(DisguiseType disguiseType, byte by) {
        if (disguiseType != DisguiseType.WITHER_SKULL && disguiseType.isMisc()) {
            return -by;
        }
        if (disguiseType == DisguiseType.PHANTOM) {
            return -by;
        }
        return by;
    }

    public static byte getYaw(DisguiseType disguiseType, EntityType entityType, byte by) {
        return DisguiseUtilities.getYaw(disguiseType, DisguiseUtilities.getYaw(DisguiseType.getType(entityType), by));
    }

    public static byte getYaw(DisguiseType disguiseType, DisguiseType disguiseType2, byte by) {
        return DisguiseUtilities.getYaw(disguiseType, DisguiseUtilities.getYaw(disguiseType2, by));
    }

    public static byte getYaw(DisguiseType disguiseType, byte by) {
        switch (disguiseType) {
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                return (byte)(by + 64);
            }
            case BOAT: 
            case ENDER_DRAGON: 
            case WITHER_SKULL: {
                return (byte)(by - 128);
            }
            case ARROW: 
            case SPECTRAL_ARROW: {
                return -by;
            }
            case PAINTING: 
            case ITEM_FRAME: {
                return (byte)(-(by + 128));
            }
        }
        if (disguiseType.isMisc() && disguiseType != DisguiseType.ARMOR_STAND) {
            return (byte)(by - 64);
        }
        return by;
    }

    public static ArrayList<PacketContainer> getNamePackets(Disguise disguise, String[] stringArray) {
        ArrayList<PacketContainer> arrayList = new ArrayList<PacketContainer>();
        Object[] objectArray = disguise instanceof PlayerDisguise && !((PlayerDisguise)disguise).isNameVisible() ? new String[]{} : DisguiseUtilities.reverse(disguise.getMultiName());
        int[] nArray = disguise.getArmorstandIds();
        int[] nArray2 = new int[]{};
        if (!LibsPremium.isPremium().booleanValue()) {
            if (stringArray.length > 1) {
                stringArray = new String[]{StringUtils.join((Object[])stringArray, (String)"\\n")};
            }
            if (objectArray.length > 1) {
                objectArray = new String[]{StringUtils.join((Object[])objectArray, (String)"\\n")};
                if ((!disguise.isPlayerDisguise() || ((PlayerDisguise)disguise).isNameVisible()) && disguise.getMultiName().length > 1) {
                    DisguiseUtilities.getLogger().info("Multiline names is a premium feature, sorry!");
                }
            }
        }
        if (stringArray.length > objectArray.length) {
            nArray2 = Arrays.copyOfRange(nArray, objectArray.length, stringArray.length);
        }
        double d = disguise.getHeight() + (double)disguise.getWatcher().getYModifier();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject;
            Object object2;
            PacketContainer packetContainer;
            if (i < stringArray.length) {
                if (((String)objectArray[i]).equals(stringArray[i])) continue;
                packetContainer = new WrappedDataWatcher();
                object2 = NmsVersion.v1_13.isSupported() ? Optional.of(WrappedChatComponent.fromJson((String)ComponentSerializer.toString((BaseComponent[])DisguiseUtilities.getColoredChat((String)objectArray[i])))) : org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)objectArray[i]);
                wrappedDataWatcherObject = ReflectionManager.createDataWatcherObject(NmsVersion.v1_13.isSupported() ? MetaIndex.ENTITY_CUSTOM_NAME : MetaIndex.ENTITY_CUSTOM_NAME_OLD, object2);
                packetContainer.setObject(wrappedDataWatcherObject, ReflectionManager.convertInvalidMeta(object2));
                object = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{0, packetContainer, true}).createPacket(new Object[]{nArray[i], packetContainer, true});
                arrayList.add((PacketContainer)object);
                continue;
            }
            if (((String)objectArray[i]).isEmpty()) {
                nArray2 = Arrays.copyOf(nArray2, nArray2.length + 1);
                nArray2[nArray2.length - 1] = nArray[i];
                continue;
            }
            packetContainer = new PacketContainer(PacketType.Play.Server.SPAWN_ENTITY_LIVING);
            packetContainer.getIntegers().write(0, (Object)nArray[i]);
            packetContainer.getIntegers().write(1, (Object)DisguiseType.ARMOR_STAND.getTypeId());
            packetContainer.getUUIDs().write(0, (Object)UUID.randomUUID());
            object2 = disguise.getEntity().getLocation();
            packetContainer.getDoubles().write(0, (Object)object2.getX());
            packetContainer.getDoubles().write(1, (Object)(object2.getY() + d + 0.28 * (double)i));
            packetContainer.getDoubles().write(2, (Object)object2.getZ());
            arrayList.add(packetContainer);
            wrappedDataWatcherObject = new WrappedDataWatcher();
            for (MetaIndex metaIndex : MetaIndex.getMetaIndexes(ArmorStandWatcher.class)) {
                Object object3 = metaIndex.getDefault();
                if (metaIndex == MetaIndex.ENTITY_META) {
                    object3 = (byte)32;
                } else if (metaIndex == MetaIndex.ARMORSTAND_META) {
                    object3 = (byte)19;
                } else if (metaIndex == MetaIndex.ENTITY_CUSTOM_NAME) {
                    object3 = Optional.of(WrappedChatComponent.fromJson((String)ComponentSerializer.toString((BaseComponent[])DisguiseUtilities.getColoredChat((String)objectArray[i]))));
                } else if (metaIndex == MetaIndex.ENTITY_CUSTOM_NAME_OLD) {
                    object3 = org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)objectArray[i]);
                } else if (metaIndex == MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE) {
                    object3 = true;
                }
                WrappedDataWatcher.WrappedDataWatcherObject wrappedDataWatcherObject2 = ReflectionManager.createDataWatcherObject(metaIndex, object3);
                wrappedDataWatcherObject.setObject(wrappedDataWatcherObject2, ReflectionManager.convertInvalidMeta(object3));
            }
            if (NmsVersion.v1_15.isSupported()) {
                object = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_METADATA, new Object[]{nArray[i], wrappedDataWatcherObject, true}).createPacket(new Object[]{nArray[i], wrappedDataWatcherObject, true});
                arrayList.add((PacketContainer)object);
                continue;
            }
            packetContainer.getDataWatcherModifier().write(0, (Object)wrappedDataWatcherObject);
        }
        if (nArray2.length > 0) {
            arrayList.add(DisguiseUtilities.getDestroyPacket(nArray2));
        }
        return arrayList;
    }

    public static Disguise getDisguise(Player player, int n) {
        Object object;
        if (n == DisguiseAPI.getSelfDisguiseId()) {
            n = player.getEntityId();
        }
        if (DisguiseUtilities.getFutureDisguises().containsKey(n)) {
            object = player.getWorld().getEntities().iterator();
            while (object.hasNext()) {
                Entity entity = (Entity)object.next();
                if (entity.getEntityId() != n) continue;
                DisguiseUtilities.onFutureDisguise(entity);
            }
        }
        if ((object = DisguiseUtilities.getDisguises(n)) == null) {
            return null;
        }
        for (Object object2 : object) {
            if (!((Disguise)object2).isDisguiseInUse() || !((TargetedDisguise)object2).canSee(player)) continue;
            return object2;
        }
        return null;
    }

    public static Entity getEntity(World world, int n) {
        for (Entity entity : world.getEntities()) {
            if (entity.getEntityId() != n) continue;
            return entity;
        }
        return null;
    }

    public static double getYModifier(Disguise disguise) {
        Entity entity = disguise.getEntity();
        double d = 0.0;
        if (disguise.getType() != DisguiseType.PLAYER && entity.getType() == EntityType.DROPPED_ITEM) {
            d -= 0.13;
        }
        switch (disguise.getType()) {
            case ENDER_CRYSTAL: {
                return d + 1.0;
            }
            case BAT: {
                if (entity instanceof LivingEntity) {
                    return d + ((LivingEntity)entity).getEyeHeight();
                }
                return d;
            }
            case MINECART: 
            case MINECART_CHEST: 
            case MINECART_COMMAND: 
            case MINECART_FURNACE: 
            case MINECART_HOPPER: 
            case MINECART_MOB_SPAWNER: 
            case MINECART_TNT: {
                switch (entity.getType()) {
                    case MINECART: 
                    case MINECART_CHEST: 
                    case MINECART_FURNACE: 
                    case MINECART_HOPPER: 
                    case MINECART_MOB_SPAWNER: 
                    case MINECART_TNT: {
                        return d;
                    }
                }
                return d + 0.4;
            }
            case BOAT: 
            case WITHER_SKULL: 
            case ARROW: 
            case SPECTRAL_ARROW: 
            case PAINTING: 
            case EGG: 
            case ENDER_PEARL: 
            case ENDER_SIGNAL: 
            case FIREWORK: 
            case SMALL_FIREBALL: 
            case SNOWBALL: 
            case SPLASH_POTION: 
            case THROWN_EXP_BOTTLE: {
                return d + 0.7;
            }
            case DROPPED_ITEM: {
                return d + 0.13;
            }
        }
        return d;
    }

    public static Random getRandom() {
        return random;
    }

    public static Map<Integer, Set<TargetedDisguise>> getDisguises() {
        return disguises;
    }

    public static HashMap<Integer, HashSet<TargetedDisguise>> getFutureDisguises() {
        return futureDisguises;
    }

    public static HashSet<UUID> getSelfDisguised() {
        return selfDisguised;
    }

    public static Gson getGson() {
        return gson;
    }

    public static boolean isPluginsUsed() {
        return pluginsUsed;
    }

    public static boolean isCommandsUsed() {
        return commandsUsed;
    }

    public static boolean isGrabHeadCommandUsed() {
        return grabHeadCommandUsed;
    }

    public static boolean isRunningPaper() {
        return runningPaper;
    }

    public static MineSkinAPI getMineSkinAPI() {
        return mineSkinAPI;
    }

    public static boolean isInvalidFile() {
        return invalidFile;
    }

    public static char[] getAlphabet() {
        return alphabet;
    }

    public static ConcurrentHashMap<String, DScoreTeam> getTeams() {
        return teams;
    }

    static {
        disguiseLoading = new HashMap();
        mineSkinAPI = new MineSkinAPI();
        alphabet = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();
        urlMatcher = Pattern.compile("^(?:(https?)://)?([-\\w_.]{2,}\\.[a-z]{2,4})(/\\S*)?$");
        viewSelf = new ArrayList<UUID>();
        viewBar = new ArrayList<UUID>();
        teams = new ConcurrentHashMap();
        warnedSkin = new HashSet();
        Matcher matcher = Pattern.compile("(?:1\\.)?(\\d+)").matcher(System.getProperty("java.version"));
        if (!matcher.find()) {
            java16 = true;
        } else {
            int n = 16;
            try {
                n = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            java16 = n >= 16;
        }
    }

    private static class UsersData {
        String[] users;
        long fetched;

        private UsersData() {
        }
    }

    public static class DScoreTeam {
        private String teamName;
        private String[] split;
        private PlayerDisguise disguise;

        public DScoreTeam(PlayerDisguise playerDisguise, String[] stringArray) {
            this.disguise = playerDisguise;
            this.split = stringArray;
        }

        public String getPlayer() {
            return this.split[1];
        }

        public synchronized String getPrefix() {
            return this.split[0];
        }

        public synchronized String getSuffix() {
            return this.split[2];
        }

        public synchronized void setSplit(String[] stringArray) {
            this.split = stringArray;
        }

        public void handleTeam(Scoreboard scoreboard, boolean bl) {
            bl = !DisguiseConfig.isArmorstandsName() && bl;
            Team team = scoreboard.getTeam(this.getTeamName());
            if (team == null) {
                team = scoreboard.registerNewTeam(this.getTeamName());
                team.addEntry(this.getPlayer());
                if (!bl) {
                    team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
                }
            } else if (team.getOption(Team.Option.NAME_TAG_VISIBILITY) != (bl ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER)) {
                team.setOption(Team.Option.NAME_TAG_VISIBILITY, bl ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
            }
            if (DisguiseConfig.isModifyCollisions() && team.getOption(Team.Option.COLLISION_RULE) != Team.OptionStatus.NEVER) {
                team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
            }
            if (this.disguise.getWatcher().getGlowColor() != null && this.disguise.getWatcher().getGlowColor() != team.getColor()) {
                team.setColor(this.disguise.getWatcher().getGlowColor());
            }
            String string = this.getPrefix();
            String string2 = this.getSuffix();
            if (!string.equals(team.getPrefix())) {
                team.setPrefix(NmsVersion.v1_13.isSupported() ? "Colorize" : string);
            }
            if (!string2.equals(team.getSuffix())) {
                team.setSuffix(NmsVersion.v1_13.isSupported() ? "Colorize" : string2);
            }
        }

        public void setTeamName(String string) {
            this.teamName = string;
        }

        public void setDisguise(PlayerDisguise playerDisguise) {
            this.disguise = playerDisguise;
        }

        public String getTeamName() {
            return this.teamName;
        }
    }
}

