/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Random;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.VillagerData;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.entity.Villager;

public class ZombieVillagerWatcher
extends ZombieWatcher {
    public ZombieVillagerWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setProfession(Villager.Profession.values()[new Random().nextInt(Villager.Profession.values().length)]);
        }
    }

    public boolean isShaking() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_SHAKING);
    }

    public void setShaking(boolean bl) {
        this.setData(MetaIndex.ZOMBIE_VILLAGER_SHAKING, bl);
        this.sendData(MetaIndex.ZOMBIE_VILLAGER_SHAKING);
    }

    public boolean isVillager() {
        if (NmsVersion.v1_14.isSupported()) {
            return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION).getProfession() != Villager.Profession.NONE;
        }
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD) != 0;
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public VillagerData getVillagerData() {
        return this.getData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setVillagerData(VillagerData villagerData) {
        this.setData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION, villagerData);
        this.sendData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION);
    }

    public Villager.Profession getProfession() {
        return this.getVillagerData().getProfession();
    }

    @RandomDefaultValue
    public void setProfession(Villager.Profession profession) {
        if (NmsVersion.v1_14.isSupported()) {
            this.setVillagerData(new VillagerData(this.getType(), profession, this.getLevel()));
        } else {
            this.setData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD, profession.ordinal() - 1);
            this.sendData(MetaIndex.ZOMBIE_VILLAGER_PROFESSION_OLD);
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getType() {
        return this.getVillagerData().getType();
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setType(Villager.Type type) {
        this.setVillagerData(new VillagerData(type, this.getProfession(), this.getLevel()));
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public int getLevel() {
        return this.getVillagerData().getLevel();
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setLevel(int n) {
        this.setVillagerData(new VillagerData(this.getType(), this.getProfession(), this.getLevel()));
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public Villager.Type getBiome() {
        return this.getType();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setBiome(Villager.Type type) {
        this.setType(type);
    }
}

