/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.HashMap;
import java.util.Map;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.FishWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.DyeColor;
import org.bukkit.entity.TropicalFish;

public class TropicalFishWatcher
extends FishWatcher {
    public TropicalFishWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setPattern(TropicalFish.Pattern.values()[RandomUtils.nextInt((int)TropicalFish.Pattern.values().length)]);
            this.setBodyColor(DyeColor.values()[RandomUtils.nextInt((int)DyeColor.values().length)]);
            this.setPatternColor(DyeColor.values()[RandomUtils.nextInt((int)DyeColor.values().length)]);
        }
    }

    public DyeColor getPatternColor() {
        return DyeColor.getByWoolData((byte)((byte)(this.getVariant() >> 24 & 0xFF)));
    }

    @RandomDefaultValue
    public void setPatternColor(DyeColor dyeColor) {
        this.setVariant(this.getData(dyeColor, this.getBodyColor(), this.getPattern()));
    }

    private int getData(DyeColor dyeColor, DyeColor dyeColor2, TropicalFish.Pattern pattern) {
        return dyeColor.getWoolData() << 24 | dyeColor2.getWoolData() << 16 | CraftPattern.values()[pattern.ordinal()].getDataValue();
    }

    public DyeColor getBodyColor() {
        return DyeColor.getByWoolData((byte)((byte)(this.getVariant() >> 16 & 0xFF)));
    }

    @RandomDefaultValue
    public void setBodyColor(DyeColor dyeColor) {
        this.setVariant(this.getData(this.getPatternColor(), dyeColor, this.getPattern()));
    }

    public TropicalFish.Pattern getPattern() {
        return CraftPattern.fromData(this.getVariant() & 0xFFFF);
    }

    @RandomDefaultValue
    public void setPattern(TropicalFish.Pattern pattern) {
        this.setVariant(this.getData(this.getPatternColor(), this.getBodyColor(), pattern));
    }

    @Deprecated
    public int getVariant() {
        return this.getData(MetaIndex.TROPICAL_FISH_VARIANT);
    }

    @Deprecated
    public void setVariant(int n) {
        this.setData(MetaIndex.TROPICAL_FISH_VARIANT, n);
        this.sendData(MetaIndex.TROPICAL_FISH_VARIANT);
    }

    private static enum CraftPattern {
        KOB("KOB", 0, 0, false),
        SUNSTREAK("SUNSTREAK", 1, 1, false),
        SNOOPER("SNOOPER", 2, 2, false),
        DASHER("DASHER", 3, 3, false),
        BRINELY("BRINELY", 4, 4, false),
        SPOTTY("SPOTTY", 5, 5, false),
        FLOPPER("FLOPPER", 6, 0, true),
        STRIPEY("STRIPEY", 7, 1, true),
        GLITTER("GLITTER", 8, 2, true),
        BLOCKFISH("BLOCKFISH", 9, 3, true),
        BETTY("BETTY", 10, 4, true),
        CLAYFISH("CLAYFISH", 11, 5, true);

        private final int variant;
        private final boolean large;
        private static final Map<Integer, TropicalFish.Pattern> BY_DATA;

        static TropicalFish.Pattern fromData(int n) {
            return BY_DATA.get(n);
        }

        private CraftPattern(String string2, int n2, int n3, boolean bl) {
            this.variant = n3;
            this.large = bl;
        }

        public int getDataValue() {
            return this.variant << 8 | (this.large ? 1 : 0);
        }

        static {
            BY_DATA = new HashMap<Integer, TropicalFish.Pattern>();
            for (CraftPattern craftPattern : CraftPattern.values()) {
                BY_DATA.put(craftPattern.getDataValue(), TropicalFish.Pattern.values()[craftPattern.ordinal()]);
            }
        }
    }
}

