/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import java.util.Optional;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import org.bukkit.DyeColor;
import org.bukkit.block.BlockFace;

public class ShulkerWatcher
extends InsentientWatcher {
    public ShulkerWatcher(Disguise disguise) {
        super(disguise);
    }

    public BlockFace getFacingDirection() {
        return BlockFace.valueOf((String)this.getData(MetaIndex.SHULKER_FACING).name());
    }

    public void setFacingDirection(BlockFace blockFace) {
        this.setData(MetaIndex.SHULKER_FACING, EnumWrappers.Direction.valueOf((String)blockFace.name()));
        this.sendData(MetaIndex.SHULKER_FACING);
    }

    public BlockPosition getAttachmentPosition() {
        return this.getData(MetaIndex.SHULKER_ATTACHED).orElse(BlockPosition.ORIGIN);
    }

    public void setAttachmentPosition(BlockPosition blockPosition) {
        this.setData(MetaIndex.SHULKER_ATTACHED, Optional.of(blockPosition));
        this.sendData(MetaIndex.SHULKER_ATTACHED);
    }

    public int getShieldHeight() {
        return this.getData(MetaIndex.SHULKER_PEEKING).byteValue();
    }

    public void setShieldHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 127) {
            n = 127;
        }
        this.setData(MetaIndex.SHULKER_PEEKING, (byte)n);
        this.sendData(MetaIndex.SHULKER_PEEKING);
    }

    @Deprecated
    public void setColor(AnimalColor animalColor) {
        this.setColor(animalColor.getDyeColor());
    }

    public void setColor(DyeColor dyeColor) {
        if (dyeColor == this.getColor()) {
            return;
        }
        this.setData(MetaIndex.SHULKER_COLOR, dyeColor.getWoolData());
        this.sendData(MetaIndex.SHULKER_COLOR);
    }

    public DyeColor getColor() {
        if (!this.hasValue(MetaIndex.SHULKER_COLOR)) {
            return DyeColor.PURPLE;
        }
        return AnimalColor.getColorByWool(this.getData(MetaIndex.SHULKER_COLOR).byteValue()).getDyeColor();
    }
}

