/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import org.bukkit.entity.Parrot;
import org.bukkit.inventory.MainHand;

public class PlayerWatcher
extends LivingWatcher {
    private boolean alwaysShowInTab = DisguiseConfig.isShowDisguisedPlayersInTab();

    public PlayerWatcher(Disguise disguise) {
        super(disguise);
        this.setData(MetaIndex.PLAYER_SKIN, MetaIndex.PLAYER_SKIN.getDefault());
        this.setData(MetaIndex.PLAYER_HAND, (byte)1);
    }

    public boolean isDisplayedInTab() {
        return this.alwaysShowInTab;
    }

    public void setDisplayedInTab(boolean bl) {
        if (this.getDisguise().isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.alwaysShowInTab = bl;
    }

    public boolean isNameVisible() {
        return ((PlayerDisguise)this.getDisguise()).isNameVisible();
    }

    public void setNameVisible(boolean bl) {
        ((PlayerDisguise)this.getDisguise()).setNameVisible(bl);
    }

    @RandomDefaultValue
    public String getName() {
        return ((PlayerDisguise)this.getDisguise()).getName();
    }

    @RandomDefaultValue
    public void setName(String string) {
        ((PlayerDisguise)this.getDisguise()).setName(string);
    }

    @Override
    public PlayerWatcher clone(Disguise disguise) {
        PlayerWatcher playerWatcher = (PlayerWatcher)super.clone(disguise);
        playerWatcher.alwaysShowInTab = this.alwaysShowInTab;
        return playerWatcher;
    }

    public MainHand getMainHand() {
        return MainHand.values()[this.getData(MetaIndex.PLAYER_HAND)];
    }

    public void setMainHand(MainHand mainHand) {
        this.setData(MetaIndex.PLAYER_HAND, (byte)mainHand.ordinal());
        this.sendData(MetaIndex.PLAYER_HAND);
    }

    private boolean isSkinFlag(int n) {
        return (this.getData(MetaIndex.PLAYER_SKIN) & 1 << n) != 0;
    }

    public boolean isCapeEnabled() {
        return this.isSkinFlag(1);
    }

    public void setCapeEnabled(boolean bl) {
        this.setSkinFlags(1, bl);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isJacketEnabled() {
        return this.isSkinFlag(2);
    }

    public void setJacketEnabled(boolean bl) {
        this.setSkinFlags(2, bl);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isLeftSleeveEnabled() {
        return this.isSkinFlag(3);
    }

    public void setLeftSleeveEnabled(boolean bl) {
        this.setSkinFlags(3, bl);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isRightSleeveEnabled() {
        return this.isSkinFlag(4);
    }

    public void setRightSleeveEnabled(boolean bl) {
        this.setSkinFlags(4, bl);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isLeftPantsEnabled() {
        return this.isSkinFlag(5);
    }

    public void setLeftPantsEnabled(boolean bl) {
        this.setSkinFlags(5, bl);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isRightPantsEnabled() {
        return this.isSkinFlag(6);
    }

    public void setRightPantsEnabled(boolean bl) {
        this.setSkinFlags(6, bl);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public boolean isHatEnabled() {
        return this.isSkinFlag(7);
    }

    public void setHatEnabled(boolean bl) {
        this.setSkinFlags(7, bl);
        this.sendData(MetaIndex.PLAYER_SKIN);
    }

    public WrappedGameProfile getSkin() {
        return ((PlayerDisguise)this.getDisguise()).getGameProfile();
    }

    public void setSkin(String string) {
        ((PlayerDisguise)this.getDisguise()).setSkin(string);
    }

    @RandomDefaultValue
    public void setSkin(WrappedGameProfile wrappedGameProfile) {
        ((PlayerDisguise)this.getDisguise()).setSkin(wrappedGameProfile);
    }

    private void setSkinFlags(int n, boolean bl) {
        byte by = this.getData(MetaIndex.PLAYER_SKIN);
        if (bl) {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(by | 1 << n));
        } else {
            this.setData(MetaIndex.PLAYER_SKIN, (byte)(by & -2 << n));
        }
    }

    public Parrot.Variant getRightShoulderParrot() {
        NbtCompound nbtCompound = (NbtCompound)this.getData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY);
        return Parrot.Variant.values()[nbtCompound.getIntegerOrDefault("Variant")];
    }

    public void setRightShoulderParrot(Parrot.Variant variant) {
        NbtCompound nbtCompound = NbtFactory.ofCompound((String)"");
        if (variant != null) {
            nbtCompound.put("id", "minecraft:parrot");
            nbtCompound.put("Variant", variant.ordinal());
        }
        this.setData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY, nbtCompound);
        this.sendData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY);
    }

    public Parrot.Variant getLeftShoulderParrot() {
        NbtCompound nbtCompound = (NbtCompound)this.getData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY);
        return Parrot.Variant.values()[nbtCompound.getIntegerOrDefault("Variant")];
    }

    public void setLeftShoulderParrot(Parrot.Variant variant) {
        NbtCompound nbtCompound = NbtFactory.ofCompound((String)"");
        if (variant != null) {
            nbtCompound.put("id", "minecraft:parrot");
            nbtCompound.put("Variant", variant.ordinal());
        }
        this.setData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY, nbtCompound);
        this.sendData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY);
    }

    public boolean isRightShoulderHasParrot() {
        return ((NbtCompound)this.getData(MetaIndex.PLAYER_RIGHT_SHOULDER_ENTITY)).containsKey("id");
    }

    public void setRightShoulderHasParrot(boolean bl) {
        if (this.isRightShoulderHasParrot() == bl) {
            return;
        }
        if (bl) {
            this.setRightShoulderParrot(Parrot.Variant.RED);
        } else {
            this.setRightShoulderParrot(null);
        }
    }

    public boolean isLeftShoulderHasParrot() {
        return ((NbtCompound)this.getData(MetaIndex.PLAYER_LEFT_SHOULDER_ENTITY)).containsKey("id");
    }

    public void setLeftShoulderHasParrot(boolean bl) {
        if (this.isLeftShoulderHasParrot() == bl) {
            return;
        }
        if (bl) {
            this.setLeftShoulderParrot(Parrot.Variant.RED);
        } else {
            this.setLeftShoulderParrot(null);
        }
    }
}

