/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Random;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.entity.Panda;

@NmsAddedIn(value=NmsVersion.v1_14)
public class PandaWatcher
extends AgeableWatcher {
    public PandaWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setMainGene(Panda.Gene.values()[new Random().nextInt(Panda.Gene.values().length)]);
            this.setHiddenGene(Panda.Gene.values()[new Random().nextInt(Panda.Gene.values().length)]);
        }
    }

    public Panda.Gene getMainGene() {
        byte by = this.getData(MetaIndex.PANDA_MAIN_GENE);
        for (Panda.Gene gene : Panda.Gene.values()) {
            if (gene.ordinal() != by) continue;
            return gene;
        }
        return Panda.Gene.NORMAL;
    }

    @RandomDefaultValue
    public void setMainGene(Panda.Gene gene) {
        this.setData(MetaIndex.PANDA_MAIN_GENE, (byte)gene.ordinal());
        this.sendData(MetaIndex.PANDA_MAIN_GENE);
    }

    public Panda.Gene getHiddenGene() {
        byte by = this.getData(MetaIndex.PANDA_HIDDEN_GENE);
        for (Panda.Gene gene : Panda.Gene.values()) {
            if (gene.ordinal() != by) continue;
            return gene;
        }
        return Panda.Gene.NORMAL;
    }

    @RandomDefaultValue
    public void setHiddenGene(Panda.Gene gene) {
        this.setData(MetaIndex.PANDA_HIDDEN_GENE, (byte)gene.ordinal());
        this.sendData(MetaIndex.PANDA_HIDDEN_GENE);
    }

    public boolean isSneeze() {
        return this.getPandaFlag(2);
    }

    public void setSneeze(boolean bl) {
        this.setPandaFlag(2, bl);
    }

    public boolean isTumble() {
        return this.getPandaFlag(4);
    }

    public void setTumble(boolean bl) {
        this.setPandaFlag(4, bl);
    }

    public boolean isSitting() {
        return this.getPandaFlag(8);
    }

    public void setSitting(boolean bl) {
        this.setPandaFlag(8, bl);
    }

    @Override
    public boolean isUpsideDown() {
        return this.getPandaFlag(16);
    }

    @Override
    public void setUpsideDown(boolean bl) {
        this.setPandaFlag(16, bl);
    }

    public int getHeadShaking() {
        return this.getHeadShakingTicks();
    }

    public void setHeadShaking(int n) {
        this.setData(MetaIndex.PANDA_HEAD_SHAKING, n);
        this.sendData(MetaIndex.PANDA_HEAD_SHAKING);
    }

    @Deprecated
    public int getHeadShakingTicks() {
        return this.getData(MetaIndex.PANDA_HEAD_SHAKING);
    }

    private boolean getPandaFlag(int n) {
        return (this.getData(MetaIndex.PANDA_META) & n) != 0;
    }

    private void setPandaFlag(int n, boolean bl) {
        byte by = this.getData(MetaIndex.PANDA_META);
        by = bl ? (byte)(by | n) : (byte)(by & ~n);
        this.setData(MetaIndex.PANDA_META, by);
        this.sendData(MetaIndex.PANDA_META);
    }
}

