/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedAttribute;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class LivingWatcher
extends FlagWatcher {
    private double maxHealth;
    private boolean maxHealthSet;
    private HashSet<String> potionEffects = new HashSet();
    private boolean[] modifiedLivingAnimations = new boolean[3];

    public LivingWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public LivingWatcher clone(Disguise disguise) {
        LivingWatcher livingWatcher = (LivingWatcher)super.clone(disguise);
        livingWatcher.potionEffects = (HashSet)this.potionEffects.clone();
        livingWatcher.maxHealth = this.maxHealth;
        livingWatcher.maxHealthSet = this.maxHealthSet;
        livingWatcher.modifiedLivingAnimations = Arrays.copyOf(this.modifiedLivingAnimations, this.modifiedLivingAnimations.length);
        return livingWatcher;
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public BlockPosition getBedPosition() {
        return this.getData(MetaIndex.LIVING_BED_POSITION).orElse(null);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setBedPosition(BlockPosition blockPosition) {
        Optional<Object> optional = blockPosition != null ? Optional.of(blockPosition) : Optional.empty();
        this.setData(MetaIndex.LIVING_BED_POSITION, optional);
        this.sendData(MetaIndex.LIVING_BED_POSITION);
    }

    public float getHealth() {
        return this.getData(MetaIndex.LIVING_HEALTH).floatValue();
    }

    public void setHealth(float f) {
        this.setData(MetaIndex.LIVING_HEALTH, Float.valueOf(f));
        this.sendData(MetaIndex.LIVING_HEALTH);
    }

    private boolean getHandFlag(int n) {
        return (this.getData(MetaIndex.LIVING_META) & 1 << n) != 0;
    }

    private void setHandFlag(int n, boolean bl) {
        byte by = this.getData(MetaIndex.LIVING_META);
        this.modifiedLivingAnimations[n] = true;
        if (bl) {
            this.setData(MetaIndex.LIVING_META, (byte)(by | 1 << n));
        } else {
            this.setData(MetaIndex.LIVING_META, (byte)(by & ~(1 << n)));
        }
        this.sendData(MetaIndex.LIVING_META);
    }

    private boolean isMainHandUsed() {
        return !this.getHandFlag(1);
    }

    private void setHandInUse(boolean bl) {
        if (this.isMainHandUsed() == bl) {
            return;
        }
        this.setHandFlag(1, !bl);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isMainHandRaised() {
        return this.isMainHandUsed() && this.getHandFlag(0);
    }

    @Override
    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setMainHandRaised(boolean bl) {
        this.setHandInUse(true);
        this.setHandFlag(0, bl);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isOffhandRaised() {
        return !this.isMainHandUsed() && this.getHandFlag(0);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setOffhandRaised(boolean bl) {
        this.setHandInUse(false);
        this.setHandFlag(0, bl);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public boolean isSpinning() {
        return this.getHandFlag(2);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setSpinning(boolean bl) {
        this.setHandFlag(2, bl);
    }

    public double getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(double d) {
        this.maxHealth = d;
        this.maxHealthSet = true;
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.UPDATE_ATTRIBUTES);
            ArrayList<WrappedAttribute> arrayList = new ArrayList<WrappedAttribute>();
            WrappedAttribute.Builder builder = WrappedAttribute.newBuilder();
            builder.attributeKey(NmsVersion.v1_16.isSupported() ? "generic.max_health" : "generic.maxHealth");
            builder.baseValue(this.getMaxHealth());
            builder.packet(packetContainer);
            arrayList.add(builder.build());
            Entity entity = this.getDisguise().getEntity();
            packetContainer.getIntegers().write(0, (Object)entity.getEntityId());
            packetContainer.getAttributeCollectionModifier().write(0, arrayList);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                try {
                    if (player == this.getDisguise().getEntity()) {
                        PacketContainer packetContainer2 = packetContainer.shallowClone();
                        packetContainer2.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer2, false);
                        continue;
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, false);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }
    }

    public boolean isPotionParticlesAmbient() {
        return this.getData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    public void setPotionParticlesAmbient(boolean bl) {
        this.setData(MetaIndex.LIVING_POTION_AMBIENT, bl);
        this.sendData(MetaIndex.LIVING_POTION_AMBIENT);
    }

    public Color getParticlesColor() {
        int n = this.getData(MetaIndex.LIVING_POTIONS);
        return Color.fromRGB((int)n);
    }

    public void setParticlesColor(Color color) {
        this.potionEffects.clear();
        this.setData(MetaIndex.LIVING_POTIONS, color.asRGB());
        this.sendData(MetaIndex.LIVING_POTIONS);
    }

    private int getPotions() {
        if (this.potionEffects.isEmpty()) {
            return 0;
        }
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (String string : this.potionEffects) {
            Color color;
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)string);
            if (potionEffectType == null || (color = potionEffectType.getColor()) == null) continue;
            arrayList.add(color);
        }
        if (arrayList.isEmpty()) {
            return 0;
        }
        Color color = (Color)arrayList.remove(0);
        return color.mixColors(arrayList.toArray(new Color[0])).asRGB();
    }

    public boolean hasPotionEffect(PotionEffectType potionEffectType) {
        return this.potionEffects.contains(potionEffectType.getName());
    }

    public boolean isMaxHealthSet() {
        return this.maxHealthSet;
    }

    public PotionEffectType[] getPotionEffects() {
        PotionEffectType[] potionEffectTypeArray = new PotionEffectType[this.potionEffects.size()];
        int n = 0;
        Iterator<String> iterator = this.potionEffects.iterator();
        while (iterator.hasNext()) {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)iterator.next());
            potionEffectTypeArray[n++] = potionEffectType;
        }
        return potionEffectTypeArray;
    }

    public void addPotionEffect(PotionEffectType potionEffectType) {
        if (!this.hasPotionEffect(potionEffectType)) {
            this.potionEffects.add(potionEffectType.getName());
        }
        this.sendPotionEffects();
    }

    public void removePotionEffect(PotionEffectType potionEffectType) {
        if (this.hasPotionEffect(potionEffectType)) {
            this.potionEffects.remove(potionEffectType.getId());
        }
        this.sendPotionEffects();
    }

    private void sendPotionEffects() {
        this.setData(MetaIndex.LIVING_POTIONS, this.getPotions());
        this.sendData(MetaIndex.LIVING_POTIONS);
    }

    public int getArrowsSticking() {
        return this.getData(MetaIndex.LIVING_ARROWS);
    }

    public void setArrowsSticking(int n) {
        this.setData(MetaIndex.LIVING_ARROWS, Math.max(0, Math.min(127, n)));
        this.sendData(MetaIndex.LIVING_ARROWS);
    }

    @Override
    protected byte addEntityAnimations(MetaIndex metaIndex, byte by, byte by2) {
        if (metaIndex != MetaIndex.LIVING_META) {
            return super.addEntityAnimations(metaIndex, by, by2);
        }
        for (int i = 0; i < 3; ++i) {
            if ((by2 & 1 << i) == 0 || this.modifiedLivingAnimations[i]) continue;
            by = (byte)(by | 1 << i);
        }
        return by;
    }

    @Override
    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    public boolean isRightClicking() {
        return this.isMainHandRaised();
    }

    @Override
    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    public void setRightClicking(boolean bl) {
        this.setMainHandRaised(bl);
    }

    public boolean[] getModifiedLivingAnimations() {
        return this.modifiedLivingAnimations;
    }
}

