/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Random;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.entity.Fox;

@NmsAddedIn(value=NmsVersion.v1_14)
public class FoxWatcher
extends AgeableWatcher {
    public FoxWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setType(Fox.Type.values()[new Random().nextInt(Fox.Type.values().length)]);
        }
    }

    public boolean isSitting() {
        return this.getFoxFlag(1);
    }

    public void setSitting(boolean bl) {
        this.setFoxFlag(1, bl);
    }

    public boolean isCrouching() {
        return this.getFoxFlag(4);
    }

    public void setCrouching(boolean bl) {
        this.setFoxFlag(4, bl);
    }

    @Override
    public boolean isSleeping() {
        return this.getFoxFlag(32);
    }

    @Override
    public void setSleeping(boolean bl) {
        this.setFoxFlag(32, bl);
    }

    @RandomDefaultValue
    public Fox.Type getType() {
        return Fox.Type.values()[this.getData(MetaIndex.FOX_TYPE)];
    }

    public void setType(Fox.Type type) {
        this.setData(MetaIndex.FOX_TYPE, type.ordinal());
        this.sendData(MetaIndex.FOX_TYPE);
    }

    public boolean isHeadTilted() {
        return this.getFoxFlag(8);
    }

    public void setHeadTilted(boolean bl) {
        this.setFoxFlag(8, bl);
    }

    public boolean isSpringing() {
        return this.getFoxFlag(16);
    }

    public void setSpringing(boolean bl) {
        this.setFoxFlag(16, bl);
    }

    public boolean isTipToeing() {
        return this.getFoxFlag(64);
    }

    public void setTipToeing(boolean bl) {
        this.setFoxFlag(64, bl);
    }

    public boolean isAngry() {
        return this.getFoxFlag(128);
    }

    public void setAngry(boolean bl) {
        this.setFoxFlag(128, bl);
    }

    private boolean getFoxFlag(int n) {
        return (this.getData(MetaIndex.FOX_META) & n) != 0;
    }

    private void setFoxFlag(int n, boolean bl) {
        byte by = this.getData(MetaIndex.FOX_META);
        by = bl ? (byte)(by | n) : (byte)(by & ~n);
        this.setData(MetaIndex.FOX_META, by);
        this.sendData(MetaIndex.FOX_META);
    }
}

