/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.OptionalInt;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class FireworkWatcher
extends FlagWatcher {
    public FireworkWatcher(Disguise disguise) {
        super(disguise);
    }

    public ItemStack getFirework() {
        if (this.getData(MetaIndex.FIREWORK_ITEM) == null) {
            return new ItemStack(Material.AIR);
        }
        return this.getData(MetaIndex.FIREWORK_ITEM);
    }

    public void setFirework(ItemStack itemStack) {
        if (itemStack == null) {
            itemStack = new ItemStack(Material.AIR);
        }
        itemStack = itemStack.clone();
        itemStack.setAmount(1);
        this.setData(MetaIndex.FIREWORK_ITEM, itemStack);
        this.sendData(MetaIndex.FIREWORK_ITEM);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public boolean isShotAtAngle() {
        return this.getData(MetaIndex.FIREWORK_SHOT_AT_ANGLE);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setShotAtAngle(boolean bl) {
        this.setData(MetaIndex.FIREWORK_SHOT_AT_ANGLE, bl);
        this.sendData(MetaIndex.FIREWORK_SHOT_AT_ANGLE);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public OptionalInt getAttachedEntityOpt() {
        return this.getData(MetaIndex.FIREWORK_ATTACHED_ENTITY);
    }

    public int getAttachedEntity() {
        return this.getData(MetaIndex.FIREWORK_ATTACHED_ENTITY).orElse(0);
    }

    public void setAttachedEntity(int n) {
        this.setAttachedEntity(n == 0 ? OptionalInt.empty() : OptionalInt.of(n));
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setAttachedEntity(OptionalInt optionalInt) {
        if (NmsVersion.v1_14.isSupported()) {
            this.setData(MetaIndex.FIREWORK_ATTACHED_ENTITY, optionalInt);
            this.sendData(MetaIndex.FIREWORK_ATTACHED_ENTITY);
        } else {
            this.setData(MetaIndex.FIREWORK_ATTACHED_ENTITY_OLD, optionalInt.orElse(0));
            this.sendData(MetaIndex.FIREWORK_ATTACHED_ENTITY_OLD);
        }
    }
}

