/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import java.lang.reflect.InvocationTargetException;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FallingBlockWatcher
extends FlagWatcher {
    private int blockCombinedId = 1;
    private boolean gridLocked;

    public FallingBlockWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public FallingBlockWatcher clone(Disguise disguise) {
        FallingBlockWatcher fallingBlockWatcher = (FallingBlockWatcher)super.clone(disguise);
        if (NmsVersion.v1_13.isSupported()) {
            fallingBlockWatcher.setBlockData(this.getBlockData().clone());
        } else {
            fallingBlockWatcher.setBlock(this.getBlock().clone());
        }
        return fallingBlockWatcher;
    }

    public boolean isGridLocked() {
        return this.gridLocked;
    }

    public void setGridLocked(boolean bl) {
        if (this.isGridLocked() == bl) {
            return;
        }
        this.gridLocked = bl;
        if (this.getDisguise().isDisguiseInUse() && this.getDisguise().getEntity() != null) {
            Object object;
            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.REL_ENTITY_MOVE);
            packetContainer.getModifier().write(0, (Object)this.getDisguise().getEntity().getEntityId());
            Location location = this.getDisguise().getEntity().getLocation();
            if (NmsVersion.v1_14.isSupported()) {
                object = packetContainer.getShorts();
                object.write(0, (Object)this.conRel(location.getX(), (double)location.getBlockX() + 0.5));
                object.write(1, (Object)this.conRel(location.getY(), (double)location.getBlockY() + (location.getY() % 1.0 >= 0.85 ? 1.0 : (location.getY() % 1.0 >= 0.35 ? 0.5 : 0.0))));
                object.write(2, (Object)this.conRel(location.getZ(), (double)location.getBlockZ() + 0.5));
            } else {
                object = packetContainer.getIntegers();
                object.write(0, (Object)this.conRel(location.getX(), (double)location.getBlockX() + 0.5));
                object.write(1, (Object)this.conRel(location.getY(), (double)location.getBlockY() + (location.getY() % 1.0 >= 0.85 ? 1.0 : (location.getY() % 1.0 >= 0.35 ? 0.5 : 0.0))));
                object.write(2, (Object)this.conRel(location.getZ(), (double)location.getBlockZ() + 0.5));
            }
            try {
                for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                    if (player == this.getDisguise().getEntity()) {
                        PacketContainer packetContainer2 = packetContainer.shallowClone();
                        packetContainer2.getModifier().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer2, this.isGridLocked());
                        continue;
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer, this.isGridLocked());
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    private short conRel(double d, double d2) {
        return (short)((d - d2) * 4096.0 * (double)(this.isGridLocked() ? -1 : 1));
    }

    public ItemStack getBlock() {
        return ReflectionManager.getItemStackByCombinedId(this.getBlockCombinedId());
    }

    public void setBlock(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == null || itemStack.getType() == Material.AIR || !itemStack.getType().isBlock()) {
            itemStack = new ItemStack(Material.STONE);
        }
        this.blockCombinedId = ReflectionManager.getCombinedIdByItemStack(itemStack);
        if (!this.getDisguise().isCustomDisguiseName()) {
            this.getDisguise().setDisguiseName(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("Block") + " " + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(ReflectionManager.toReadable(itemStack.getType().name(), " ")));
        }
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            DisguiseUtilities.refreshTrackers(this.getDisguise());
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public BlockData getBlockData() {
        return ReflectionManager.getBlockDataByCombinedId(this.getBlockCombinedId());
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setBlockData(BlockData blockData) {
        if (blockData == null || blockData.getMaterial() == Material.AIR && blockData.getMaterial().isBlock()) {
            this.setBlock(null);
            return;
        }
        this.blockCombinedId = ReflectionManager.getCombinedIdByBlockData(blockData);
        if (!this.getDisguise().isCustomDisguiseName()) {
            this.getDisguise().setDisguiseName(TranslateType.DISGUISE_OPTIONS_PARAMETERS.get("Block") + " " + TranslateType.DISGUISE_OPTIONS_PARAMETERS.get(ReflectionManager.toReadable(blockData.getMaterial().name(), " ")));
        }
        if (DisguiseAPI.isDisguiseInUse(this.getDisguise()) && this.getDisguise().getWatcher() == this) {
            DisguiseUtilities.refreshTrackers(this.getDisguise());
        }
    }

    public int getBlockCombinedId() {
        if (this.blockCombinedId < 1) {
            this.blockCombinedId = 1;
        }
        return this.blockCombinedId;
    }
}

