/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.WrappedBlockData;
import java.util.Optional;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.InsentientWatcher;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class EndermanWatcher
extends InsentientWatcher {
    public EndermanWatcher(Disguise disguise) {
        super(disguise);
    }

    @Override
    public ItemStack getItemInMainHand() {
        Optional<WrappedBlockData> optional = this.getData(MetaIndex.ENDERMAN_ITEM);
        if (optional.isPresent()) {
            WrappedBlockData wrappedBlockData = optional.get();
            return new ItemStack(wrappedBlockData.getType(), 1);
        }
        return null;
    }

    @Override
    public void setItemInMainHand(ItemStack itemStack) {
        this.setItemInMainHand(itemStack.getType());
    }

    public void setItemInMainHand(Material material) {
        if (!material.isBlock()) {
            return;
        }
        Optional<Object> optional = material == null ? Optional.empty() : Optional.of(WrappedBlockData.createData((Material)material));
        this.setData(MetaIndex.ENDERMAN_ITEM, optional);
        this.sendData(MetaIndex.ENDERMAN_ITEM);
    }

    @Deprecated
    public void setItemInMainHand(Material material, int n) {
        this.setItemInMainHand(material);
    }

    public boolean isAggressive() {
        return this.getData(MetaIndex.ENDERMAN_AGRESSIVE);
    }

    public void setAggressive(boolean bl) {
        this.setData(MetaIndex.ENDERMAN_AGRESSIVE, bl);
        this.sendData(MetaIndex.ENDERMAN_AGRESSIVE);
    }
}

