/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Random;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.AnimalColor;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.TameableWatcher;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.bukkit.DyeColor;
import org.bukkit.entity.Cat;

@NmsAddedIn(value=NmsVersion.v1_14)
public class CatWatcher
extends TameableWatcher {
    public CatWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setType(Cat.Type.values()[new Random().nextInt(Cat.Type.values().length)]);
        }
    }

    public Cat.Type getType() {
        return Cat.Type.values()[this.getData(MetaIndex.CAT_TYPE)];
    }

    @RandomDefaultValue
    public void setType(Cat.Type type) {
        this.setData(MetaIndex.CAT_TYPE, type.ordinal());
        this.sendData(MetaIndex.CAT_TYPE);
    }

    public DyeColor getCollarColor() {
        return AnimalColor.getColorByWool(this.getData(MetaIndex.CAT_COLLAR)).getDyeColor();
    }

    @Deprecated
    public void setCollarColor(AnimalColor animalColor) {
        this.setCollarColor(animalColor.getDyeColor());
    }

    public void setCollarColor(DyeColor dyeColor) {
        if (!this.isTamed()) {
            this.setTamed(true);
        }
        if (dyeColor == this.getCollarColor()) {
            return;
        }
        this.setData(MetaIndex.CAT_COLLAR, Integer.valueOf(dyeColor.getWoolData()));
        this.sendData(MetaIndex.CAT_COLLAR);
    }

    public boolean isLyingDown() {
        return this.getData(MetaIndex.CAT_LYING_DOWN);
    }

    public void setLyingDown(boolean bl) {
        this.setData(MetaIndex.CAT_LYING_DOWN, bl);
        this.sendData(MetaIndex.CAT_LYING_DOWN);
    }

    public boolean isLookingUp() {
        return this.getData(MetaIndex.CAT_LOOKING_UP);
    }

    public void setLookingUp(boolean bl) {
        this.setData(MetaIndex.CAT_LOOKING_UP, bl);
        this.sendData(MetaIndex.CAT_LOOKING_UP);
    }
}

