/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.Vector3F;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import org.bukkit.util.EulerAngle;

public class ArmorStandWatcher
extends LivingWatcher {
    public ArmorStandWatcher(Disguise disguise) {
        super(disguise);
    }

    private boolean getArmorStandFlag(int n) {
        return (this.getData(MetaIndex.ARMORSTAND_META) & n) != 0;
    }

    public EulerAngle getBody() {
        return this.getPose(MetaIndex.ARMORSTAND_BODY);
    }

    public EulerAngle getHead() {
        return this.getPose(MetaIndex.ARMORSTAND_HEAD);
    }

    public EulerAngle getLeftArm() {
        return this.getPose(MetaIndex.ARMORSTAND_LEFT_ARM);
    }

    public EulerAngle getLeftLeg() {
        return this.getPose(MetaIndex.ARMORSTAND_LEFT_LEG);
    }

    private EulerAngle getPose(MetaIndex<Vector3F> metaIndex) {
        if (!this.hasValue(metaIndex)) {
            return new EulerAngle(0.0, 0.0, 0.0);
        }
        Vector3F vector3F = this.getData(metaIndex);
        return new EulerAngle((double)vector3F.getX(), (double)vector3F.getY(), (double)vector3F.getZ());
    }

    public EulerAngle getRightArm() {
        return this.getPose(MetaIndex.ARMORSTAND_RIGHT_ARM);
    }

    public EulerAngle getRightLeg() {
        return this.getPose(MetaIndex.ARMORSTAND_RIGHT_LEG);
    }

    public boolean isMarker() {
        return this.getArmorStandFlag(16);
    }

    public boolean isNoBasePlate() {
        return this.getArmorStandFlag(8);
    }

    @Override
    public boolean isNoGravity() {
        return this.getArmorStandFlag(2);
    }

    public boolean isShowArms() {
        return this.getArmorStandFlag(4);
    }

    public boolean isSmall() {
        return this.getArmorStandFlag(1);
    }

    private void setArmorStandFlag(int n, boolean bl) {
        byte by = this.getData(MetaIndex.ARMORSTAND_META);
        by = bl ? (byte)(by | n) : (byte)(by & n);
        this.setData(MetaIndex.ARMORSTAND_META, by);
        this.sendData(MetaIndex.ARMORSTAND_META);
    }

    public void setBody(EulerAngle eulerAngle) {
        this.setPose(MetaIndex.ARMORSTAND_BODY, eulerAngle);
    }

    public void setHead(EulerAngle eulerAngle) {
        this.setPose(MetaIndex.ARMORSTAND_HEAD, eulerAngle);
    }

    public void setLeftArm(EulerAngle eulerAngle) {
        this.setPose(MetaIndex.ARMORSTAND_LEFT_ARM, eulerAngle);
    }

    public void setLeftLeg(EulerAngle eulerAngle) {
        this.setPose(MetaIndex.ARMORSTAND_LEFT_LEG, eulerAngle);
    }

    public void setMarker(boolean bl) {
        this.setArmorStandFlag(16, bl);
    }

    public void setNoBasePlate(boolean bl) {
        this.setArmorStandFlag(8, bl);
    }

    @Override
    public void setNoGravity(boolean bl) {
        this.setArmorStandFlag(2, bl);
    }

    private void setPose(MetaIndex<Vector3F> metaIndex, EulerAngle eulerAngle) {
        this.setData(metaIndex, new Vector3F((float)eulerAngle.getX(), (float)eulerAngle.getY(), (float)eulerAngle.getZ()));
        this.sendData(metaIndex);
    }

    public void setRightArm(EulerAngle eulerAngle) {
        this.setPose(MetaIndex.ARMORSTAND_RIGHT_ARM, eulerAngle);
    }

    public void setRightLeg(EulerAngle eulerAngle) {
        this.setPose(MetaIndex.ARMORSTAND_RIGHT_LEG, eulerAngle);
    }

    public void setShowArms(boolean bl) {
        this.setArmorStandFlag(4, bl);
    }

    public void setSmall(boolean bl) {
        this.setArmorStandFlag(1, bl);
    }
}

