/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import com.comphenix.protocol.wrappers.WrappedParticle;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import org.apache.commons.lang.math.RandomUtils;
import org.bukkit.Color;
import org.bukkit.Particle;

public class AreaEffectCloudWatcher
extends FlagWatcher {
    public AreaEffectCloudWatcher(Disguise disguise) {
        super(disguise);
        if (DisguiseConfig.isRandomDisguises()) {
            this.setColor(Color.fromRGB((int)RandomUtils.nextInt((int)256), (int)RandomUtils.nextInt((int)256), (int)RandomUtils.nextInt((int)256)));
        }
    }

    public float getRadius() {
        return this.getData(MetaIndex.AREA_EFFECT_RADIUS).floatValue();
    }

    public void setRadius(float f) {
        if (f > 30.0f) {
            f = 30.0f;
        } else if ((double)f < 0.1) {
            f = 0.1f;
        }
        this.setData(MetaIndex.AREA_EFFECT_RADIUS, Float.valueOf(f));
        this.sendData(MetaIndex.AREA_EFFECT_RADIUS);
    }

    public Color getColor() {
        int n = this.getData(MetaIndex.AREA_EFFECT_CLOUD_COLOR);
        return Color.fromRGB((int)n);
    }

    @RandomDefaultValue
    public void setColor(Color color) {
        this.setData(MetaIndex.AREA_EFFECT_CLOUD_COLOR, color.asRGB());
        this.sendData(MetaIndex.AREA_EFFECT_CLOUD_COLOR);
    }

    public boolean isIgnoreRadius() {
        return this.getData(MetaIndex.AREA_EFFECT_IGNORE_RADIUS);
    }

    public void setIgnoreRadius(boolean bl) {
        this.setData(MetaIndex.AREA_EFFECT_IGNORE_RADIUS, bl);
        this.sendData(MetaIndex.AREA_EFFECT_IGNORE_RADIUS);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public <T> void setParticle(Particle particle, T t) {
        this.setParticle(WrappedParticle.create((Particle)particle, t));
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public WrappedParticle getParticle() {
        if (NmsVersion.v1_13.isSupported()) {
            return this.getData(MetaIndex.AREA_EFFECT_PARTICLE);
        }
        int n = this.getData(MetaIndex.AREA_EFFECT_PARTICLE_OLD);
        Particle particle = Particle.values()[n];
        return WrappedParticle.create((Particle)particle, null);
    }

    @NmsAddedIn(value=NmsVersion.v1_13)
    public void setParticle(WrappedParticle wrappedParticle) {
        if (NmsVersion.v1_13.isSupported()) {
            this.setData(MetaIndex.AREA_EFFECT_PARTICLE, wrappedParticle);
            this.sendData(MetaIndex.AREA_EFFECT_PARTICLE);
        } else {
            this.setParticleType(wrappedParticle.getParticle());
        }
    }

    public Particle getParticleType() {
        if (NmsVersion.v1_13.isSupported()) {
            return this.getParticle().getParticle();
        }
        return Particle.values()[this.getData(MetaIndex.AREA_EFFECT_PARTICLE_OLD)];
    }

    public void setParticleType(Particle particle) {
        if (NmsVersion.v1_13.isSupported()) {
            this.setParticle(WrappedParticle.create((Particle)particle, null));
        } else {
            this.setData(MetaIndex.AREA_EFFECT_PARTICLE_OLD, particle.ordinal());
            this.sendData(MetaIndex.AREA_EFFECT_PARTICLE_OLD);
        }
    }
}

