/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes.watchers;

import java.util.Optional;
import java.util.UUID;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;

public abstract class AbstractHorseWatcher
extends AgeableWatcher {
    private static final int TAMED = 2;
    private static final int SADDLED = 4;
    private static final int REPRODUCED = 8;
    private static final int GRAZING = 16;
    private static final int REARING = 32;
    private static final int EATING = 64;

    public AbstractHorseWatcher(Disguise disguise) {
        super(disguise);
    }

    public UUID getOwner() {
        return this.getData(MetaIndex.HORSE_OWNER).orElse(null);
    }

    public void setOwner(UUID uUID) {
        this.setData(MetaIndex.HORSE_OWNER, Optional.of(uUID));
        this.sendData(MetaIndex.HORSE_OWNER);
    }

    public boolean isReproduced() {
        return this.isHorseFlag(8);
    }

    public void setReproduced(boolean bl) {
        this.setHorseFlag(8, bl);
    }

    public boolean isGrazing() {
        return this.isHorseFlag(16);
    }

    public void setGrazing(boolean bl) {
        this.setHorseFlag(16, bl);
    }

    public boolean isEating() {
        return this.isHorseFlag(64);
    }

    public void setEating(boolean bl) {
        this.setHorseFlag(64, bl);
    }

    public boolean isRearing() {
        return this.isHorseFlag(32);
    }

    public void setRearing(boolean bl) {
        this.setHorseFlag(32, bl);
    }

    public boolean isSaddled() {
        return this.isHorseFlag(4);
    }

    public void setSaddled(boolean bl) {
        this.setHorseFlag(4, bl);
    }

    public boolean isTamed() {
        return this.isHorseFlag(2);
    }

    public void setTamed(boolean bl) {
        this.setHorseFlag(2, bl);
    }

    private boolean isHorseFlag(int n) {
        return (this.getHorseFlag() & n) != 0;
    }

    private byte getHorseFlag() {
        return this.getData(MetaIndex.HORSE_META);
    }

    private void setHorseFlag(int n, boolean bl) {
        byte by = this.getData(MetaIndex.HORSE_META);
        if (bl) {
            this.setData(MetaIndex.HORSE_META, (byte)(by | n));
        } else {
            this.setData(MetaIndex.HORSE_META, (byte)(by & ~n));
        }
        this.sendData(MetaIndex.HORSE_META);
    }
}

