/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class TargetedDisguise
extends Disguise {
    private ArrayList<String> disguiseViewers = new ArrayList();
    private TargetType targetType = TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS;

    public TargetedDisguise(DisguiseType disguiseType) {
        super(disguiseType);
    }

    @Override
    protected void clone(Disguise disguise) {
        ((TargetedDisguise)disguise).targetType = this.getDisguiseTarget();
        ((TargetedDisguise)disguise).disguiseViewers = new ArrayList<String>(this.disguiseViewers);
        super.clone(disguise);
    }

    public TargetedDisguise addPlayer(Player player) {
        this.addPlayer(player.getName());
        return this;
    }

    public TargetedDisguise addPlayer(String string) {
        if (!this.disguiseViewers.contains(string)) {
            this.disguiseViewers.add(string);
            if (DisguiseAPI.isDisguiseInUse(this)) {
                DisguiseUtilities.checkConflicts(this, string);
                DisguiseUtilities.refreshTracker(this, string);
                if (this.isHidePlayer() && this.getEntity() instanceof Player) {
                    try {
                        Player player = Bukkit.getPlayerExact((String)string);
                        if (player != null) {
                            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                            packetContainer.getPlayerInfoAction().write(0, (Object)(this.canSee(player) ? EnumWrappers.PlayerInfoAction.REMOVE_PLAYER : EnumWrappers.PlayerInfoAction.ADD_PLAYER));
                            packetContainer.getPlayerInfoDataLists().write(0, Arrays.asList(new PlayerInfoData(ReflectionManager.getGameProfile((Player)this.getEntity()), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)DisguiseUtilities.getPlayerListName((Player)this.getEntity())))));
                            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
            }
        }
        return this;
    }

    public boolean canSee(Player player) {
        return this.canSee(player.getName());
    }

    public boolean canSee(String string) {
        boolean bl = this.disguiseViewers.contains(string);
        if (this.targetType == TargetType.SHOW_TO_EVERYONE_BUT_THESE_PLAYERS) {
            return !bl;
        }
        return bl;
    }

    public TargetType getDisguiseTarget() {
        return this.targetType;
    }

    public TargetedDisguise setDisguiseTarget(TargetType targetType) {
        if (DisguiseUtilities.isDisguiseInUse(this)) {
            throw new RuntimeException("Cannot set the disguise target after the entity has been disguised");
        }
        this.targetType = targetType;
        return this;
    }

    public List<String> getObservers() {
        return Collections.unmodifiableList(this.disguiseViewers);
    }

    public TargetedDisguise removePlayer(Player player) {
        this.removePlayer(player.getName());
        return this;
    }

    public TargetedDisguise removePlayer(String string) {
        if (this.disguiseViewers.contains(string)) {
            this.disguiseViewers.remove(string);
            if (DisguiseAPI.isDisguiseInUse(this)) {
                DisguiseUtilities.checkConflicts(this, string);
                DisguiseUtilities.refreshTracker(this, string);
                if (this.isHidePlayer() && this.getEntity() instanceof Player) {
                    try {
                        Player player = Bukkit.getPlayerExact((String)string);
                        if (player != null) {
                            PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
                            packetContainer.getPlayerInfoAction().write(0, (Object)(this.canSee(player) ? EnumWrappers.PlayerInfoAction.ADD_PLAYER : EnumWrappers.PlayerInfoAction.REMOVE_PLAYER));
                            packetContainer.getPlayerInfoDataLists().write(0, Arrays.asList(new PlayerInfoData(ReflectionManager.getGameProfile((Player)this.getEntity()), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)DisguiseUtilities.getPlayerListName((Player)this.getEntity())))));
                            ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
            }
        }
        return this;
    }

    public TargetedDisguise silentlyAddPlayer(String string) {
        if (!this.disguiseViewers.contains(string)) {
            this.disguiseViewers.add(string);
        }
        return this;
    }

    public TargetedDisguise silentlyRemovePlayer(String string) {
        this.disguiseViewers.remove(string);
        return this;
    }

    public static enum TargetType {
        HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS,
        SHOW_TO_EVERYONE_BUT_THESE_PLAYERS;

    }
}

