/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.lang.reflect.InvocationTargetException;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.PlayerWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.reflection.LibsProfileLookup;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerDisguise
extends TargetedDisguise {
    private transient LibsProfileLookup currentLookup;
    private WrappedGameProfile gameProfile;
    private String playerName = "Herobrine";
    private String skinToUse;
    private boolean nameVisible = true;
    private boolean explicitNameVisible = false;
    private transient DisguiseUtilities.DScoreTeam scoreboardName;
    private boolean deadmau5Ears;

    private PlayerDisguise() {
        super(DisguiseType.PLAYER);
    }

    public PlayerDisguise(Player player) {
        this(ReflectionManager.getGameProfile(player));
    }

    public PlayerDisguise(Player player, Player player2) {
        this(ReflectionManager.getGameProfile(player), ReflectionManager.getGameProfile(player2));
    }

    public PlayerDisguise(String string) {
        this(string, string);
    }

    public PlayerDisguise(String string, String string2) {
        this();
        WrappedGameProfile wrappedGameProfile;
        if (string.equals(string2) && (wrappedGameProfile = this.getProfile(string2)) != null) {
            this.setName(wrappedGameProfile.getName());
            this.setSkin(wrappedGameProfile);
            this.createDisguise();
            return;
        }
        this.setName(string);
        this.setSkin(string2);
        this.createDisguise();
    }

    public PlayerDisguise(WrappedGameProfile wrappedGameProfile) {
        this();
        this.setName(wrappedGameProfile.getName());
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.getUUID(), wrappedGameProfile.getName(), wrappedGameProfile);
        this.createDisguise();
    }

    public PlayerDisguise(WrappedGameProfile wrappedGameProfile, WrappedGameProfile wrappedGameProfile2) {
        this();
        this.setName(wrappedGameProfile.getName());
        this.gameProfile = ReflectionManager.getGameProfile(this.getUUID(), wrappedGameProfile.getName());
        this.setSkin(wrappedGameProfile2);
        this.createDisguise();
    }

    @Override
    public double getHeight() {
        if (this.getWatcher() == null) {
            return 1.8;
        }
        if (this.getEntity() == null || this.getWatcher().getModifiedEntityAnimations()[1]) {
            return this.getWatcher().isSneaking() ? 1.5 : 1.8;
        }
        return this.getEntity() instanceof Player && ((Player)this.getEntity()).isSneaking() ? 1.5 : 1.8;
    }

    @Deprecated
    public DisguiseUtilities.DScoreTeam getScoreboardName() {
        if (!DisguiseConfig.isScoreboardNames()) {
            throw new IllegalStateException("Cannot use this method when it's been disabled in config!");
        }
        if (this.scoreboardName == null) {
            this.scoreboardName = this.isUpsideDown() || this.isDeadmau5Ears() ? new DisguiseUtilities.DScoreTeam(this, new String[]{"", this.getProfileName(), ""}) : DisguiseUtilities.createExtendedName(this);
        }
        return this.scoreboardName;
    }

    private void setScoreboardName(String[] stringArray) {
        if (this.isUpsideDown() || this.isDeadmau5Ears()) {
            return;
        }
        this.getScoreboardName().setSplit(stringArray);
    }

    private boolean isStaticName(String string) {
        return string != null && (string.equalsIgnoreCase("Dinnerbone") || string.equalsIgnoreCase("Grumm"));
    }

    public boolean hasScoreboardName() {
        if (!DisguiseConfig.isArmorstandsName() && this.isStaticName(this.getName())) {
            return false;
        }
        return DisguiseConfig.isScoreboardNames();
    }

    public String getProfileName() {
        return this.isUpsideDown() ? "Dinnerbone" : (this.isDeadmau5Ears() ? "deadmau5" : (this.hasScoreboardName() ? this.getScoreboardName().getPlayer() : (this.getName().isEmpty() ? "\u00a7r" : this.getName())));
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    public PlayerDisguise setNameVisible(boolean bl) {
        return this.setNameVisible(bl, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PlayerDisguise setNameVisible(boolean bl, boolean bl2) {
        if (this.isNameVisible() == bl || bl2 && this.explicitNameVisible) {
            return this;
        }
        if (!bl2) {
            this.explicitNameVisible = true;
        }
        if (this.isDisguiseInUse()) {
            if (DisguiseConfig.isArmorstandsName()) {
                this.nameVisible = bl;
                this.sendArmorStands(this.isNameVisible() ? DisguiseUtilities.reverse(this.getMultiName()) : new String[]{});
                return this;
            } else {
                if (!DisguiseConfig.isScoreboardNames()) {
                    if (!this.removeDisguise()) throw new IllegalStateException("Unable to restart disguise");
                    this.nameVisible = bl;
                    if (this.startDisguise()) return this;
                    throw new IllegalStateException("Unable to restart disguise");
                }
                this.nameVisible = bl;
                DisguiseUtilities.updateExtendedName(this);
            }
            return this;
        } else {
            this.nameVisible = bl;
        }
        return this;
    }

    @Override
    public PlayerDisguise addPlayer(Player player) {
        return (PlayerDisguise)super.addPlayer(player);
    }

    @Override
    public PlayerDisguise addPlayer(String string) {
        return (PlayerDisguise)super.addPlayer(string);
    }

    @Override
    public PlayerDisguise setUpsideDown(boolean bl) {
        if (this.isUpsideDown() == bl) {
            return this;
        }
        this.getWatcher().setInternalUpsideDown(bl);
        if (this.isDisguiseInUse()) {
            this.resendDisguise(DisguiseConfig.isArmorstandsName() ? this.getName() : "Dinnerbone", true);
        } else {
            this.scoreboardName = null;
        }
        return this;
    }

    public PlayerDisguise setDeadmau5Ears(boolean bl) {
        if (bl == this.isDeadmau5Ears()) {
            return this;
        }
        this.deadmau5Ears = bl;
        if (this.isDisguiseInUse()) {
            this.resendDisguise(DisguiseConfig.isArmorstandsName() ? this.getName() : "deadmau5", true);
        } else {
            this.scoreboardName = null;
        }
        return this;
    }

    @Override
    public PlayerDisguise clone() {
        PlayerDisguise playerDisguise = new PlayerDisguise();
        if (this.getWatcher() != null) {
            playerDisguise.setWatcher(this.getWatcher().clone(playerDisguise));
        }
        if (this.currentLookup == null && this.gameProfile != null) {
            playerDisguise.skinToUse = this.getSkin();
            playerDisguise.gameProfile = ReflectionManager.getGameProfileWithThisSkin(playerDisguise.getUUID(), this.getGameProfile().getName(), this.getGameProfile());
        } else {
            playerDisguise.setSkin(this.getSkin());
        }
        playerDisguise.setName(this.getName());
        playerDisguise.nameVisible = this.isNameVisible();
        playerDisguise.explicitNameVisible = this.explicitNameVisible;
        playerDisguise.setUpsideDown(this.isUpsideDown());
        playerDisguise.setDeadmau5Ears(this.isDeadmau5Ears());
        this.clone(playerDisguise);
        return playerDisguise;
    }

    public WrappedGameProfile getGameProfile() {
        if (this.gameProfile == null) {
            this.gameProfile = this.getSkin() != null ? ReflectionManager.getGameProfile(this.getUUID(), this.getProfileName()) : ReflectionManager.getGameProfileWithThisSkin(this.getUUID(), this.getProfileName(), DisguiseUtilities.getProfileFromMojang(this));
        }
        return this.gameProfile;
    }

    public void setGameProfile(WrappedGameProfile wrappedGameProfile) {
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.getUUID(), wrappedGameProfile.getName(), wrappedGameProfile);
    }

    public String getName() {
        return this.playerName;
    }

    public void setName(String string) {
        int n;
        if (this.getName().equals("<Inherit>") && this.getEntity() != null && ((string = this.getEntity().getCustomName()) == null || string.isEmpty())) {
            string = this.getEntity().getType().name();
        }
        if (DisguiseConfig.isCopyPlayerTeamInfo() && (DisguiseConfig.getPlayerNameType() == DisguiseConfig.PlayerNameType.TEAMS || DisguiseConfig.getPlayerNameType() == DisguiseConfig.PlayerNameType.ARMORSTANDS)) {
            string = DisguiseUtilities.getDisplayName(string);
        }
        if (string.equals(this.playerName)) {
            return;
        }
        switch (DisguiseConfig.getPlayerNameType()) {
            case TEAMS: {
                n = (NmsVersion.v1_13.isSupported() ? 64 : 16) * 2;
                break;
            }
            case EXTENDED: {
                n = (NmsVersion.v1_13.isSupported() ? 64 : 16) * 2 + 16;
                break;
            }
            case ARMORSTANDS: {
                n = 256;
                break;
            }
            default: {
                n = 16;
            }
        }
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        if (this.isDisguiseInUse()) {
            if (DisguiseConfig.isArmorstandsName()) {
                this.playerName = string;
                this.setNameVisible(!string.isEmpty(), true);
                this.setMultiName(DisguiseUtilities.splitNewLine(string));
            } else {
                boolean bl = false;
                if (DisguiseConfig.isScoreboardNames() && !this.isStaticName(string)) {
                    DisguiseUtilities.DScoreTeam dScoreTeam = this.getScoreboardName();
                    String[] stringArray = DisguiseUtilities.getExtendedNameSplit(dScoreTeam.getPlayer(), string);
                    bl = !stringArray[1].equals(dScoreTeam.getPlayer());
                    this.setScoreboardName(stringArray);
                }
                boolean bl2 = bl = !DisguiseConfig.isScoreboardNames() || this.isStaticName(string) || this.isStaticName(this.getName()) || bl;
                if (bl) {
                    this.resendDisguise(string, false);
                } else {
                    if (this.getName().isEmpty() && !string.isEmpty() && !this.isNameVisible()) {
                        this.setNameVisible(true, true);
                    } else if (!this.getName().isEmpty() && string.isEmpty() && this.isNameVisible()) {
                        this.setNameVisible(false, true);
                    } else {
                        DisguiseUtilities.updateExtendedName(this);
                    }
                    this.playerName = string;
                }
            }
            if (this.isDisplayedInTab()) {
                PacketContainer packetContainer = DisguiseUtilities.getTabPacket(this, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME);
                try {
                    for (String[] stringArray : Bukkit.getOnlinePlayers()) {
                        if (!this.canSee((Player)stringArray)) continue;
                        ProtocolLibrary.getProtocolManager().sendServerPacket((Player)stringArray, packetContainer);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        } else {
            if (this.scoreboardName != null) {
                DisguiseUtilities.DScoreTeam dScoreTeam = this.getScoreboardName();
                String[] stringArray = DisguiseUtilities.getExtendedNameSplit(dScoreTeam.getPlayer(), string);
                this.setScoreboardName(stringArray);
            }
            if (DisguiseConfig.isArmorstandsName()) {
                this.setMultiName(DisguiseUtilities.splitNewLine(string));
            }
            this.setNameVisible(!string.isEmpty(), true);
            this.playerName = string;
            if (this.gameProfile != null) {
                this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.getUUID(), this.getProfileName(), this.getGameProfile());
            }
        }
    }

    private void resendDisguise(String string, boolean bl) {
        if (this.removeDisguise()) {
            if (this.getName().isEmpty() && !string.isEmpty()) {
                this.setNameVisible(true, true);
            } else if (!this.getName().isEmpty() && string.isEmpty()) {
                this.setNameVisible(false, true);
            }
            this.playerName = string;
            if (bl) {
                this.scoreboardName = null;
            }
            if (this.gameProfile != null) {
                this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.getUUID(), this.getProfileName(), this.getGameProfile());
            }
            if (!this.startDisguise()) {
                throw new IllegalStateException("Unable to restart disguise");
            }
        } else {
            throw new IllegalStateException("Unable to restart disguise");
        }
    }

    public String getSkin() {
        return this.skinToUse;
    }

    public PlayerDisguise setSkin(String string) {
        Object object;
        WrappedGameProfile wrappedGameProfile = this.getProfile(string);
        if (wrappedGameProfile != null) {
            return this.setSkin(wrappedGameProfile);
        }
        if (string != null && ((String[])(object = DisguiseUtilities.splitNewLine(string))).length > 0) {
            string = object[0];
        }
        if (string != null && string.length() > 16) {
            string = null;
        }
        object = this.skinToUse;
        this.skinToUse = string;
        if (string == null) {
            this.currentLookup = null;
            this.gameProfile = null;
        } else {
            if (string.length() > 16) {
                this.skinToUse = string.substring(0, 16);
            }
            if (string.equals(object)) {
                return this;
            }
            if (this.isDisguiseInUse()) {
                this.currentLookup = new LibsProfileLookup(){

                    @Override
                    public void onLookup(WrappedGameProfile wrappedGameProfile) {
                        if (PlayerDisguise.this.currentLookup != this || wrappedGameProfile == null || wrappedGameProfile.getProperties().isEmpty()) {
                            return;
                        }
                        PlayerDisguise.this.setSkin(wrappedGameProfile);
                        PlayerDisguise.this.currentLookup = null;
                    }
                };
                WrappedGameProfile wrappedGameProfile2 = DisguiseUtilities.getProfileFromMojang(this.skinToUse, this.currentLookup, DisguiseConfig.isContactMojangServers());
                if (wrappedGameProfile2 != null) {
                    this.setSkin(wrappedGameProfile2);
                }
            }
        }
        return this;
    }

    public PlayerDisguise setSkin(WrappedGameProfile wrappedGameProfile) {
        if (wrappedGameProfile == null) {
            this.gameProfile = null;
            this.skinToUse = null;
            return this;
        }
        this.currentLookup = null;
        this.skinToUse = wrappedGameProfile.getName();
        this.gameProfile = ReflectionManager.getGameProfileWithThisSkin(this.getUUID(), this.getProfileName(), wrappedGameProfile);
        this.refreshDisguise();
        return this;
    }

    private WrappedGameProfile getProfile(String string) {
        if (string != null && string.length() > 70 && string.startsWith("{\"id\":") && string.endsWith("}") && string.contains(",\"name\":")) {
            try {
                return (WrappedGameProfile)DisguiseUtilities.getGson().fromJson(string, WrappedGameProfile.class);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Tried to parse " + string + " to a GameProfile, but it has been formatted incorrectly!");
            }
        }
        return null;
    }

    private void refreshDisguise() {
        if (!DisguiseUtilities.isDisguiseInUse(this)) {
            return;
        }
        if (this.isDisplayedInTab()) {
            PacketContainer packetContainer = DisguiseUtilities.getTabPacket(this, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            PacketContainer packetContainer2 = packetContainer.shallowClone();
            packetContainer2.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!this.canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer2);
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        DisguiseUtilities.refreshTrackers(this);
    }

    @Override
    public PlayerWatcher getWatcher() {
        return (PlayerWatcher)super.getWatcher();
    }

    @Override
    public PlayerDisguise setWatcher(FlagWatcher flagWatcher) {
        return (PlayerDisguise)super.setWatcher(flagWatcher);
    }

    public boolean isDisplayedInTab() {
        return this.getWatcher().isDisplayedInTab();
    }

    public void setDisplayedInTab(boolean bl) {
        this.getWatcher().setDisplayedInTab(bl);
    }

    @Override
    public boolean isPlayerDisguise() {
        return true;
    }

    @Override
    public PlayerDisguise removePlayer(Player player) {
        return (PlayerDisguise)super.removePlayer(player);
    }

    @Override
    public PlayerDisguise removePlayer(String string) {
        return (PlayerDisguise)super.removePlayer(string);
    }

    @Override
    public PlayerDisguise setDisguiseTarget(TargetedDisguise.TargetType targetType) {
        return (PlayerDisguise)super.setDisguiseTarget(targetType);
    }

    @Override
    public PlayerDisguise setEntity(Entity entity) {
        return (PlayerDisguise)super.setEntity(entity);
    }

    @Override
    public PlayerDisguise setHearSelfDisguise(boolean bl) {
        return (PlayerDisguise)super.setHearSelfDisguise(bl);
    }

    @Override
    public PlayerDisguise setHideArmorFromSelf(boolean bl) {
        return (PlayerDisguise)super.setHideArmorFromSelf(bl);
    }

    @Override
    public PlayerDisguise setHideHeldItemFromSelf(boolean bl) {
        return (PlayerDisguise)super.setHideHeldItemFromSelf(bl);
    }

    @Override
    public PlayerDisguise setKeepDisguiseOnPlayerDeath(boolean bl) {
        return (PlayerDisguise)super.setKeepDisguiseOnPlayerDeath(bl);
    }

    @Override
    public PlayerDisguise setModifyBoundingBox(boolean bl) {
        return (PlayerDisguise)super.setModifyBoundingBox(bl);
    }

    @Override
    public PlayerDisguise setReplaceSounds(boolean bl) {
        return (PlayerDisguise)super.setReplaceSounds(bl);
    }

    @Override
    public boolean startDisguise() {
        return this.startDisguise(null);
    }

    @Override
    public boolean startDisguise(CommandSender commandSender) {
        String string;
        if (this.isDisguiseInUse()) {
            return false;
        }
        if (this.skinToUse != null && this.gameProfile == null) {
            this.currentLookup = new LibsProfileLookup(){

                @Override
                public void onLookup(WrappedGameProfile wrappedGameProfile) {
                    if (PlayerDisguise.this.currentLookup != this || wrappedGameProfile == null || wrappedGameProfile.getProperties().isEmpty()) {
                        return;
                    }
                    PlayerDisguise.this.setSkin(wrappedGameProfile);
                    PlayerDisguise.this.currentLookup = null;
                }
            };
            string = DisguiseUtilities.getProfileFromMojang(this.skinToUse, this.currentLookup, DisguiseConfig.isContactMojangServers());
            if (string != null) {
                this.setSkin((WrappedGameProfile)string);
            }
        }
        if (this.isDynamicName()) {
            string = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (string == null) {
                string = "";
            }
            if (!this.getName().equals(string)) {
                this.setName(string);
            }
        } else if (this.getName().equals("<Inherit>") && this.getEntity() != null) {
            string = this.getEntity().getCustomName();
            if (string == null || string.isEmpty()) {
                string = this.getEntity().getType().name();
            }
            this.setName(string);
        }
        boolean bl = super.startDisguise(commandSender);
        if (bl && this.hasScoreboardName()) {
            DisguiseUtilities.registerExtendedName(this);
        }
        return bl;
    }

    @Override
    public PlayerDisguise setVelocitySent(boolean bl) {
        return (PlayerDisguise)super.setVelocitySent(bl);
    }

    @Override
    public PlayerDisguise setViewSelfDisguise(boolean bl) {
        return (PlayerDisguise)super.setViewSelfDisguise(bl);
    }

    @Override
    public PlayerDisguise silentlyAddPlayer(String string) {
        return (PlayerDisguise)super.silentlyAddPlayer(string);
    }

    @Override
    public PlayerDisguise silentlyRemovePlayer(String string) {
        return (PlayerDisguise)super.silentlyRemovePlayer(string);
    }

    @Override
    public boolean removeDisguise(boolean bl) {
        boolean bl2 = super.removeDisguise(bl);
        if (!bl2) {
            return bl2;
        }
        if (this.hasScoreboardName()) {
            if (bl) {
                new BukkitRunnable(){

                    public void run() {
                        DisguiseUtilities.unregisterExtendedName(PlayerDisguise.this);
                    }
                }.runTaskLater((Plugin)LibsDisguises.getInstance(), 5L);
            } else {
                DisguiseUtilities.unregisterExtendedName(this);
            }
        }
        return bl2;
    }

    public boolean isDeadmau5Ears() {
        return this.deadmau5Ears;
    }
}

