/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import java.security.InvalidParameterException;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ArmorStandWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MobDisguise
extends TargetedDisguise {
    private boolean isAdult;

    public MobDisguise(DisguiseType disguiseType) {
        this(disguiseType, true);
    }

    public MobDisguise(DisguiseType disguiseType, boolean bl) {
        super(disguiseType);
        if (!disguiseType.isMob()) {
            throw new InvalidParameterException("Expected a living DisguiseType while constructing MobDisguise. Received " + (Object)((Object)disguiseType) + " instead. Please use " + (disguiseType.isPlayer() ? "PlayerDisguise" : "MiscDisguise") + " instead");
        }
        this.isAdult = bl;
        this.createDisguise();
    }

    @Override
    public double getHeight() {
        DisguiseValues disguiseValues = DisguiseValues.getDisguiseValues(this.getType());
        if (disguiseValues == null || disguiseValues.getAdultBox() == null) {
            return 0.0;
        }
        if (!this.isAdult() && disguiseValues.getBabyBox() != null) {
            return disguiseValues.getBabyBox().getY();
        }
        if (this.getWatcher() != null) {
            if (this.getType() == DisguiseType.ARMOR_STAND) {
                return (((ArmorStandWatcher)this.getWatcher()).isSmall() ? disguiseValues.getBabyBox() : disguiseValues.getAdultBox()).getY();
            }
            if (this.getType() == DisguiseType.SLIME || this.getType() == DisguiseType.MAGMA_CUBE) {
                return 0.51 * (0.255 * (double)((SlimeWatcher)this.getWatcher()).getSize());
            }
        }
        return disguiseValues.getAdultBox().getY();
    }

    @Override
    public MobDisguise addPlayer(Player player) {
        return (MobDisguise)super.addPlayer(player);
    }

    @Override
    public MobDisguise addPlayer(String string) {
        return (MobDisguise)super.addPlayer(string);
    }

    @Override
    public MobDisguise clone() {
        MobDisguise mobDisguise = new MobDisguise(this.getType(), this.isAdult());
        this.clone(mobDisguise);
        return mobDisguise;
    }

    public boolean doesDisguiseAge() {
        return this.getWatcher() != null && (this.getWatcher() instanceof AgeableWatcher || this.getWatcher() instanceof ZombieWatcher);
    }

    @Override
    public LivingWatcher getWatcher() {
        return (LivingWatcher)super.getWatcher();
    }

    @Override
    public MobDisguise setWatcher(FlagWatcher flagWatcher) {
        return (MobDisguise)super.setWatcher(flagWatcher);
    }

    public boolean isAdult() {
        if (this.getWatcher() != null) {
            if (this.getWatcher() instanceof AgeableWatcher) {
                return ((AgeableWatcher)this.getWatcher()).isAdult();
            }
            if (this.getWatcher() instanceof ZombieWatcher) {
                return ((ZombieWatcher)this.getWatcher()).isAdult();
            }
            return true;
        }
        return this.isAdult;
    }

    @Override
    public boolean isMobDisguise() {
        return true;
    }

    @Override
    public MobDisguise removePlayer(Player player) {
        return (MobDisguise)super.removePlayer(player);
    }

    @Override
    public MobDisguise removePlayer(String string) {
        return (MobDisguise)super.removePlayer(string);
    }

    @Override
    public MobDisguise setDisguiseTarget(TargetedDisguise.TargetType targetType) {
        return (MobDisguise)super.setDisguiseTarget(targetType);
    }

    @Override
    public MobDisguise setEntity(Entity entity) {
        return (MobDisguise)super.setEntity(entity);
    }

    @Override
    public MobDisguise setHearSelfDisguise(boolean bl) {
        return (MobDisguise)super.setHearSelfDisguise(bl);
    }

    @Override
    public MobDisguise setHideArmorFromSelf(boolean bl) {
        return (MobDisguise)super.setHideArmorFromSelf(bl);
    }

    @Override
    public MobDisguise setHideHeldItemFromSelf(boolean bl) {
        return (MobDisguise)super.setHideHeldItemFromSelf(bl);
    }

    @Override
    public MobDisguise setKeepDisguiseOnPlayerDeath(boolean bl) {
        return (MobDisguise)super.setKeepDisguiseOnPlayerDeath(bl);
    }

    @Override
    public MobDisguise setModifyBoundingBox(boolean bl) {
        return (MobDisguise)super.setModifyBoundingBox(bl);
    }

    @Override
    public MobDisguise setReplaceSounds(boolean bl) {
        return (MobDisguise)super.setReplaceSounds(bl);
    }

    @Override
    public MobDisguise setVelocitySent(boolean bl) {
        return (MobDisguise)super.setVelocitySent(bl);
    }

    @Override
    public MobDisguise setViewSelfDisguise(boolean bl) {
        return (MobDisguise)super.setViewSelfDisguise(bl);
    }

    @Override
    public MobDisguise silentlyAddPlayer(String string) {
        return (MobDisguise)super.silentlyAddPlayer(string);
    }

    @Override
    public MobDisguise silentlyRemovePlayer(String string) {
        return (MobDisguise)super.silentlyRemovePlayer(string);
    }
}

