/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import java.security.InvalidParameterException;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.DroppedItemWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FallingBlockWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PaintingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SplashPotionWatcher;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import org.bukkit.Art;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MiscDisguise
extends TargetedDisguise {
    private int id = -1;
    private int data = 0;

    public MiscDisguise(DisguiseType disguiseType) {
        this(disguiseType, -1, disguiseType.getDefaultData());
    }

    public MiscDisguise(DisguiseType disguiseType, Material material, int n) {
        this(disguiseType, new ItemStack(material, 1, (short)n));
    }

    public MiscDisguise(DisguiseType disguiseType, ItemStack itemStack) {
        super(disguiseType);
        if (disguiseType != DisguiseType.FALLING_BLOCK && disguiseType != DisguiseType.DROPPED_ITEM) {
            throw new IllegalArgumentException("This constructor requires a DROPPED_ITEM or FALLING_BLOCK disguise type!");
        }
        this.apply(0, itemStack);
    }

    public MiscDisguise(DisguiseType disguiseType, Material material) {
        super(disguiseType);
        if (disguiseType != DisguiseType.FALLING_BLOCK && disguiseType != DisguiseType.DROPPED_ITEM) {
            throw new IllegalArgumentException("This constructor requires a DROPPED_ITEM or FALLING_BLOCK disguise type!");
        }
        this.apply(0, new ItemStack(material));
    }

    public MiscDisguise(DisguiseType disguiseType, int n) {
        this(disguiseType, n, disguiseType.getDefaultData());
    }

    @Deprecated
    public MiscDisguise(DisguiseType disguiseType, int n, int n2) {
        super(disguiseType);
        if (!disguiseType.isMisc()) {
            throw new InvalidParameterException("Expected a non-living DisguiseType while constructing MiscDisguise. Received " + (Object)((Object)disguiseType) + " instead. Please use " + (disguiseType.isPlayer() ? "PlayerDisguise" : "MobDisguise") + " instead");
        }
        this.apply(n, new ItemStack(Material.STONE));
    }

    @Override
    public double getHeight() {
        DisguiseValues disguiseValues = DisguiseValues.getDisguiseValues(this.getType());
        if (disguiseValues == null || disguiseValues.getAdultBox() == null) {
            return 0.0;
        }
        return disguiseValues.getAdultBox().getY();
    }

    private void apply(int n, ItemStack itemStack) {
        this.createDisguise();
        this.id = this.getType().getTypeId();
        this.data = this.getType().getDefaultData();
        switch (this.getType()) {
            case PAINTING: {
                ((PaintingWatcher)this.getWatcher()).setArt(Art.values()[Math.max(0, n) % Art.values().length]);
                break;
            }
            case FALLING_BLOCK: {
                ((FallingBlockWatcher)this.getWatcher()).setBlock(itemStack);
                break;
            }
            case SPLASH_POTION: {
                ((SplashPotionWatcher)this.getWatcher()).setPotionId(Math.max(0, n));
                break;
            }
            case DROPPED_ITEM: {
                ((DroppedItemWatcher)this.getWatcher()).setItemStack(itemStack);
                break;
            }
            case FISHING_HOOK: 
            case ARROW: 
            case SPECTRAL_ARROW: 
            case SMALL_FIREBALL: 
            case FIREBALL: 
            case WITHER_SKULL: 
            case TRIDENT: {
                this.data = n;
                break;
            }
        }
    }

    @Override
    public MiscDisguise addPlayer(Player player) {
        return (MiscDisguise)super.addPlayer(player);
    }

    @Override
    public MiscDisguise addPlayer(String string) {
        return (MiscDisguise)super.addPlayer(string);
    }

    @Override
    public MiscDisguise clone() {
        MiscDisguise miscDisguise = new MiscDisguise(this.getType(), this.getData());
        this.clone(miscDisguise);
        return miscDisguise;
    }

    public int getData() {
        switch (this.getType()) {
            case FALLING_BLOCK: {
                return ((FallingBlockWatcher)this.getWatcher()).getBlock().getDurability();
            }
            case PAINTING: {
                return ((PaintingWatcher)this.getWatcher()).getArt().getId();
            }
            case SPLASH_POTION: {
                return ((SplashPotionWatcher)this.getWatcher()).getPotionId();
            }
        }
        return this.data;
    }

    public int getId() {
        if (this.getType() == DisguiseType.FALLING_BLOCK) {
            return ((FallingBlockWatcher)this.getWatcher()).getBlock().getType().ordinal();
        }
        return this.id;
    }

    @Override
    public boolean isMiscDisguise() {
        return true;
    }

    @Override
    public MiscDisguise removePlayer(Player player) {
        return (MiscDisguise)super.removePlayer(player);
    }

    @Override
    public MiscDisguise removePlayer(String string) {
        return (MiscDisguise)super.removePlayer(string);
    }

    @Override
    public MiscDisguise setDisguiseTarget(TargetedDisguise.TargetType targetType) {
        return (MiscDisguise)super.setDisguiseTarget(targetType);
    }

    @Override
    public MiscDisguise setEntity(Entity entity) {
        return (MiscDisguise)super.setEntity(entity);
    }

    @Override
    public MiscDisguise setHearSelfDisguise(boolean bl) {
        return (MiscDisguise)super.setHearSelfDisguise(bl);
    }

    @Override
    public MiscDisguise setHideArmorFromSelf(boolean bl) {
        return (MiscDisguise)super.setHideArmorFromSelf(bl);
    }

    @Override
    public MiscDisguise setHideHeldItemFromSelf(boolean bl) {
        return (MiscDisguise)super.setHideHeldItemFromSelf(bl);
    }

    @Override
    public MiscDisguise setKeepDisguiseOnPlayerDeath(boolean bl) {
        return (MiscDisguise)super.setKeepDisguiseOnPlayerDeath(bl);
    }

    @Override
    public MiscDisguise setModifyBoundingBox(boolean bl) {
        return (MiscDisguise)super.setModifyBoundingBox(bl);
    }

    @Override
    public MiscDisguise setReplaceSounds(boolean bl) {
        return (MiscDisguise)super.setReplaceSounds(bl);
    }

    @Override
    public MiscDisguise setVelocitySent(boolean bl) {
        return (MiscDisguise)super.setVelocitySent(bl);
    }

    @Override
    public MiscDisguise setViewSelfDisguise(boolean bl) {
        return (MiscDisguise)super.setViewSelfDisguise(bl);
    }

    @Override
    public MiscDisguise setWatcher(FlagWatcher flagWatcher) {
        return (MiscDisguise)super.setWatcher(flagWatcher);
    }

    @Override
    public MiscDisguise silentlyAddPlayer(String string) {
        return (MiscDisguise)super.silentlyAddPlayer(string);
    }

    @Override
    public MiscDisguise silentlyRemovePlayer(String string) {
        return (MiscDisguise)super.silentlyRemovePlayer(string);
    }
}

