/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class LibsEquipment
implements EntityEquipment {
    private ItemStack[] equipment = new ItemStack[EquipmentSlot.values().length];
    private transient FlagWatcher flagWatcher;

    public LibsEquipment(FlagWatcher flagWatcher) {
        this.flagWatcher = flagWatcher;
    }

    public void setEquipment(EntityEquipment entityEquipment) {
        if (entityEquipment == null) {
            return;
        }
        this.setArmorContents(entityEquipment.getArmorContents());
        this.setItemInMainHand(entityEquipment.getItemInMainHand());
        this.setItemInOffHand(entityEquipment.getItemInOffHand());
    }

    protected void setFlagWatcher(FlagWatcher flagWatcher) {
        this.flagWatcher = flagWatcher;
    }

    public LibsEquipment clone(FlagWatcher flagWatcher) {
        LibsEquipment libsEquipment = new LibsEquipment(flagWatcher);
        for (int i = 0; i < this.equipment.length; ++i) {
            ItemStack itemStack = this.equipment[i];
            if (itemStack == null) continue;
            libsEquipment.equipment[i] = itemStack.clone();
        }
        return libsEquipment;
    }

    public ItemStack getItem(EquipmentSlot equipmentSlot) {
        return this.equipment[equipmentSlot.ordinal()];
    }

    public void setItem(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        if (this.getItem(equipmentSlot) == itemStack) {
            return;
        }
        this.equipment[equipmentSlot.ordinal()] = itemStack;
        this.flagWatcher.sendItemStack(equipmentSlot, itemStack);
    }

    public ItemStack getItemInMainHand() {
        return this.getItem(EquipmentSlot.HAND);
    }

    public void setItemInMainHand(ItemStack itemStack) {
        this.setItem(EquipmentSlot.HAND, itemStack);
    }

    public ItemStack getItemInOffHand() {
        return this.getItem(EquipmentSlot.OFF_HAND);
    }

    public void setItemInOffHand(ItemStack itemStack) {
        this.setItem(EquipmentSlot.OFF_HAND, itemStack);
    }

    public ItemStack getItemInHand() {
        return this.getItem(EquipmentSlot.HAND);
    }

    public void setItemInHand(ItemStack itemStack) {
        this.setItem(EquipmentSlot.HAND, itemStack);
    }

    public ItemStack getHelmet() {
        return this.getItem(EquipmentSlot.HEAD);
    }

    public void setHelmet(ItemStack itemStack) {
        this.setItem(EquipmentSlot.HEAD, itemStack);
    }

    public ItemStack getChestplate() {
        return this.getItem(EquipmentSlot.CHEST);
    }

    public void setChestplate(ItemStack itemStack) {
        this.setItem(EquipmentSlot.CHEST, itemStack);
    }

    public ItemStack getLeggings() {
        return this.getItem(EquipmentSlot.LEGS);
    }

    public void setLeggings(ItemStack itemStack) {
        this.setItem(EquipmentSlot.LEGS, itemStack);
    }

    public ItemStack getBoots() {
        return this.getItem(EquipmentSlot.FEET);
    }

    public void setBoots(ItemStack itemStack) {
        this.setItem(EquipmentSlot.FEET, itemStack);
    }

    public ItemStack[] getArmorContents() {
        return new ItemStack[]{this.getBoots(), this.getLeggings(), this.getChestplate(), this.getHelmet()};
    }

    public void setArmorContents(ItemStack[] itemStackArray) {
        this.setBoots(itemStackArray[0]);
        this.setLeggings(itemStackArray[1]);
        this.setChestplate(itemStackArray[2]);
        this.setHelmet(itemStackArray[3]);
    }

    public void clear() {
        this.setBoots(null);
        this.setLeggings(null);
        this.setChestplate(null);
        this.setHelmet(null);
    }

    public float getItemInHandDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setItemInHandDropChance(float f) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getItemInMainHandDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setItemInMainHandDropChance(float f) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getItemInOffHandDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setItemInOffHandDropChance(float f) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getHelmetDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setHelmetDropChance(float f) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getChestplateDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setChestplateDropChance(float f) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getLeggingsDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setLeggingsDropChance(float f) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public float getBootsDropChance() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public void setBootsDropChance(float f) {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    public Entity getHolder() {
        throw new UnsupportedOperationException("This is not supported on a disguise");
    }

    @Deprecated
    public void setBoots(ItemStack itemStack, boolean bl) {
        this.setBoots(itemStack);
    }

    @Deprecated
    public void setChestplate(ItemStack itemStack, boolean bl) {
        this.setChestplate(itemStack);
    }

    @Deprecated
    public void setLeggings(ItemStack itemStack, boolean bl) {
        this.setLeggings(itemStack);
    }

    @Deprecated
    public void setHelmet(ItemStack itemStack, boolean bl) {
        this.setHelmet(itemStack);
    }

    @Deprecated
    public void setItem(EquipmentSlot equipmentSlot, ItemStack itemStack, boolean bl) {
        this.setItem(equipmentSlot, itemStack);
    }

    @Deprecated
    public void setItemInMainHand(ItemStack itemStack, boolean bl) {
        this.setItemInMainHand(itemStack);
    }

    @Deprecated
    public void setItemInOffHand(ItemStack itemStack, boolean bl) {
        this.setItemInOffHand(itemStack);
    }
}

