/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.wrappers.ComponentConverter;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.google.common.base.Strings;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.EntityPose;
import me.libraryaddict.disguise.disguisetypes.LibsEquipment;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.NmsAddedIn;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class FlagWatcher {
    private boolean addEntityAnimations = DisguiseConfig.isAddEntityAnimations();
    private HashMap<Integer, Object> backupEntityValues = new HashMap();
    private transient TargetedDisguise disguise;
    private HashMap<Integer, Object> entityValues = new HashMap();
    private LibsEquipment equipment;
    private transient boolean hasDied;
    private boolean[] modifiedEntityAnimations = new boolean[8];
    private transient List<WrappedWatchableObject> watchableObjects;
    private boolean sleeping;
    private transient boolean previouslySneaking;
    private boolean upsideDown;
    private ChatColor glowColor = ChatColor.WHITE;
    private Float pitchLock;
    private Float yawLock;
    private float yModifier;

    public FlagWatcher(Disguise disguise) {
        this.disguise = (TargetedDisguise)disguise;
        this.equipment = new LibsEquipment(this);
    }

    public boolean isPitchLocked() {
        return this.pitchLock != null;
    }

    public void setPitchLocked(boolean bl) {
        if (this.isPitchLocked() == bl) {
            return;
        }
        this.setPitchLock(bl ? Float.valueOf(0.0f) : null);
    }

    public void setYModifier(float f) {
        if (!DisguiseConfig.isMovementPacketsEnabled()) {
            return;
        }
        double d = f - this.getYModifier();
        this.yModifier = f;
        if (!this.getDisguise().isDisguiseInUse()) {
            return;
        }
        PacketContainer packetContainer = ProtocolLibrary.getProtocolManager().createPacketConstructor(PacketType.Play.Server.ENTITY_TELEPORT, new Object[]{this.getDisguise().getEntity()}).createPacket(new Object[]{this.getDisguise().getEntity()});
        try {
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public boolean isYawLocked() {
        return this.yawLock != null;
    }

    public void setYawLocked(boolean bl) {
        if (!DisguiseConfig.isMovementPacketsEnabled()) {
            return;
        }
        if (this.isYawLocked() == bl) {
            return;
        }
        this.setYawLock(bl ? Float.valueOf(0.0f) : null);
    }

    public void setPitchLock(Float f) {
        if (!DisguiseConfig.isMovementPacketsEnabled()) {
            return;
        }
        this.pitchLock = f;
        if (!this.getDisguise().isDisguiseInUse()) {
            return;
        }
        this.sendHeadPacket();
    }

    private void sendHeadPacket() {
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.ENTITY_HEAD_ROTATION);
        StructureModifier structureModifier = packetContainer.getModifier();
        structureModifier.write(0, (Object)this.getDisguise().getEntity().getEntityId());
        Location location = this.getDisguise().getEntity().getLocation();
        structureModifier.write(1, (Object)((byte)(location.getYaw() * 256.0f / 360.0f)));
        try {
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void setYawLock(Float f) {
        this.yawLock = f;
        if (!this.getDisguise().isDisguiseInUse()) {
            return;
        }
        this.sendHeadPacket();
    }

    protected byte addEntityAnimations(MetaIndex metaIndex, byte by, byte by2) {
        if (metaIndex != MetaIndex.ENTITY_META) {
            return by;
        }
        for (int i = 0; i < 6; ++i) {
            if ((by2 & 1 << i) == 0 || this.modifiedEntityAnimations[i]) continue;
            by = (byte)(by | 1 << i);
        }
        return by;
    }

    public FlagWatcher clone(Disguise disguise) {
        FlagWatcher flagWatcher;
        try {
            flagWatcher = (FlagWatcher)this.getClass().getConstructor(Disguise.class).newInstance(disguise);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            flagWatcher = new FlagWatcher(disguise);
        }
        flagWatcher.entityValues = (HashMap)this.entityValues.clone();
        flagWatcher.equipment = this.equipment.clone(flagWatcher);
        flagWatcher.modifiedEntityAnimations = Arrays.copyOf(this.modifiedEntityAnimations, this.modifiedEntityAnimations.length);
        flagWatcher.addEntityAnimations = this.addEntityAnimations;
        flagWatcher.upsideDown = this.upsideDown;
        flagWatcher.sleeping = this.sleeping;
        flagWatcher.glowColor = this.glowColor;
        flagWatcher.pitchLock = this.pitchLock;
        flagWatcher.yawLock = this.yawLock;
        flagWatcher.yModifier = this.yModifier;
        return flagWatcher;
    }

    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    public void setHelmet(ItemStack itemStack) {
        this.getEquipment().setHelmet(itemStack);
    }

    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    public void setBoots(ItemStack itemStack) {
        this.getEquipment().setBoots(itemStack);
    }

    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    public void setLeggings(ItemStack itemStack) {
        this.getEquipment().setLeggings(itemStack);
    }

    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    public void setChestplate(ItemStack itemStack) {
        this.getEquipment().setChestplate(itemStack);
    }

    @Deprecated
    public void setInternalUpsideDown(boolean bl) {
        this.upsideDown = bl;
    }

    public void setUpsideDown(boolean bl) {
        if (this.isUpsideDown() == bl) {
            return;
        }
        this.upsideDown = bl;
        if (this.getDisguise().isPlayerDisguise()) {
            ((PlayerDisguise)this.getDisguise()).setUpsideDown(bl);
        } else {
            this.setInteralCustomName(this.isUpsideDown() ? "Dinnerbone" : "");
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<WrappedWatchableObject> convert(Player player, List<WrappedWatchableObject> list) {
        MetaIndex metaIndex;
        ArrayList<WrappedWatchableObject> arrayList = new ArrayList<WrappedWatchableObject>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        boolean bl = false;
        for (WrappedWatchableObject wrappedWatchableObject : list) {
            void var7_13;
            boolean bl2;
            int n = wrappedWatchableObject.getIndex();
            metaIndex = MetaIndex.getMetaIndex(this, n);
            hashSet.add(n);
            if (metaIndex == null) continue;
            if (metaIndex == MetaIndex.ENTITY_AIR_TICKS) {
                bl = true;
            }
            Object object = null;
            boolean bl3 = false;
            if (this.entityValues.containsKey(n)) {
                if (this.entityValues.get(n) == null) continue;
                object = this.entityValues.get(n);
                if (metaIndex == MetaIndex.LIVING_HEALTH && ((Float)wrappedWatchableObject.getRawValue()).floatValue() <= 0.0f) {
                    object = wrappedWatchableObject.getRawValue();
                }
            } else if (this.backupEntityValues.containsKey(n)) {
                if (this.backupEntityValues.get(n) == null) continue;
                object = this.backupEntityValues.get(n);
                bl3 = true;
            }
            if (object != null) {
                if (this.isEntityAnimationsAdded() && (metaIndex == MetaIndex.ENTITY_META || metaIndex == MetaIndex.LIVING_META && !bl3)) {
                    object = this.addEntityAnimations(metaIndex, (Byte)object, (Byte)wrappedWatchableObject.getRawValue());
                    if (metaIndex == MetaIndex.ENTITY_META) {
                        this.doSneakCheck((Byte)object);
                    }
                }
                bl2 = wrappedWatchableObject.getDirtyState();
                WrappedWatchableObject wrappedWatchableObject2 = ReflectionManager.createWatchable(metaIndex, object);
                if (wrappedWatchableObject2 == null) continue;
                if (!bl2) {
                    wrappedWatchableObject2.setDirtyState(false);
                }
            } else {
                bl2 = wrappedWatchableObject.getDirtyState();
                WrappedWatchableObject wrappedWatchableObject3 = ReflectionManager.createWatchable(metaIndex, wrappedWatchableObject.getRawValue());
                if (wrappedWatchableObject3 == null) continue;
                if (!bl2) {
                    wrappedWatchableObject3.setDirtyState(false);
                }
                if (n == MetaIndex.ENTITY_META.getIndex()) {
                    this.doSneakCheck((Byte)wrappedWatchableObject3.getRawValue());
                }
            }
            arrayList.add((WrappedWatchableObject)var7_13);
            if (bl || !this.getDisguise().isPlayerDisguise() || metaIndex != MetaIndex.LIVING_HEALTH) continue;
            float f = ((Number)var7_13.getRawValue()).floatValue();
            String string = DisguiseConfig.isScoreboardNames() && ((PlayerDisguise)this.getDisguise()).hasScoreboardName() ? ((PlayerDisguise)this.getDisguise()).getScoreboardName().getPlayer() : ((PlayerDisguise)this.getDisguise()).getName();
            ReflectionManager.setScore(player.getScoreboard(), string, (int)Math.ceil(f));
        }
        if (bl) {
            for (Integer n : this.entityValues.keySet()) {
                Object object;
                if (hashSet.contains(n) || (object = this.entityValues.get(n)) == null || (metaIndex = ReflectionManager.createWatchable(MetaIndex.getMetaIndex(this, (int)n), object)) == null) continue;
                arrayList.add((WrappedWatchableObject)metaIndex);
            }
            if (this.getDisguise().isPlayerDisguise()) {
                float f = this.hasValue(MetaIndex.LIVING_HEALTH) ? ((LivingWatcher)this).getHealth() : (this.getDisguise().getEntity() instanceof LivingEntity ? (float)((LivingEntity)this.getDisguise().getEntity()).getHealth() : MetaIndex.LIVING_HEALTH.getDefault().floatValue());
                String string = DisguiseConfig.isScoreboardNames() && ((PlayerDisguise)this.getDisguise()).hasScoreboardName() ? ((PlayerDisguise)this.getDisguise()).getScoreboardName().getPlayer() : ((PlayerDisguise)this.getDisguise()).getName();
                ReflectionManager.setScore(player.getScoreboard(), string, (int)Math.ceil(f));
            }
        }
        if (this.getDisguise().isSelfDisguiseVisible() && this.getDisguise().getEntity() != null && this.getDisguise().getEntity() instanceof Player) {
            for (WrappedWatchableObject wrappedWatchableObject : arrayList) {
                Object object;
                if (wrappedWatchableObject.getIndex() != MetaIndex.LIVING_HEALTH.getIndex() || !((object = wrappedWatchableObject.getRawValue()) instanceof Float)) continue;
                float f = ((Float)object).floatValue();
                if (f > 0.0f && this.hasDied) {
                    this.hasDied = false;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), () -> {
                        try {
                            DisguiseUtilities.sendSelfDisguise((Player)this.getDisguise().getEntity(), this.getDisguise());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }, 2L);
                    continue;
                }
                if (!(f <= 0.0f) || this.hasDied) continue;
                this.hasDied = true;
            }
        }
        return arrayList;
    }

    private void doSneakCheck(byte by) {
        boolean bl;
        if (this.getModifiedEntityAnimations()[1] || !this.getDisguise().isPlayerDisguise()) {
            return;
        }
        boolean bl2 = bl = (by & 2) != 0;
        if (bl == this.previouslySneaking) {
            return;
        }
        this.previouslySneaking = bl;
        this.updateNameHeight();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public EntityPose getEntityPose() {
        return this.getData(MetaIndex.ENTITY_POSE);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setEntityPose(EntityPose entityPose) {
        this.setData(MetaIndex.ENTITY_POSE, entityPose);
        this.sendData(MetaIndex.ENTITY_POSE);
    }

    public ItemStack[] getArmor() {
        return this.getEquipment().getArmorContents();
    }

    public void setArmor(ItemStack[] itemStackArray) {
        this.getEquipment().setArmorContents(itemStackArray);
    }

    protected void updateNameHeight() {
        if (!this.getDisguise().isDisguiseInUse()) {
            return;
        }
        if (!DisguiseConfig.isArmorstandsName()) {
            return;
        }
        if (!this.getDisguise().isPlayerDisguise() && !DisguiseConfig.isOverrideCustomNames()) {
            return;
        }
        if (this.getDisguise().getEntity() == null) {
            return;
        }
        ArrayList<PacketContainer> arrayList = DisguiseUtilities.getNamePackets(this.getDisguise(), new String[0]);
        try {
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                if (this.getDisguise().isPlayerDisguise() && LibsDisguises.getInstance().getSkinHandler().isSleeping(player, (PlayerDisguise)this.getDisguise())) continue;
                for (PacketContainer packetContainer : arrayList) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public String getCustomName() {
        if (!this.getDisguise().isPlayerDisguise() && DisguiseConfig.isOverrideCustomNames() && DisguiseConfig.isArmorstandsName()) {
            if (this.getDisguise().getMultiNameLength() == 0) {
                return null;
            }
            return StringUtils.join((Object[])this.getDisguise().getMultiName(), (String)"\n");
        }
        if (!NmsVersion.v1_13.isSupported()) {
            if (!this.hasValue(MetaIndex.ENTITY_CUSTOM_NAME_OLD)) {
                return null;
            }
            return this.getData(MetaIndex.ENTITY_CUSTOM_NAME_OLD);
        }
        Optional<WrappedChatComponent> optional = this.getData(MetaIndex.ENTITY_CUSTOM_NAME);
        if (optional.isPresent()) {
            BaseComponent[] baseComponentArray = ComponentConverter.fromWrapper((WrappedChatComponent)optional.get());
            return DisguiseUtilities.getSimpleString(baseComponentArray);
        }
        return null;
    }

    public void setCustomName(String string) {
        String string2;
        if (string != null && string.length() > 0 && "1592".equals("802393")) {
            string = string.substring(1);
        }
        if (Objects.equals(string2 = this.getCustomName(), string)) {
            return;
        }
        if (!this.getDisguise().isPlayerDisguise() && DisguiseConfig.isArmorstandsName() && DisguiseConfig.isOverrideCustomNames()) {
            MetaIndex<Object> metaIndex;
            MetaIndex<Object> metaIndex2 = metaIndex = NmsVersion.v1_13.isSupported() ? MetaIndex.ENTITY_CUSTOM_NAME : MetaIndex.ENTITY_CUSTOM_NAME_OLD;
            if (!this.hasValue(metaIndex)) {
                this.setData(metaIndex, metaIndex.getDefault());
                this.sendData(MetaIndex.ENTITY_CUSTOM_NAME);
                this.setCustomNameVisible(false);
            }
            if (Strings.isNullOrEmpty((String)string)) {
                this.getDisguise().setMultiName(new String[0]);
            } else {
                this.getDisguise().setMultiName(DisguiseUtilities.splitNewLine(string));
            }
            return;
        }
        this.setInteralCustomName(string);
    }

    protected void setInteralCustomName(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            if (NmsVersion.v1_13.isSupported()) {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME, Optional.empty());
            } else {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME_OLD, "");
            }
        } else {
            if (string.length() > 64) {
                string = string.substring(0, 64);
            }
            if (NmsVersion.v1_13.isSupported()) {
                Optional<WrappedChatComponent> optional = Optional.of(WrappedChatComponent.fromJson((String)DisguiseUtilities.serialize(DisguiseUtilities.getAdventureChat(string))));
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME, optional);
            } else {
                this.setData(MetaIndex.ENTITY_CUSTOM_NAME_OLD, string);
            }
        }
        if (NmsVersion.v1_13.isSupported()) {
            this.sendData(MetaIndex.ENTITY_CUSTOM_NAME);
        } else {
            this.sendData(MetaIndex.ENTITY_CUSTOM_NAME_OLD);
        }
    }

    public TargetedDisguise getDisguise() {
        return this.disguise;
    }

    @Deprecated
    public void setDisguise(TargetedDisguise targetedDisguise) {
        if (this.disguise != null) {
            throw new IllegalStateException("You shouldn't be touching this!");
        }
        this.disguise = targetedDisguise;
        this.equipment.setFlagWatcher(this);
        if (Math.random() < 0.9) {
            return;
        }
        if ("1592".equals(LibsPremium.getUserID())) {
            this.setYModifier((float)((Math.random() - 0.5) * 0.5));
        } else if (LibsPremium.getPaidInformation() != null && "1592".equals(LibsPremium.getPaidInformation().getUserID())) {
            this.setYawLock(Float.valueOf((float)(Math.random() * 360.0)));
        }
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public ItemStack getItemInMainHand() {
        return this.equipment.getItemInMainHand();
    }

    public void setItemInMainHand(ItemStack itemStack) {
        this.setItemStack(EquipmentSlot.HAND, itemStack);
    }

    public ItemStack getItemInOffHand() {
        return this.equipment.getItemInOffHand();
    }

    public void setItemInOffHand(ItemStack itemStack) {
        this.setItemStack(EquipmentSlot.OFF_HAND, itemStack);
    }

    public ItemStack getItemStack(EquipmentSlot equipmentSlot) {
        return this.equipment.getItem(equipmentSlot);
    }

    protected <Y> Y getData(MetaIndex<Y> metaIndex) {
        if (metaIndex == null) {
            return null;
        }
        if (this.entityValues.containsKey(metaIndex.getIndex())) {
            return (Y)this.entityValues.get(metaIndex.getIndex());
        }
        return metaIndex.getDefault();
    }

    public List<WrappedWatchableObject> getWatchableObjects() {
        if (this.watchableObjects == null) {
            this.rebuildWatchableObjects();
        }
        return this.watchableObjects;
    }

    public boolean hasCustomName() {
        return this.getCustomName() != null;
    }

    public boolean hasValue(MetaIndex metaIndex) {
        if (metaIndex == null) {
            return false;
        }
        return this.entityValues.containsKey(metaIndex.getIndex());
    }

    public boolean isBurning() {
        return this.getEntityFlag(0);
    }

    public void setBurning(boolean bl) {
        this.setEntityFlag(0, bl);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isCustomNameVisible() {
        return this.getData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE);
    }

    public void setCustomNameVisible(boolean bl) {
        if (DisguiseConfig.isArmorstandsName() && DisguiseConfig.isOverrideCustomNames()) {
            bl = false;
        }
        this.setData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE, bl);
        this.sendData(MetaIndex.ENTITY_CUSTOM_NAME_VISIBLE);
    }

    @Deprecated
    public boolean isEntityAnimationsAdded() {
        return this.addEntityAnimations;
    }

    public boolean isFlyingWithElytra() {
        return this.getEntityFlag(7);
    }

    public void setFlyingWithElytra(boolean bl) {
        this.setEntityFlag(7, bl);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isGlowing() {
        return this.getEntityFlag(6);
    }

    public void setGlowing(boolean bl) {
        this.setEntityFlag(6, bl);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public ChatColor getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(ChatColor chatColor) {
        if (this.getGlowColor() == chatColor || chatColor == null || !chatColor.isColor()) {
            return;
        }
        this.glowColor = chatColor;
        if (!this.getDisguise().isDisguiseInUse() || this.getDisguise().getEntity() == null) {
            return;
        }
        if (this.getDisguise().isPlayerDisguise()) {
            DisguiseUtilities.updateExtendedName((PlayerDisguise)this.getDisguise());
        } else {
            DisguiseUtilities.setGlowColor(this.getDisguise(), this.getGlowColor());
        }
    }

    public boolean isInvisible() {
        return this.getEntityFlag(5);
    }

    public void setInvisible(boolean bl) {
        this.setEntityFlag(5, bl);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isNoGravity() {
        return this.getData(MetaIndex.ENTITY_NO_GRAVITY);
    }

    @RandomDefaultValue
    public void setNoGravity(boolean bl) {
        this.setData(MetaIndex.ENTITY_NO_GRAVITY, bl);
        this.sendData(MetaIndex.ENTITY_NO_GRAVITY);
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    public boolean isRightClicking() {
        return this.isMainHandRaised();
    }

    @Deprecated
    @NmsAddedIn(value=NmsVersion.v1_12)
    public void setRightClicking(boolean bl) {
        this.setMainHandRaised(bl);
    }

    public boolean isMainHandRaised() {
        return !NmsVersion.v1_13.isSupported() && this.getEntityFlag(4);
    }

    public void setMainHandRaised(boolean bl) {
        if (NmsVersion.v1_13.isSupported()) {
            return;
        }
        this.setEntityFlag(4, bl);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public boolean isSneaking() {
        return this.getEntityFlag(1);
    }

    public void setSneaking(boolean bl) {
        this.setEntityFlag(1, bl);
        this.sendData(MetaIndex.ENTITY_META);
        if (this.getDisguise().isPlayerDisguise()) {
            this.updateNameHeight();
        }
        if (NmsVersion.v1_14.isSupported()) {
            this.updatePose();
        }
    }

    public boolean isSprinting() {
        return this.getEntityFlag(3);
    }

    public void setSprinting(boolean bl) {
        this.setEntityFlag(3, bl);
        this.sendData(MetaIndex.ENTITY_META);
    }

    public void rebuildWatchableObjects() {
        this.watchableObjects = new ArrayList<WrappedWatchableObject>();
        for (int i = 0; i <= 31; ++i) {
            WrappedWatchableObject wrappedWatchableObject;
            if (this.entityValues.containsKey(i) && this.entityValues.get(i) != null) {
                wrappedWatchableObject = ReflectionManager.createWatchable(MetaIndex.getMetaIndex(this, i), this.entityValues.get(i));
            } else {
                if (!this.backupEntityValues.containsKey(i) || this.backupEntityValues.get(i) == null) continue;
                wrappedWatchableObject = ReflectionManager.createWatchable(MetaIndex.getMetaIndex(this, i), this.backupEntityValues.get(i));
            }
            if (wrappedWatchableObject == null) continue;
            this.watchableObjects.add(wrappedWatchableObject);
        }
    }

    protected void sendData(MetaIndex ... packetContainer) {
        Object object;
        if (this.getDisguise() == null || !DisguiseAPI.isDisguiseInUse(this.getDisguise()) || this.getDisguise().getWatcher() != this) {
            return;
        }
        ArrayList<WrappedWatchableObject> arrayList = new ArrayList<WrappedWatchableObject>();
        for (PacketContainer metaIndex : packetContainer) {
            WrappedWatchableObject wrappedWatchableObject;
            if (metaIndex == null || !this.entityValues.containsKey(metaIndex.getIndex()) || this.entityValues.get(metaIndex.getIndex()) == null) continue;
            object = this.entityValues.get(metaIndex.getIndex());
            if (this.isEntityAnimationsAdded() && DisguiseConfig.isMetaPacketsEnabled() && (metaIndex == MetaIndex.ENTITY_META || metaIndex == MetaIndex.LIVING_META)) {
                object = this.addEntityAnimations((MetaIndex)metaIndex, (Byte)object, WrappedDataWatcher.getEntityWatcher((Entity)this.disguise.getEntity()).getByte(0));
            }
            if ((wrappedWatchableObject = ReflectionManager.createWatchable((MetaIndex)metaIndex, object)) == null) continue;
            arrayList.add(wrappedWatchableObject);
        }
        if (!arrayList.isEmpty()) {
            PacketContainer packetContainer2 = new PacketContainer(PacketType.Play.Server.ENTITY_METADATA);
            StructureModifier structureModifier = packetContainer2.getModifier();
            structureModifier.write(0, (Object)this.getDisguise().getEntity().getEntityId());
            packetContainer2.getWatchableCollectionModifier().write(0, arrayList);
            for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
                try {
                    if (player == this.getDisguise().getEntity()) {
                        object = packetContainer2.shallowClone();
                        object.getIntegers().write(0, (Object)DisguiseAPI.getSelfDisguiseId());
                        ProtocolLibrary.getProtocolManager().sendServerPacket(player, (PacketContainer)object);
                        continue;
                    }
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer2);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        }
    }

    public boolean isAddEntityAnimations() {
        return this.isEntityAnimationsAdded();
    }

    public void setAddEntityAnimations(boolean bl) {
        this.addEntityAnimations = bl;
    }

    protected void setBackupValue(MetaIndex metaIndex, Object object) {
        if (metaIndex == null) {
            return;
        }
        this.backupEntityValues.put(metaIndex.getIndex(), object);
    }

    private boolean getEntityFlag(int n) {
        return (this.getData(MetaIndex.ENTITY_META) & 1 << n) != 0;
    }

    private void setEntityFlag(int n, boolean bl) {
        this.modifiedEntityAnimations[n] = true;
        byte by = this.getData(MetaIndex.ENTITY_META);
        if (bl) {
            this.setData(MetaIndex.ENTITY_META, (byte)(by | 1 << n));
        } else {
            this.setData(MetaIndex.ENTITY_META, (byte)(by & ~(1 << n)));
        }
    }

    @Deprecated
    public void setItemInHand(ItemStack itemStack) {
        this.setItemInMainHand(itemStack);
    }

    public void setItemStack(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        this.equipment.setItem(equipmentSlot, itemStack);
    }

    protected void sendItemStack(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        if (!DisguiseAPI.isDisguiseInUse(this.getDisguise()) || this.getDisguise().getWatcher() != this || this.getDisguise().getEntity() == null) {
            return;
        }
        if (itemStack == null && this.getDisguise().getEntity() instanceof LivingEntity) {
            itemStack = ReflectionManager.getEquipment(equipmentSlot, this.getDisguise().getEntity());
        }
        Object object = ReflectionManager.getNmsItem(itemStack);
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.ENTITY_EQUIPMENT);
        StructureModifier structureModifier = packetContainer.getModifier();
        structureModifier.write(0, (Object)this.getDisguise().getEntity().getEntityId());
        if (NmsVersion.v1_16.isSupported()) {
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            arrayList.add(Pair.of((Object)ReflectionManager.createEnumItemSlot(equipmentSlot), (Object)object));
            structureModifier.write(1, arrayList);
        } else {
            structureModifier.write(1, (Object)ReflectionManager.createEnumItemSlot(equipmentSlot));
            structureModifier.write(2, object);
        }
        for (Player player : DisguiseUtilities.getPerverts(this.getDisguise())) {
            try {
                ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public boolean isSleeping() {
        return this.sleeping;
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setSleeping(boolean bl) {
        if (this.isSleeping() == bl) {
            return;
        }
        this.sleeping = bl;
        this.updatePose();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public boolean isSwimming() {
        return this.getEntityFlag(4);
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    public void setSwimming(boolean bl) {
        if (this.isSwimming() == bl) {
            return;
        }
        this.setEntityFlag(4, bl);
        this.updatePose();
    }

    @NmsAddedIn(value=NmsVersion.v1_14)
    protected void updatePose() {
        if (this.isSleeping()) {
            this.setEntityPose(EntityPose.SLEEPING);
        } else if (this.isSwimming()) {
            this.setEntityPose(EntityPose.SWIMMING);
        } else if (this.isSneaking()) {
            this.setEntityPose(EntityPose.SNEAKING);
        } else {
            this.setEntityPose(EntityPose.STANDING);
        }
    }

    @Deprecated
    public <Y> void setUnsafeData(MetaIndex<Y> metaIndex, Y y) {
        this.setData(metaIndex, y);
    }

    protected <Y> void setData(MetaIndex<Y> metaIndex, Y y) {
        if (metaIndex == null) {
            return;
        }
        if (metaIndex.getIndex() == -1) {
            throw new IllegalArgumentException("You can't do that in this version of Minecraft! I can't use " + MetaIndex.getName(metaIndex) + "!");
        }
        if (y == null && metaIndex.getDefault() instanceof ItemStack) {
            throw new IllegalArgumentException("Cannot use null ItemStacks");
        }
        this.entityValues.put(metaIndex.getIndex(), y);
        if (!DisguiseConfig.isMetaPacketsEnabled()) {
            this.rebuildWatchableObjects();
        }
    }

    protected HashMap<Integer, Object> getBackupEntityValues() {
        return this.backupEntityValues;
    }

    protected HashMap<Integer, Object> getEntityValues() {
        return this.entityValues;
    }

    public boolean[] getModifiedEntityAnimations() {
        return this.modifiedEntityAnimations;
    }

    public boolean isUpsideDown() {
        return this.upsideDown;
    }

    public Float getPitchLock() {
        return this.pitchLock;
    }

    public Float getYawLock() {
        return this.yawLock;
    }

    public float getYModifier() {
        return this.yModifier;
    }
}

