/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.disguisetypes;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.DisguiseRunnable;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AbstractHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import me.libraryaddict.disguise.events.DisguiseEvent;
import me.libraryaddict.disguise.events.UndisguiseEvent;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.DisguiseValues;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.parser.RandomDefaultValue;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Disguise {
    private transient boolean disguiseInUse;
    private DisguiseType disguiseType;
    private transient BukkitRunnable runnable;
    private transient Entity entity;
    private boolean hearSelfDisguise = DisguiseConfig.isSelfDisguisesSoundsReplaced();
    private boolean hideArmorFromSelf = DisguiseConfig.isHidingArmorFromSelf();
    private boolean hideHeldItemFromSelf = DisguiseConfig.isHidingHeldItemFromSelf();
    private boolean keepDisguisePlayerDeath = DisguiseConfig.isKeepDisguiseOnPlayerDeath();
    private boolean modifyBoundingBox = DisguiseConfig.isModifyBoundingBox();
    private boolean playerHiddenFromTab = DisguiseConfig.isHideDisguisedPlayers();
    private boolean replaceSounds = DisguiseConfig.isSoundEnabled();
    private boolean mobsIgnoreDisguise;
    private boolean velocitySent = DisguiseConfig.isVelocitySent();
    private boolean viewSelfDisguise = DisguiseConfig.isViewDisguises() && DisguiseConfig.isViewSelfDisguisesDefault();
    private DisguiseConfig.NotifyBar notifyBar = DisguiseConfig.getNotifyBar();
    private BarColor bossBarColor = DisguiseConfig.getBossBarColor();
    private BarStyle bossBarStyle = DisguiseConfig.getBossBarStyle();
    private final NamespacedKey bossBar = new NamespacedKey("libsdisguises", UUID.randomUUID().toString());
    private FlagWatcher watcher;
    protected long disguiseExpires;
    private final LinkedHashMap<String, Object> customData = new LinkedHashMap();
    private String disguiseName;
    private boolean customDisguiseName = true;
    private boolean tallDisguisesVisible = DisguiseConfig.isTallSelfDisguises();
    private String[] multiName = new String[0];
    private transient int[] armorstandIds = new int[0];
    private boolean dynamicName;
    private String soundGroup;
    private UUID uuid = ReflectionManager.getRandomUUID();

    public Disguise(DisguiseType disguiseType) {
        this.disguiseType = disguiseType;
        this.disguiseName = disguiseType.toReadable();
    }

    public HashMap<String, Object> getCustomData() {
        return this.customData;
    }

    public UUID getUUID() {
        if (this.uuid == null) {
            this.uuid = ReflectionManager.getRandomUUID();
        }
        return this.uuid;
    }

    public int getMultiNameLength() {
        return this.multiName.length;
    }

    @RandomDefaultValue
    public void setDisguiseName(String string) {
        this.disguiseName = string;
    }

    private int[] getInternalArmorstandIds() {
        if (this.armorstandIds == null) {
            this.armorstandIds = new int[0];
        }
        return this.armorstandIds;
    }

    public String[] getMultiName() {
        return DisguiseUtilities.reverse(this.multiName);
    }

    public void setMultiName(String ... stringArray) {
        if (stringArray.length == 1 && stringArray[0].isEmpty()) {
            stringArray = new String[]{};
        }
        stringArray = DisguiseUtilities.reverse(stringArray);
        Object[] objectArray = this.multiName;
        this.multiName = stringArray;
        if (Arrays.equals(objectArray, stringArray)) {
            return;
        }
        if (!this.isDisguiseInUse()) {
            return;
        }
        this.sendArmorStands((String[])objectArray);
    }

    public abstract double getHeight();

    protected void sendArmorStands(String[] stringArray) {
        if (!this.isDisguiseInUse()) {
            return;
        }
        ArrayList<PacketContainer> arrayList = DisguiseUtilities.getNamePackets(this, stringArray);
        try {
            for (Player player : DisguiseUtilities.getPerverts(this)) {
                if (this.isPlayerDisguise() && LibsDisguises.getInstance().getSkinHandler().isSleeping(player, (PlayerDisguise)this)) continue;
                for (PacketContainer packetContainer : arrayList) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public int[] getArmorstandIds() {
        if (this.getMultiNameLength() > this.getInternalArmorstandIds().length) {
            int n = this.armorstandIds.length;
            this.armorstandIds = Arrays.copyOf(this.armorstandIds, this.getMultiNameLength());
            for (int i = n; i < this.armorstandIds.length; ++i) {
                this.armorstandIds[i] = ReflectionManager.getNewEntityId();
            }
        }
        return this.armorstandIds;
    }

    public void addCustomData(String string, Object object) {
        this.customData.put(string, object);
    }

    public boolean hasCustomData(String string) {
        return this.customData.containsKey(string);
    }

    public Object getCustomData(String string) {
        return this.customData.get(string);
    }

    public abstract Disguise clone();

    protected void clone(Disguise disguise) {
        disguise.setDisguiseName(this.getDisguiseName());
        disguise.setCustomDisguiseName(this.isCustomDisguiseName());
        disguise.setTallDisguisesVisible(this.isTallDisguisesVisible());
        disguise.setReplaceSounds(this.isSoundsReplaced());
        disguise.setViewSelfDisguise(this.isSelfDisguiseVisible());
        disguise.setHearSelfDisguise(this.isSelfDisguiseSoundsReplaced());
        disguise.setHideArmorFromSelf(this.isHidingArmorFromSelf());
        disguise.setHideHeldItemFromSelf(this.isHidingHeldItemFromSelf());
        disguise.setVelocitySent(this.isVelocitySent());
        disguise.setModifyBoundingBox(this.isModifyBoundingBox());
        disguise.multiName = Arrays.copyOf(this.multiName, this.multiName.length);
        disguise.setDynamicName(this.isDynamicName());
        disguise.setSoundGroup(this.getSoundGroup());
        disguise.notifyBar = this.getNotifyBar();
        disguise.bossBarColor = this.getBossBarColor();
        disguise.bossBarStyle = this.getBossBarStyle();
        disguise.setExpires(this.getExpires());
        if (this.getWatcher() != null) {
            disguise.setWatcher(this.getWatcher().clone(disguise));
        }
        disguise.createDisguise();
    }

    protected void createDisguise() {
        if (this.getType().getEntityType() == null) {
            throw new RuntimeException("DisguiseType " + (Object)((Object)this.getType()) + " was used in a futile attempt to construct a disguise, but this Minecraft version does not have that entity");
        }
        boolean bl = true;
        if (this instanceof MobDisguise) {
            bl = ((MobDisguise)this).isAdult();
        }
        if (this.getWatcher() == null) {
            try {
                this.setWatcher(this.getType().getWatcherClass().getConstructor(Disguise.class).newInstance(this));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.getWatcher().getDisguise() != this) {
            this.getWatcher().setDisguise((TargetedDisguise)this);
        }
        if (!bl) {
            if (this.getWatcher() instanceof AgeableWatcher) {
                ((AgeableWatcher)this.getWatcher()).setBaby(true);
            } else if (this.getWatcher() instanceof ZombieWatcher) {
                ((ZombieWatcher)this.getWatcher()).setBaby(true);
            }
        }
    }

    public boolean isDisguiseExpired() {
        return DisguiseConfig.isDynamicExpiry() ? this.disguiseExpires == 1L : this.disguiseExpires > 0L && this.disguiseExpires < System.currentTimeMillis();
    }

    public long getExpires() {
        return this.disguiseExpires;
    }

    public void setExpires(long l) {
        this.disguiseExpires = l;
        if (this.isDisguiseExpired()) {
            this.removeDisguise();
        }
    }

    private void removeBossBar() {
        KeyedBossBar keyedBossBar = Bukkit.getBossBar((NamespacedKey)this.getBossBar());
        if (keyedBossBar == null) {
            return;
        }
        keyedBossBar.removeAll();
        Bukkit.removeBossBar((NamespacedKey)this.getBossBar());
    }

    public void setNotifyBar(DisguiseConfig.NotifyBar notifyBar) {
        if (this.getNotifyBar() == notifyBar) {
            return;
        }
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.BOSS_BAR) {
            this.removeBossBar();
        }
        this.notifyBar = notifyBar;
        this.makeBossBar();
    }

    public void setBossBarColor(BarColor barColor) {
        if (this.getBossBarColor() == barColor) {
            return;
        }
        this.bossBarColor = barColor;
        this.makeBossBar();
    }

    public void setBossBarStyle(BarStyle barStyle) {
        if (this.getBossBarStyle() == barStyle) {
            return;
        }
        this.bossBarStyle = barStyle;
        this.makeBossBar();
    }

    public void setBossBar(BarColor barColor, BarStyle barStyle) {
        this.bossBarColor = barColor;
        this.bossBarStyle = barStyle;
        this.setNotifyBar(DisguiseConfig.NotifyBar.BOSS_BAR);
    }

    private void makeBossBar() {
        if (this.getNotifyBar() != DisguiseConfig.NotifyBar.BOSS_BAR || !NmsVersion.v1_13.isSupported() || !(this.getEntity() instanceof Player)) {
            return;
        }
        if (this.getEntity().hasPermission("libsdisguises.noactionbar") || DisguiseAPI.getDisguise(this.getEntity()) != this) {
            return;
        }
        this.removeBossBar();
        KeyedBossBar keyedBossBar = Bukkit.createBossBar((NamespacedKey)this.getBossBar(), (String)BaseComponent.toLegacyText((BaseComponent[])LibsMsg.ACTION_BAR_MESSAGE.getBase(this.getDisguiseName())), (BarColor)this.getBossBarColor(), (BarStyle)this.getBossBarStyle(), (BarFlag[])new BarFlag[0]);
        keyedBossBar.setProgress(1.0);
        keyedBossBar.addPlayer((Player)this.getEntity());
    }

    public boolean isUpsideDown() {
        return this.getWatcher().isUpsideDown();
    }

    public Disguise setUpsideDown(boolean bl) {
        this.getWatcher().setUpsideDown(bl);
        return this;
    }

    protected void doActionBar() {
        if (this.getNotifyBar() == DisguiseConfig.NotifyBar.ACTION_BAR && this.getEntity() instanceof Player && !this.getEntity().hasPermission("libsdisguises.noactionbar") && DisguiseAPI.getDisguise(this.getEntity()) == this) {
            ((Player)this.getEntity()).spigot().sendMessage(ChatMessageType.ACTION_BAR, LibsMsg.ACTION_BAR_MESSAGE.getBase(this.getDisguiseName()));
        }
        if (this.isDynamicName()) {
            String string = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (string == null) {
                string = "";
            }
            if (this.isPlayerDisguise()) {
                if (!((PlayerDisguise)this).getName().equals(string)) {
                    ((PlayerDisguise)this).setName(string);
                }
            } else {
                this.getWatcher().setCustomName(string);
            }
        }
    }

    private void createRunnable() {
        if (this.runnable != null && !this.runnable.isCancelled()) {
            this.runnable.cancel();
        }
        TargetedDisguise targetedDisguise = (TargetedDisguise)this;
        this.runnable = new DisguiseRunnable(this);
        this.runnable.runTaskTimer((Plugin)LibsDisguises.getInstance(), 1L, 1L);
    }

    public Entity getEntity() {
        return this.entity;
    }

    public Disguise setEntity(Entity entity) {
        DisguiseValues disguiseValues;
        if (this.getEntity() != null) {
            if (this.getEntity() == entity) {
                return this;
            }
            throw new RuntimeException("This disguise is already in use! Try .clone()");
        }
        if (this.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
            throw new RuntimeException("Cannot disguise a living entity with a misc disguise. Reenable MiscDisguisesForLiving in the config to do this");
        }
        this.entity = entity;
        if (entity != null) {
            this.setupWatcher();
        }
        if (this.getEntity() instanceof Player && this.isSelfDisguiseVisible() && !this.isTallDisguisesVisible() && !this.getType().isCustom() && (disguiseValues = DisguiseValues.getDisguiseValues(this.getType())) != null) {
            FakeBoundingBox fakeBoundingBox = null;
            if (this.isMobDisguise() && !((MobDisguise)this).isAdult()) {
                fakeBoundingBox = disguiseValues.getBabyBox();
            }
            if (fakeBoundingBox == null) {
                fakeBoundingBox = disguiseValues.getAdultBox();
            }
            if (fakeBoundingBox != null && fakeBoundingBox.getY() > 1.7) {
                this.setSelfDisguiseVisible(false);
            }
        }
        return this;
    }

    public DisguiseType getType() {
        return this.disguiseType;
    }

    public FlagWatcher getWatcher() {
        return this.watcher;
    }

    @Deprecated
    public Disguise setWatcher(FlagWatcher flagWatcher) {
        if (!this.getType().getWatcherClass().isInstance(flagWatcher)) {
            throw new IllegalArgumentException((flagWatcher == null ? "null" : flagWatcher.getClass().getSimpleName()) + " is not a instance of " + this.getType().getWatcherClass().getSimpleName() + " for DisguiseType " + this.getType().name());
        }
        this.watcher = flagWatcher;
        if (this.getEntity() != null) {
            this.setupWatcher();
        }
        return this;
    }

    public boolean isDisguiseInUse() {
        return this.disguiseInUse;
    }

    public boolean isHidePlayer() {
        return this.playerHiddenFromTab;
    }

    public void setHidePlayer(boolean bl) {
        if (this.isDisguiseInUse()) {
            throw new IllegalStateException("Cannot set this while disguise is in use!");
        }
        this.playerHiddenFromTab = bl;
    }

    @Deprecated
    public boolean isHidingArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    @Deprecated
    public boolean isHidingHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public boolean isHideArmorFromSelf() {
        return this.hideArmorFromSelf;
    }

    public Disguise setHideArmorFromSelf(boolean bl) {
        this.hideArmorFromSelf = bl;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public boolean isHideHeldItemFromSelf() {
        return this.hideHeldItemFromSelf;
    }

    public Disguise setHideHeldItemFromSelf(boolean bl) {
        this.hideHeldItemFromSelf = bl;
        if (this.getEntity() instanceof Player) {
            ((Player)this.getEntity()).updateInventory();
        }
        return this;
    }

    public boolean isKeepDisguiseOnPlayerDeath() {
        return this.keepDisguisePlayerDeath;
    }

    public Disguise setKeepDisguiseOnPlayerDeath(boolean bl) {
        this.keepDisguisePlayerDeath = bl;
        return this;
    }

    public boolean isMiscDisguise() {
        return false;
    }

    public boolean isMobDisguise() {
        return false;
    }

    public boolean isModifyBoundingBox() {
        return this.modifyBoundingBox;
    }

    public Disguise setModifyBoundingBox(boolean bl) {
        if (this.isModifyBoundingBox() != bl) {
            this.modifyBoundingBox = bl;
            if (DisguiseUtilities.isDisguiseInUse(this)) {
                DisguiseUtilities.doBoundingBox((TargetedDisguise)this);
            }
        }
        return this;
    }

    public boolean isPlayerDisguise() {
        return false;
    }

    public boolean isCustomDisguise() {
        return false;
    }

    public boolean isRemoveDisguiseOnDeath() {
        return this.getEntity() == null || (this.getEntity() instanceof Player ? !this.isKeepDisguiseOnPlayerDeath() : this.getEntity().isDead() || !this.getEntity().isValid());
    }

    @Deprecated
    public boolean isSelfDisguiseSoundsReplaced() {
        return this.hearSelfDisguise;
    }

    public boolean isSelfDisguiseVisible() {
        return DisguiseConfig.isViewDisguises() && this.viewSelfDisguise;
    }

    public void setSelfDisguiseVisible(boolean bl) {
        this.setViewSelfDisguise(bl);
    }

    public boolean isSoundsReplaced() {
        return this.replaceSounds;
    }

    public boolean isVelocitySent() {
        return this.velocitySent;
    }

    public Disguise setVelocitySent(boolean bl) {
        this.velocitySent = bl;
        return this;
    }

    public boolean removeDisguise() {
        return this.removeDisguise(false);
    }

    public boolean removeDisguise(CommandSender commandSender) {
        return this.removeDisguise(commandSender, false);
    }

    public boolean removeDisguise(boolean bl) {
        return this.removeDisguise(null, bl);
    }

    public boolean removeDisguise(CommandSender commandSender, boolean bl) {
        Object object;
        PlayerInfoData playerInfoData;
        if (!this.isDisguiseInUse()) {
            return false;
        }
        UndisguiseEvent undisguiseEvent = new UndisguiseEvent(commandSender, this.entity, this, bl);
        Bukkit.getPluginManager().callEvent((Event)undisguiseEvent);
        if (undisguiseEvent.isCancelled() && this.getEntity() != null && Bukkit.getWorlds().contains(this.getEntity().getWorld()) && (!(this.getEntity() instanceof Player) || ((Player)this.getEntity()).isOnline())) {
            return false;
        }
        this.disguiseInUse = false;
        if (this.runnable != null) {
            this.runnable.cancel();
            this.runnable = null;
        }
        if (this.getEntity() == null) {
            HashMap<Integer, HashSet<TargetedDisguise>> hashMap = DisguiseUtilities.getFutureDisguises();
            DisguiseUtilities.getFutureDisguises().keySet().removeIf(n -> ((HashSet)hashMap.get(n)).remove(this) && ((HashSet)hashMap.get(n)).isEmpty());
            return true;
        }
        if (this instanceof PlayerDisguise && (playerInfoData = (PlayerInfoData)this).isDisplayedInTab()) {
            object = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            object.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            object.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(playerInfoData.getGameProfile(), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)playerInfoData.getProfileName()))));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, (PacketContainer)object);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        if (this.getInternalArmorstandIds().length > 0) {
            try {
                playerInfoData = DisguiseUtilities.getDestroyPacket(this.getInternalArmorstandIds());
                for (Object object2 : this.getEntity().getWorld().getPlayers()) {
                    ProtocolLibrary.getProtocolManager().sendServerPacket((Player)object2, (PacketContainer)playerInfoData);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        if (!this.isPlayerDisguise()) {
            DisguiseUtilities.setGlowColor(this, null);
        }
        if (DisguiseUtilities.removeDisguise((TargetedDisguise)this) && !bl) {
            if (this.getEntity() instanceof Player) {
                DisguiseUtilities.removeSelfDisguise(this);
            }
            if (this.getEntity().isValid()) {
                DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
            } else {
                DisguiseUtilities.destroyEntity((TargetedDisguise)this);
            }
        }
        if (this.isHidePlayer() && this.getEntity() instanceof Player && ((Player)this.getEntity()).isOnline()) {
            playerInfoData = new PlayerInfoData(ReflectionManager.getGameProfile((Player)this.getEntity()), 0, EnumWrappers.NativeGameMode.fromBukkit((GameMode)((Player)this.getEntity()).getGameMode()), WrappedChatComponent.fromText((String)DisguiseUtilities.getPlayerListName((Player)this.getEntity())));
            object = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            object.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            object.getPlayerInfoDataLists().write(0, Collections.singletonList(playerInfoData));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, (PacketContainer)object);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        for (Player player : new PlayerInfoData[]{"LastDisguise", "LD-LastAttacked", "forge_mods", "LibsRabbitHop", "ld_loggedin"}) {
            this.getEntity().removeMetadata((String)player, (Plugin)LibsDisguises.getInstance());
        }
        if (DisguiseConfig.getPvPTimer() > 0.0 && this.getEntity() instanceof Player) {
            this.getEntity().setMetadata("LastDisguise", (MetadataValue)new FixedMetadataValue((Plugin)LibsDisguises.getInstance(), (Object)System.currentTimeMillis()));
        }
        if (NmsVersion.v1_13.isSupported()) {
            this.removeBossBar();
        }
        return true;
    }

    public boolean isHearSelfDisguise() {
        return this.hearSelfDisguise;
    }

    public Disguise setHearSelfDisguise(boolean bl) {
        this.hearSelfDisguise = bl;
        return this;
    }

    public Disguise setReplaceSounds(boolean bl) {
        this.replaceSounds = bl;
        return this;
    }

    private void setupWatcher() {
        if (this.getWatcher() == null) {
            this.createDisguise();
        }
        ArrayList<MetaIndex> arrayList = MetaIndex.getMetaIndexes(this.getType().getWatcherClass());
        ArrayList<MetaIndex> arrayList2 = MetaIndex.getMetaIndexes(DisguiseType.getType(this.getEntity().getType()).getWatcherClass());
        for (MetaIndex metaIndex : arrayList2) {
            if (arrayList.contains(metaIndex)) continue;
            MetaIndex metaIndex2 = null;
            for (MetaIndex metaIndex3 : arrayList) {
                if (metaIndex3.getIndex() != metaIndex.getIndex()) continue;
                metaIndex2 = metaIndex3;
            }
            this.getWatcher().setBackupValue(metaIndex, metaIndex2 == null ? null : metaIndex2.getDefault());
        }
        if (this.getEntity() instanceof Player && !this.getWatcher().hasCustomName()) {
            this.getWatcher().setCustomName("");
            this.getWatcher().setCustomNameVisible(false);
        }
        if ((this.getEntity() instanceof Boat || this.getEntity() instanceof AbstractHorse) && (this.getWatcher() instanceof BoatWatcher || this.getWatcher() instanceof AbstractHorseWatcher)) {
            this.getWatcher().setNoGravity(!this.getEntity().hasGravity());
        } else {
            this.getWatcher().setNoGravity(true);
        }
    }

    @Deprecated
    public Disguise setViewSelfDisguise(boolean bl) {
        if (this.isSelfDisguiseVisible() == bl || !DisguiseConfig.isViewDisguises()) {
            return this;
        }
        this.viewSelfDisguise = bl;
        if (this.getEntity() != null && this.getEntity() instanceof Player && DisguiseAPI.getDisguise((Player)this.getEntity(), this.getEntity()) == this) {
            if (this.isSelfDisguiseVisible()) {
                DisguiseUtilities.setupFakeDisguise(this);
            } else {
                DisguiseUtilities.removeSelfDisguise(this);
            }
        }
        return this;
    }

    public boolean startDisguise() {
        return this.startDisguise(null);
    }

    public boolean startDisguise(CommandSender commandSender) {
        Object object2;
        if (this.isDisguiseInUse() || this.isDisguiseExpired()) {
            return false;
        }
        if (this.getEntity() == null) {
            throw new IllegalStateException("No entity is assigned to this disguise!");
        }
        if (this.multiName == null) {
            this.multiName = new String[0];
        }
        if (LibsPremium.getUserID().equals("12345") || !LibsMsg.OWNED_BY.getRaw().contains("'")) {
            ((TargetedDisguise)this).setDisguiseTarget(TargetedDisguise.TargetType.HIDE_DISGUISE_TO_EVERYONE_BUT_THESE_PLAYERS);
            if (this.getEntity() instanceof Player) {
                ((TargetedDisguise)this).addPlayer((Player)this.getEntity());
            }
            for (Object object2 : this.getEntity().getNearbyEntities(4.0, 4.0, 4.0)) {
                if (!(object2 instanceof Player)) continue;
                ((TargetedDisguise)this).addPlayer((Player)object2);
            }
        }
        DisguiseUtilities.setPluginsUsed();
        DisguiseEvent disguiseEvent = new DisguiseEvent(commandSender, this.entity, this);
        Bukkit.getPluginManager().callEvent((Event)disguiseEvent);
        if (disguiseEvent.isCancelled()) {
            return false;
        }
        this.disguiseInUse = true;
        if (!DisguiseUtilities.isInvalidFile()) {
            this.createRunnable();
        }
        if (this instanceof PlayerDisguise && ((PlayerDisguise)(object2 = (PlayerDisguise)this)).isDisplayedInTab()) {
            PacketContainer packetContainer = DisguiseUtilities.getTabPacket((PlayerDisguise)object2, EnumWrappers.PlayerInfoAction.ADD_PLAYER);
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, packetContainer);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        DisguiseUtilities.addDisguise(this.entity.getEntityId(), (TargetedDisguise)this);
        if (!this.isPlayerDisguise()) {
            DisguiseUtilities.setGlowColor(this, this.getWatcher().getGlowColor());
        }
        if (this.isSelfDisguiseVisible() && this.getEntity() instanceof Player) {
            DisguiseUtilities.removeSelfDisguise(this);
        }
        DisguiseUtilities.refreshTrackers((TargetedDisguise)this);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)LibsDisguises.getInstance(), new Runnable(){

            @Override
            public void run() {
                DisguiseUtilities.setupFakeDisguise(Disguise.this);
            }
        }, 2L);
        if (this.isHidePlayer() && this.getEntity() instanceof Player) {
            object2 = new PacketContainer(PacketType.Play.Server.PLAYER_INFO);
            object2.getPlayerInfoAction().write(0, (Object)EnumWrappers.PlayerInfoAction.REMOVE_PLAYER);
            object2.getPlayerInfoDataLists().write(0, Collections.singletonList(new PlayerInfoData(ReflectionManager.getGameProfile((Player)this.getEntity()), 0, EnumWrappers.NativeGameMode.SURVIVAL, WrappedChatComponent.fromText((String)""))));
            try {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!((TargetedDisguise)this).canSee(player)) continue;
                    ProtocolLibrary.getProtocolManager().sendServerPacket(player, (PacketContainer)object2);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        if (!this.entity.isOp() && new Random().nextBoolean() && (!LibsMsg.OWNED_BY.getRaw().contains("'") || "802393".equals("12345"))) {
            this.setExpires(DisguiseConfig.isDynamicExpiry() ? 4800L : System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(330L));
        }
        if (this.isDynamicName()) {
            object2 = this.getEntity() instanceof Player ? DisguiseUtilities.translateAlternateColorCodes(DisguiseUtilities.getDisplayName((CommandSender)this.getEntity())) : this.getEntity().getCustomName();
            if (object2 == null) {
                object2 = "";
            }
            this.getWatcher().setCustomName((String)object2);
        }
        this.makeBossBar();
        return true;
    }

    public boolean stopDisguise() {
        return this.removeDisguise();
    }

    public boolean isMobsIgnoreDisguise() {
        return this.mobsIgnoreDisguise;
    }

    public void setMobsIgnoreDisguise(boolean bl) {
        this.mobsIgnoreDisguise = bl;
    }

    public DisguiseConfig.NotifyBar getNotifyBar() {
        return this.notifyBar;
    }

    public BarColor getBossBarColor() {
        return this.bossBarColor;
    }

    public BarStyle getBossBarStyle() {
        return this.bossBarStyle;
    }

    private NamespacedKey getBossBar() {
        return this.bossBar;
    }

    public String getDisguiseName() {
        return this.disguiseName;
    }

    public boolean isCustomDisguiseName() {
        return this.customDisguiseName;
    }

    public void setCustomDisguiseName(boolean bl) {
        this.customDisguiseName = bl;
    }

    public boolean isTallDisguisesVisible() {
        return this.tallDisguisesVisible;
    }

    public void setTallDisguisesVisible(boolean bl) {
        this.tallDisguisesVisible = bl;
    }

    public boolean isDynamicName() {
        return this.dynamicName;
    }

    public void setDynamicName(boolean bl) {
        this.dynamicName = bl;
    }

    public String getSoundGroup() {
        return this.soundGroup;
    }

    public void setSoundGroup(String string) {
        this.soundGroup = string;
    }
}

