/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class DisguiseHelpCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        for (String string2 : DisguiseHelpCommand.getCommandNames().values()) {
            Object object;
            DisguisePermissions disguisePermissions = DisguiseParser.getPermissions(commandSender, string2);
            if (!disguisePermissions.hasPermissions()) continue;
            if (stringArray.length == 0) {
                this.sendCommandUsage(commandSender, null);
                return true;
            }
            ParamInfo paramInfo = null;
            for (ParamInfo object22 : ParamInfoManager.getParamInfos()) {
                object = object22.getName().replaceAll(" ", "");
                if (!stringArray[0].equalsIgnoreCase((String)object) && !stringArray[0].equalsIgnoreCase((String)object + "s")) continue;
                paramInfo = object22;
                break;
            }
            if (paramInfo != null) {
                if (paramInfo.hasValues() && paramInfo.canTranslateValues()) {
                    LibsMsg.DHELP_HELP4.send(commandSender, paramInfo.getName(), StringUtils.join(paramInfo.getEnums(""), (String)LibsMsg.DHELP_HELP4_SEPERATOR.get(new Object[0])));
                } else if (!paramInfo.getName().equals(paramInfo.getDescriptiveName())) {
                    LibsMsg.DHELP_HELP6.send(commandSender, paramInfo.getName(), paramInfo.getDescriptiveName(), paramInfo.getDescription());
                } else {
                    LibsMsg.DHELP_HELP5.send(commandSender, paramInfo.getName(), paramInfo.getDescription());
                }
                return true;
            }
            DisguisePerm disguisePerm = DisguiseParser.getDisguisePerm(stringArray[0]);
            if (disguisePerm == null) {
                LibsMsg.DHELP_CANTFIND.send(commandSender, stringArray[0]);
                return true;
            }
            if (!disguisePermissions.isAllowedDisguise(disguisePerm)) {
                LibsMsg.NO_PERM_DISGUISE.send(commandSender, new Object[0]);
                return true;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            object = disguisePerm.getWatcherClass();
            int n = 0;
            try {
                for (WatcherMethod watcherMethod : ParamInfoManager.getDisguiseWatcherMethods((Class<? extends FlagWatcher>)object)) {
                    if (!(stringArray.length >= 2 && stringArray[1].equalsIgnoreCase(LibsMsg.DHELP_SHOW.get(new Object[0])) || disguisePermissions.isAllowedDisguise(disguisePerm, Collections.singleton(watcherMethod.getName().toLowerCase(Locale.ENGLISH))))) {
                        ++n;
                        continue;
                    }
                    ParamInfo paramInfo2 = ParamInfoManager.getParamInfo(watcherMethod);
                    int n2 = ParamInfoManager.getValue(watcherMethod);
                    ChatColor chatColor = ChatColor.YELLOW;
                    if (n2 == 1) {
                        chatColor = ChatColor.AQUA;
                    } else if (n2 == 2) {
                        chatColor = ChatColor.GRAY;
                    }
                    String string3 = TranslateType.DISGUISE_OPTIONS.get(watcherMethod.getName()) + ChatColor.DARK_RED + "(" + ChatColor.GREEN + paramInfo2.getName() + ChatColor.DARK_RED + ")";
                    arrayList.add(chatColor + string3);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (arrayList.isEmpty()) {
                arrayList.add(LibsMsg.DHELP_NO_OPTIONS.get(new Object[0]));
            }
            LibsMsg.DHELP_OPTIONS.send(commandSender, ChatColor.DARK_RED + disguisePerm.toReadable(), StringUtils.join(arrayList, (String)(ChatColor.DARK_RED + ", ")));
            if (n > 0) {
                LibsMsg.NO_PERMS_USE_OPTIONS.send(commandSender, n);
            }
            return true;
        }
        LibsMsg.NO_PERM.send(commandSender, new Object[0]);
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getPreviousArgs(stringArray);
        for (String string2 : DisguiseHelpCommand.getCommandNames().values()) {
            DisguisePermissions disguisePermissions = DisguiseParser.getPermissions(commandSender, string2);
            if (stringArray2.length == 0) {
                for (DisguisePerm disguisePerm : disguisePermissions.getAllowed()) {
                    if (disguisePerm.isUnknown()) continue;
                    arrayList.add(disguisePerm.toReadable().replaceAll(" ", "_"));
                }
                for (ParamInfo paramInfo : ParamInfoManager.getParamInfos()) {
                    arrayList.add(paramInfo.getName().replaceAll(" ", ""));
                }
                continue;
            }
            if (DisguiseParser.getDisguisePerm(stringArray2[0]) != null) continue;
            arrayList.add(LibsMsg.DHELP_SHOW.get(new Object[0]));
        }
        return this.filterTabs(arrayList, stringArray);
    }

    @Override
    protected void sendCommandUsage(CommandSender commandSender, DisguisePermissions disguisePermissions) {
        LibsMsg.DHELP_HELP1.send(commandSender, new Object[0]);
        LibsMsg.DHELP_HELP2.send(commandSender, new Object[0]);
        for (ParamInfo paramInfo : ParamInfoManager.getParamInfos()) {
            LibsMsg.DHELP_HELP3.send(commandSender, paramInfo.getName().replaceAll(" ", "") + (!paramInfo.getName().equals(paramInfo.getDescriptiveName()) ? " ~ " + paramInfo.getDescriptiveName() : ""), paramInfo.getDescription());
        }
    }
}

