/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.modify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyRadiusCommand
extends DisguiseBaseCommand
implements TabCompleter {
    private Collection<Entity> getNearbyEntities(CommandSender commandSender, int n) {
        Location location = commandSender instanceof Player ? ((Player)commandSender).getLocation() : ((BlockCommandSender)commandSender).getBlock().getLocation().add(0.5, 0.0, 0.5);
        return location.getWorld().getNearbyEntities(location, (double)n, (double)n, (double)n);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender.getName().equals("CONSOLE")) {
            LibsMsg.NO_CONSOLE.send(commandSender, new Object[0]);
            return true;
        }
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (!disguisePermissions.hasPermissions()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return true;
        }
        if (stringArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        if (stringArray[0].equalsIgnoreCase(TranslateType.DISGUISES.get("DisguiseType")) || stringArray[0].equalsIgnoreCase(TranslateType.DISGUISES.get("DisguiseType") + "s")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DisguiseType disguiseType : DisguiseType.values()) {
                if (disguiseType.getEntityType() == null) continue;
                arrayList.add(disguiseType.toReadable());
            }
            Collections.sort(arrayList);
            LibsMsg.DMODRADIUS_USABLE.send(commandSender, ChatColor.GREEN + StringUtils.join(arrayList, (String)(ChatColor.DARK_GREEN + ", " + ChatColor.GREEN)));
            return true;
        }
        DisguiseType disguiseType = null;
        int n = 0;
        if (!this.isInteger(stringArray[0])) {
            for (DisguiseType disguiseType2 : DisguiseType.values()) {
                if (disguiseType2.getEntityType() == null || !disguiseType2.toReadable().replaceAll(" ", "").equalsIgnoreCase(stringArray[0].replaceAll("_", ""))) continue;
                disguiseType = disguiseType2;
                n = 1;
                break;
            }
            if (disguiseType == null) {
                LibsMsg.DMODRADIUS_UNRECOGNIZED.send(commandSender, stringArray[0]);
                return true;
            }
        }
        if (stringArray.length == n + 1) {
            if (n == 0) {
                LibsMsg.DMODRADIUS_NEEDOPTIONS.send(commandSender, new Object[0]);
            } else {
                LibsMsg.DMODRADIUS_NEEDOPTIONS_ENTITY.send(commandSender, new Object[0]);
            }
            return true;
        }
        if (stringArray.length < 2) {
            LibsMsg.DMODRADIUS_NEEDOPTIONS.send(commandSender, new Object[0]);
            return true;
        }
        if (!this.isInteger(stringArray[n])) {
            LibsMsg.NOT_NUMBER.send(commandSender, stringArray[n]);
            return true;
        }
        int n2 = Integer.parseInt(stringArray[n]);
        if (n2 > DisguiseConfig.getDisguiseRadiusMax()) {
            LibsMsg.LIMITED_RADIUS.send(commandSender, DisguiseConfig.getDisguiseRadiusMax());
            n2 = DisguiseConfig.getDisguiseRadiusMax();
        }
        Object[] objectArray = new String[stringArray.length - (n + 1)];
        System.arraycopy(stringArray, n + 1, objectArray, 0, objectArray.length);
        if (objectArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        int n3 = 0;
        int n4 = 0;
        String[] stringArray2 = DisguiseUtilities.split(StringUtils.join((Object[])objectArray, (String)" "));
        for (Entity entity : this.getNearbyEntities(commandSender, n2)) {
            Disguise disguise;
            if (entity == commandSender || disguiseType != null && !disguiseType.name().equalsIgnoreCase(entity.getType().name()) || (disguise = commandSender instanceof Player ? DisguiseAPI.getDisguise((Player)commandSender, entity) : DisguiseAPI.getDisguise(entity)) == null) continue;
            DisguisePerm disguisePerm = new DisguisePerm(disguise.getType());
            if (!disguisePermissions.isAllowedDisguise(disguisePerm)) {
                ++n4;
                continue;
            }
            String[] stringArray3 = Arrays.copyOf(stringArray2, stringArray2.length);
            stringArray3 = DisguiseParser.parsePlaceholders(stringArray3, commandSender, (CommandSender)entity);
            try {
                DisguiseParser.callMethods(commandSender, disguise, disguisePermissions, disguisePerm, new ArrayList<String>(), stringArray3, "DisguiseModifyRadius");
                ++n3;
            }
            catch (DisguiseParseException disguiseParseException) {
                disguiseParseException.send(commandSender);
                return true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return true;
            }
        }
        if (n4 > 0) {
            LibsMsg.DMODRADIUS_NOPERM.send(commandSender, n4);
        }
        if (n3 > 0) {
            LibsMsg.DMODRADIUS.send(commandSender, n3);
        } else {
            LibsMsg.DMODRADIUS_NOENTS.send(commandSender, new Object[0]);
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getPreviousArgs(stringArray);
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (stringArray2.length == 0) {
            for (DisguiseType disguiseType : DisguiseType.values()) {
                if (disguiseType.getEntityType() == null) continue;
                arrayList.add(disguiseType.toReadable().replaceAll(" ", "_"));
            }
            return this.filterTabs(arrayList, stringArray);
        }
        int n = 0;
        if (!this.isInteger(stringArray2[0])) {
            for (DisguiseType disguiseType : DisguiseType.values()) {
                if (disguiseType.getEntityType() == null || !disguiseType.toReadable().replaceAll(" ", "").equalsIgnoreCase(stringArray2[0].replaceAll("_", ""))) continue;
                n = 2;
                break;
            }
            if (n == 1 || stringArray2.length == 1 || !this.isInteger(stringArray2[1])) {
                return this.filterTabs(arrayList, stringArray);
            }
        }
        if (stringArray2.length <= n || !this.isInteger(stringArray2[n])) {
            return this.filterTabs(arrayList, stringArray);
        }
        int n2 = Integer.parseInt(stringArray2[n]);
        if (n2 > DisguiseConfig.getDisguiseRadiusMax()) {
            LibsMsg.LIMITED_RADIUS.send(commandSender, DisguiseConfig.getDisguiseRadiusMax());
            n2 = DisguiseConfig.getDisguiseRadiusMax();
        }
        ++n;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Entity entity : this.getNearbyEntities(commandSender, n2)) {
            Disguise disguise = DisguiseAPI.getDisguise(entity);
            if (disguise == null) continue;
            DisguiseType disguiseType = disguise.getType();
            for (WatcherMethod watcherMethod : ParamInfoManager.getDisguiseWatcherMethods(disguiseType.getWatcherClass())) {
                for (String string2 : stringArray2) {
                    if (!watcherMethod.getName().equalsIgnoreCase(string2) || arrayList2.contains(string2)) continue;
                    arrayList2.add(string2);
                }
            }
            DisguisePerm disguisePerm = new DisguisePerm(disguiseType);
            if (!disguisePermissions.isAllowedDisguise(disguisePerm, arrayList2)) continue;
            arrayList.addAll(this.getTabDisguiseSubOptions(commandSender, disguisePermissions, disguisePerm, stringArray2, n, this.getCurrentArg(stringArray2)));
        }
        return this.filterTabs(arrayList, stringArray);
    }

    @Override
    protected void sendCommandUsage(CommandSender commandSender, DisguisePermissions disguisePermissions) {
        ArrayList<String> arrayList = this.getAllowedDisguises(disguisePermissions);
        LibsMsg.DMODRADIUS_HELP1.send(commandSender, DisguiseConfig.getDisguiseRadiusMax());
        LibsMsg.DMODIFY_HELP3.send(commandSender, StringUtils.join(arrayList, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
        LibsMsg.DMODRADIUS_HELP2.send(commandSender, new Object[0]);
        LibsMsg.DMODRADIUS_HELP3.send(commandSender, new Object[0]);
    }
}

