/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.modify;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyPlayerCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (!disguisePermissions.hasPermissions()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return true;
        }
        if (stringArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        Player player = Bukkit.getPlayer((String)stringArray[0]);
        if (player == null && stringArray[0].contains("-")) {
            try {
                player = Bukkit.getEntity((UUID)UUID.fromString(stringArray[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (player == null) {
            LibsMsg.CANNOT_FIND_PLAYER.send(commandSender, stringArray[0]);
            return true;
        }
        Object[] objectArray = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, objectArray, 0, objectArray.length);
        if (objectArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        Disguise disguise = null;
        if (commandSender instanceof Player) {
            disguise = DisguiseAPI.getDisguise((Player)commandSender, (Entity)player);
        }
        if (disguise == null) {
            disguise = DisguiseAPI.getDisguise((Entity)player);
        }
        if (disguise == null) {
            LibsMsg.DMODPLAYER_NODISGUISE.send(commandSender, player.getName());
            return true;
        }
        DisguisePerm disguisePerm = new DisguisePerm(disguise.getType());
        if (!disguisePermissions.isAllowedDisguise(disguisePerm)) {
            LibsMsg.DMODPLAYER_NOPERM.send(commandSender, new Object[0]);
            return true;
        }
        String[] stringArray2 = DisguiseUtilities.split(StringUtils.join((Object[])objectArray, (String)" "));
        stringArray2 = DisguiseParser.parsePlaceholders(stringArray2, commandSender, (CommandSender)player);
        try {
            DisguiseParser.callMethods(commandSender, disguise, disguisePermissions, disguisePerm, new ArrayList<String>(), stringArray2, "DisguiseModifyPlayer");
        }
        catch (DisguiseParseException disguiseParseException) {
            disguiseParseException.send(commandSender);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return true;
        }
        LibsMsg.DMODPLAYER_MODIFIED.send(commandSender, player.getName());
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getPreviousArgs(stringArray);
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (!disguisePermissions.hasPermissions()) {
            return arrayList;
        }
        if (stringArray2.length == 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (commandSender instanceof Player && !((Player)commandSender).canSee(player)) continue;
                arrayList.add(player.getName());
            }
        } else {
            Player player = Bukkit.getPlayer((String)stringArray2[0]);
            if (player == null) {
                return arrayList;
            }
            Disguise disguise = null;
            if (commandSender instanceof Player) {
                disguise = DisguiseAPI.getDisguise((Player)commandSender, (Entity)player);
            }
            if (disguise == null) {
                disguise = DisguiseAPI.getDisguise((Entity)player);
            }
            if (disguise == null) {
                return arrayList;
            }
            DisguisePerm disguisePerm = new DisguisePerm(disguise.getType());
            arrayList.addAll(this.getTabDisguiseOptions(commandSender, disguisePermissions, disguisePerm, stringArray2, 1, this.getCurrentArg(stringArray2)));
        }
        return this.filterTabs(arrayList, stringArray);
    }

    @Override
    protected void sendCommandUsage(CommandSender commandSender, DisguisePermissions disguisePermissions) {
        ArrayList<String> arrayList = this.getAllowedDisguises(disguisePermissions);
        LibsMsg.DMODPLAYER_HELP1.send(commandSender, new Object[0]);
        LibsMsg.DMODIFY_HELP3.send(commandSender, StringUtils.join(arrayList, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
    }
}

