/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.modify;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Entity)) {
            LibsMsg.NO_CONSOLE.send(commandSender, new Object[0]);
            return true;
        }
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (!disguisePermissions.hasPermissions()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return true;
        }
        if (stringArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        Disguise disguise = DisguiseAPI.getDisguise((Player)commandSender, (Entity)commandSender);
        if (disguise == null) {
            LibsMsg.NOT_DISGUISED.send(commandSender, new Object[0]);
            return true;
        }
        DisguisePerm disguisePerm = new DisguisePerm(disguise.getType());
        if (!disguisePermissions.isAllowedDisguise(disguisePerm)) {
            LibsMsg.DMODIFY_NO_PERM.send(commandSender, new Object[0]);
            return true;
        }
        String[] stringArray2 = DisguiseUtilities.split(StringUtils.join((Object[])stringArray, (String)" "));
        stringArray2 = DisguiseParser.parsePlaceholders(stringArray2, commandSender, commandSender);
        try {
            DisguiseParser.callMethods(commandSender, disguise, disguisePermissions, disguisePerm, new ArrayList<String>(), stringArray2, "DisguiseModify");
        }
        catch (DisguiseParseException disguiseParseException) {
            disguiseParseException.send(commandSender);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return true;
        }
        LibsMsg.DMODIFY_MODIFIED.send(commandSender, new Object[0]);
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return new ArrayList<String>();
        }
        Disguise disguise = DisguiseAPI.getDisguise((Player)commandSender, (Entity)commandSender);
        if (disguise == null) {
            return new ArrayList<String>();
        }
        String[] stringArray2 = this.getPreviousArgs(stringArray);
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        DisguisePerm disguisePerm = new DisguisePerm(disguise.getType());
        List<String> list = this.getTabDisguiseOptions(commandSender, disguisePermissions, disguisePerm, stringArray2, 0, this.getCurrentArg(stringArray));
        return this.filterTabs(list, stringArray);
    }

    @Override
    protected void sendCommandUsage(CommandSender commandSender, DisguisePermissions disguisePermissions) {
        ArrayList<String> arrayList = this.getAllowedDisguises(disguisePermissions);
        LibsMsg.DMODIFY_HELP1.send(commandSender, new Object[0]);
        LibsMsg.DMODIFY_HELP2.send(commandSender, new Object[0]);
        LibsMsg.DMODIFY_HELP3.send(commandSender, StringUtils.join(arrayList, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
    }
}

