/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HttpsURLConnection;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.config.ConfigLoader;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LDUploadLogs
implements LDCommand {
    private long lastUsed;

    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("uploadlog", "uploadlogs", "uploadconfig", "uploadconfigs", "logs", "log");
    }

    @Override
    public boolean hasPermission(CommandSender commandSender) {
        return commandSender.isOp();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public void onCommand(final CommandSender commandSender, String[] stringArray) {
        if (this.lastUsed + TimeUnit.MINUTES.toMillis(3L) > System.currentTimeMillis()) {
            commandSender.sendMessage(ChatColor.RED + "You last used this command under 3 minutes ago! Restart the server or wait for this timer to disappear!");
            return;
        }
        File file = new File("logs/latest.log");
        final File file2 = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
        List list = new ConfigLoader().getConfigs().stream().map(string -> new File(LibsDisguises.getInstance().getDataFolder(), (String)string)).collect(Collectors.toList());
        final StringBuilder stringBuilder = new StringBuilder();
        for (File file3 : list) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n\n================\n\n");
            }
            try {
                String string2 = new String(Files.readAllBytes(file3.toPath()));
                string2 = string2.replaceAll("\n? *#[^\n]*", "").replaceAll("[\n\r]+", "\n");
                stringBuilder.append("File: ").append(file3.getName()).append("\n\n").append(string2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (this.isTooBig(file)) {
            commandSender.sendMessage(ChatColor.RED + "Your latest.log file is too big! It should be less than 512kb! Please restart and run this command again!");
            return;
        }
        if (this.isTooBig(file2)) {
            commandSender.sendMessage(ChatColor.RED + "Your disguises.yml is too big! You'll need to trim that file down before using this command! It should be less than 512kb!");
            return;
        }
        try {
            int n;
            final String string3 = new String(Files.readAllBytes(file.toPath()));
            boolean bl = false;
            int n2 = 0;
            for (int i = 0; i < 15 && (n = string3.indexOf("\n", n2)) != -1; ++i) {
                String string4 = string3.substring(n2, n);
                n2 = n + 2;
                if (!string4.contains("Starting minecraft server version") && !string4.contains("Loading properties") && !string4.contains("This server is running")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                commandSender.sendMessage(ChatColor.RED + "Your latest.log is too old! Please restart the server and try again!");
                return;
            }
            commandSender.sendMessage(ChatColor.GOLD + "Now creating pastebin links...");
            new BukkitRunnable(){

                public void run() {
                    try {
                        String string = new String(Files.readAllBytes(file2.toPath()));
                        stringBuilder.append("\n\n================\n");
                        ArrayList<String> arrayList = DisguiseConfig.doOutput(true, true);
                        for (String object2 : arrayList) {
                            stringBuilder.append("\n").append(object2);
                        }
                        if (arrayList.isEmpty()) {
                            stringBuilder.append("\nUsing default config!");
                        }
                        final URL uRL = new GuestPaste("latest.log", string3).paste();
                        final URL uRL2 = new GuestPaste("LibsDisguises config.yml", stringBuilder.toString()).paste();
                        final URL uRL3 = new GuestPaste("LibsDisguises disguises.yml", string).paste();
                        LDUploadLogs.this.lastUsed = System.currentTimeMillis();
                        new BukkitRunnable(){

                            public void run() {
                                commandSender.sendMessage(ChatColor.GOLD + "Upload successful!");
                                if (commandSender instanceof Player) {
                                    commandSender.sendMessage(ChatColor.GOLD + "Click on the below message to have it appear in your chat input");
                                }
                                String string = "My log file: " + uRL + ", my combined config files: " + uRL2 + " and my disguises file: " + uRL3;
                                ComponentBuilder componentBuilder = new ComponentBuilder("");
                                componentBuilder.append(string);
                                componentBuilder.color(net.md_5.bungee.api.ChatColor.AQUA);
                                componentBuilder.event(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, string));
                                commandSender.spigot().sendMessage(componentBuilder.create());
                            }
                        }.runTask((Plugin)LibsDisguises.getInstance());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        commandSender.sendMessage(ChatColor.RED + "Unexpected error! Upload failed! " + exception.getMessage());
                    }
                }
            }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean isTooBig(File file) {
        return file.exists() && this.isTooBig(file.length());
    }

    private boolean isTooBig(long l) {
        return l >= 524288L;
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_UPLOAD_LOGS;
    }

    public class GuestPaste {
        private String name = null;
        private final String text;

        public GuestPaste(String string, String string2) {
            this.name = string;
            this.text = string2;
        }

        public URL paste() {
            URL uRL = new URL("https://pastebin.com/api/api_post.php");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setRequestProperty("User-Agent", "Mozilla/5.0");
            LinkedList<AbstractMap.SimpleEntry<String, String>> linkedList = new LinkedList<AbstractMap.SimpleEntry<String, String>>();
            if (this.getClass().getName().contains("me.libraryaddict")) {
                linkedList.add(new AbstractMap.SimpleEntry<String, String>("api_dev_key", "62067f9dcc1979a475105b529eb453a5"));
            }
            linkedList.add(new AbstractMap.SimpleEntry<String, String>("api_option", "paste"));
            linkedList.add(new AbstractMap.SimpleEntry<String, String>("api_paste_name", this.name));
            linkedList.add(new AbstractMap.SimpleEntry<String, String>("api_paste_code", this.text));
            linkedList.add(new AbstractMap.SimpleEntry<String, String>("api_paste_format", "text"));
            linkedList.add(new AbstractMap.SimpleEntry<String, String>("api_paste_expire_date", "1M"));
            linkedList.add(new AbstractMap.SimpleEntry<String, String>("api_paste_private", "1"));
            StringBuilder stringBuilder = new StringBuilder();
            for (AbstractMap.SimpleEntry object : linkedList) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('&');
                }
                stringBuilder.append(URLEncoder.encode((String)object.getKey(), "UTF-8"));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode((String)object.getValue(), "UTF-8"));
            }
            httpsURLConnection.setDoOutput(true);
            try (DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());){
                dataOutputStream.writeBytes(stringBuilder.toString());
                dataOutputStream.flush();
            }
            int n = httpsURLConnection.getResponseCode();
            if (n >= 200 && n < 300) {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));){
                    String string;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder2.append(string);
                    }
                    URL uRL2 = new URL(stringBuilder2.toString());
                    return uRL2;
                }
            }
            throw new IllegalStateException("Unexpected response code " + n);
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof GuestPaste)) {
                return false;
            }
            GuestPaste guestPaste = (GuestPaste)object;
            if (!guestPaste.canEqual(this)) {
                return false;
            }
            String string = this.getName();
            String string2 = guestPaste.getName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            String string3 = this.getText();
            String string4 = guestPaste.getText();
            return !(string3 == null ? string4 != null : !string3.equals(string4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof GuestPaste;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            String string = this.getName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            String string2 = this.getText();
            n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
            return n2;
        }

        public String toString() {
            return "LDUploadLogs.GuestPaste(name=" + this.getName() + ", text=" + this.getText() + ")";
        }
    }
}

