/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.Arrays;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.plugin.PluginInformation;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LDUpdate
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("update", "update dev", "update release", "update!");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.update";
    }

    @Override
    public void onCommand(final CommandSender commandSender, String[] stringArray) {
        final UpdateChecker updateChecker = LibsDisguises.getInstance().getUpdateChecker();
        if (updateChecker.isDownloading()) {
            LibsMsg.UPDATE_IN_PROGRESS.send(commandSender, new Object[0]);
            return;
        }
        boolean bl = updateChecker.isUsingReleaseBuilds();
        if (stringArray.length > 1) {
            boolean bl2 = bl;
            if (stringArray[1].equalsIgnoreCase("dev")) {
                bl = false;
            } else if (stringArray[1].equalsIgnoreCase("release")) {
                bl = true;
            } else {
                LibsMsg.LIBS_UPDATE_UNKNOWN_BRANCH.send(commandSender, new Object[0]);
                return;
            }
            DisguiseConfig.setUsingReleaseBuilds(bl);
        }
        new BukkitRunnable(){

            public void run() {
                LibsMsg libsMsg = updateChecker.doUpdateCheck();
                if (updateChecker.getUpdate() == null) {
                    LibsMsg.UPDATE_FAILED.send(commandSender, new Object[0]);
                    return;
                }
                if (updateChecker.isOnLatestUpdate(true)) {
                    if (updateChecker.getLastDownload() != null) {
                        LibsMsg.UPDATE_ALREADY_DOWNLOADED.send(commandSender, new Object[0]);
                    } else {
                        LibsMsg.UPDATE_ON_LATEST.send(commandSender, new Object[0]);
                    }
                    return;
                }
                PluginInformation pluginInformation = updateChecker.doUpdate();
                if (pluginInformation == null) {
                    LibsMsg.UPDATE_FAILED.send(commandSender, new Object[0]);
                    return;
                }
                for (String string : updateChecker.getUpdateMessage()) {
                    DisguiseUtilities.sendMessage(commandSender, string);
                }
                if (commandSender instanceof Player) {
                    for (String string : updateChecker.getUpdateMessage()) {
                        DisguiseUtilities.getLogger().info(string);
                    }
                }
            }
        }.runTaskAsynchronously((Plugin)LibsDisguises.getInstance());
    }

    @Override
    public boolean hasPermission(CommandSender commandSender) {
        return commandSender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_UPDATE;
    }
}

