/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.disguisetypes.MetaIndex;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.CommandSender;

public class LDMetaInfo
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Arrays.asList("metainfo", "metadata", "metadatainfo", "metaindex");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.metainfo";
    }

    @Override
    public void onCommand(CommandSender commandSender, String[] stringArray) {
        if (stringArray.length > 1) {
            MetaIndex metaIndex = MetaIndex.getMetaIndexByName(stringArray[1]);
            if (metaIndex == null) {
                LibsMsg.META_NOT_FOUND.send(commandSender, new Object[0]);
                return;
            }
            commandSender.sendMessage(metaIndex.toString());
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (MetaIndex metaIndex : MetaIndex.values()) {
                arrayList.add(MetaIndex.getName(metaIndex));
            }
            arrayList.sort(String::compareToIgnoreCase);
            ComponentBuilder componentBuilder = new ComponentBuilder("").append(LibsMsg.META_VALUES.getBase(new Object[0]));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                componentBuilder.append(TextComponent.fromLegacyText((String)string));
                componentBuilder.event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/libsdisguises metainfo " + string));
                componentBuilder.event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, LibsMsg.META_CLICK_SHOW.getBase(string)));
                if (!iterator.hasNext()) continue;
                componentBuilder.append(LibsMsg.META_VALUE_SEPERATOR.getBase(new Object[0]));
            }
            commandSender.spigot().sendMessage(componentBuilder.create());
        }
    }

    @Override
    public boolean hasPermission(CommandSender commandSender) {
        return commandSender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_METAINFO;
    }
}

