/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.TargetedDisguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.command.CommandSender;

public class LDCount
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Collections.singletonList("count");
    }

    @Override
    public String getPermission() {
        return "libsdisguises.count";
    }

    @Override
    public void onCommand(CommandSender commandSender, String[] stringArray) {
        HashMap<DisguiseType, Integer> hashMap = new HashMap<DisguiseType, Integer>();
        for (Set<TargetedDisguise> object : DisguiseUtilities.getDisguises().values()) {
            for (Disguise disguise : object) {
                hashMap.compute(disguise.getType(), (disguiseType, n) -> (n != null ? n : 0) + 1);
            }
        }
        if (hashMap.isEmpty()) {
            LibsMsg.NO_DISGUISES_IN_USE.send(commandSender, new Object[0]);
        } else {
            LibsMsg.ACTIVE_DISGUISES_COUNT.send(commandSender, hashMap.values().stream().reduce(Integer::sum).get());
            ArrayList arrayList = new ArrayList(hashMap.keySet());
            arrayList.sort((disguiseType, disguiseType2) -> String.CASE_INSENSITIVE_ORDER.compare(TranslateType.DISGUISES.get(disguiseType.toReadable()), TranslateType.DISGUISES.get(disguiseType2.toReadable())));
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuilder.append(LibsMsg.ACTIVE_DISGUISES_DISGUISE.get(TranslateType.DISGUISES.get(((DisguiseType)((Object)arrayList.get(i))).toReadable()), hashMap.get(arrayList.get(i))));
                if (i + 1 >= arrayList.size()) continue;
                stringBuilder.append(LibsMsg.ACTIVE_DISGUISES_SEPERATOR.get(new Object[0]));
            }
            LibsMsg.ACTIVE_DISGUISES.send(commandSender, stringBuilder.toString());
        }
    }

    @Override
    public boolean hasPermission(CommandSender commandSender) {
        return commandSender.hasPermission(this.getPermission());
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_COUNT;
    }
}

