/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.libsdisguises;

import java.util.Collections;
import java.util.List;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.libsdisguises.LDCommand;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.updates.UpdateChecker;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class LDChangelog
implements LDCommand {
    @Override
    public List<String> getTabComplete() {
        return Collections.singletonList("changelog");
    }

    @Override
    public boolean hasPermission(CommandSender commandSender) {
        return commandSender.hasPermission(this.getPermission());
    }

    @Override
    public String getPermission() {
        return "libsdisguises.update";
    }

    @Override
    public void onCommand(CommandSender commandSender, String[] stringArray) {
        UpdateChecker updateChecker = LibsDisguises.getInstance().getUpdateChecker();
        if (updateChecker.isDownloading()) {
            LibsMsg.UPDATE_IN_PROGRESS.send(commandSender, new Object[0]);
            return;
        }
        if (updateChecker.getUpdate() == null) {
            LibsMsg.UPDATE_REQUIRED.send(commandSender, new Object[0]);
            return;
        }
        if (!updateChecker.getUpdate().isReleaseBuild()) {
            commandSender.sendMessage(ChatColor.GOLD + "You are on build " + (LibsDisguises.getInstance().isNumberedBuild() ? "#" : "") + LibsDisguises.getInstance().getBuildNo());
        }
        for (String string : updateChecker.getUpdate().getChangelog()) {
            commandSender.sendMessage(ChatColor.GOLD + string);
        }
    }

    @Override
    public LibsMsg getHelp() {
        return LibsMsg.LD_COMMAND_CHANGELOG;
    }
}

