/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.interactions;

import java.util.ArrayList;
import java.util.Arrays;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseModifyInteraction
implements LibsEntityInteract {
    private String[] options;

    @Override
    public void onInteract(Player player, Entity entity) {
        DisguisePerm disguisePerm;
        String string = entity instanceof Player ? entity.getName() : DisguiseType.getType(entity).toReadable();
        Disguise disguise = DisguiseAPI.getDisguise(player, entity);
        if (disguise == null) {
            LibsMsg.UNDISG_PLAYER_FAIL.send((CommandSender)player, string);
            return;
        }
        this.options = DisguiseParser.parsePlaceholders(this.options, (CommandSender)player, (CommandSender)entity);
        DisguisePermissions disguisePermissions = DisguiseParser.getPermissions((CommandSender)player, "disguiseentitymodify");
        if (!disguisePermissions.isAllowedDisguise(disguisePerm = new DisguisePerm(disguise.getType()), Arrays.asList(this.options))) {
            LibsMsg.DMODPLAYER_NOPERM.send((CommandSender)player, new Object[0]);
            return;
        }
        try {
            DisguiseParser.callMethods((CommandSender)player, disguise, disguisePermissions, disguisePerm, new ArrayList<String>(Arrays.asList(this.options)), this.options, "DisguiseModifyEntity");
            LibsMsg.LISTENER_MODIFIED_DISG.send((CommandSender)player, new Object[0]);
        }
        catch (DisguiseParseException disguiseParseException) {
            disguiseParseException.send((CommandSender)player);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public DisguiseModifyInteraction(String[] stringArray) {
        this.options = stringArray;
    }
}

