/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.interactions;

import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsEntityInteract;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DisguiseEntityInteraction
implements LibsEntityInteract {
    private String[] disguiseArgs;

    @Override
    public void onInteract(Player player, Entity entity) {
        Disguise disguise;
        String string = entity instanceof Player ? entity.getName() : DisguiseType.getType(entity).toReadable();
        try {
            disguise = DisguiseParser.parseDisguise((CommandSender)player, entity, "disguiseentity", this.disguiseArgs, DisguiseParser.getPermissions((CommandSender)player, "disguiseentity"));
        }
        catch (DisguiseParseException disguiseParseException) {
            disguiseParseException.send((CommandSender)player);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
            LibsMsg.DISABLED_LIVING_TO_MISC.send((CommandSender)player, new Object[0]);
        } else {
            if (entity instanceof Player && DisguiseConfig.isNameOfPlayerShownAboveDisguise() && !entity.hasPermission("libsdisguises.hidename") && disguise.getWatcher() instanceof LivingWatcher) {
                disguise.getWatcher().setCustomName(this.getDisplayName((CommandSender)entity));
                if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                    disguise.getWatcher().setCustomNameVisible(true);
                }
            }
            DisguiseAPI.disguiseEntity((CommandSender)player, entity, disguise);
            String string2 = disguise.getDisguiseName();
            if (disguise.isDisguiseInUse()) {
                if (disguise.isPlayerDisguise()) {
                    if (entity instanceof Player) {
                        LibsMsg.LISTEN_ENTITY_PLAYER_DISG_PLAYER.send((CommandSender)player, string, string2);
                    } else {
                        LibsMsg.LISTEN_ENTITY_ENTITY_DISG_PLAYER.send((CommandSender)player, string, string2);
                    }
                } else if (entity instanceof Player) {
                    LibsMsg.LISTEN_ENTITY_PLAYER_DISG_ENTITY.send((CommandSender)player, string, string2);
                } else {
                    LibsMsg.LISTEN_ENTITY_ENTITY_DISG_ENTITY.send((CommandSender)player, string, string2);
                }
            } else if (disguise.isPlayerDisguise()) {
                if (entity instanceof Player) {
                    LibsMsg.LISTEN_ENTITY_PLAYER_DISG_PLAYER_FAIL.send((CommandSender)player, string, string2);
                } else {
                    LibsMsg.LISTEN_ENTITY_ENTITY_DISG_PLAYER_FAIL.send((CommandSender)player, string, string2);
                }
            } else if (entity instanceof Player) {
                LibsMsg.LISTEN_ENTITY_PLAYER_DISG_ENTITY_FAIL.send((CommandSender)player, string, string2);
            } else {
                LibsMsg.LISTEN_ENTITY_ENTITY_DISG_ENTITY_FAIL.send((CommandSender)player, string, string2);
            }
        }
    }

    protected String getDisplayName(CommandSender commandSender) {
        String string = DisguiseConfig.getNameAboveDisguise().replace("%simple%", commandSender.getName());
        if (string.contains("%complex%")) {
            string = string.replace("%complex%", DisguiseUtilities.getDisplayName(commandSender));
        }
        return DisguiseUtilities.translateAlternateColorCodes(string);
    }

    public DisguiseEntityInteraction(String[] stringArray) {
        this.disguiseArgs = stringArray;
    }
}

