/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.disguise;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DisguiseRadiusCommand
extends DisguiseBaseCommand
implements TabCompleter {
    private ArrayList<Class<? extends Entity>> validClasses = new ArrayList();

    public DisguiseRadiusCommand() {
        for (EntityType entityType : EntityType.values()) {
            for (Class clazz = entityType.getEntityClass(); clazz != null && Entity.class.isAssignableFrom(clazz) && !this.validClasses.contains(clazz); clazz = clazz.getSuperclass()) {
                this.validClasses.add(clazz);
            }
        }
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (this.isNotPremium(commandSender)) {
            return true;
        }
        if (commandSender.getName().equals("CONSOLE")) {
            LibsMsg.NO_CONSOLE.send(commandSender, new Object[0]);
            return true;
        }
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (!disguisePermissions.hasPermissions()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return true;
        }
        if (stringArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        if (this.hasHitRateLimit(commandSender)) {
            return true;
        }
        if (stringArray[0].equalsIgnoreCase(TranslateType.DISGUISES.get("EntityType")) || stringArray[0].equalsIgnoreCase(TranslateType.DISGUISES.get("EntityType") + "s")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Class<? extends Entity> clazz : this.validClasses) {
                arrayList.add(TranslateType.DISGUISES.get(clazz.getSimpleName()));
            }
            Collections.sort(arrayList);
            LibsMsg.DRADIUS_ENTITIES.send(commandSender, ChatColor.GREEN + StringUtils.join(arrayList, (String)(ChatColor.DARK_GREEN + ", " + ChatColor.GREEN)));
            return true;
        }
        Class<Entity> clazz = Entity.class;
        EntityType entityType = null;
        int n = 0;
        if (!this.isInteger(stringArray[0])) {
            for (Class<? extends Entity> objectArray2 : this.validClasses) {
                if (!TranslateType.DISGUISES.get(objectArray2.getSimpleName()).equalsIgnoreCase(stringArray[0])) continue;
                clazz = objectArray2;
                n = 1;
                break;
            }
            if (n == 0) {
                try {
                    entityType = EntityType.valueOf((String)stringArray[0].toUpperCase(Locale.ENGLISH));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (entityType == null) {
                    LibsMsg.DMODRADIUS_UNRECOGNIZED.send(commandSender, stringArray[0]);
                    return true;
                }
            }
        }
        if (stringArray.length == n + 1) {
            if (n == 0) {
                LibsMsg.DRADIUS_NEEDOPTIONS.send(commandSender, new Object[0]);
            } else {
                LibsMsg.DRADIUS_NEEDOPTIONS_ENTITY.send(commandSender, new Object[0]);
            }
            return true;
        }
        if (stringArray.length < 2) {
            LibsMsg.DRADIUS_NEEDOPTIONS.send(commandSender, new Object[0]);
            return true;
        }
        if (!this.isInteger(stringArray[n])) {
            LibsMsg.NOT_NUMBER.send(commandSender, stringArray[n]);
            return true;
        }
        int n2 = Integer.parseInt(stringArray[n]);
        if (n2 > DisguiseConfig.getDisguiseRadiusMax()) {
            LibsMsg.LIMITED_RADIUS.send(commandSender, DisguiseConfig.getDisguiseRadiusMax());
            n2 = DisguiseConfig.getDisguiseRadiusMax();
        }
        Object[] objectArray = new String[stringArray.length - (n + 1)];
        System.arraycopy(stringArray, n + 1, objectArray, 0, objectArray.length);
        if (objectArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        String[] stringArray2 = DisguiseUtilities.split(StringUtils.join((Object[])objectArray, (String)" "));
        try {
            Disguise disguiseParseException = DisguiseParser.parseTestDisguise(commandSender, this.getPermNode(), stringArray2, disguisePermissions);
            int n3 = 0;
            int n4 = 0;
            Location location = commandSender instanceof Player ? ((Player)commandSender).getLocation() : ((BlockCommandSender)commandSender).getBlock().getLocation().add(0.5, 0.0, 0.5);
            for (Entity entity : location.getWorld().getNearbyEntities(location, (double)n2, (double)n2, (double)n2)) {
                if (entity == commandSender || (entityType == null ? !clazz.isAssignableFrom(entity.getClass()) : entity.getType() != entityType)) continue;
                if (disguiseParseException.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled() && entity instanceof LivingEntity) {
                    ++n4;
                    continue;
                }
                Disguise disguise = DisguiseParser.parseDisguise(commandSender, entity, this.getPermNode(), stringArray2, disguisePermissions);
                if (entity instanceof Player && DisguiseConfig.isNameOfPlayerShownAboveDisguise() && !entity.hasPermission("libsdisguises.hidename") && disguise.getWatcher() instanceof LivingWatcher) {
                    disguise.getWatcher().setCustomName(this.getDisplayName((CommandSender)entity));
                    if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                        disguise.getWatcher().setCustomNameVisible(true);
                    }
                }
                disguise.setEntity(entity);
                if (!this.setViewDisguise(stringArray) && DisguiseAPI.hasSelfDisguisePreference(disguise.getEntity()) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewSelfDisguisesDefault()) {
                    disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
                }
                if (!DisguiseAPI.isNotifyBarShown(disguise.getEntity())) {
                    disguise.setNotifyBar(DisguiseConfig.NotifyBar.NONE);
                }
                disguise.startDisguise(commandSender);
                if (!disguise.isDisguiseInUse()) continue;
                ++n3;
            }
            if (n3 > 0) {
                LibsMsg.DISRADIUS.send(commandSender, n3);
            } else {
                LibsMsg.DISRADIUS_FAIL.send(commandSender, new Object[0]);
            }
            if (n4 > 0) {
                LibsMsg.DRADIUS_MISCDISG.send(commandSender, n4);
            }
        }
        catch (DisguiseParseException throwable) {
            throwable.send(commandSender);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return true;
    }

    private boolean setViewDisguise(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.equalsIgnoreCase("setSelfDisguiseVisible")) continue;
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getPreviousArgs(stringArray);
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (stringArray2.length == 0) {
            for (Class<? extends Entity> clazz : this.validClasses) {
                arrayList.add(TranslateType.DISGUISES.get(clazz.getSimpleName()));
            }
            return this.filterTabs(arrayList, stringArray);
        }
        int n = 1;
        if (!this.isInteger(stringArray2[0])) {
            for (Class<? extends Entity> clazz : this.validClasses) {
                if (!TranslateType.DISGUISES.get(clazz.getSimpleName()).equalsIgnoreCase(stringArray2[0])) continue;
                n = 2;
                break;
            }
            if (n == 1 || stringArray2.length == 1 || !this.isInteger(stringArray2[1])) {
                return this.filterTabs(arrayList, stringArray);
            }
        }
        arrayList.addAll(this.getTabDisguiseTypes(commandSender, disguisePermissions, stringArray2, n, this.getCurrentArg(stringArray)));
        return this.filterTabs(arrayList, stringArray);
    }

    @Override
    protected void sendCommandUsage(CommandSender commandSender, DisguisePermissions disguisePermissions) {
        ArrayList<String> arrayList = this.getAllowedDisguises(disguisePermissions);
        if (arrayList.isEmpty()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return;
        }
        LibsMsg.DRADIUS_HELP1.send(commandSender, DisguiseConfig.getDisguiseRadiusMax());
        LibsMsg.CAN_USE_DISGS.send(commandSender, StringUtils.join(arrayList, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
        if (arrayList.contains("player")) {
            LibsMsg.DRADIUS_HELP3.send(commandSender, new Object[0]);
        }
        LibsMsg.DRADIUS_HELP4.send(commandSender, new Object[0]);
        if (arrayList.contains("dropped_item") || arrayList.contains("falling_block")) {
            LibsMsg.DRADIUS_HELP5.send(commandSender, new Object[0]);
        }
        LibsMsg.DRADIUS_HELP6.send(commandSender, new Object[0]);
    }
}

