/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.disguise;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguisePlayerCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Disguise disguise;
        if (this.isNotPremium(commandSender)) {
            return true;
        }
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (!disguisePermissions.hasPermissions()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return true;
        }
        if (stringArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        if (stringArray.length == 1) {
            LibsMsg.DPLAYER_SUPPLY.send(commandSender, new Object[0]);
            return true;
        }
        if (this.hasHitRateLimit(commandSender)) {
            return true;
        }
        Player player = Bukkit.getPlayer((String)stringArray[0]);
        if (player == null && stringArray[0].contains("-")) {
            try {
                player = Bukkit.getEntity((UUID)UUID.fromString(stringArray[0]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (player == null) {
            LibsMsg.CANNOT_FIND_PLAYER.send(commandSender, stringArray[0]);
            return true;
        }
        Object[] objectArray = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, objectArray, 0, objectArray.length);
        if (objectArray.length == 0) {
            this.sendCommandUsage(commandSender, disguisePermissions);
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(commandSender, (Entity)player, this.getPermNode(), DisguiseUtilities.split(StringUtils.join((Object[])objectArray, (String)" ")), disguisePermissions);
        }
        catch (DisguiseParseException disguiseParseException) {
            disguiseParseException.send(commandSender);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return true;
        }
        if (disguise.isMiscDisguise() && !DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            LibsMsg.DISABLED_LIVING_TO_MISC.send(commandSender, new Object[0]);
            return true;
        }
        if (DisguiseConfig.isNameOfPlayerShownAboveDisguise() && !player.hasPermission("libsdisguises.hidename") && disguise.getWatcher() instanceof LivingWatcher) {
            disguise.getWatcher().setCustomName(this.getDisplayName((CommandSender)player));
            if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                disguise.getWatcher().setCustomNameVisible(true);
            }
        }
        disguise.setEntity((Entity)player);
        if (!this.setViewDisguise(stringArray) && DisguiseAPI.hasSelfDisguisePreference(disguise.getEntity()) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewSelfDisguisesDefault()) {
            disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
        }
        if (!DisguiseAPI.isNotifyBarShown(disguise.getEntity())) {
            disguise.setNotifyBar(DisguiseConfig.NotifyBar.NONE);
        }
        disguise.startDisguise(commandSender);
        if (disguise.isDisguiseInUse()) {
            LibsMsg.DISG_PLAYER_AS_DISG.send(commandSender, player instanceof Player ? player.getName() : DisguiseType.getType((Entity)player).toReadable(), disguise.getDisguiseName());
        } else {
            LibsMsg.DISG_PLAYER_AS_DISG_FAIL.send(commandSender, player instanceof Player ? player.getName() : DisguiseType.getType((Entity)player).toReadable(), disguise.getDisguiseName());
        }
        return true;
    }

    private boolean setViewDisguise(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.equalsIgnoreCase("setSelfDisguiseVisible")) continue;
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.getPreviousArgs(stringArray);
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        if (stringArray2.length == 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (commandSender instanceof Player && !((Player)commandSender).canSee(player)) continue;
                arrayList.add(player.getName());
            }
        } else {
            arrayList.addAll(this.getTabDisguiseTypes(commandSender, disguisePermissions, stringArray2, 1, this.getCurrentArg(stringArray)));
        }
        return this.filterTabs(arrayList, stringArray);
    }

    @Override
    protected void sendCommandUsage(CommandSender commandSender, DisguisePermissions disguisePermissions) {
        ArrayList<String> arrayList = this.getAllowedDisguises(disguisePermissions);
        if (arrayList.isEmpty()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return;
        }
        LibsMsg.D_HELP1.send(commandSender, new Object[0]);
        LibsMsg.CAN_USE_DISGS.send(commandSender, StringUtils.join(arrayList, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
        if (arrayList.contains("player")) {
            LibsMsg.D_HELP3.send(commandSender, new Object[0]);
        }
        LibsMsg.D_HELP4.send(commandSender, new Object[0]);
        if (arrayList.contains("dropped_item") || arrayList.contains("falling_block")) {
            LibsMsg.D_HELP5.send(commandSender, new Object[0]);
        }
    }
}

