/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.disguise;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.commands.interactions.DisguiseEntityInteraction;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DisguiseEntityCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Disguise disguise;
        if (this.isNotPremium(commandSender)) {
            return true;
        }
        if (!(commandSender instanceof Player)) {
            LibsMsg.NO_CONSOLE.send(commandSender, new Object[0]);
            return true;
        }
        if (!this.getPermissions(commandSender).hasPermissions()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return true;
        }
        if (stringArray.length == 0) {
            this.sendCommandUsage(commandSender, this.getPermissions(commandSender));
            return true;
        }
        if (this.hasHitRateLimit(commandSender)) {
            return true;
        }
        String[] stringArray2 = DisguiseUtilities.split(StringUtils.join((Object[])stringArray, (String)" "));
        try {
            disguise = DisguiseParser.parseTestDisguise(commandSender, this.getPermNode(), stringArray2, this.getPermissions(commandSender));
        }
        catch (DisguiseParseException disguiseParseException) {
            disguiseParseException.send(commandSender);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return true;
        }
        LibsDisguises.getInstance().getListener().addInteraction(commandSender.getName(), new DisguiseEntityInteraction(stringArray2), DisguiseConfig.getDisguiseEntityExpire());
        LibsMsg.DISG_ENT_CLICK.send(commandSender, DisguiseConfig.getDisguiseEntityExpire(), disguise.getDisguiseName());
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!(commandSender instanceof Player)) {
            return arrayList;
        }
        String[] stringArray2 = this.getPreviousArgs(stringArray);
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        return this.filterTabs(this.getTabDisguiseTypes(commandSender, disguisePermissions, stringArray2, 0, this.getCurrentArg(stringArray)), stringArray);
    }

    @Override
    protected void sendCommandUsage(CommandSender commandSender, DisguisePermissions disguisePermissions) {
        ArrayList<String> arrayList = this.getAllowedDisguises(disguisePermissions);
        if (arrayList.isEmpty()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return;
        }
        LibsMsg.DISG_ENT_HELP1.send(commandSender, new Object[0]);
        LibsMsg.CAN_USE_DISGS.send(commandSender, StringUtils.join(arrayList, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
        if (arrayList.contains("player")) {
            LibsMsg.DISG_ENT_HELP3.send(commandSender, new Object[0]);
        }
        LibsMsg.DISG_ENT_HELP4.send(commandSender, new Object[0]);
        if (arrayList.contains("dropped_item") || arrayList.contains("falling_block")) {
            LibsMsg.DISG_ENT_HELP5.send(commandSender, new Object[0]);
        }
    }
}

