/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands.disguise;

import java.util.ArrayList;
import java.util.List;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.DisguiseBaseCommand;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DisguiseCommand
extends DisguiseBaseCommand
implements TabCompleter {
    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        Disguise disguise;
        if (this.isNotPremium(commandSender)) {
            return true;
        }
        if (!(commandSender instanceof Entity)) {
            LibsMsg.NO_CONSOLE.send(commandSender, new Object[0]);
            return true;
        }
        if (stringArray.length == 0) {
            this.sendCommandUsage(commandSender, this.getPermissions(commandSender));
            return true;
        }
        if (this.hasHitRateLimit(commandSender)) {
            return true;
        }
        try {
            disguise = DisguiseParser.parseDisguise(commandSender, (Entity)commandSender, this.getPermNode(), DisguiseUtilities.split(StringUtils.join((Object[])stringArray, (String)" ")), this.getPermissions(commandSender));
        }
        catch (DisguiseParseException disguiseParseException) {
            disguiseParseException.send(commandSender);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return true;
        }
        if (DisguiseConfig.isNameOfPlayerShownAboveDisguise() && !commandSender.hasPermission("libsdisguises.hidename") && disguise.getWatcher() instanceof LivingWatcher) {
            disguise.getWatcher().setCustomName(this.getDisplayName(commandSender));
            if (DisguiseConfig.isNameAboveHeadAlwaysVisible()) {
                disguise.getWatcher().setCustomNameVisible(true);
            }
        }
        disguise.setEntity((Entity)((Player)commandSender));
        if (!this.setViewDisguise(stringArray) && DisguiseAPI.hasSelfDisguisePreference(disguise.getEntity()) && disguise.isSelfDisguiseVisible() == DisguiseConfig.isViewSelfDisguisesDefault()) {
            disguise.setViewSelfDisguise(!disguise.isSelfDisguiseVisible());
        }
        if (!DisguiseAPI.isNotifyBarShown(disguise.getEntity())) {
            disguise.setNotifyBar(DisguiseConfig.NotifyBar.NONE);
        }
        disguise.startDisguise(commandSender);
        if (disguise.isDisguiseInUse()) {
            LibsMsg.DISGUISED.send(commandSender, disguise.getDisguiseName());
        } else {
            LibsMsg.FAILED_DISGIUSE.send(commandSender, disguise.getDisguiseName());
        }
        return true;
    }

    private boolean setViewDisguise(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.equalsIgnoreCase("setSelfDisguiseVisible")) continue;
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        String[] stringArray2 = this.getPreviousArgs(stringArray);
        DisguisePermissions disguisePermissions = this.getPermissions(commandSender);
        return this.filterTabs(this.getTabDisguiseTypes(commandSender, disguisePermissions, stringArray2, 0, this.getCurrentArg(stringArray)), stringArray);
    }

    @Override
    protected void sendCommandUsage(CommandSender commandSender, DisguisePermissions disguisePermissions) {
        ArrayList<String> arrayList = this.getAllowedDisguises(disguisePermissions);
        if (arrayList.isEmpty()) {
            LibsMsg.NO_PERM.send(commandSender, new Object[0]);
            return;
        }
        LibsMsg.DISG_HELP1.send(commandSender, new Object[0]);
        LibsMsg.CAN_USE_DISGS.send(commandSender, StringUtils.join(arrayList, (String)LibsMsg.CAN_USE_DISGS_SEPERATOR.get(new Object[0])));
        if (arrayList.contains("player")) {
            LibsMsg.DISG_HELP2.send(commandSender, new Object[0]);
        }
        LibsMsg.DISG_HELP3.send(commandSender, new Object[0]);
        if (arrayList.contains("dropped_item") || arrayList.contains("falling_block")) {
            LibsMsg.DISG_HELP4.send(commandSender, new Object[0]);
        }
    }
}

