/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise.commands;

import com.comphenix.protocol.ProtocolLibrary;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.commands.disguise.DisguiseCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseEntityCommand;
import me.libraryaddict.disguise.commands.disguise.DisguisePlayerCommand;
import me.libraryaddict.disguise.commands.disguise.DisguiseRadiusCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyEntityCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyPlayerCommand;
import me.libraryaddict.disguise.commands.modify.DisguiseModifyRadiusCommand;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.params.ParamInfo;
import me.libraryaddict.disguise.utilities.params.ParamInfoManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.parser.DisguisePermissions;
import me.libraryaddict.disguise.utilities.parser.WatcherMethod;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class DisguiseBaseCommand
implements CommandExecutor {
    private static final Map<Class<? extends DisguiseBaseCommand>, String> disguiseCommands;
    private final Cache<UUID, Long> rateLimit = CacheBuilder.newBuilder().expireAfterWrite(500L, TimeUnit.MILLISECONDS).build();

    protected boolean hasHitRateLimit(CommandSender commandSender) {
        if (commandSender.isOp() || !(commandSender instanceof Player) || commandSender.hasPermission("libsdisguises.ratelimitbypass")) {
            return false;
        }
        if (this.rateLimit.getIfPresent((Object)((Player)commandSender).getUniqueId()) != null) {
            LibsMsg.TOO_FAST.send(commandSender, new Object[0]);
            return true;
        }
        this.rateLimit.put((Object)((Player)commandSender).getUniqueId(), (Object)System.currentTimeMillis());
        return false;
    }

    protected boolean isNotPremium(CommandSender commandSender) {
        String string = StringUtils.join((Object[])DisguiseUtilities.getProtocolLibRequiredVersion(), (String)" or build #");
        String string2 = ProtocolLibrary.getPlugin().getDescription().getVersion();
        if (DisguiseUtilities.isProtocolLibOutdated()) {
            DisguiseUtilities.sendProtocolLibUpdateMessage(commandSender, string2, string);
        }
        if (!(!(commandSender instanceof Player) || commandSender.isOp() || LibsPremium.isPremium().booleanValue() && LibsPremium.getPaidInformation() != LibsPremium.getPluginInformation())) {
            commandSender.sendMessage(ChatColor.RED + "This is the free version of Lib's Disguises, player commands are limited to console and Operators only! Purchase the plugin for non-admin usage!");
            return true;
        }
        return false;
    }

    protected List<String> getTabDisguiseTypes(CommandSender commandSender, DisguisePermissions disguisePermissions, String[] stringArray, int n, String string) {
        if (stringArray.length <= n) {
            return this.getAllowedDisguises(disguisePermissions);
        }
        DisguisePerm disguisePerm = DisguiseParser.getDisguisePerm(stringArray[n]);
        if (disguisePerm == null) {
            return new ArrayList<String>();
        }
        if (stringArray.length == n + 1 && disguisePerm.getType() == DisguiseType.PLAYER && !disguisePerm.isCustomDisguise()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (commandSender instanceof Player && !((Player)commandSender).canSee(player)) continue;
                arrayList.add(player.getName());
            }
            return arrayList;
        }
        return this.getTabDisguiseOptions(commandSender, disguisePermissions, disguisePerm, stringArray, n + (disguisePerm.isPlayer() ? 2 : 1), string);
    }

    protected List<String> getTabDisguiseOptions(CommandSender commandSender, DisguisePermissions disguisePermissions, DisguisePerm disguisePerm, String[] stringArray, int n, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        WatcherMethod[] watcherMethodArray = ParamInfoManager.getDisguiseWatcherMethods(disguisePerm.getWatcherClass());
        block0: for (int i = n; i < stringArray.length; ++i) {
            for (WatcherMethod watcherMethod : watcherMethodArray) {
                String string2 = stringArray[i];
                if (!watcherMethod.getName().equalsIgnoreCase(string2)) continue;
                arrayList.add(string2);
                continue block0;
            }
        }
        if (!disguisePermissions.isAllowedDisguise(disguisePerm, arrayList)) {
            return new ArrayList<String>();
        }
        return this.getTabDisguiseSubOptions(commandSender, disguisePermissions, disguisePerm, stringArray, n, string);
    }

    protected List<String> getTabDisguiseSubOptions(CommandSender commandSender, DisguisePermissions disguisePermissions, DisguisePerm disguisePerm, String[] stringArray, int n, String string) {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        ParamInfo paramInfo = null;
        if (stringArray.length == n) {
            if (disguisePerm.getType() == DisguiseType.FALLING_BLOCK) {
                paramInfo = ParamInfoManager.getParamInfoItemBlock();
            } else if (disguisePerm.getType() == DisguiseType.DROPPED_ITEM) {
                paramInfo = ParamInfoManager.getParamInfo(ItemStack.class);
            }
        } else if (stringArray.length > n) {
            WatcherMethod[] watcherMethodArray = stringArray[stringArray.length - 1];
            paramInfo = ParamInfoManager.getParamInfo(disguisePerm, (String)watcherMethodArray);
            if (paramInfo != null && !paramInfo.isParam(Boolean.TYPE)) {
                bl = false;
            }
            if (disguisePerm.getType() == DisguiseType.ENDERMAN && watcherMethodArray.equalsIgnoreCase("setItemInMainHand")) {
                paramInfo = ParamInfoManager.getParamInfoItemBlock();
            }
        }
        if (paramInfo != null) {
            if (paramInfo.hasValues()) {
                arrayList.addAll(paramInfo.getEnums(string));
            } else if (paramInfo.isParam(String.class)) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (commandSender instanceof Player && !((Player)commandSender).canSee(player)) continue;
                    arrayList.add(player.getName());
                }
            }
        }
        if (bl) {
            for (WatcherMethod watcherMethod : ParamInfoManager.getDisguiseWatcherMethods(disguisePerm.getWatcherClass())) {
                if (!disguisePermissions.isAllowedDisguise(disguisePerm, Collections.singletonList(watcherMethod.getName()))) continue;
                arrayList.add(watcherMethod.getName());
            }
        }
        return arrayList;
    }

    protected List<String> filterTabs(List<String> list, String[] stringArray) {
        if (stringArray.length == 0) {
            return list;
        }
        Iterator<String> iterator = list.iterator();
        String string = stringArray[stringArray.length - 1].toLowerCase(Locale.ENGLISH);
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string2.toLowerCase(Locale.ENGLISH).startsWith(string)) continue;
            iterator.remove();
        }
        return new ArrayList<String>(new HashSet<String>(list));
    }

    protected String getDisplayName(CommandSender commandSender) {
        String string = DisguiseConfig.getNameAboveDisguise().replace("%simple%", commandSender.getName());
        if (string.contains("%complex%")) {
            string = string.replace("%complex%", DisguiseUtilities.getDisplayName(commandSender));
        }
        return DisguiseUtilities.translateAlternateColorCodes(string);
    }

    protected ArrayList<String> getAllowedDisguises(DisguisePermissions disguisePermissions) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DisguisePerm disguisePerm : disguisePermissions.getAllowed()) {
            if (disguisePerm.isUnknown()) continue;
            arrayList.add(disguisePerm.toReadable().replaceAll(" ", "_"));
        }
        return arrayList;
    }

    protected String[] getPreviousArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            String string = stringArray[i];
            if (string.trim().isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    protected String getCurrentArg(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        return stringArray[stringArray.length - 1].trim();
    }

    protected static final Map<Class<? extends DisguiseBaseCommand>, String> getCommandNames() {
        return disguiseCommands;
    }

    public final String getPermNode() {
        String string = DisguiseBaseCommand.getCommandNames().get(this.getClass());
        if (string == null) {
            throw new UnsupportedOperationException("Unknown disguise command, perm node not found");
        }
        return string;
    }

    protected DisguisePermissions getPermissions(CommandSender commandSender) {
        return DisguiseParser.getPermissions(commandSender, this.getPermNode());
    }

    protected boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected abstract void sendCommandUsage(CommandSender var1, DisguisePermissions var2);

    static {
        HashMap<Class<? extends DisguiseBaseCommand>, String> hashMap = new HashMap<Class<? extends DisguiseBaseCommand>, String>();
        hashMap.put(DisguiseCommand.class, "Disguise");
        hashMap.put(DisguiseEntityCommand.class, "DisguiseEntity");
        hashMap.put(DisguisePlayerCommand.class, "DisguisePlayer");
        hashMap.put(DisguiseRadiusCommand.class, "DisguiseRadius");
        hashMap.put(DisguiseModifyCommand.class, "DisguiseModify");
        hashMap.put(DisguiseModifyEntityCommand.class, "DisguiseModifyEntity");
        hashMap.put(DisguiseModifyPlayerCommand.class, "DisguiseModifyPlayer");
        hashMap.put(DisguiseModifyRadiusCommand.class, "DisguiseModifyRadius");
        disguiseCommands = hashMap;
    }
}

