/*
 * Decompiled with CFR 0.152.
 */
package me.libraryaddict.disguise;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.LibsDisguises;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.utilities.DisguiseUtilities;
import me.libraryaddict.disguise.utilities.LibsPremium;
import me.libraryaddict.disguise.utilities.config.ConfigLoader;
import me.libraryaddict.disguise.utilities.modded.ModdedEntity;
import me.libraryaddict.disguise.utilities.modded.ModdedManager;
import me.libraryaddict.disguise.utilities.packets.PacketsManager;
import me.libraryaddict.disguise.utilities.parser.DisguiseParseException;
import me.libraryaddict.disguise.utilities.parser.DisguiseParser;
import me.libraryaddict.disguise.utilities.parser.DisguisePerm;
import me.libraryaddict.disguise.utilities.reflection.NmsVersion;
import me.libraryaddict.disguise.utilities.reflection.ReflectionManager;
import me.libraryaddict.disguise.utilities.translations.LibsMsg;
import me.libraryaddict.disguise.utilities.translations.TranslateType;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class DisguiseConfig {
    private static HashMap<DisguisePerm, String> customDisguises = new HashMap();
    private static UpdatesBranch updatesBranch = UpdatesBranch.SAME_BUILDS;
    private static boolean addEntityAnimations;
    private static boolean animationPacketsEnabled;
    private static boolean catDyeable;
    private static boolean collectPacketsEnabled;
    private static boolean disableFriendlyInvisibles;
    private static boolean disabledInvisibility;
    private static boolean disguiseBlownWhenAttacked;
    private static boolean disguiseBlownWhenAttacking;
    private static boolean dynamicExpiry;
    private static boolean entityStatusPacketsEnabled;
    private static boolean equipmentPacketsEnabled;
    private static boolean explicitDisguisePermissions;
    private static boolean hideDisguisedPlayers;
    private static boolean hidingArmorFromSelf;
    private static boolean hidingCreativeEquipmentFromSelf;
    private static boolean hidingHeldItemFromSelf;
    private static boolean horseSaddleable;
    private static boolean keepDisguiseOnPlayerDeath;
    private static boolean llamaCarpetable;
    private static boolean maxHealthDeterminedByDisguisedEntity;
    private static boolean metaPacketsEnabled;
    private static boolean miscDisguisesForLivingEnabled;
    private static boolean modifyBoundingBox;
    private static boolean modifyCollisions;
    private static boolean monstersIgnoreDisguises;
    private static boolean movementPacketsEnabled;
    private static boolean nameAboveHeadAlwaysVisible;
    private static boolean nameOfPlayerShownAboveDisguise;
    private static boolean playerHideArmor;
    private static boolean saveEntityDisguises;
    private static boolean saveGameProfiles;
    private static boolean savePlayerDisguises;
    private static boolean selfDisguisesSoundsReplaced;
    private static boolean sheepDyeable;
    private static boolean showDisguisedPlayersInTab;
    private static boolean stopShulkerDisguisesFromMoving;
    private static boolean undisguiseOnWorldChange;
    private static boolean updateGameProfiles;
    private static boolean useTranslations;
    private static boolean velocitySent;
    private static boolean viewDisguises;
    private static boolean warnScoreboardConflict;
    private static boolean witherSkullPacketsEnabled;
    private static boolean wolfDyeable;
    private static int disguiseCloneExpire;
    private static int disguiseEntityExpire;
    private static int maxClonedDisguises;
    private static int uuidGeneratedVersion;
    private static boolean disablePvP;
    private static boolean disablePvE;
    private static double pvPTimer;
    private static boolean retaliationCombat;
    private static NotifyBar notifyBar;
    private static BarStyle bossBarStyle;
    private static BarColor bossBarColor;
    private static PermissionDefault commandVisibility;
    private static int tablistRemoveDelay;
    private static boolean usingReleaseBuild;
    private static boolean bisectHosted;
    private static String savedServerIp;
    private static Boolean autoUpdate;
    private static boolean notifyUpdate;
    private static BukkitTask updaterTask;
    private static boolean tallSelfDisguises;
    private static PlayerNameType playerNameType;
    private static boolean overrideCustomNames;
    private static boolean randomDisguises;
    private static boolean loginPayloadPackets;
    private static boolean saveUserPreferences;
    private static long lastUpdateRequest;
    private static boolean hittingRateLimit;
    private static boolean copyPlayerTeamInfo;
    private static String nameAboveDisguise;
    private static int playerDisguisesSkinExpiresMove;
    private static boolean viewSelfDisguisesDefault;
    private static String lastGithubUpdateETag;
    private static String lastPluginUpdateVersion;
    private static boolean contactMojangServers;
    private static int disguiseRadiusMax;
    private static String data;

    public static boolean isArmorstandsName() {
        return DisguiseConfig.getPlayerNameType() == PlayerNameType.ARMORSTANDS;
    }

    public static boolean isExtendedNames() {
        return DisguiseConfig.getPlayerNameType() == PlayerNameType.EXTENDED;
    }

    public static boolean isAutoUpdate() {
        if (DisguiseConfig.getAutoUpdate() == null) {
            autoUpdate = LibsDisguises.getInstance().getConfig().getBoolean("AutoUpdate");
        }
        return DisguiseConfig.getAutoUpdate();
    }

    public static void setAutoUpdate(boolean bl) {
        if (DisguiseConfig.isAutoUpdate() == bl) {
            return;
        }
        autoUpdate = bl;
        DisguiseConfig.doUpdaterTask();
    }

    public static void setNotifyUpdate(boolean bl) {
        if (DisguiseConfig.isNotifyUpdate() == bl) {
            return;
        }
        notifyUpdate = bl;
        DisguiseConfig.doUpdaterTask();
    }

    public static void setLastUpdateRequest(long l) {
        if (l <= DisguiseConfig.getLastUpdateRequest()) {
            return;
        }
        lastUpdateRequest = l;
        DisguiseConfig.saveInternalConfig();
    }

    private static void doUpdaterTask() {
        boolean bl;
        boolean bl2 = DisguiseConfig.isAutoUpdate() || DisguiseConfig.isNotifyUpdate() || "1592".equals((LibsPremium.getPaidInformation() == null ? LibsPremium.getPluginInformation() : LibsPremium.getPaidInformation()).getUserID()) ? true : (bl = false);
        if (!LibsDisguises.getInstance().isNumberedBuild()) {
            return;
        }
        if (updaterTask == null != bl) {
            return;
        }
        if (!bl) {
            updaterTask.cancel();
            updaterTask = null;
            return;
        }
        int n = (int)(TimeUnit.HOURS.toSeconds(DisguiseConfig.isHittingRateLimit() ? 36L : 12L) * 20L);
        long l = (System.currentTimeMillis() - DisguiseConfig.getLastUpdateRequest()) / 50L;
        l = Math.max(36000L, (long)n - l);
        updaterTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)LibsDisguises.getInstance(), new Runnable(){

            @Override
            public void run() {
                LibsDisguises.getInstance().getUpdateChecker().doAutoUpdateCheck();
            }
        }, l, (long)n);
    }

    public static void setUsingReleaseBuilds(boolean bl) {
        if (bl == DisguiseConfig.isUsingReleaseBuild()) {
            return;
        }
        usingReleaseBuild = bl;
        DisguiseConfig.saveInternalConfig();
    }

    public static void setHittingRateLimit(boolean bl) {
        if (bl == DisguiseConfig.isHittingRateLimit()) {
            return;
        }
        hittingRateLimit = bl;
        DisguiseConfig.saveInternalConfig();
        DisguiseConfig.doUpdaterTask();
    }

    public static void setBisectHosted(boolean bl, String string) {
        if (DisguiseConfig.isBisectHosted() == bl && DisguiseConfig.getSavedServerIp().equals(string)) {
            return;
        }
        bisectHosted = bl;
        savedServerIp = string;
        DisguiseConfig.saveInternalConfig();
    }

    public static void loadInternalConfig() {
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "internal.yml");
        if (!file.exists()) {
            DisguiseConfig.saveInternalConfig();
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        bisectHosted = yamlConfiguration.getBoolean("Bisect-Hosted", DisguiseConfig.isBisectHosted());
        savedServerIp = yamlConfiguration.getString("Server-IP", DisguiseConfig.getSavedServerIp());
        usingReleaseBuild = yamlConfiguration.getBoolean("ReleaseBuild", DisguiseConfig.isUsingReleaseBuild());
        lastUpdateRequest = yamlConfiguration.getLong("LastUpdateRequest", 0L);
        hittingRateLimit = yamlConfiguration.getBoolean("HittingRateLimit", false);
        lastGithubUpdateETag = yamlConfiguration.getString("LastGithubETag", null);
        lastPluginUpdateVersion = yamlConfiguration.getString("LastPluginVersion", null);
        data = yamlConfiguration.getString("Data", null);
        if (!(yamlConfiguration.contains("Bisect-Hosted") && yamlConfiguration.contains("Server-IP") && yamlConfiguration.contains("ReleaseBuild"))) {
            DisguiseConfig.saveInternalConfig();
        }
    }

    public static void saveInternalConfig() {
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "internal.yml");
        String string = ReflectionManager.getResourceAsString(LibsDisguises.getInstance().getFile(), "internal.yml");
        for (Object object : new Object[]{DisguiseConfig.isBisectHosted(), DisguiseConfig.getSavedServerIp(), DisguiseConfig.isUsingReleaseBuild(), DisguiseConfig.getLastUpdateRequest(), DisguiseConfig.isHittingRateLimit(), DisguiseConfig.getLastGithubUpdateETag(), DisguiseConfig.getLastPluginUpdateVersion(), DisguiseConfig.getData()}) {
            string = string.replaceFirst("%data%", "" + object);
        }
        file.delete();
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try (PrintWriter printWriter = new PrintWriter(file, "UTF-8");){
            printWriter.write(string);
        }
        catch (FileNotFoundException | UnsupportedEncodingException iOException) {
            iOException.printStackTrace();
        }
    }

    public static PermissionDefault getCommandVisibility() {
        return commandVisibility;
    }

    public static void setCommandVisibility(PermissionDefault permissionDefault) {
        if (permissionDefault == null || DisguiseConfig.getCommandVisibility() == permissionDefault) {
            return;
        }
        commandVisibility = permissionDefault;
        for (Permission permission : LibsDisguises.getInstance().getDescription().getPermissions()) {
            if (!permission.getName().startsWith("libsdisguises.seecmd")) continue;
            permission.setDefault(DisguiseConfig.getCommandVisibility());
        }
    }

    private DisguiseConfig() {
    }

    public static int getUUIDGeneratedVersion() {
        return uuidGeneratedVersion;
    }

    public static void setUUIDGeneratedVersion(int n) {
        uuidGeneratedVersion = n;
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(String string) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(string);
        if (entry == null) {
            return null;
        }
        try {
            return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(entry.getValue()));
        }
        catch (Throwable throwable) {
            DisguiseUtilities.getLogger().warning("Error when attempting to grab the custom disguise " + string);
            throwable.printStackTrace();
            return null;
        }
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(Entity entity, String string) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(string);
        if (entry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise((CommandSender)Bukkit.getConsoleSender(), entity, entry.getValue()));
    }

    public static Map.Entry<DisguisePerm, Disguise> getCustomDisguise(CommandSender commandSender, Entity entity, String string) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        Map.Entry<DisguisePerm, String> entry = DisguiseConfig.getRawCustomDisguise(string);
        if (entry == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<DisguisePerm, Disguise>(entry.getKey(), DisguiseParser.parseDisguise(commandSender, entity, entry.getValue()));
    }

    public static boolean isScoreboardNames() {
        return DisguiseConfig.getPlayerNameType() != PlayerNameType.VANILLA;
    }

    public static void removeCustomDisguise(String string) {
        for (DisguisePerm disguisePerm : customDisguises.keySet()) {
            String string2 = disguisePerm.toReadable();
            if (!string2.equalsIgnoreCase(string) && !string2.replaceAll("_", "").equalsIgnoreCase(string)) continue;
            customDisguises.remove(disguisePerm);
            break;
        }
    }

    public static Map.Entry<DisguisePerm, String> getRawCustomDisguise(String string) {
        for (Map.Entry<DisguisePerm, String> entry : customDisguises.entrySet()) {
            String string2 = entry.getKey().toReadable();
            if (!string2.equalsIgnoreCase(string) && !string2.replaceAll("_", "").equalsIgnoreCase(string)) continue;
            return entry;
        }
        return null;
    }

    public static void setUseTranslations(boolean bl) {
        useTranslations = bl;
        TranslateType.refreshTranslations();
    }

    public static void loadConfig() {
        int n;
        ArrayList<String> arrayList;
        boolean bl;
        boolean bl2;
        PermissionDefault permissionDefault;
        Object object;
        Object object2;
        ConfigLoader configLoader = new ConfigLoader();
        configLoader.saveMissingConfigs();
        DisguiseConfig.loadModdedDisguiseTypes();
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "Skins");
        if (!file.exists()) {
            file.mkdir();
            object2 = new File(file, "README");
            try {
                ((File)object2).createNewFile();
                object = new PrintWriter((File)object2);
                try {
                    ((PrintWriter)object).println("This folder is used to store .png files for uploading with the /savedisguise or /grabskin commands");
                }
                finally {
                    ((PrintWriter)object).close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object2 = configLoader.load();
        PacketsManager.setViewDisguisesListener(true);
        DisguiseConfig.setAddEntityAnimations(object2.getBoolean("AddEntityAnimations"));
        DisguiseConfig.setAnimationPacketsEnabled(object2.getBoolean("PacketsEnabled.Animation"));
        DisguiseConfig.setCatDyeable(object2.getBoolean("DyeableCat"));
        DisguiseConfig.setCollectPacketsEnabled(object2.getBoolean("PacketsEnabled.Collect"));
        DisguiseConfig.setDisableFriendlyInvisibles(object2.getBoolean("Scoreboard.DisableFriendlyInvisibles"));
        DisguiseConfig.setDisabledInvisibility(object2.getBoolean("DisableInvisibility"));
        DisguiseConfig.setDisablePvP(object2.getBoolean("DisablePvP"));
        DisguiseConfig.setDisablePvE(object2.getBoolean("DisablePvE"));
        DisguiseConfig.setPvPTimer(object2.getDouble("PvPTimer"));
        DisguiseConfig.setDisguiseBlownWhenAttacked(object2.getBoolean("BlowDisguisesWhenAttacked"));
        DisguiseConfig.setDisguiseBlownWhenAttacking(object2.getBoolean("BlowDisguisesWhenAttacking"));
        DisguiseConfig.setDisguiseCloneExpire(object2.getInt("DisguiseCloneExpire"));
        DisguiseConfig.setDisguiseEntityExpire(object2.getInt("DisguiseEntityExpire"));
        DisguiseConfig.setDynamicExpiry(object2.getBoolean("DynamicExpiry"));
        DisguiseConfig.setEntityStatusPacketsEnabled(object2.getBoolean("PacketsEnabled.EntityStatus"));
        DisguiseConfig.setEquipmentPacketsEnabled(object2.getBoolean("PacketsEnabled.Equipment"));
        DisguiseConfig.setExplicitDisguisePermissions(object2.getBoolean("Permissions.ExplicitDisguises"));
        DisguiseConfig.setHideArmorFromSelf(object2.getBoolean("RemoveArmor"));
        DisguiseConfig.setHidingCreativeEquipmentFromSelf(object2.getBoolean("RemoveCreativeEquipment"));
        DisguiseConfig.setHideDisguisedPlayers(object2.getBoolean("HideDisguisedPlayersFromTab"));
        DisguiseConfig.setHideHeldItemFromSelf(object2.getBoolean("RemoveHeldItem"));
        DisguiseConfig.setHorseSaddleable(object2.getBoolean("SaddleableHorse"));
        DisguiseConfig.setKeepDisguiseOnPlayerDeath(object2.getBoolean("KeepDisguises.PlayerDeath"));
        DisguiseConfig.setLlamaCarpetable(object2.getBoolean("CarpetableLlama"));
        DisguiseConfig.setMaxClonedDisguises(object2.getInt("DisguiseCloneSize"));
        DisguiseConfig.setMaxHealthDeterminedByDisguisedEntity(object2.getBoolean("MaxHealthDeterminedByEntity"));
        DisguiseConfig.setMetaPacketsEnabled(object2.getBoolean("PacketsEnabled.Metadata"));
        DisguiseConfig.setLoginPayloadPackets(object2.getBoolean("PacketsEnabled.LoginPayload"));
        DisguiseConfig.setMiscDisguisesForLivingEnabled(object2.getBoolean("MiscDisguisesForLiving"));
        DisguiseConfig.setModifyBoundingBox(object2.getBoolean("ModifyBoundingBox"));
        DisguiseConfig.setModifyCollisions(object2.getBoolean("Scoreboard.Collisions"));
        DisguiseConfig.setMonstersIgnoreDisguises(object2.getBoolean("MonstersIgnoreDisguises"));
        DisguiseConfig.setMovementPacketsEnabled(object2.getBoolean("PacketsEnabled.Movement"));
        DisguiseConfig.setNameAboveHeadAlwaysVisible(object2.getBoolean("NameAboveHeadAlwaysVisible"));
        DisguiseConfig.setNameOfPlayerShownAboveDisguise(object2.getBoolean("ShowNamesAboveDisguises"));
        DisguiseConfig.setNameAboveDisguise(object2.getString("NameAboveDisguise"));
        DisguiseConfig.setPlayerHideArmor(object2.getBoolean("PlayerHideArmor"));
        DisguiseConfig.setRetaliationCombat(object2.getBoolean("RetaliationCombat"));
        DisguiseConfig.setSaveGameProfiles(object2.getBoolean("SaveGameProfiles"));
        DisguiseConfig.setSavePlayerDisguises(object2.getBoolean("SaveDisguises.Players"));
        DisguiseConfig.setSaveEntityDisguises(object2.getBoolean("SaveDisguises.Entities"));
        DisguiseConfig.setSelfDisguisesSoundsReplaced(object2.getBoolean("HearSelfDisguise"));
        DisguiseConfig.setSheepDyeable(object2.getBoolean("DyeableSheep"));
        DisguiseConfig.setShowDisguisedPlayersInTab(object2.getBoolean("ShowPlayerDisguisesInTab"));
        DisguiseConfig.setSoundsEnabled(object2.getBoolean("DisguiseSounds"));
        DisguiseConfig.setStopShulkerDisguisesFromMoving(object2.getBoolean("StopShulkerDisguisesFromMoving", true));
        DisguiseConfig.setUUIDGeneratedVersion(object2.getInt("UUIDVersion"));
        DisguiseConfig.setUndisguiseOnWorldChange(object2.getBoolean("UndisguiseOnWorldChange"));
        DisguiseConfig.setUpdateGameProfiles(object2.getBoolean("UpdateGameProfiles"));
        DisguiseConfig.setUseTranslations(object2.getBoolean("Translations"));
        DisguiseConfig.setVelocitySent(object2.getBoolean("SendVelocity"));
        DisguiseConfig.setViewDisguises(object2.getBoolean("ViewSelfDisguises"));
        DisguiseConfig.setWarnScoreboardConflict(object2.getBoolean("Scoreboard.WarnConflict"));
        DisguiseConfig.setCopyPlayerTeamInfo(object2.getBoolean("Scoreboard.CopyPlayerTeamInfo"));
        DisguiseConfig.setWitherSkullPacketsEnabled(object2.getBoolean("PacketsEnabled.WitherSkull"));
        DisguiseConfig.setWolfDyeable(object2.getBoolean("DyeableWolf"));
        DisguiseConfig.setTablistRemoveDelay(object2.getInt("TablistRemoveDelay"));
        DisguiseConfig.setAutoUpdate(object2.getBoolean("AutoUpdate"));
        DisguiseConfig.setTallSelfDisguises(object2.getBoolean("TallSelfDisguises"));
        DisguiseConfig.setOverrideCustomNames(object2.getBoolean("OverrideCustomNames"));
        DisguiseConfig.setRandomDisguises(object2.getBoolean("RandomDisguiseOptions"));
        DisguiseConfig.setSaveUserPreferences(object2.getBoolean("SaveUserPreferences"));
        DisguiseConfig.setPlayerDisguisesSkinExpiresMove(object2.getInt("PlayerDisguisesTablistExpiresMove"));
        DisguiseConfig.setViewSelfDisguisesDefault(object2.getBoolean("ViewSelfDisguisesDefault"));
        DisguiseConfig.setContactMojangServers(object2.getBoolean("ContactMojangServers"));
        DisguiseConfig.setDisguiseRadiusMax(object2.getInt("DisguiseRadiusMax"));
        object = object2.getString("MineSkinAPIKey");
        if (object != null && ((String)object).matches("[a-zA-Z0-9]{8,}")) {
            DisguiseUtilities.getMineSkinAPI().setApiKey((String)object);
        } else if (object != null && ((String)object).length() > 8) {
            DisguiseUtilities.getLogger().warning("API Key provided for MineSkin does not appear to be in a valid format!");
        }
        if (!LibsPremium.isPremium().booleanValue() && (DisguiseConfig.isSavePlayerDisguises() || DisguiseConfig.isSaveEntityDisguises())) {
            DisguiseUtilities.getLogger().warning("You must purchase the plugin to use saved disguises!");
        }
        try {
            DisguiseConfig.setPlayerNameType(PlayerNameType.valueOf(object2.getString("PlayerNames").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + object2.getString("PlayerNames") + "' to a valid option for PlayerNames");
        }
        try {
            DisguiseConfig.setNotifyBar(NotifyBar.valueOf(object2.getString("NotifyBar").toUpperCase(Locale.ENGLISH)));
            if (DisguiseConfig.getNotifyBar() == NotifyBar.BOSS_BAR && !NmsVersion.v1_13.isSupported()) {
                DisguiseUtilities.getLogger().warning("BossBars hasn't been implemented properly in 1.12 due to api restrictions, falling back to ACTION_BAR");
                DisguiseConfig.setNotifyBar(NotifyBar.ACTION_BAR);
            }
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + object2.getString("NotifyBar") + "' to a valid option for NotifyBar");
        }
        try {
            DisguiseConfig.setBossBarColor(BarColor.valueOf((String)object2.getString("BossBarColor").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + object2.getString("BossBarColor") + "' to a valid option for BossBarColor");
        }
        try {
            DisguiseConfig.setBossBarStyle(BarStyle.valueOf((String)object2.getString("BossBarStyle").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + object2.getString("BossBarStyle") + "' to a valid option for BossBarStyle");
        }
        try {
            DisguiseConfig.setUpdatesBranch(UpdatesBranch.valueOf(object2.getString("UpdatesBranch").toUpperCase(Locale.ENGLISH)));
        }
        catch (Exception exception) {
            DisguiseUtilities.getLogger().warning("Cannot parse '" + object2.getString("UpdatesBranch") + "' to a valid option for UpdatesBranch");
        }
        String string = object2.getString("Permissions.SeeCommands");
        PermissionDefault permissionDefault2 = permissionDefault = string == null ? null : PermissionDefault.getByName((String)string);
        if (permissionDefault == null) {
            DisguiseUtilities.getLogger().warning("Invalid option '" + object2.getString("Permissions.SeeCommands") + "' for Permissions.SeeCommands when loading config!");
        } else {
            DisguiseConfig.setCommandVisibility(permissionDefault);
        }
        DisguiseConfig.loadCustomDisguises();
        if ("802393".equals("12345") && DisguiseConfig.getCustomDisguises().size() > 10) {
            DisguiseConfig.setSoundsEnabled(false);
            Iterator<Map.Entry<DisguisePerm, String>> iterator = DisguiseConfig.getCustomDisguises().entrySet().iterator();
            bl2 = false;
            while (iterator.hasNext()) {
                iterator.next();
                if (!new Random().nextBoolean()) continue;
                iterator.remove();
            }
        }
        if (object2.contains("VerboseConfig")) {
            bl = object2.getBoolean("VerboseConfig");
        } else {
            DisguiseUtilities.getLogger().info("As 'VerboseConfig' hasn't been set, it is assumed true. Set it in your config to remove these messages!");
            bl = true;
        }
        bl2 = object2.getBoolean("ChangedConfig");
        if ((bl || bl2) && !(arrayList = DisguiseConfig.doOutput((ConfigurationSection)object2, bl2, bl)).isEmpty()) {
            DisguiseUtilities.getLogger().info("This is not an error! Now outputting " + (bl ? "missing " : "") + (bl2 ? (bl ? "and " : "") + "changed/invalid " : "") + "config values");
            for (String string2 : arrayList) {
                DisguiseUtilities.getLogger().info(string2);
            }
        }
        if ((n = DisguiseConfig.doOutput((ConfigurationSection)object2, false, true).size()) > 0) {
            if (object2.getBoolean("UpdateConfig", true)) {
                configLoader.saveDefaultConfigs();
                DisguiseUtilities.getLogger().info("Config has been auto-updated!");
            } else if (!bl) {
                DisguiseUtilities.getLogger().warning("Your config is missing " + n + " options! Please consider regenerating your config!");
                DisguiseUtilities.getLogger().info("You can also add the missing entries yourself! Try '/libsdisguises config'");
            }
        } else {
            DisguiseUtilities.getLogger().info("Config is up to date!");
        }
    }

    public static void loadModdedDisguiseTypes() {
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!yamlConfiguration.contains("Custom-Entities")) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : yamlConfiguration.getConfigurationSection("Custom-Entities").getKeys(false)) {
            try {
                String string2;
                if (!string.matches("[a-zA-Z0-9_]+")) {
                    DisguiseUtilities.getLogger().severe("Invalid modded disguise name '" + string + "'");
                    continue;
                }
                ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("Custom-Entities." + string);
                if (!configurationSection.contains("Name")) {
                    DisguiseUtilities.getLogger().severe("No mod:entity 'Name' provided for '" + string + "'");
                    continue;
                }
                String string3 = configurationSection.getString("Name");
                if (!string3.contains(":") || string3.contains(".")) {
                    DisguiseUtilities.getLogger().severe("Invalid modded name '" + string3 + "' in disguises.yml!");
                    continue;
                }
                boolean bl = configurationSection.getBoolean("Register", true);
                boolean bl2 = configurationSection.getString("Type", "LIVING").equalsIgnoreCase("LIVING");
                String string4 = configurationSection.getString("Type");
                String string5 = configurationSection.getString("Mod");
                String[] stringArray = string5 == null || !configurationSection.contains("Version") ? null : configurationSection.getString("Version").split(",");
                String string6 = string2 = string5 == null ? null : configurationSection.getString("Required");
                if (configurationSection.contains("Channels")) {
                    for (String string7 : configurationSection.getString("Channels").split(",")) {
                        if (!string7.contains("|")) {
                            string7 = string7 + "|";
                            DisguiseUtilities.getLogger().severe("No channel version declared for " + string7);
                        }
                        arrayList.add(string7);
                    }
                }
                if (string2 != null) {
                    string2 = DisguiseUtilities.translateAlternateColorCodes(string2);
                }
                ModdedEntity object = new ModdedEntity(null, string, bl2, string5, stringArray, string2, 0);
                if (ModdedManager.getModdedEntity(string) != null) {
                    DisguiseUtilities.getLogger().info("Modded entity " + string + " has already been " + (bl ? "registered" : "added"));
                    continue;
                }
                ModdedManager.registerModdedEntity(new NamespacedKey(string3.substring(0, string3.indexOf(":")), string3.substring(string3.indexOf(":") + 1)), object, bl);
                DisguiseUtilities.getLogger().info("Modded entity " + string + " has been " + (bl ? "registered" : "added"));
            }
            catch (Exception exception) {
                DisguiseUtilities.getLogger().severe("Error while trying to register modded entity " + string);
                exception.printStackTrace();
            }
        }
        new ModdedManager(arrayList);
    }

    public static ArrayList<String> doOutput(boolean bl, boolean bl2) {
        return DisguiseConfig.doOutput((ConfigurationSection)new ConfigLoader().load(), bl, bl2);
    }

    public static ArrayList<String> doOutput(ConfigurationSection configurationSection, boolean bl, boolean bl2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ConfigurationSection configurationSection2 = configurationSection.getDefaultSection();
        if (configurationSection2 == null) {
            configurationSection2 = new ConfigLoader().loadDefaults();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : configurationSection2.getKeys(true)) {
            if (configurationSection2.isConfigurationSection(object)) continue;
            hashMap.put(object, configurationSection2.get(object));
        }
        for (String string : configurationSection.getKeys(true)) {
            if (configurationSection.isConfigurationSection(string)) continue;
            if (!hashMap.containsKey(string)) {
                if (!bl) continue;
                arrayList.add("Unknown config option '" + string + ": " + configurationSection.get(string) + "'");
                continue;
            }
            if (!hashMap.get(string).equals(configurationSection.get(string)) && bl) {
                arrayList.add("Modified config: '" + string + ": " + configurationSection.get(string) + "'");
            }
            hashMap.remove(string);
        }
        if (bl2) {
            for (Map.Entry entry : hashMap.entrySet()) {
                arrayList.add("Missing '" + (String)entry.getKey() + ": " + entry.getValue() + "'");
            }
        }
        return arrayList;
    }

    static void loadCustomDisguises() {
        customDisguises.clear();
        File file = new File(LibsDisguises.getInstance().getDataFolder(), "configs/disguises.yml");
        if (!file.exists()) {
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("Disguises");
        if (configurationSection == null) {
            return;
        }
        int n = 0;
        for (String string : configurationSection.getKeys(false)) {
            String string2 = configurationSection.getString(string);
            if (!NmsVersion.v1_13.isSupported() && string.equals("libraryaddict")) {
                string2 = string2.replace("GOLDEN_BOOTS,GOLDEN_LEGGINGS,GOLDEN_CHESTPLATE,GOLDEN_HELMET", "GOLD_BOOTS,GOLD_LEGGINGS,GOLD_CHESTPLATE,GOLD_HELMET");
            }
            try {
                DisguiseConfig.addCustomDisguise(string, string2);
            }
            catch (Exception exception) {
                ++n;
                if (exception instanceof DisguiseParseException) {
                    if (exception.getMessage() != null) {
                        DisguiseUtilities.getLogger().severe(exception.getMessage());
                    }
                    if (exception.getCause() == null) continue;
                    exception.printStackTrace();
                    continue;
                }
                exception.printStackTrace();
            }
        }
        if (n > 0) {
            DisguiseUtilities.getLogger().warning("Failed to load " + n + " custom disguises");
        }
        DisguiseUtilities.getLogger().info("Loaded " + customDisguises.size() + " custom disguise" + (customDisguises.size() == 1 ? "" : "s"));
    }

    public static void addCustomDisguise(String string, String string2) {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Custom Disguises should not be called async!");
        }
        if (DisguiseConfig.getRawCustomDisguise(string2) != null) {
            throw new DisguiseParseException(LibsMsg.CUSTOM_DISGUISE_NAME_CONFLICT, string);
        }
        try {
            String[] stringArray = DisguiseUtilities.split(string2);
            Disguise disguise = DisguiseParser.parseTestDisguise((CommandSender)Bukkit.getConsoleSender(), "disguise", stringArray, DisguiseParser.getPermissions((CommandSender)Bukkit.getConsoleSender(), "disguise"));
            DisguisePerm disguisePerm = new DisguisePerm(disguise.getType(), string);
            customDisguises.put(disguisePerm, string2);
            DisguiseUtilities.getLogger().info("Loaded custom disguise " + string);
        }
        catch (DisguiseParseException disguiseParseException) {
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, string, disguiseParseException.getMessage() == null ? "" : ": " + disguiseParseException.getMessage());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DisguiseParseException(LibsMsg.ERROR_LOADING_CUSTOM_DISGUISE, string, "");
        }
    }

    public static boolean isSoundEnabled() {
        return PacketsManager.isHearDisguisesEnabled();
    }

    public static void setAnimationPacketsEnabled(boolean bl) {
        if (bl != DisguiseConfig.isAnimationPacketsEnabled()) {
            animationPacketsEnabled = bl;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setCollectPacketsEnabled(boolean bl) {
        if (bl != DisguiseConfig.isCollectPacketsEnabled()) {
            collectPacketsEnabled = bl;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setEntityStatusPacketsEnabled(boolean bl) {
        if (bl != DisguiseConfig.isEntityStatusPacketsEnabled()) {
            entityStatusPacketsEnabled = bl;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setEquipmentPacketsEnabled(boolean bl) {
        if (bl != DisguiseConfig.isEquipmentPacketsEnabled()) {
            equipmentPacketsEnabled = bl;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setHideArmorFromSelf(boolean bl) {
        if (hidingArmorFromSelf != bl) {
            hidingArmorFromSelf = bl;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setHideHeldItemFromSelf(boolean bl) {
        if (hidingHeldItemFromSelf != bl) {
            hidingHeldItemFromSelf = bl;
            PacketsManager.setInventoryListenerEnabled(DisguiseConfig.isHidingHeldItemFromSelf() || DisguiseConfig.isHidingArmorFromSelf());
        }
    }

    public static void setMiscDisguisesForLivingEnabled(boolean bl) {
        if (bl != DisguiseConfig.isMiscDisguisesForLivingEnabled()) {
            miscDisguisesForLivingEnabled = bl;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setMovementPacketsEnabled(boolean bl) {
        if (bl != DisguiseConfig.isMovementPacketsEnabled()) {
            movementPacketsEnabled = bl;
            PacketsManager.setupMainPacketsListener();
        }
    }

    public static void setSoundsEnabled(boolean bl) {
        PacketsManager.setHearDisguisesListener(bl);
    }

    public static HashMap<DisguisePerm, String> getCustomDisguises() {
        return customDisguises;
    }

    public static void setCustomDisguises(HashMap<DisguisePerm, String> hashMap) {
        customDisguises = hashMap;
    }

    public static UpdatesBranch getUpdatesBranch() {
        return updatesBranch;
    }

    public static void setUpdatesBranch(UpdatesBranch updatesBranch) {
        DisguiseConfig.updatesBranch = updatesBranch;
    }

    public static boolean isAddEntityAnimations() {
        return addEntityAnimations;
    }

    public static void setAddEntityAnimations(boolean bl) {
        addEntityAnimations = bl;
    }

    public static boolean isAnimationPacketsEnabled() {
        return animationPacketsEnabled;
    }

    public static boolean isCatDyeable() {
        return catDyeable;
    }

    public static void setCatDyeable(boolean bl) {
        catDyeable = bl;
    }

    public static boolean isCollectPacketsEnabled() {
        return collectPacketsEnabled;
    }

    public static boolean isDisableFriendlyInvisibles() {
        return disableFriendlyInvisibles;
    }

    public static void setDisableFriendlyInvisibles(boolean bl) {
        disableFriendlyInvisibles = bl;
    }

    public static boolean isDisabledInvisibility() {
        return disabledInvisibility;
    }

    public static void setDisabledInvisibility(boolean bl) {
        disabledInvisibility = bl;
    }

    public static boolean isDisguiseBlownWhenAttacked() {
        return disguiseBlownWhenAttacked;
    }

    public static void setDisguiseBlownWhenAttacked(boolean bl) {
        disguiseBlownWhenAttacked = bl;
    }

    public static boolean isDisguiseBlownWhenAttacking() {
        return disguiseBlownWhenAttacking;
    }

    public static void setDisguiseBlownWhenAttacking(boolean bl) {
        disguiseBlownWhenAttacking = bl;
    }

    public static boolean isDynamicExpiry() {
        return dynamicExpiry;
    }

    public static void setDynamicExpiry(boolean bl) {
        dynamicExpiry = bl;
    }

    public static boolean isEntityStatusPacketsEnabled() {
        return entityStatusPacketsEnabled;
    }

    public static boolean isEquipmentPacketsEnabled() {
        return equipmentPacketsEnabled;
    }

    public static boolean isExplicitDisguisePermissions() {
        return explicitDisguisePermissions;
    }

    public static void setExplicitDisguisePermissions(boolean bl) {
        explicitDisguisePermissions = bl;
    }

    public static boolean isHideDisguisedPlayers() {
        return hideDisguisedPlayers;
    }

    public static void setHideDisguisedPlayers(boolean bl) {
        hideDisguisedPlayers = bl;
    }

    public static boolean isHidingArmorFromSelf() {
        return hidingArmorFromSelf;
    }

    public static void setHidingArmorFromSelf(boolean bl) {
        hidingArmorFromSelf = bl;
    }

    public static boolean isHidingCreativeEquipmentFromSelf() {
        return hidingCreativeEquipmentFromSelf;
    }

    public static void setHidingCreativeEquipmentFromSelf(boolean bl) {
        hidingCreativeEquipmentFromSelf = bl;
    }

    public static boolean isHidingHeldItemFromSelf() {
        return hidingHeldItemFromSelf;
    }

    public static void setHidingHeldItemFromSelf(boolean bl) {
        hidingHeldItemFromSelf = bl;
    }

    public static boolean isHorseSaddleable() {
        return horseSaddleable;
    }

    public static void setHorseSaddleable(boolean bl) {
        horseSaddleable = bl;
    }

    public static boolean isKeepDisguiseOnPlayerDeath() {
        return keepDisguiseOnPlayerDeath;
    }

    public static void setKeepDisguiseOnPlayerDeath(boolean bl) {
        keepDisguiseOnPlayerDeath = bl;
    }

    public static boolean isLlamaCarpetable() {
        return llamaCarpetable;
    }

    public static void setLlamaCarpetable(boolean bl) {
        llamaCarpetable = bl;
    }

    public static boolean isMaxHealthDeterminedByDisguisedEntity() {
        return maxHealthDeterminedByDisguisedEntity;
    }

    public static void setMaxHealthDeterminedByDisguisedEntity(boolean bl) {
        maxHealthDeterminedByDisguisedEntity = bl;
    }

    public static boolean isMetaPacketsEnabled() {
        return metaPacketsEnabled;
    }

    public static void setMetaPacketsEnabled(boolean bl) {
        metaPacketsEnabled = bl;
    }

    public static boolean isMiscDisguisesForLivingEnabled() {
        return miscDisguisesForLivingEnabled;
    }

    public static boolean isModifyBoundingBox() {
        return modifyBoundingBox;
    }

    public static void setModifyBoundingBox(boolean bl) {
        modifyBoundingBox = bl;
    }

    public static boolean isModifyCollisions() {
        return modifyCollisions;
    }

    public static void setModifyCollisions(boolean bl) {
        modifyCollisions = bl;
    }

    public static boolean isMonstersIgnoreDisguises() {
        return monstersIgnoreDisguises;
    }

    public static void setMonstersIgnoreDisguises(boolean bl) {
        monstersIgnoreDisguises = bl;
    }

    public static boolean isMovementPacketsEnabled() {
        return movementPacketsEnabled;
    }

    public static boolean isNameAboveHeadAlwaysVisible() {
        return nameAboveHeadAlwaysVisible;
    }

    public static void setNameAboveHeadAlwaysVisible(boolean bl) {
        nameAboveHeadAlwaysVisible = bl;
    }

    public static boolean isNameOfPlayerShownAboveDisguise() {
        return nameOfPlayerShownAboveDisguise;
    }

    public static void setNameOfPlayerShownAboveDisguise(boolean bl) {
        nameOfPlayerShownAboveDisguise = bl;
    }

    public static boolean isPlayerHideArmor() {
        return playerHideArmor;
    }

    public static void setPlayerHideArmor(boolean bl) {
        playerHideArmor = bl;
    }

    public static boolean isSaveEntityDisguises() {
        return saveEntityDisguises;
    }

    public static void setSaveEntityDisguises(boolean bl) {
        saveEntityDisguises = bl;
    }

    public static boolean isSaveGameProfiles() {
        return saveGameProfiles;
    }

    public static void setSaveGameProfiles(boolean bl) {
        saveGameProfiles = bl;
    }

    public static boolean isSavePlayerDisguises() {
        return savePlayerDisguises;
    }

    public static void setSavePlayerDisguises(boolean bl) {
        savePlayerDisguises = bl;
    }

    public static boolean isSelfDisguisesSoundsReplaced() {
        return selfDisguisesSoundsReplaced;
    }

    public static void setSelfDisguisesSoundsReplaced(boolean bl) {
        selfDisguisesSoundsReplaced = bl;
    }

    public static boolean isSheepDyeable() {
        return sheepDyeable;
    }

    public static void setSheepDyeable(boolean bl) {
        sheepDyeable = bl;
    }

    public static boolean isShowDisguisedPlayersInTab() {
        return showDisguisedPlayersInTab;
    }

    public static void setShowDisguisedPlayersInTab(boolean bl) {
        showDisguisedPlayersInTab = bl;
    }

    public static boolean isStopShulkerDisguisesFromMoving() {
        return stopShulkerDisguisesFromMoving;
    }

    public static void setStopShulkerDisguisesFromMoving(boolean bl) {
        stopShulkerDisguisesFromMoving = bl;
    }

    public static boolean isUndisguiseOnWorldChange() {
        return undisguiseOnWorldChange;
    }

    public static void setUndisguiseOnWorldChange(boolean bl) {
        undisguiseOnWorldChange = bl;
    }

    public static boolean isUpdateGameProfiles() {
        return updateGameProfiles;
    }

    public static void setUpdateGameProfiles(boolean bl) {
        updateGameProfiles = bl;
    }

    public static boolean isUseTranslations() {
        return useTranslations;
    }

    public static boolean isVelocitySent() {
        return velocitySent;
    }

    public static void setVelocitySent(boolean bl) {
        velocitySent = bl;
    }

    public static boolean isViewDisguises() {
        return viewDisguises;
    }

    public static void setViewDisguises(boolean bl) {
        viewDisguises = bl;
    }

    public static boolean isWarnScoreboardConflict() {
        return warnScoreboardConflict;
    }

    public static void setWarnScoreboardConflict(boolean bl) {
        warnScoreboardConflict = bl;
    }

    public static boolean isWitherSkullPacketsEnabled() {
        return witherSkullPacketsEnabled;
    }

    public static void setWitherSkullPacketsEnabled(boolean bl) {
        witherSkullPacketsEnabled = bl;
    }

    public static boolean isWolfDyeable() {
        return wolfDyeable;
    }

    public static void setWolfDyeable(boolean bl) {
        wolfDyeable = bl;
    }

    public static int getDisguiseCloneExpire() {
        return disguiseCloneExpire;
    }

    public static void setDisguiseCloneExpire(int n) {
        disguiseCloneExpire = n;
    }

    public static int getDisguiseEntityExpire() {
        return disguiseEntityExpire;
    }

    public static void setDisguiseEntityExpire(int n) {
        disguiseEntityExpire = n;
    }

    public static int getMaxClonedDisguises() {
        return maxClonedDisguises;
    }

    public static void setMaxClonedDisguises(int n) {
        maxClonedDisguises = n;
    }

    public static boolean isDisablePvP() {
        return disablePvP;
    }

    public static void setDisablePvP(boolean bl) {
        disablePvP = bl;
    }

    public static boolean isDisablePvE() {
        return disablePvE;
    }

    public static void setDisablePvE(boolean bl) {
        disablePvE = bl;
    }

    public static double getPvPTimer() {
        return pvPTimer;
    }

    public static void setPvPTimer(double d) {
        pvPTimer = d;
    }

    public static boolean isRetaliationCombat() {
        return retaliationCombat;
    }

    public static void setRetaliationCombat(boolean bl) {
        retaliationCombat = bl;
    }

    public static NotifyBar getNotifyBar() {
        return notifyBar;
    }

    public static void setNotifyBar(NotifyBar notifyBar) {
        DisguiseConfig.notifyBar = notifyBar;
    }

    public static BarStyle getBossBarStyle() {
        return bossBarStyle;
    }

    public static void setBossBarStyle(BarStyle barStyle) {
        bossBarStyle = barStyle;
    }

    public static BarColor getBossBarColor() {
        return bossBarColor;
    }

    public static void setBossBarColor(BarColor barColor) {
        bossBarColor = barColor;
    }

    public static int getTablistRemoveDelay() {
        return tablistRemoveDelay;
    }

    public static void setTablistRemoveDelay(int n) {
        tablistRemoveDelay = n;
    }

    public static boolean isUsingReleaseBuild() {
        return usingReleaseBuild;
    }

    public static boolean isBisectHosted() {
        return bisectHosted;
    }

    public static String getSavedServerIp() {
        return savedServerIp;
    }

    public static Boolean getAutoUpdate() {
        return autoUpdate;
    }

    public static boolean isNotifyUpdate() {
        return notifyUpdate;
    }

    public static boolean isTallSelfDisguises() {
        return tallSelfDisguises;
    }

    public static void setTallSelfDisguises(boolean bl) {
        tallSelfDisguises = bl;
    }

    public static PlayerNameType getPlayerNameType() {
        return playerNameType;
    }

    public static void setPlayerNameType(PlayerNameType playerNameType) {
        DisguiseConfig.playerNameType = playerNameType;
    }

    public static boolean isOverrideCustomNames() {
        return overrideCustomNames;
    }

    public static void setOverrideCustomNames(boolean bl) {
        overrideCustomNames = bl;
    }

    public static boolean isRandomDisguises() {
        return randomDisguises;
    }

    public static void setRandomDisguises(boolean bl) {
        randomDisguises = bl;
    }

    public static boolean isLoginPayloadPackets() {
        return loginPayloadPackets;
    }

    public static void setLoginPayloadPackets(boolean bl) {
        loginPayloadPackets = bl;
    }

    public static boolean isSaveUserPreferences() {
        return saveUserPreferences;
    }

    public static void setSaveUserPreferences(boolean bl) {
        saveUserPreferences = bl;
    }

    public static long getLastUpdateRequest() {
        return lastUpdateRequest;
    }

    public static boolean isHittingRateLimit() {
        return hittingRateLimit;
    }

    public static boolean isCopyPlayerTeamInfo() {
        return copyPlayerTeamInfo;
    }

    public static void setCopyPlayerTeamInfo(boolean bl) {
        copyPlayerTeamInfo = bl;
    }

    public static String getNameAboveDisguise() {
        return nameAboveDisguise;
    }

    public static void setNameAboveDisguise(String string) {
        nameAboveDisguise = string;
    }

    public static int getPlayerDisguisesSkinExpiresMove() {
        return playerDisguisesSkinExpiresMove;
    }

    public static void setPlayerDisguisesSkinExpiresMove(int n) {
        playerDisguisesSkinExpiresMove = n;
    }

    public static boolean isViewSelfDisguisesDefault() {
        return viewSelfDisguisesDefault;
    }

    public static void setViewSelfDisguisesDefault(boolean bl) {
        viewSelfDisguisesDefault = bl;
    }

    public static String getLastGithubUpdateETag() {
        return lastGithubUpdateETag;
    }

    public static void setLastGithubUpdateETag(String string) {
        lastGithubUpdateETag = string;
    }

    public static String getLastPluginUpdateVersion() {
        return lastPluginUpdateVersion;
    }

    public static void setLastPluginUpdateVersion(String string) {
        lastPluginUpdateVersion = string;
    }

    public static boolean isContactMojangServers() {
        return contactMojangServers;
    }

    public static void setContactMojangServers(boolean bl) {
        contactMojangServers = bl;
    }

    public static int getDisguiseRadiusMax() {
        return disguiseRadiusMax;
    }

    protected static void setDisguiseRadiusMax(int n) {
        disguiseRadiusMax = n;
    }

    public static String getData() {
        return data;
    }

    public static void setData(String string) {
        data = string;
    }

    static {
        notifyBar = NotifyBar.ACTION_BAR;
        bossBarStyle = BarStyle.SOLID;
        bossBarColor = BarColor.GREEN;
        commandVisibility = PermissionDefault.TRUE;
        usingReleaseBuild = true;
        bisectHosted = true;
        savedServerIp = "";
        playerNameType = PlayerNameType.TEAMS;
    }

    public static enum PlayerNameType {
        VANILLA,
        TEAMS,
        EXTENDED,
        ARMORSTANDS;


        public boolean isTeams() {
            return this == TEAMS || this == EXTENDED;
        }
    }

    public static enum NotifyBar {
        NONE,
        BOSS_BAR,
        ACTION_BAR;

    }

    public static enum UpdatesBranch {
        SAME_BUILDS,
        SNAPSHOTS,
        RELEASES;

    }

    public static enum DisguisePushing {
        MODIFY_SCOREBOARD,
        IGNORE_SCOREBOARD,
        CREATE_SCOREBOARD;

    }
}

